
///////////////////////////////////
//      FUNCIONES DEL FORM       //
///////////////////////////////////

//Form.OnChange - Case Codigo
function changeCodigo(value)
{
	with(form)
	{
		if(value != '')
		{
			var cod = getItemValue("codigob");
			var xml = dhtmlxAjax.postSync(urlxmls + "formularios/data/inversiones.php","&op=rep&codigo=" + value + "&codigob=" + cod);
			if(xml.xmlDoc.responseText == "repetido")
			{
				dhtmlx.alert("Ya existe un programa con ese c&oacute;digo. El c&oacute;digo del programa debe ser &uacute;nico.");
				setItemValue("codigo",'');
			}
		}
	}
}

//Form.OnButtonClick - Case Cancelar
function clickCancelar()
{
	with(form)
	{
		clickLimpiar();
		showItem("frbuscar");
		hideItem("frinversion");
		hideItem("frpresupuestos");
		hideItem("frcontrataciones");
		hideItem("proyectos");
	}
}

//Form.OnButtonClick - Case ContratoAgregar
function clickContratoAdd()
{
	ventanaContrato("add");
}

//Form.OnButtonClick - Case ContratoModificar
function clickContratoEdit()
{
	if(gdContratos.getSelectedRowId()>0)
		ventanaContrato("edit");
	else
		dhtmlx.alert("Seleccione el contrato que desea modificar");
}

//Form.OnButtonClick - Case ContratoEliminar
function clickContratoDel()
{
	with(gdContratos)
	{
		elemid = getSelectedRowId();
		if(elemid>0)
		{
			if(confirm("Esta seguro que desea eliminar el contrato?"))
			{
				var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/contratos.php?&op=delete&id=" + elemid);
				dhtmlx.alert(xml.xmlDoc.responseText);
				
				codb = form.getItemValue("act_id");
				gdContratos = new dhtmlXGridObject(form.getContainer('contratosgrid'));
				cargaGridContratos();
				gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
			}	
		}
	}
}

//Form.OnButtonClick - Case ContratoGuardar
function clickContratoSave()
{
	with(formContrato)
	{

		codb = form.getItemValue("act_id");
			
		setItemValue("op", "contrat");
		setItemValue("programa", codb);

		send(urlxmls + "formularios/data/contratos.php","post",function(xml){
			win.close();
			dhtmlx.alert(xml.xmlDoc.responseText);

			gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
		});
	}
}


//Form.OnButtonClick - Case Eliminar
function clickEliminar()
{
	with(form)
	{
		elemid = getCombo("codigob").getSelectedValue();
		if(elemid>0)
		{
			if(confirm("Esta seguro que desea eliminar el programa?"))
			{
				var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/inversiones.php?&op=delete&id=" + elemid);
				dhtmlx.alert(xml.xmlDoc.responseText);
				
				var opts = getCombo("codigob");
				opts.loadXML(urlxmls + "formularios/data/opciones.php?op=inversion");
			}	
		}
	}
}

//Form.OnButtonClick - Case Guardar
function clickGuardar()
{
	with(form)
	{
		err = "";
		setItemValue("fecha",getCalendar("fechaalta").getFormatedDate("%Y-%m-%d"));
		setItemValue("anio",getCalendar("fechaalta").getFormatedDate("%Y"));
			    	
		send(urlxmls + "formularios/data/inversiones.php","post",function(xml){
			var resp = xml.xmlDoc.responseText.split('||');
			dhtmlx.alert(resp[0]);
			
			if(resp[1])
			{
				showItem("frpresupuestos");
				showItem("frcontrataciones");
				showItem("frproyectos");

				setItemValue("act_tipo", 2);
				setItemValue("act_id", resp[1]);
			}
		});
	}
}

//Form.OnButtonClick - Case Limpiar
function clickLimpiar()
{
	form.clear();
	gdPresupuestos.clearAll();
	gdContratos.clearAll();
	gdProyectos.clearAll();
}

//Form.OnButtonClick - Case Nueva
function clickNueva()
{
	with(form)
	{
		showItem("frinversion");
		hideItem("frpresupuestos");
		hideItem("frcontrataciones");
		hideItem("frproyectos");
		hideItem("frbuscar");
		setItemValue("act_tipo",1);
		setItemValue("act_id","");
	}
}

//Form.OnButtonClick - Case PresupuestoAgregar
function clickPresupuestoAdd()
{
	ventanaPresupuesto("add");
}

//Form.OnButtonClick - Case PresupuestoModificar
function clickPresupuestoEdit()
{
	if(gdPresupuestos.getSelectedRowId()>0)
		ventanaPresupuesto("edit");
	else
		dhtmlx.alert("Seleccione el presupuesto que desea modificar");
}

//Form.OnButtonClick - Case PresupuestoEliminar
function clickPresupuestoDel()
{
	with(gdPresupuestos)
	{
		elemid = getSelectedRowId();
		if(elemid>0)
		{
			if(confirm("Esta seguro que desea eliminar el presupuesto?"))
			{
				var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/presupuestos.php?&op=delete&id=" + elemid);
				dhtmlx.alert(xml.xmlDoc.responseText);
				
				codb = form.getItemValue("act_id");
				gdPresupuestos = new dhtmlXGridObject(form.getContainer('presupuestosgrid'));
				cargaGridPresupuesto();
				gdPresupuestos.clearAndLoad(urlxmls + "formularios/data/presupuestos.php?op=load&id=" + codb + "&rs=" + (new Date()).valueOf());
			}	
		}
	}
}

//Form.OnButtonClick - Case PresupuestoGuardar
function clickPresupuestoSave()
{
	with(formPresupuesto)
	{

		codb = form.getItemValue("act_id");
			
		setItemValue("op", "presup");
		setItemValue("programa", codb);

		send(urlxmls + "formularios/data/presupuestos.php","post",function(xml){
			win.close();
			dhtmlx.alert(xml.xmlDoc.responseText);

			gdPresupuestos.clearAndLoad(urlxmls + "formularios/data/presupuestos.php?op=load&id=" + codb + "&rs=" + (new Date()).valueOf());
		});
	}
}

//Form.OnButtonClick - Case ProyectoAgregar
function clickProyectoAdd()
{
	ventanaProyecto("add");
}

//Form.OnButtonClick - Case ProyectoModificar
function clickProyectoBase()
{
	if(gdProyectos.getSelectedRowId()>0)
		ventanaProyecto("base");
	else
		dhtmlx.alert("Seleccione el proyecto para ver el baseline");
}

//Form.OnButtonClick - Case ProyectoEliminar
function clickProyectoDel()
{
	with(gdProyectos)
	{
		elemid = getSelectedRowId();
		if(elemid>0)
		{
			if(confirm("Esta seguro que desea eliminar el proyecto?"))
			{
				var xml = dhtmlxAjax.getSync(urlxmls + "formularios/data/proyectos.php?&op=delete&id=" + elemid);
				dhtmlx.alert(xml.xmlDoc.responseText);
				
				codb = form.getItemValue("act_id");
				gdProyectos = new dhtmlXGridObject(form.getContainer('proyectosgrid'));
				cargaGridProyectos();
				gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
			}	
		}
	}
}

//Form.OnButtonClick - Case ProyectoGuardar
function clickProyectoSave()
{
	with(gdBaseline)
	{
		lastId = getRowsNum() - 1;
		avance = cells2(lastId,1).getValue();
	}
	if(avance == 100)
	{
		with(formProyecto)
		{

			codb = form.getItemValue("act_id");
			
			setItemValue("op", "proy");
			setItemValue("programa", codb);
			var xml1 = serializar(gdBaseline);
			setItemValue("baseline", xml1);
	
			send(urlxmls + "formularios/data/proyectos.php","post",function(xml){
				win.close();
				dhtmlx.alert(xml.xmlDoc.responseText);
	
				gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
			});
		}
	}
	else
		dhtmlx.alert("El proyecto debe finalizar con un avance del 100%");
}

//Form.OnButtonClick - Case Reportar
function clickReportar()
{
	with(form)
	{
		codb = getCombo("codigob").getSelectedValue();
		if(codb>0)
		{
			showItem("frinversion");
			showItem("frpresupuestos");
			showItem("frcontrataciones");
			showItem("frproyectos");
			hideItem("frbuscar");
			
			load(urlxmls + "formularios/data/inversiones.php?op=load&id=" + codb, function(){
				gdPresupuestos.clearAndLoad(urlxmls + "formularios/data/presupuestos.php?op=load&id=" + codb);
				gdContratos.clearAndLoad(urlxmls + "formularios/data/contratos.php?op=load&id=" + codb);
				gdProyectos.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=load&id=" + codb);
				setItemValue("act_tipo",2); 
				setItemValue("act_id",codb);
			});
		}
	}
}

///////////////////////////////////

///////////////////////////////////
//    FUNCIONES DE LOS COMBOS    // 
///////////////////////////////////

function cargaAgenciaB()
{
	optsAgenciaB = form.getCombo("agenciab");
	with(optsAgenciaB)
	{
		loadXML(urlxmls + "formularios/data/opciones.php?op=agencia");
		attachEvent("onChange", function(){
			var v_a = getSelectedValue();
			if(v_a)
			{
		    	optsEnteB.loadXML(urlxmls + "formularios/data/opciones.php?op=entidad&agencia=" + v_a);
		    	form.setItemValue('agencia', v_a);
			}
		});
	}
}

function cargaEnteB()
{
	optsEnteB = form.getCombo("entidadb");
	with(optsEnteB)
	{
		attachEvent("onChange", function(){
			var v_a = optsAgenciaB.getSelectedValue();
			var v_e = getSelectedValue();
			if(v_a && v_e)
			{
				optsCodigoB.loadXML(urlxmls + "formularios/data/opciones.php?op=inversion&agencia=" + v_a + "&entidad=" + v_e);
				form.setItemValue('entidad', v_e);
			}
		});
	}
}

function cargaCodigoB()
{
	optsCodigoB = form.getCombo("codigob");
	with(optsCodigoB)
	{
		enableFilteringMode(true);
	}
}

function cargaAgencia()
{
	optsAgencia = form.getCombo("agencia");
	with(optsAgencia)
	{
		loadXML(urlxmls + "formularios/data/opciones.php?op=agencia");
		attachEvent("onChange", function(){
			optsEntidad.loadXML(urlxmls + "formularios/data/opciones.php?op=entidad&agencia=" + getSelectedValue(), function(){
	   			form.load(urlxmls + "formularios/data/inversiones.php?op=load2&id=" + optsCodigoB.getSelectedValue());
	   		});
		});
	}
}

function cargaEntidad()
{
    optsEntidad = form.getCombo("entidad");
}

function cargaEstado()
{
	optsEstado = form.getCombo("estado");
	optsEstado.loadXML(urlxmls + "formularios/data/opciones.php?op=estado");
}

function cargaFuncion()
{
	optsFuncion = form.getCombo("funcion");
	optsFuncion.loadXML(urlxmls + "formularios/data/opciones.php?op=funcion");
}

function cargaTipo()
{
	optsTipo = form.getCombo("tipo");
	optsTipo.loadXML(urlxmls + "formularios/data/opciones.php?op=tipo");
}

/////////////////////////////

function ventanaContrato(op)
{
	win = creaVentana(400,320,"Datos de la Contrataci&oacute;n",820)
	formContrato = formContratos(win);
	
	with(gdContratos)
	{
		if(op == "add")
			var act_tipo = 1;
		else
		{
			var rowId = getSelectedRowId();
			var numero = cells(rowId,0).getValue();
			var empresa = cells(rowId,1).getValue();
			var importe = cells(rowId,2).getValue();
			var iniprev = cells(rowId,3).getValue();
			var inireal = cells(rowId,4).getValue();
			var finprev = cells(rowId,5).getValue();
			var finreal = cells(rowId,6).getValue();
			var act_tipo = 2;
		}
	}
	with(formContrato)
	{
		codb = form.getCombo("codigob").getSelectedValue();
		
		setItemValue("programa", codb);
		setItemValue("numero", numero);
		setItemValue("empresa", empresa);
		setItemValue("importe", importe);
		setItemValue("iniprev", iniprev);
		setItemValue("inireal", inireal);
		setItemValue("finprev", finprev);
		setItemValue("finreal", finreal);
		setItemValue("act_tipo", act_tipo);
		setItemValue("id", rowId);
		attachEvent("onButtonClick", function(id){
	        switch(id)
	        {
				case "contratoguardar":
					clickContratoSave();
					break;

				default:
					win.close();
					break;
	    	}
	    });
	}
}

function ventanaPresupuesto(op)
{
	win = creaVentana(400,230,"Informaci&oacute;n del Presupuesto",600);
	formPresupuesto = formPresupuestos(win);

	with(gdPresupuestos)
	{
		if(op == "add")
		{
			if(getRowsNum()>0)
			{
				var anio = cells2(getRowsNum()-1,0).getValue();
				anio++;

				var ant = cells2(getRowsNum()-1,2).getValue();
				var act = cells2(getRowsNum()-1,3).getValue();
				var sig = 0;
			}
			else
			{
				now = new Date;
				var anio = now.getFullYear();
						
				var ant = 0;
				var act = 0;
				var sig = 0;
			}
			var act_tipo = 1;
		}
		else
		{
			var rowId = getSelectedRowId();
			var anio = cells(rowId,0).getValue();
			var ant = cells(rowId,1).getValue();
			var act = cells(rowId,2).getValue();
			var sig = cells(rowId,3).getValue();
			var act_tipo = 2;
		}
	}
	with(formPresupuesto)
	{
		codb = form.getCombo("codigob").getSelectedValue();
		
		setItemValue("programa", codb);
		setItemValue("anio", anio);
		setItemValue("anterior", ant);
		setItemValue("actual", act);
		setItemValue("siguiente", sig);
		setItemValue("act_tipo", act_tipo);
		setItemValue("id", rowId);
		attachEvent("onButtonClick", function(id){
	        switch(id)
	        {
				case "presupuestoguardar":
					clickPresupuestoSave();
					break;

				default:
					win.close();
					break;
	    	}
	    });
	}
}

function ventanaProyecto(op)
{
	win = creaVentana(400,470,"Datos del Proyecto",1140);
	formProyecto = formProyectos(win);
	
	with(formProyecto)
	{
		gdBaseline = new dhtmlXGridObject(getContainer("gdbaseline"));
		cargaGridBaseline();
		
		if(op == "add")
		{
			setItemValue("act_tipo",1);
			setReadonly("nombre", false);
			showItem("inicio");
			showItem("final");
			hideItem("inicio_ro");
			hideItem("final_ro");
			hideItem("cambios");
		}
		else
		{
			var rowId = gdProyectos.getSelectedRowId();

			setItemValue("act_tipo",2);
			setItemValue("id",rowId);
			setReadonly("nombre", true);
			hideItem("inicio");
			hideItem("final");
			showItem("inicio_ro");
			showItem("final_ro");
			showItem("cambios");
			
			load(urlxmls + "formularios/data/proyectos.php?op=get&id=" + rowId);
			gdBaseline.clearAndLoad(urlxmls + "formularios/data/proyectos.php?op=base&id=" + rowId);

		}

		attachEvent("onButtonClick", function(id){
	        switch(id)
	        {
				case "proyectoguardar":
					clickProyectoSave();
					break;
					
				default:
					win.close();
					break;
	    	}
	    });
	}
	
}

function creaVentana(wd, ht, txt, pos)
{
	var w = wins.createWindow("win", 0, 0, wd, ht);
	with(w)
	{
		setText(txt);
		button("park").hide();
		button("minmax1").hide();
		center();
		setModal(true);
        setPosition(getPosition()[0], pos);
		divModalCollection = document.getElementsByClassName("dhx_modal_cover_dv");
		divModal = divModalCollection[0];
		divModal.style.height = "1820px";
	}
	return w;
}


