///////////////////////////////////
//    FUNCIONES DE LOS GRIDS     // 
///////////////////////////////////

function cargaGridContratos()
{
	with(gdContratos)
	{
		setImagePath(urlxmls + "formularios/dhtmlx/imgs/");
		setHeader("Numero Contrato,Empresa(s) Adjudicataria(s),Importe,Inicio,#cspan,Final,#cspan");
		attachHeader("#rspan,#rspan,#rspan,Prevista,Real,Prevista,Real");
		setInitWidths("100,*,100,80,80,80,80");
		setColAlign("left,left,right,center,center,center,center");
		setColTypes("ro,ro,ro,ro,ro,ro,ro");
		init();
	}
}

function cargaGridPresupuesto()
{
	with(gdPresupuestos)
	{
		setImagePath(urlxmls + "formularios/dhtmlx/imgs/");
		setHeader("A&ntilde;o,Ejercicio Anterior,Ejercicio Actual,Ejercicio Siguiente");
		setInitWidths("*,180,180,180");
		setColAlign("center,right,right,right");
		setColTypes("ro,ro,ro,ro");
		init();
	}
}

function cargaGridProyectos()
{
	with(gdProyectos)
	{
		setImagePath(urlxmls + "formularios/dhtmlx/imgs/");
		setHeader("Proyecto,Presupuesto,#cspan,#cspan,Realidad,#cspan,#cspan,#cspan,#cspan");
		attachHeader("#rspan,Costo Total,Fecha Inicio,Fecha Fin,Fecha Inicio<br/>Real,% Avance<br/>Presup.,Costo Presup.<br/>a la Fecha,% Avance<br/>Real,Costo Real<br/>a la Fecha");
		setInitWidths("*,90,75,75,75,65,90,65,90");
		setColAlign("left,right,center,center,center,center,right,center,right");
		setColTypes("ro,ro,ro,ro,ro,ro,ro,ro,ro");
		init();
		
	}
}

function cargaGridBaseline()
{
	with(gdBaseline)
	{
		setHeader("MES,% AV,COSTE");
		setInitWidths("*,100,100"); 
		setColAlign("center,center,right"); 
		setColTypes("ro,ed,ed"); 
		init();
		attachEvent("onEditCell", function(stage,rId,cInd,nValue,oValue){
			switch(stage)
			{
				case 1:
					cells(rId,cInd).cell.firstChild.select();
					break;
				
				case 2:
					nValue = nValue.replace("&euro;","");
					switch(cInd)
					{
						case 1:
							if(nValue != '')
							{
								if(!isNumber(nValue))
									return false;
									
								rowInd = getRowIndex(rId) - 1;
								if(rowInd>0)
								{
									if(parseFloat(nValue) < parseFloat(cells2(rowInd,1).getValue()))
									{
										dhtmlx.alert("El avance no puede ser menor al mes anterior");
										return false;
									}
								}
							}
							break;
							
						case 2:
							if(nValue != '')
							{
								if(!isNumber(nValue))
									return false;
									
								var costo = 0;
								forEachRow(function(id){
									cellval = cells(id,2).getValue().replace("&euro;","");
									cellval = cellval.replace(".","");
									costo += parseFloat(revisaNum(cellval));
								});
								formProyecto.setItemValue("costo", formatoNum(costo) + "€");
		
								nValue = formatoNum(nValue) + " &euro;";
								return nValue;
							}
							break;
					}
					break;
			}
			
		    return true;
		});
	}
}