<?php

	//$urlxmls = "http://drupal6.betapruebas.com/";
	global $base_url;
	$urlxmls = $base_url."/";

    drupal_add_css("formularios/dhtmlx/dhtmlx.css");	  
    drupal_add_css("formularios/dhtmlx/dhtmlx_custom.css");	  
	drupal_add_js("formularios/dhtmlx/dhtmlx.js");

    drupal_add_css("modulos/css/template.css");
?>

<div id="form_container"></div>
<style type="text/css">
    .label-bold{
    	font-weight:bold;
    }
</style>
<script type="text/javascript">

function limpiar(f)
{
	f.clear();
}
    
function doGrid(name, value) {	
	var f = this.getForm();
	return '<div id="grid_container" style="width:560px;height:100px;"></div>';
}
	
var valorescombo = [
	{value: "1", text: "1", selected:true},
	{value: "2", text: "2"},
	{value: "3", text: "3"},
	{value: "4", text: "4"},
	{value: "5", text: "5"}
];

function lblValoracion(){
	return 	{type:"block", width:700, list:[
				{type:"label", label:"Valoración Anterior", labelWidth:110, offsetLeft:415, className:"valoracion"},
				{type:"newcolumn", offset:30},
				{type:"label", label:"Nueva Valoración", labelWidth:110, className:"valoracion"},
			]};
}

function inputValoracion(num,preg){
	return	{type:"block", width:700, list:[
				{type:"input", name:"op"+num, label:preg, readonly:true},
				{type:"newcolumn", offset:80},
				{type:"combo", name:"p"+num, label:"", options:valorescombo}
			]};
}
    
var struc = [
	{type:"settings", inputWidth:150, labelWidth:200},
	{type:"fieldset", name:"frbuscar", width:800, list:[
		{type:"label", label:"Evaluación por el Responsable del Programa", labelWidth:500},
		{type:"combo", name:"agenciab", label:"Departamento:", inputWidth:300},
		{type:"combo", name:"entidadb", label:"Entidad:", inputWidth:300},
	    	{type:"combo", name:"codigob", label:"Código del Programa:", inputWidth:300},
	    	{type:"newcolumn"},
	    	{type:"button", name:"reportar", value:"Reportar", offsetLeft:20, offsetTop:20}
	]},
	{type:"fieldset", name:"frinversion", width:750, list:[
	    {type:"settings", inputWidth:60, labelWidth:440},
	    {type:"label", label:"Formulario Evaluación del Responsable del Programa", labelWidth:500},
		{type:"input", name:"codigo", label:"Programa:", inputWidth:670, labelWidth:120, readonly:true},
		{type:"input", name:"ultima", label:"Última Evaluación:", inputWidth:100, labelWidth:120, readonly:true},
		{type:"fieldset", name:"a1", label:"Gestión de Riesgos", width:800, list:[
			lblValoracion(),
			inputValoracion(1, "1. Existe una estrategia de gestión de riesgos:"),
			inputValoracion(2, "2. Los riesgos se entienden:"),
			inputValoracion(3, "3. Los riesgos se priorizan:"),
			inputValoracion(4, "4. Hay un seguimiento de riesgos:"),
			inputValoracion(5, "5. Se establecen planes de contingencia:")
		]},
		{type:"fieldset", name:"a2", label:"Gestión de Requisitos", width:800, list:[
			lblValoracion(),
			inputValoracion(6, "6. Los objetivos son claros:"),
			inputValoracion(7, "7. El alcance se controla:"),
			inputValoracion(8, "8. Los requisitos son completos, claros y están validados:"),
			inputValoracion(9, "9. Los implicados apropiados han participado en la definición de requisitos:")
		]},
		{type:"fieldset", name:"a3", label:"Supervisión de Contratistas", width:800, list:[
			lblValoracion(),
			inputValoracion(10, "10. Hay una estrategia de contratación:"),
		    {type:"fieldset", name:"a3_1", label:"11. Se recibe información del contratista como", list:[
		    	{type:"settings", labelWidth:425},
				inputValoracion(11, "a. Informes EVM (control integrado de costo/plan):"),
				inputValoracion(12, "b. Estado del programa:"),
				inputValoracion(13, "c. Estado de los riesgos:")
	    	]},
			inputValoracion(14, "12. Se monitoriza, controla al contratista:")
		]},
		{type:"fieldset", name:"a4", label:"Capital Humano", width:800, list:[
			lblValoracion(),
			inputValoracion(15, "13. El equipo está cualificado:"),
			inputValoracion(16, "14. Baja tasa de rotación (de personal):")
		]},
		{type:"fieldset", name:"a5", label:"Otros", width:800, list:[
			lblValoracion(),
			inputValoracion(17, "15. Cualquier otro factor que el Responsable del Programa considera importante:")
		]},
		{type:"input", name:"comentarios", label:"Comentarios:", inputWidth:780, rows:3},
		{type:"input", name:"evaluacion", label:"Evaluación Promedio:", value:"1", className:"label-bold", inputWidth:60, labelWidth:200, offsetLeft:200, readonly:true},
		{type:"calendar", name:"fechaalta", label:"Fecha Envío:", className:"label-bold", inputWidth:80, labelWidth:200, offsetLeft:200, validate:"NotEmpty"},
	        {type:"block", width: 550, list:[
	            	{type:"button", name:"guardar", value:"Guardar Cambios", offsetLeft:210, offsetTop:10},
	            	{type:"newcolumn"},
	            	{type:"button", name:"cancelar", value:"Cancelar", offsetLeft:50, offsetTop:10}
	        ]},
       		{type:"hidden", name:"fecha"}
	]}
];

var form = new dhtmlXForm("form_container",struc);
with(form)
{
	attachEvent("onButtonClick", function(id){
   		switch(id)
   		{
   	    	case "reportar":
				var codinv = getCombo("codigob").getSelectedValue();
				var nominv = getCombo("codigob").getSelectedText();
				if(codinv)
				{
					showItem("frinversion");
					hideItem("frbuscar");
					setItemValue("codigo", nominv);
					load("<?php echo $urlxmls; ?>formularios/data/evaluaciones.php?op=last&id=" + codinv);
				}
				else
					dhtmlx.alert("Seleccione un programa de la lista");
   	    		break;

   			case "guardar":
		    	setItemValue("fecha",getCalendar("fechaalta").getFormatedDate("%Y-%m-%d"));
   				send("<?php echo $urlxmls; ?>formularios/data/evaluaciones.php","post",function(xml){
   	    	    	dhtmlx.alert(xml.xmlDoc.responseText);
			    	limpiar(form);
    	    		showItem("frbuscar");
    	    		hideItem("frinversion");
	    		});
	    		break;

			case "limpiar":
				limpiar(form);
				break;

			case "cancelar":
				limpiar(form);
	    	    		showItem("frbuscar");
	    	    		hideItem("frinversion");
				break;
		}
        });
        attachEvent("onChange", function(id, value){
    		prom = 0;
    	    	cont = 0;
    	    	forEachItem(function(id){
    	        	if(id.indexOf("p")==0)
    	        	{
    	            		prom += parseInt(getItemValue(id));
    	            		cont++;
    	        	}
	    	});
	    	prom /= cont;
	    	setItemValue("evaluacion", Math.round(prom*10)/10);
        });

	attachEvent("onValidateError", function (input, value, result){
		dhtmlx.alert("Revise los datos del formulario. Existen campos sin rellenar.("+input+")");
	});

   	hideItem("frinversion");
}

var optsAgenciaB = form.getCombo("agenciab");
optsAgenciaB.loadXML("<?php echo $urlxmls; ?>formularios/data/opciones.php?op=agencia");
optsAgenciaB.attachEvent("onChange", function(){
	var v_a = optsAgenciaB.getSelectedValue();
	if(v_a)
	{
	    	optsEnteB.loadXML("<?php echo $urlxmls; ?>formularios/data/opciones.php?op=entidad&agencia="+v_a);
	    	form.setItemValue('agencia',v_a);
	}
});

var optsEnteB = form.getCombo("entidadb");
optsEnteB.attachEvent("onChange", function(){
	var v_a = optsAgenciaB.getSelectedValue();
	var v_e = optsEnteB.getSelectedValue();
	if(v_a && v_e)
	{
		optsCodigoB.loadXML("<?php echo $urlxmls; ?>formularios/data/opciones.php?op=inversion&agencia="+v_a+"&entidad="+v_e);
	    	form.setItemValue('entidad',v_e);
	}
});

var optsCodigoB = form.getCombo("codigob");
optsCodigoB.enableFilteringMode(true);
	    
</script>