<?php
    drupal_add_css("formularios/dhtmlx/dhtmlx.css");	  
    drupal_add_js("formularios/dhtmlx/dhtmlx.js");
    drupal_add_js("formularios/dhtmlx/format-number.js");
    
	global $base_url;
	$urlxmls = $base_url."/";
	//$urlxmls = "http://drupal6.betapruebas.com/";

?>

<div id="form_container" style="width:600px;height:600px;"></div>
<script type="text/javascript">

var grid; var err;
	
function limpiar(f)
{
	f.clear();
	grid.clearAll();
}

function doGrid(name, value) 
{	
	var f = this.getForm();
	return '<div id="grid_container" style="width:550px;height:300px;"></div>';
}
	
	
	var struc = [
		{type:"settings", inputWidth:150, labelWidth:200},
		{type:"fieldset", name:"frinversion", width:700, list:[
			{type:"label", label:"Formulario Programas de Alta Prioridad", labelWidth:500},
			{type:"combo", name:"agencia", label:"Departamento:", inputWidth:300, validate:"NotEmpty"},
			{type:"combo", name:"entidad", label:"Entidad:", inputWidth:300, validate:"NotEmpty"},
			{type: "template", name: "presupuesto", label: "", value: "", format: "doGrid", inputWidth:550}
		]}
	];
	    
	var form = new dhtmlXForm("form_container",struc);
	with(form)
    	{
		attachEvent("onButtonClick", function(id){
    	    switch(id)
    	    {
    	    	case "guardar":
    	    		err = "";
	    	    	var xml1 = "";
					grid.forEachRow(function(id){
		        		grid.forEachCell(id,function(cellObj,ind){
		            		xml1 += cellObj.getValue() + "@@";
						});
		        		xml1 += id + "@@||"; 
		    		});
		    		setItemValue("presupuesto",xml1);
		    		
			    	setItemValue("fecha",getCalendar("fechaalta").getFormatedDate("%Y-%m-%d"));
		    	    	if(grid.getRowsNum()>0)
		    	    		setItemValue("anio",grid.cells2(grid.getRowsNum()-1,0).getValue());
			    	
			    	send("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php","post",function(xml){
			    		send("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php");
		    	    	    	alert(xml.xmlDoc.responseText);
				    	limpiar(form);
				});
		        break;
			        
			case "cancelar":
				limpiar(form);
				break;
		    }
        });

		attachEvent("onValidateError", function (input, value, result){
			err += input + ",";
		});
		
		attachEvent("onAfterValidate", function (status){
			if(status==false)
				alert("Revise los datos del formulario. Existen campos sin rellenar.("+err+")");
     			
		});
	}
	
	var opts = form.getCombo("agencia");
	opts.loadXML("<?php echo $urlxmls; ?>formularios/data/opciones.php?op=agencia");
	opts.attachEvent("onChange", function(){
		var v_a = opts.getSelectedValue();
		if(v_a)
		{
		    	var opts2 = form.getCombo("entidad");
		    	opts2.loadXML("<?php echo $urlxmls; ?>formularios/data/opciones.php?op=entidad&agencia="+v_a);
			grid.clearAndLoad("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php?op=priority&agencia="+v_a);
		}
	});

	var opts3 = form.getCombo("entidad");
	opts3.attachEvent("onChange", function(){
		var v_a = opts.getSelectedValue();
		var v_e = opts3.getSelectedValue();
		if(v_a && v_e)
			grid.clearAndLoad("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php?op=priority&agencia="+v_a+"&entidad="+v_e);
	});
	    
	grid = new dhtmlXGridObject('grid_container');
	with(grid)
	{
		setImagePath("<?php echo $urlxmls; ?>formularios/dhtmlx/imgs/");
		setHeader("Codigo,Nombre,Alta Prioridad");
		setInitWidths("150,300,80");
		setColAlign("left,left,center");
		setColTypes("ro,ro,ch");
		init();
		attachEvent("onCheck", function(rId,cInd,state){
			var xml = dhtmlxAjax.postSync("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php", "op=marcar&state="+state+"&id="+rId);
			dhtmlxAjax.postSync("<?php echo $urlxmls; ?>formularios/data/altaprioridad.php", "op=marcar&state="+state+"&id="+rId);
			alert(xml.xmlDoc.responseText);
		});
    	}
</script>