function TablaOcupacion(idContainer){	
	this.idContenedorTabla="#"+idContainer;
	this.esViernes=false;
	this.horasNormales=20;//las 8 de la tarde
	this.horasViernes=15;//las 3 de la tarde
	this.crearCuarto=function(id){
		return "<td id='"+id+"' onclick='seleccionar(\"#"+id+"\")'></td>";
	}
	/*
	 * Dando una fila y una columna crear una hora con sus cuartos
	 * Cuatro celdas con un id único en la tabla
	 * */
	this.crearHora=function (f,h){
		var id=f+"_"+h+"_"; 
		//return "<td class='init' id='"+id+"1'></td><td id='"+id+"2'></td><td id='"+id+"3'></td><td id='"+id+"4'></td>";		
		return this.crearCuarto(id+'1')+this.crearCuarto(id+'2')+this.crearCuarto(id+'3')+this.crearCuarto(id+'4');
		
	}
	/*
	 * Crea la fila (f), para el objeto f
	 */
	this.crearLinea=function(nombre,codigo,f){
		var resultado="<tr class='linea'><td class='nombreobjeto'>"+nombre+"<input type='hidden' id='"+f+"code' value='"+codigo+ "'/></td>";
		
		var hasta;
		if(this.esViernes)
			hasta=this.horasViernes;
		else
			hasta=this.horasNormales;
		for(var i=8;i<hasta;i++){
			resultado+=this.crearHora(f,i);
		}
		resultado+="</tr>";
		return resultado;
	}
	/*
	 * Pone le estado del cuarto en ocupado
	 * */
	this.seleccionarCuarto=function (f,h,c,situacion){
		var id="#"+f+"_"+h+"_"+c;
		if(situacion=='A')
			$(id).attr("class","ocupado");
		else
			$(id).attr("class","nodisponible");
	}
	/*
	 * Pone le estado del cuarto en nodisponible
	 * */
	this.noDisponible=function (f,h,c){
		var id=f+"_"+h+"_"+c;
		$(id).attr("class","nodisponible");
	}
	/*
	 * Crea la cabecera donde se ponen las horas
	 */
	this.crearCabeceraTabla=function(){
		var resultado="<tr class='cabecera'><td class='nombreobjeto'><span class='hora'>8:00</span></td>";
		var hasta;
		if(this.esViernes)
			hasta=this.horasViernes-8;
		else
			hasta=this.horasNormales-8;
		for(var i=0;i<hasta;i++){
			resultado+="<td colspan='4'><span class='hora'>"+(9+i)+":00</span></td>";
		}
		resultado+="</tr>";
		return resultado;
	}
	/*
	 * Crea la tabla de prueba
	 */
	this.crearTabla=function(){
		var tabla="<table class='tablaOcupacionClass'>";
		tabla+=this.crearCabeceraTabla();
		for(var i=0;i<20;i++){
			tabla+=this.crearLinea("prueba","1", i);
		}		
		tabla+="</table>";
		$(this.idContenedorTabla).html(tabla);
	}
	/*
	 * Crea una tabla para una fecha en concreto para todas las salas. Mira si es viernes
	 * */
	this.crearTablaConSalas=function(salas,viernes){
		this.esViernes=viernes
		var tabla="<table class='tablaOcupacionClass'>";
		tabla+=this.crearCabeceraTabla();
		for(var i=0;i<salas.length;i++){
			tabla+=this.crearLinea(salas[i].nombre,salas[i].codigo, i);
		}		
		tabla+="</table>"
		$(this.idContenedorTabla).html(tabla);
		for(var i=0;i<salas.length;i++){
		  this.ocuparHuecos(salas[i].ocupaciones,i);
		}
		
	}
	/*
	 * 
	 * */
	this.ocuparHuecos=function(ocupaciones,linea){
		if(ocupaciones!=null&&ocupaciones.length>0){
			for(var a=0;a<ocupaciones.length;a++){
			var horaentrada=ocupaciones[a].horaInicio.split(":");
			var horasalida=ocupaciones[a].horaFin.split(":");
			var hora1=parseInt(horaentrada[0]);
			var hora2=parseInt(horasalida[0]);
			var cuarto1=this.getCuarto(parseInt(horaentrada[1]));
			var cuarto2=this.getCuarto2(parseInt(horasalida[1]));
			if(parseInt(horasalida[1])==0)
					hora2--;
			var cuartoinit;
			var cuartofin;
			if(ocupaciones[a].situacion!='B'){
			for(var i=hora1;i<=hora2;i++){
				if(i==hora1)
					cuartoinit=cuarto1;
				else
					cuartoinit=1;
				if(i==hora2)
					cuartofin=cuarto2;
				else
					cuartofin=4;
				
				for(var k=cuartoinit;k<=cuartofin;k++){
					this.seleccionarCuarto(linea,i,k,ocupaciones[a].situacion);
					var id="#"+linea+"_"+i+"_"+k;
					$(id).rup_tooltip(
						      {
						            content : {
						                  text : ocupaciones[a].horaInicio+"-"+ocupaciones[a].horaFin
						               
						            }
						            
						      });

				}
			
			}
			}
			}
		}
	}
	/*
	 * Devuelve el cuarto correspondiente a un minuto de inicio
	 * */
	this.getCuarto=function(minuto){
		if(minuto>=0 &&minuto<15)
			return 1;
		else if(minuto>=15 && minuto<30)
			return 2;
		else if(minuto>=30 && minuto<45)
			return 3;
		else if(minuto>=45)
			return 4;
		
	}
	/*
	 * Devuelve el cuarto correspondiente a un minuto final
	 * */
	this.getCuarto2=function(minuto){
		if(minuto>0 &&minuto<=15)
			return 1;
		else if(minuto>=16 && minuto<=30)
			return 2;
		else if(minuto>=31 && minuto<=45)
			return 3;
		else if(minuto>=46||minuto==0)//si el minuto es 0  hay que restar uno a la hora
			return 4;
		
	}
}


var tablaOcupacion1;


/*Controla el modo departamento para la página actual*/
var modoDepartamento=false;
$( document ).ready(function() {
	$("#salas_feedback").rup_feedback({});
	tablaOcupacion1=new TablaOcupacion("contendedorTabla");
	jQuery("#ubicaciones").rup_combo({
		width :250,
		blank : "-1",
		selected:0,
		loadFromSelect:true
		});
	jQuery("#salas1").rup_combo({
		width :250,			
		parent: [ "ubicaciones" ],
		source : "../aa00j10s01/comboPorEdif",
		sourceParam: {
			label:"nombre10",
			value:"csala10"
		},
		blank : "-1",
		method : 'GET'
		
 	});
	jQuery("#departamentos").rup_combo({
		width :250,
		blank : "-1",
		selected:0,
		loadFromSelect:true
		});
	jQuery("#salas2").rup_combo({
		width :250,			
		blank : "-1",
		parent: [ "departamentos" ],
		source : "../aa00j10s01/comboPorDep",
		sourceParam: {
			label:"nombre10",
			value:"csala10"
		}
		,
		method : 'GET'
		
 	});
	//tablaOcupacion1.crearTabla();

	
	$("#calendario2").rup_date( 	{
//		dateFormat:'dd/mm/yy'
		numberOfMonths:1,
		firstDay:1,
		minDate:new Date(),
		multiSelect:60
	
		
	
	});

	 reiniciar();
	 $("#fake_filter_toolbar").bind("click", function () {
		 toogleForm();
	 });
});

function departamental(esDepartamental){
	modoDepartamento=esDepartamental;
	if(esDepartamental){
		$("#departamentosdiv").show();
		$("#comunesdiv").hide();
	}
	else{
		$("#departamentosdiv").hide();
		$("#comunesdiv").show();
	}
	
}
function buscarOcupacion(){
	if(modoDepartamento){
	$("#salas_filter_form").rup_form({
        feedback:$("#salas_feedback"),
        validate: {
            rules: {
        	  	"calendario2":{required:true}
            }
        },
       success:function(){
    	   buscarOcupacion2();
        }
	});
}
else{
	$("#salas_filter_form").rup_form({			
        feedback:$("#salas_feedback"),
        validate: {
            rules: {
            	"calendario2":{required:true}
            }
        },	        
        success:function(){
        	buscarOcupacion2();
        }
	});
}	
$("#salas_filter_form").rup_form("submit");
	
}
/**
 * Función para buscar la ocupación al hacer click en el botón buscar.
 * Si hay solamente una fecha seleccionada, se muestran los datos para todas las salas que cumplan el resto del filtrado
 * Si hay mas de una fecha seleccionada, se muestra la ocupación de la sala seleccionada esos días
 */
function buscarOcupacion2(){

	var fechas=$("#calendario2").rup_date("getDate").split(",");
	var sala;
	if(fechas.length>1)	{
		//hay más de una fecha, hay que se ver si hay una sala seleccionada para poder hacer algo
		//el asp cuando hay varias fechas muestra la tabla para la sala seleccionada 				
		if(modoDepartamento){
			sala=$("#salas2").rup_combo("value");
		}
		else{
			sala=$("#salas1").rup_combo("value");
		}
		if(sala==""||sala=="-1"){//avisar, hay que seleccionar sala
			alert("Cuando se ha seleccionado un día, es necesario seleccionar una sala")
		}
		else{
			//obtener los horarios de la sala
			var params={};
			params.dia=$("#calendario2").rup_date("getDate");
			params.sala=sala;
			$("#dialogoEspera").show();
			$.post( "../consultas/salasReservadas", 
					params, function( data ) {		
				$("#dialogoEspera").show();
						tablaOcupacion1.crearTablaConSalas(data,false);
						$("#leyenda").show();
						$("#dialogoEspera").hide();
				}, "json").fail(function() {
					$("#dialogoEspera").hide();
				});
		}
		
	}
	else if(fechas.length==1){//todas las salas filtradas, en la fecha
		var params={};
		params.dia=fechas[0];

		if(modoDepartamento){
			sala=$("#salas2").rup_combo("value");
			if(sala==""||sala=="-1"){
				if($("#departamentos").rup_combo("value")!="")
					params.departamento=$("#departamentos").rup_combo("value");
				else
					params.departamento=-1;
			}
			else{
				params.sala=sala;
			}
		}
		else{
			sala=$("#salas1").rup_combo("value");
			if(sala==""||sala=="-1"){
				if($("#ubicaciones").rup_combo("value")!="")
					params.edificio=$("#ubicaciones").rup_combo("value");
				else
					params.edificio=-1;
			}
			else{
				params.sala=sala;
			}
		}
		$("#dialogoEspera").show();
		$.post( "../consultas/salasReservadas", 
				params, function( data ) {
					var fechas1=fechas[0].split("/");
					var date=new Date(fechas1[2]+"-"+fechas1[1]+"-"+fechas1[0]);
			
					var esViernes=date.getDay()==5?true:false;
					tablaOcupacion1.crearTablaConSalas(data,esViernes);
					$("#leyenda").show();
					$("#dialogoEspera").hide();
			}, "json").fail(function() {
						$("#dialogoEspera").hide();
						});
	}
	
}
/**
 * Limpia el formulario
 */
function reiniciar(){
	departamental(false);
	$("#radio1").attr("checked","checked");
	jQuery("#ubicaciones").rup_combo("value","-1");
	jQuery("#departamentos").rup_combo("value","-1");
}
function seleccionar(id){
	var ids=id.split("_");
	//tablaOcupacion1.seleccionarCuarto(ids[0],ids[1],ids[2]);
	var clase=$(id).attr("class");
	if(clase!="ocupado" && clase!="nodisponible"){
		var hi=ids[1]+":"+15*(parseInt(ids[2])-1);
		
		var hf=ids[1]+":";
		if(15*parseInt(ids[2])==60)//último cuarto, sumar hora
			hf=(parseInt(ids[1])+1)+":00";
		else {
			if(parseInt(ids[2])!=0)
				hf=ids[1]+":"+15*parseInt(ids[2]);
			else
				hf=ids[1]+":"+15*parseInt(ids[2])+"0";
		}
		reservarSala($(ids[0]+"code").val(),hi,hf,ids[0].substr(1,ids[0].length));
		
		
	}
}
/**
 * Esta funcion sirve para reservar una sala en concreto. Llamará a una jsp
 * @param idsala
 */
function reservarSala(idsala,horaInicio,horaFin,fila){	
	var fechas=$("#calendario2").rup_date("getDate").split(",");
	$("#sala").val(idsala);
	$("#edificio").val(-1);
	if(fechas.length==1)
		$("#dias").val(fechas[0]);
	else 
		$("#dias").val(fechas[fila]);
	$("#horaInicio").val(horaInicio);
	$("#horaFinal").val(horaFin);
	$("#oculto").submit();
}
function limpiar(){
	$("#contendedorTabla").html("");
	departamental(false);
	$("#radio1").attr("checked","checked");
	$("#ubicaciones").rup_combo("select",0);
	$("#departamentos").rup_combo("select",0);
	$("#calendario2").rup_date("destroy");
	$("#calendario2").val("");
	$("#calendario2").rup_date( 	{
		numberOfMonths:1,
		firstDay:1,
		minDate:new Date(),
		multiSelect:60	
	});
	$("#leyenda").hide();
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaPanelOcupacion,"ayuda_feedback");
}