/**
 * Controla la visibilidad de los botones de las fechas
 * @param contenedor
 * @returns {botonesFechas}
 */
function botonesFechas(cont){
	this.idactivado=-1;
	this.contenedor="#"+cont;
	this.crear=  function(dias){
		var str="";
		if(dias!=null){
			for(var k=0;k<dias.length;k++){
				str+="<span class='pestanafecha' id='fechaboton"+k+"' onclick='buscarDia("+k+")'>"+dias[k]+"</span>";
			}
			$(this.contenedor).html(str);
			this.activar(0);
		}
	}
	this.activar=function(id){
		if(this.idactivado!=-1)
			$("#fechaboton"+this.idactivado).attr('class','normal');
		$("#fechaboton"+id).attr('class','activado');
		this.idactivado=id;
	}
	this.borrar=function(){
		$(this.contenedor).html("");
	}
}

jQuery(function($){
	$("#dia").rup_date ({multiSelect:60,minDate:new Date()});
	$("#diadesde").rup_date({minDate:new Date()});
	$("#diahasta").rup_date({minDate:new Date()});
	$.rup_date ({from: "diadesde",
		to: "diahasta"});
			$("#horaIni").rup_time({hour:8,minute:0,
				onSelect:function(dateText,inst){
					if(dateText>$("#horaFin").rup_time("getTime"))
						$("#horaFin").val(dateText);	
				}
			});
			
			$("#horaFin").rup_time({hour:9,minute:0,
				onSelect:function(dateText,inst){
					if(dateText<$("#horaIni").rup_time("getTime"))
						$("#horaIni").val(dateText);	
				}	
			});
			jQuery("#ubicacion").rup_combo({
				width :250,
				blank : "",
				
				loadFromSelect:true
				});
			
			jQuery("#mediosFijos").rup_combo({
							width :250,
				
				multiselect:true,
				loadFromSelect:true
				});


		
		$("#salas_filter_form").rup_form("clearForm");
		$("#salas").rup_table({
			url:"../aa00j10s01",
			colNames:[ "", $.rup.i18n.app.ConsultaAsistida.titulo2, $.rup.i18n.app.ConsultaAsistida.titulo3, $.rup.i18n.app.ConsultaAsistida.titulo4],
			colModel: [	
			           { 	name: "csala10",
			         			 	label: "",
			         				align: "left",
			         				width: 50,
			         				editable: false,
			         				fixed: false,
			         				hidden: false,
			         				resizable: false,
			         				sortable: false,
			                      
			                         align : "center",
			                         resizable: false,
			                         width: 30,
			                         sortable:false,
			                         formatter :
			                               masiveIconFormatter = function (cellvalue, options, rowObject)
			                               {
			                                     var html = '';
			                                                html="<input type='button' value='"+$.rup.i18n.app.ConsultaAsistida.reservar+"' onclick='reservarSala(\""+rowObject.csala10+"\")'/>"
			                                  
			                                    return html;
			                               }

			         			},
			         			{ 	name: "nombre10",
			         			 	label:  $.rup.i18n.app.ConsultaAsistida.titulo2,
			         				align: "left",
			         				width: 50,
			         				editable: false,
			         				fixed: false,
			         				hidden: false,
			         				resizable: false,
			         				sortable: false,
			                         formatter :
			                              linkFormatter = function (cellvalue, options, rowObject)
			                               {
			                                     var html = '';
			                                      html="<a href='javascript:crearDialogoDetalle(\""+rowObject.csala10+"\")'>"+rowObject.nombre10+"</a>";
			                                  
			                                    return html;
			                               }
			         			},{ 	name: "ncap10",
			         			 	label:  $.rup.i18n.app.ConsultaAsistida.titulo3,
			         				align: "left",
			         				width: 50,
			         				editable: false,
			         				fixed: false,
			         				hidden: false,
			         				resizable: false,
			         				sortable: false
			         			},{ name: "aa00j06s01."+ ($.rup_utils.capitalizedLang()=="Es" ? "descc06" : "desce06"),
			         			 	label:  $.rup.i18n.app.ConsultaAsistida.titulo4,
			         				align: "left",
			         				width: 50,
			         				editable: false,
			         				fixed: false,
			         				hidden: false,
			         				resizable: false,
			         				sortable: false
			         			}
			         	],
			model:"Aa00j10s01",
			usePlugins:["filter","fluid","toolbar","feedback"],
			
			filter:{
				url:"../aa00j10s01/consultaAsistida",
				 clearSearchFormMode:"reset",
		            showHidden:false
			},
			
			primaryKey: "csala10",
			sortname: "csala10",
			sortorder: "asc",
			loadOnStartUp: false
		});
		
	
		
				diasSueltos();
	
		//
	//	$("#listaDiasSueltos").hide();
//		$("#salas").on("rupTable_beforeProcessing", function(event, data, st,
//				xhr){
//			alert(data);
//			
//		});
		
		
	
		
}
);

function diasSueltos(){
//	$("#diasconsecutivos").hide();
//	
//	$("#diassueltos").show();
	$("#sueltos1").attr("checked","checked");
	//$("#idTable").rup_table("showFeedback",$("#salas_feedback"), "Días sueltos: muestra las salas libres en cada día. ", "ok",{});
	
}
function diasConsecutivos(){
//	$("#diassueltos").hide();
//	$("#diasconsecutivos").show();
	//$("#idTable").rup_table("showFeedback",$("#salas_feedback"), "Días consecutivos: muestra las salas libres en el rango de días seleccionado. ", "ok",{});

}
function buscarDia(ind){

	controlBotones.activar(ind);
	var dias=$("#dia").rup_date("getDate").split(",");
	$("#fecha").val(dias[controlBotones.idactivado]);
	buscar(ind,true);
}
var controlBotones=new botonesFechas("listaDiasSueltos");

function busquedaInicial(){
	buscar(0,false);
}
/**
 * Busca 
 * @param ind
 * @param creado
 */
function buscar(ind,creado){

	var radio=$("#salas_filter_form input[type='radio']:checked").val();
	if(radio==1){//multiple se manda solo el día actual
		$("#dias").val($("#dia").rup_date("getDate").split(",")[controlBotones.idactivado]);

	//en la consola da error pero no he podido validarlo de otra forma
$("#salas_filter_form").rup_form({
			
            feedback:$("#salas_feedback"),
            validate: {
                rules: {
            	  	"dia":{required:true},            	  
                    "horaIni":{required:true},
            	  	"horaFin":{required:true},
            	  	"ubicaciones":{required:true},
            	  	"capacidad":{number:true}
            	  	//,
            	  	//"medios":{required:false}
                   
                }
            },
            success:function(){
            	buscar2(ind,creado);
            }
		});
	}
	else{
$("#salas_filter_form").rup_form({
			
            feedback:$("#salas_feedback"),
            validate: {
                rules: {            	  	
            	  	"diadesde":{required:true},
            	  	"diahasta":{required:true},
                    "horaIni":{required:true},
            	  	"horaFin":{required:true},
            	  	"ubicaciones":{required:true},
            	  	"capacidad":{number:true}
            	  	//,
            	  	//"medios":{required:false}
                   
                }
            },
            success:function(){
            	buscar2(ind,creado);
            }
		});
	}
	$("#salas_filter_form").rup_form("submit");

	
	
}
function buscar2(ind,creado){

	var radio=$("#salas_filter_form input[type='radio']:checked").val();
	if(radio==1){//multiple se manda solo el día actual
		$("#dias").val($("#dia").rup_date("getDate").split(",")[controlBotones.idactivado]);
		if(radio==1){//Hay que poner un boton por cada día para hacer la comprobación
			var dias=$("#dia").rup_date("getDate").split(",");
			if(!creado)
			controlBotones.crear(dias);		
			
		}
		else{//borrar lista de botones 		
			controlBotones.borrar();
		}
		var datos=$("#mediosFijos").rup_combo("value");
		if(datos.length>0){
			var parametros={};
			parametros["mediosFijos"]=datos;
			var kk=jQuery.toJSON(parametros);
			//Chapuza para emular al ASP:
			//Primero se buscasn las salas que tengan todos los equipamientos
			//Si existen, se hace la petición con todos los campos,(esto se hace en el controller) 
			//Si no existen muestra la alerta 
		
			$.ajax({
				type: "POST",
				url:  "../aa00j10s01/contarSalasConMedios",
				data: kk,
				success: function( data ) {
					if(data==0){	
						if($.rup.lang=="es")
							alert("NO HAY SALAS CON TODOS LOS MEDIOS FIJOS ESPECIFICADOS EN SU CONSULTA.\nNECESITARÁ RESERVAR MEDIOS MÓVILES");
						else
							alert("EZ DAGO ZURE KONTSULTAN ZEHAZTUTAKO BALIABIDE FINKO GUZTAK DITUEN ARETORIK.\nBALIABIDE MUGIKORRAK ERRESERBATU BEHARKO DITUZU");
					
					}
					$("#listaDiasSueltos").show();
					if(radio==1)//fechas multiples, buscar dia seleccionado
						$("#fecha").val(dias[controlBotones.idactivado]);				
					$("#salas").rup_table("filter");
					$("#salas_grid_div").show();
			},
		    contentType: "application/json; charset=utf-8",
		    dataType: "json"
		
				});
		}
		else{
			$("#listaDiasSueltos").show();
			if(radio==1)//fechas multiples, buscar dia seleccionado
				$("#fecha").val(dias[controlBotones.idactivado]);		
			$("#salas").rup_table("filter");
			$("#salas_grid_div").show();
		}
	}
}
/**
 * Esta funcion sirve para reservar una sala en concreto. Llamará a una jsp
 * @param idsala
 */
function reservarSala(idsala){
	var radio=$("#salas_filter_form input[type='radio']:checked").val();
	
	$("#sala").val(idsala);
	$("#edificio").val($("#ubicacion").rup_combo("value"));
	if(radio==1)//multiple se manda solo el día actual
		$("#dias").val($("#dia").rup_date("getDate").split(",")[controlBotones.idactivado]);
	else{//rango calcular días
		$("#dias").val(fechasEntreFechas($("#diadesde").rup_date("getDate"),$("#diahasta").rup_date("getDate")));
	}		
	$("#horaInicio").val($("#horaIni").rup_time("getTime"));
	$("#horaFinal").val($("#horaFin").rup_time("getTime"));
	$("#oculto").submit();
}
/**
 * Devuelve la lista de fechas formateadas correctamente entre dos fechas.
 * fecha1<=fecha2
 * @param fecha1
 * @param fecha2
 */
function fechasEntreFechas(fecha1, fecha2){
	var fechaarr1=fecha1.split("/");
	var fechaarr2=fecha2.split("/");
	var date1;
	var date2;
	if($.rup.lang=="es"){
		date1= new Date(fechaarr1[2],fechaarr1[1],fechaarr1[0]);
		date2= new Date(fechaarr2[2],fechaarr2[1],fechaarr2[0]);
	}else{
		date1= new Date(fechaarr1[0],fechaarr1[1],fechaarr1[2]);
		date2= new Date(fechaarr2[0],fechaarr2[1],fechaarr2[2]);
	}
	var currDate=new Date(date1.getFullYear(), date1.getMonth(), date1.getDate());
	var count=0;
	var resultado=new Array();
	while(currDate.getTime()<= date2.getTime()){
		if($.rup.lang=="es")
			resultado.push(currDate.getDate()+"/"+ currDate.getMonth()+"/"+ currDate.getFullYear());
		else
			resultado.push(currDate.getFullYear()+"/"+ currDate.getMonth()+"/"+ currDate.getDate());
		count++;
		currDate=new Date(date1.getFullYear(), date1.getMonth(), date1.getDate()+count);
	}
	return resultado.toString();
	
}
function limpiarBusqueda(){
	$("#ubicacion").rup_combo("clear");
	$("#mediosFijos").rup_combo("clear");
	$("#horaIni").rup_time("setRupValue","");
	
	$("#horaFin").rup_time("setRupValue","");
	$("#capacidad").val("");
	$("#diadesde").rup_date("setRupValue","");
	$("#diahasta").rup_date("setRupValue","");
	$("#dia").rup_date("setRupValue","");
	$("#salas_grid_div").hide();
	$("#listaDiasSueltos").hide();
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaConsultasAsistida,"ayuda_feedback");
}