jQuery(function($){

	$("#TextosReserva").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j04s01",
		colNames: [
			"ctexto04",
			$.rup.i18n.app.TextoReservas.nombre,
			$.rup.i18n.app.TextoReservas.textc,
			$.rup.i18n.app.TextoReservas.texte,
			Situacion,
			"bloq04",
			"usub04",
			
		],
		colModel: [
			{ 	name: "ctexto04", 
			 	label: "ctexto04",
				align: "left", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "ttexto04", 
			 	label: "ttexto04",
				align: "", 
				width: 100, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "tresc04", 
			 	label: "tresc04",
				align: "", 
				width: 350, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "trese04", 
			 	label: "trese04",
				align: "", 
				width: 350, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "sit04", 
			 	label: "sit04",
				align: "", 
				width: 70, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "bloq04", 
			 	label: "bloq04",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "usub04", 
			 	label: "usub04",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			}
        ],
        model:"Aa00j04s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "ctexto04",
		sortname: "ttexto04",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
        formEdit:{
        	detailForm: "#TextosReserva_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodTextosReserva").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#TextosReserva"), "aa00j04s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"ctexto04":{
    					required: true,
						number: true,
						min: 1,
						max: 99,
						maxlength: 2
    					},
    				"ttexto04":{
    					required: true,
						maxlength: 25
    					},
    				"tresc04":{
        					required: true,
    						maxlength: 2000
        					},
    				"trese04":{
    					required: true,
						maxlength: 2000
    					},
    				"sit04":{
    					required: true,
						maxlength: 1
    					},
    				"bloq04":{
    					required: true,
						integer: true,
						maxlength: 1
    					},
    				"usub04":{
    					required: false,
						maxlength: 20
    				}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit04");
		},
        onPaging:function (bt){
         
        	$("#TextosReserva").rup_table("deselectAllRows");
        }
	});
	jQuery("#TextosReserva").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit04")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#TextosReserva").on("jqGridDblClickRow", function(event, form, oper) {
		 //var situacion=$(this).rup_table("getRowData", form)["sit02"];
	//	 if(oper)
		 	 if(!todosEnAlta($(this),"sit04")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#TextosReserva").on("rupTable_beforeEditRow",function(event, form, oper) {
		 
		 return  todosEnAlta($(this),"sit04");
	    
	});
	jQuery("#TextosReserva").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		
		  $('input').change(function() { 
        haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#TextosReserva").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j04s01", "ttexto04");
	});
	jQuery("#TextosReserva").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return bloquear(oper, $(this), "aa00j04s01",  "ttexto04");
	});
	jQuery("#TextosReserva_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#TextosReserva"), "aa00j04s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	$("#sit04_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});

//	$("#sit04_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/situacion/comboAB",
//		sourceParam: { label:"descripcion"+$.rup_utils.capitalizedLang(), value:"codigo" },
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	$("#TextosReserva_detail_link_cancel").hide();
	  $("#TextosReserva_cb div").hide();
	  $("#TextosReserva").rup_table("cleanFilterForm");
	  $("#TextosReserva").rup_table("filter");
});


function handlerSituacion(){
	if(bloquear('edit',jQuery("#TextosReserva"), "aa00j04s01",  "ttexto04")){
		//llarmar a cambiar estado
		var cods= jQuery("#TextosReserva").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j04s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#TextosReserva"), "aa00j04s01");
	            	$("#TextosReserva").rup_table("filter");
	            	$("#TextosReserva").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#TextosReserva"), "aa00j04s01");
				}
	    });
	}	
}

function desactivar(){	
	$("[id='TextosReserva_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='TextosReserva_toolbar##Editar']").prop("disabled",true);
	$("[id='TextosReserva_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='TextosReserva_toolbar##Clonar']").prop("disabled",true);
	
}
function activar(){
	$("[id='TextosReserva_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='TextosReserva_toolbar##Editar']").prop("disabled",false);
	$("[id='TextosReserva_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='TextosReserva_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#TextosReserva").jqGrid('getGridParam','sortname');
	var ordasc=$("#TextosReserva").jqGrid('getGridParam','sortorder');
	$("#tipoSalida").val(tipo);
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#ttexto04_filter_table2").val($("#ttexto04_filter_table").val());
	$("#tresc04_filter_table2").val($("#tresc04_filter_table").val());
	$("#trese04_filter_table2").val($("#trese04_filter_table").val());
	$("#sit04_filter_table2").val($("#sit04_filter_table").val());

	$("#textos_informe").attr("action","/aa00jReservaSalasWar/aa00j04s01/excel");
	$("#textos_informe").attr("method","POST");
	$("#textos_informe").attr("target","_blank");
	$("#textos_informe").submit();
	
}