jQuery(function($){

	$("#sitios").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j02s01",
		colNames: [
			"csitio02",
			Nombre,
			Situacion,
			"bloq02",
			"usub02"
		],
		colModel: [
			{ 	name: "csitio02", 
			 	label: "csitio02",
				align: "left", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nombre02", 
			 	label: "nombre02",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "sit02", 
			 	label: "sit02",
				align: "left", 
				width: 80, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "bloq02", 
			 	label: "bloq02",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "usub02", 
			 	label: "usub02",
				align: "left", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			}
        ],
        model:"Aa00j02s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "csitio02",
		sortname: "nombre02",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
        formEdit:{
        	detailForm: "#sitios_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodsitios").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#sitios"), "aa00j02s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
			
         	validate:{ 
    			rules:{
    				"csitio02":{
    					required: true,
						number: true,
						min: 1,
						max: 99,
						maxlength: 2
    					},
    				"nombre02":{
    					required: true,
						maxlength: 50
    					},
    				"sit02":{
    					required: true,
						maxlength: 1
    					},
    				"bloq02":{
						required: true,
						integer: true,
						maxlength: 1
    					},
    				"usub02":{
						required: false,
						maxlength: 20
    					}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
		    pintarFilaSituacion(rowid, rowdata, $(this), "sit02");
		},
        onPaging:function (bt){
         
        	$("#sitios").rup_table("deselectAllRows");
        }
       
	});

	jQuery("#sitios-toolbar").rup_toolbar("disableButton","refrescar");
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#sitios").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j02s01", "nombre02");
	});
	jQuery("#sitios").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return bloquear(oper, $(this), "aa00j02s01", "nombre02");
	});
	jQuery("#sitios_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#sitios"), "aa00j02s01");
	});
	jQuery("#sitios").on("rupTable_afterDeleteRow", function(event, row) {
		desactivar();
	});
	jQuery("#sitios").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		
		  $('input').change(function() { 
            haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});
	//Control de estado
	 jQuery("#sitios").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit02")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	 });
	 jQuery("#sitios").on("jqGridDblClickRow", function(event, form, oper) {
		 //var situacion=$(this).rup_table("getRowData", form)["sit02"];
		// if(oper)
		 	 if(!todosEnAlta($(this),"sit02")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
 });
	 jQuery("#sitios").on("rupTable_beforeEditRow",function(event, form, oper) {
		 var selRows = $(this).rup_table("getSelectedRows");
		 return  todosEnAlta($(this),"sit02");
	     
	});
	 
	/* FIN: BLOQUEO Y DESBLOQUEO */
	// jQuery("#sitios").p.ondblClickRow=null;
	
	$("#sit02_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});
	
//	$("#sit02_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/situacion/comboAB",
//		sourceParam: { label:"descripcion"+$.rup_utils.capitalizedLang(), value:"codigo" },
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	// jQuery("#sitios input").bind('dblclick',function(e){ return false; }); 
	$("#sitios_detail_link_cancel").hide();
	 $("#sitios_cb div").hide();
	  $("#sitios").rup_table("cleanFilterForm");
	  $("#sitios").rup_table("filter");
	  $("#sitios").rup_table("showSearchCriteria");
});

function handlerSituacion(){
	if(bloquear('edit',jQuery("#sitios"), "aa00j02s01", "nombre02")){
		//llarmar a cambiar estado
		var cods= jQuery("#sitios").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j02s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#sitios"), "aa00j02s01");
	            	$("#sitios").rup_table("filter");
	            	$("#sitios").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#sitios"), "aa00j02s01");
				}
	    });
	}	
}
function desactivar(){
	$("[id='sitios_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='sitios_toolbar##Editar']").prop("disabled",true);
	$("[id='sitios_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='sitios_toolbar##Clonar']").prop("disabled",true);
}
function activar(){
	$("[id='sitios_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='sitios_toolbar##Editar']").prop("disabled",false);
	$("[id='sitios_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='sitios_toolbar##Clonar']").prop("disabled",false);

}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#sitios").jqGrid('getGridParam','sortname');
	var ordasc=$("#sitios").jqGrid('getGridParam','sortorder');
	$("#tipoSalida").val(tipo);
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#nombre02_filter_table2").val($("#nombre02_filter_table").val());
	$("#sit02_filter_table2").val($("#sit02_filter_table").val());
	

	$("#sitios_informe").attr("action","/aa00jReservaSalasWar/aa00j02s01/excel");
	$("#sitios_informe").attr("method","POST");
	$("#sitios_informe").attr("target","_blank");
	$("#sitios_informe").submit();
	
}