

jQuery(function($){

	$("#salas").rup_table({
		rowNum:20,
		url: "../aa00j10s01",
		colNames: [
		    "Codigo",
			
			Edificio,
			Nombre,
			"Descripcion",
			Telefono,
			Capacidad,
			"Planta",
			etDisponible,
			Departamento,
			Situacion
		],
		colModel: [
			{ 	name: "csala10",
			 	label: "Codigo",
				align: "right",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			
			{ 	name: "aa00j03s01.nombre03",
			 	label: "Edificio",
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "nombre10",
			 	label: "Nombre",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "desc10",
			 	label: "Descripcion",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "tlfno10",
			 	label: "Telefono",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "ncap10",
			 	label: "Capacidad",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "planta10",
			 	label: "Planta",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "swdisp10",
			 	label: "etDisponible",
				align: "left",
				width: 80,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "aa00j07s01." + ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"),
			 	label: "Departamento",
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "sit10",
			 	label: "Situacion",
				align: "left",
				width: 80,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			}
        ],
        model:"Aa00j10s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "csala10",
		sortname: "nombre10",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}
				
				]
		},
        formEdit:{        	
        	
        	detailForm: "#salas_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660",
                beforeShowForm:function(e){
            		var control=$("#fileupload_foto"); 
            		 control.replaceWith( control = control.clone( true ) );
            		 var control2=$("#fileupload_croquis"); 
            		 control2.replaceWith( control2 = control2.clone( true ) );
                }
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodsalas").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#salas"), "aa00j10s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
			
         	validate:{ 
    			rules:{
    				"csala10":{
						required: true,
						number: true,
						min: 0,
						max: 9999
    					},
    				"aa00j07s01.cdep07":{
						required: false,
						number: true,
						min: 0,
						max: 99
    					},
    				"aa00j03s01.cedif03":{
						required: true,
						number: true,
						min: 1,
						max: 999
    					},
    				"aa00j06s01.crest06":{
						required: false,
						number: true,
						min: 0,
						max: 99
    					},
    				"aa00j04s01.ctexto04":{
						required: false,
						number: true,
						min: 0,
						max: 999
    					},
    				"nombre10":{
						required: true
    					},
    				"sit10":{
						required: true
    					},
    				"bloq10":{
						required: true,
						number: true,
						min: 0,
						max: 1
    					},
    				"swdisp10":{
						required: true,
						number: true,
						min: 0,
						max: 1
    					},
    				"desc10":{
						required: false
    					},
    				"tlfno10":{
						required: false
    					},
    				"usub10":{
						required: false
    					},
    				"planta10":{
						required: false
    					},
    				"dcapc10":{
						required: false
    					},
    				"dcape10":{
						required: false
    					},
    				"ncap10":{
						required: false,
						number: true,
						min: 0,
						max: 999
    					},
       				"aa00j12s01s.nom12":{
    					required: false
        				}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit10");
			pintarFilaDisponible(rowid, rowdata, $(this), "swdisp10");
		},
        onPaging:function (bt){
         
        	$("#salas").rup_table("deselectAllRows");
        }
	});
	jQuery("#salas").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit10")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#salas").on("jqGridDblClickRow", function(event, form, oper) {
		  	 if(!todosEnAlta($(this),"sit10")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#salas").on("rupTable_beforeEditRow",function(event, form, oper) {		

		 return  todosEnAlta($(this),"sit10");	    
	});
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#salas").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j10s01", "nombre10");
	});
	jQuery("#salas").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		limpiarCampos();

		return bloquear(oper, $(this), "aa00j10s01", "nombre10");
	});
	jQuery("#salas_detail_div").on("dialogclose", function() {

		desbloquear(jQuery("#salas"), "aa00j10s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	jQuery("#salas").on("jqGridAddEditClickPgButtons", function(event, form, oper) {
		limpiarCampos();
	});

	jQuery("#salas").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		cargarMediosFijos();
		cargarFotos();
		cargarRestriccion($("#crest06_detail_table").rup_combo("value"));
		cargarTextoReserva($("#ctexto04_detail_table").rup_combo("value"));
		  $('input').change(function() { 
              haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});

	function limpiarCampos() {
		$("#csala10_detail_table").val("");
		$("#cdep07_detail_table").rup_combo("select", "");
		$("#cedif03_detail_table").rup_combo("select", "");
		$("#nombre10_detail_table").val("");
		$("#swdisp10_detail_table").rup_combo("select", "");
		
		$("#desc10_detail_table").val("");
		$("#tlfno10_detail_table").val("");
		$("#planta10_detail_table").val("");
		$("#ncap10_detail_table").val("");
		$("#dcapc10_detail_table").val("");
		$("#dcape10_detail_table").val("");

		$("#mediosFijos").empty();
		$("#nom12_detail_table").val("");

		$("#crest06_detail_table").rup_combo("select", "");
		$("#textoRestriccion").val("");
		$("#descc06_detail_table").val("");
		$("#desce06_detail_table").val("");
		$("#menc06_detail_table").val("");
		$("#mene06_detail_table").val("");

		$("#ctexto04_detail_table").rup_combo("select", "");
		$("#textoReserva").val("");
		$("#ttexto04_detail_table").val("");
		$("#tresc04_detail_table").val("");
		$("#trese04_detail_table").val("");

		$("#foto").empty();
		$("#croquis").empty();
		$('#foto').empty().html(etImagenNoDisponible);
		$('#croquis').empty().html(etImagenNoDisponible);
		$("#fileupload_foto").val("");
		$("#fileupload_foto").val("");
	}
	var selectedid=0; 
	if(!(esAdmin))
	 selectedid=1;
	 
	//Combo Departamento - FILTRO
	$("#cdep07_filter_table").rup_combo({
		loadFromSelect:true, 
		style: "dropdown",
		width:"400",
		disabled:  !(esTecnico||esAdmin),
		selected: selectedid,
		onLoadSuccess: function() {
			//Combo Edificio - FILTRO
			$("#cedif03_filter_table").rup_combo({
				loadFromSelect:true, 
				style: "dropdown",
				width:"216",
				disabled:  !(esTecnico||esAdmin),
				selected: ""+codEdificio,
				onLoadSuccess: function() {
					$("#salas_filter_cleanLink").trigger('click');
				},
				blank:""
			});
		},
		blank:""
	});

	//Combo Departamento - DETALLE
	$("#cdep07_detail_table").rup_combo({
		loadFromSelect:true, 
		style: "dropdown",
		width:"400",
		disabled:  !(esTecnico||esAdmin),
		selected: selectedid,
		blank:""
	});
	
	//Combo Edificio - DETALLE
	$("#cedif03_detail_table").rup_combo({		
		loadFromSelect:true, 
		style: "dropdown",
		width:"216",
	
		selected: ""+codEdificio,
		blank:""
	});
	
	//Combo Disponible - FILTRO
	$("#swdisp10_filter_table").rup_combo({		
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:2
	});
	
	//Combo Disponible - DETALLE
	$("#swdisp10_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});

	//Combo Situacion - FILTRO
	$("#sit10_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:2
	});
	
	//Combo Situacion - DETALLE

	
	//Combo Restricción - DETALLE
	$("#crest06_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"280",
		selected:"",
		blank:"",
		onLoadSuccess: function() {
			$("#crest06_detail_table").rup_combo("selectLabel",
					($.rup_utils.capitalizedLang()=="Es" ? $("#descc06_detail_table").val() : $("#desce06_detail_table").val()));
		},
		select: function(event, object){
			cargarRestriccion(object.value);
		}
	});

	//Combo Texto reserva - DETALLE
	$("#ctexto04_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"280",
		selected:"",
		blank:"",
		onLoadSuccess: function() {
			$("#ctexto04_detail_table").rup_combo("selectLabel", $("#ttexto04_detail_table").val());
		},
		select: function(event, object){
			cargarTextoReserva(object.value);
		}
	});
	
    jQuery("#salas_detail_button_save").click(function () {
    	//Seleccionamos todos los responsables de la lista de responsables ocupados
    	$('#mediosFijos option').prop('selected', true);
    });

	$("#fileupload_foto").change(function (){
		var fileName = $(this).val();
		$('#foto').empty().html(fileName);
		$('#nombreFoto').val(fileName);
	});
	
	$("#fileupload_croquis").change(function (){
		var fileName = $(this).val();
		$('#croquis').empty().html(fileName);
		$('#nombreCroquis').val(fileName);
	});

	jQuery("#button_foto_zoom").off("click.foto").on("click.foto", function() {
    	abrirFoto();
	});

	jQuery("#button_croquis_zoom").off("click.croquis").on("click.croquis", function() {
    	abrirCroquis();
	});
	
//	$('#div_fileupload_foto').rup_upload({
//		form:"salas_detail_form",
//		fileInput: $("#fileupload_foto"),
//		submitInForm:true
//		});
//	$('#div_fileupload_croquis').rup_upload({
//		form:"salas_detail_form",
//		fileInput: $("#fileupload_croquis"),
//		submitInForm:true
//		});
	  $("#salas_detail_link_cancel").hide();
	//FIN: Para el tema de los file upload
	 $("#salas_cb div").hide();
	  $("#salas").rup_table("cleanFilterForm");
	  $("#salas").rup_table("filter");
	
});

function cargarRestriccion(codigo) {

	$("#textoRestriccion").val("");

	if (codigo.length>0) {
		$.rup_ajax({
			type: "GET",
			url: "/aa00jReservaSalasWar/aa00j06s01/" + codigo,
			dataType: "json",
			contentType: 'application/json',
			success: function(data, textStatus, jqXHR) {
				if (data != null) {
					$("#textoRestriccion").val($.rup_utils.capitalizedLang()=="Es" ? data.menc06 : data.mene06);
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				alert(etError);
			}
		});
	}
}

function cargarTextoReserva(codigo) {

	$("#textoReserva").val("");

	if (codigo.length>0) {
		$.rup_ajax({
			type: "GET",
			url: "/aa00jReservaSalasWar/aa00j04s01/" + codigo,
			dataType: "json",
			contentType: 'application/json',
			success: function(data, textStatus, jqXHR) {
				if (data != null) {
					$("#textoReserva").val($.rup_utils.capitalizedLang()=="Es" ? data.tresc04 : data.trese04);
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				alert(etError);
			}
		});
	}
}

function cargarFotos() {

	var codSala = $("#csala10_detail_table").val();

	$('#foto').empty().append(null);
	$('#foto').empty().html(etCargando);
	$('#croquis').empty().append(null);
	$('#croquis').empty().html(etCargando);

	if (codSala.length>0) {

		try {
			imageFoto = new Image();
			imageFoto.align="center";
			imageFoto.src = "/aa00jReservaSalasWar/aa00j11s01/obtenerFoto/" + codSala + "?ahora=" + new Date().getTime();
			imageFoto.onload = function () {
				
					imageFoto.width = 120;
			
					imageFoto.height = 120;
				
		        $('#foto').empty().append(imageFoto);
		    };
		    imageFoto.onerror = function () {
		        $('#foto').empty().html(etImagenNoDisponible);
		    };
		    $('#foto').empty().html(etCargando);
		    jQuery("#foto").off("dblclick.foto").on("dblclick.foto", function() {
		    	abrirFoto();
			});
		} catch(e) {}
		
	    try {
		    imageCroquis = new Image();
		    imageCroquis.src = "/aa00jReservaSalasWar/aa00j11s01/obtenerCroquis/" + codSala + "?ahora=" + new Date().getTime();
		    imageCroquis.onload = function () {
		    
		    		imageCroquis.width = 120;
				
					imageCroquis.height = 120;
			
		        $('#croquis').empty().append(imageCroquis);
		    };
		    imageCroquis.onerror = function () {
		        $('#croquis').empty().html(etImagenNoDisponible);
		    };
		    $('#croquis').empty().html(etCargando);
		    jQuery("#croquis").off("dblclick.croquis").on("dblclick.croquis", function() {
		    	abrirCroquis();
			});
	    } catch(e) {}

	} else {
		$('#foto').empty().html(etImagenNoDisponible);
		$('#croquis').empty().html(etImagenNoDisponible);
	}
}

function cargarMediosFijos() {

	var codSala = $("#csala10_detail_table").val();

	$("#mediosFijos").empty();

	if (codSala.length>0) {
	    $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j12s01/obtenerMediosFijosSala/" + codSala,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	                 for (var i=0; i<data.length; i++) {
	                	 $("#mediosFijos").append('<option value="' + data[i].nom12 + '">' + data[i].nom12 + '</option>');
	                 }
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
					alert(etErrorObtenerMediosFijos);
				}
	    });
	}
}

function eliminarMedioFijo() {

	if ($('option:selected', $("#mediosFijos")).size() > 0) {
		$.rup_messages("msgConfirm", 
				{ title: etPregunta,
				  message: etPreguntaEliminarMediosFijos,
				  OKFunction: function() {
					  //Primero comprobamos que no esté en ninguna reserva
					  //o sea que no esté en la tabla 21
					  var codSala = $("#csala10_detail_table").val();
					  var seleccionados = [];
					  $('#mediosFijos option:selected').each(function() {
						  seleccionados.push($(this).val());
					  });
					  var data = {nombres:seleccionados, csala12:codSala};

					  $.rup_ajax({
							type: "POST",
							url: "/aa00jReservaSalasWar/aa00j12s01/comprobarBorrado",
							data: $.toJSON(data),
							dataType: "json",
							contentType: 'application/json',
							success: function(data, textStatus, jqXHR) {
								if (data != null && data != "") {
									alert(data);
								} else {
									$('option:selected', $("#mediosFijos")).remove();
								}
							},
							error: function (XMLHttpRequest, textStatus, errorThrown) {
								alert(etErrorBorrarMedioFijo);
							}
						});
				}
		});
	}
}

function crearNuevoMedioFijo() {

	$("#MedioFijo_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevoMedioFijo,
		minWidth: 400,
		buttons:[{
			text: etGuardar,
			click: function() {
				var existe = 0;
				//Comprobamos que no exista ya un medio fijo con el mismo nombre
				$("#mediosFijos option").each(function() {
					if ($(this).val().trim().toUpperCase() == $("#nom12_detail_table").val().trim().toUpperCase()) {
						existe = 1;
					}
				});

				if (existe) {
					alert(etYaExisteMedioFijo);
				} else {
					$("#MedioFijo_detail_div").rup_dialog("close");
					//Añadimos el medio fijo al select
					$("#mediosFijos").append('<option value="' + $("#nom12_detail_table").val() + '">' + $("#nom12_detail_table").val() + '</option>');
				}
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#MedioFijo_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#nom12_detail_table").focus(); }
	});

	$("#nom12_detail_table").focus();
}

function crearNuevaRestriccion() {

	$("#Restriccion_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevaRestriccion,
		minWidth: 400,
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos la nuevo restricción
				var data = {descripcionEs:$("#descc06_detail_table").val(),
							descripcionEu:$("#desce06_detail_table").val(),
							mensajeEs:$("#menc06_detail_table").val(),
							mensajeEu:$("#mene06_detail_table").val()};

				$.rup_ajax({
					type: "POST",
					url: "/aa00jReservaSalasWar/aa00j06s01/anyadir",
					data: $.toJSON(data),
					dataType: "json",
					contentType: 'application/json',
					success: function(data, textStatus, jqXHR) {
						if (data != null) {
							if (isNaN(data)) {
								alert(data);
							} else {
								$("#Restriccion_detail_div").rup_dialog("close");
								$("#crest06_detail_table").rup_combo("reload");
								$("#crest06_filter_table").rup_combo("reload");
							}
						}
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						alert(etErrorCrearRestriccion);
					}
				});
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#Restriccion_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#descc06_detail_table").focus(); }
	});
	
	$("#descc06_detail_table").focus();
}

function crearNuevoTextoReserva() {

	$("#TextoReserva_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevoTextoReserva,
		minWidth: 400,
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos el nuevo texto reserva
				var data = {titulo:$("#ttexto04_detail_table").val(),
							textoEs:$("#tresc04_detail_table").val(),
							textoEu:$("#trese04_detail_table").val()};

				$.rup_ajax({
					type: "POST",
					url: "/aa00jReservaSalasWar/aa00j04s01/anyadir",
					data: $.toJSON(data),
					dataType: "json",
					contentType: 'application/json',
					success: function(data, textStatus, jqXHR) {
						if (data != null) {
							if (isNaN(data)) {
								alert(data);
							} else {
								$("#TextoReserva_detail_div").rup_dialog("close");
								$("#ctexto04_detail_table").rup_combo("reload");
								$("#ctexto04_filter_table").rup_combo("reload");
							}
						}
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						alert(etErrorCrearTextoReserva);
					}
				});
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#TextoReserva_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#ttexto04_detail_table").focus(); }
	});
	
	$("#ttexto04_detail_table").focus();
	$("salas_cb div").hide()

}

function abrirFoto() {
	var winArgs = $('#foto').find('img').map(function() {
					return this.src;
			  	  }).get();
	if (winArgs.length > 0) {
		var winSettings = 'center:yes;resizable:yes;help:no;status:no;dialogWidth:'
            + (self.screen.availWidth * 7 / 8)
            + 'px;dialogHeight:'
            + (self.screen.availHeight * 7 / 8 + 'px');
		winArgs = window.showModalDialog('/aa00jReservaSalasWar/aa00jVisorImagen', winArgs, winSettings);	
	}
}

function abrirCroquis() {
	var winArgs = $('#croquis').find('img').map(function() {
					return this.src;
			  	  }).get();
	if (winArgs.length > 0) {
		var winSettings = 'center:yes;resizable:yes;help:no;status:no;dialogWidth:'
		            + (self.screen.availWidth * 7 / 8)
		            + 'px;dialogHeight:'
		            + (self.screen.availHeight * 7 / 8 + 'px');
		winArgs = window.showModalDialog('/aa00jReservaSalasWar/aa00jVisorImagen', winArgs, winSettings);
	}
}

function handlerSituacion(){
	
	if(bloquear('edit', $("#salas"), "aa00j10s01", "nombre10")){
		//llarmar a cambiar estado
		var cods= jQuery("#salas").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j10s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#salas"), "aa00j10s01");
	            	$("#salas").rup_table("filter");
	            	$("#salas").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#salas"), "aa00j10s01");
				}
	    });
	}	
}

function desactivar(){
	$("[id='salas_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='salas_toolbar##Editar']").prop("disabled",true);
	$("[id='salas_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='salas_toolbar##Clonar']").prop("disabled",true);

}
function activar(){
	//
	$("[id='salas_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='salas_toolbar##Editar']").prop("disabled",false);
	$("[id='salas_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='salas_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#salas").jqGrid('getGridParam','sortname');
	var ordasc=$("#salas").jqGrid('getGridParam','sortorder');
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#nombre10_filter_table2").val($("#nombre10_filter_table").val());
	$("#cdep07_filter_table2").val($("#cdep07_filter_table").val());
	$("#cedif03_filter_table2").val($("#cedif03_filter_table").val());
	$("#swdisp10_filter_table2").val($("#swdisp10_filter_table").val());
	$("#sit10_filter_table2").val($("#sit10_filter_table").val());
	$("#tipoSalida").val(tipo);
	$("#salas_informe").attr("action","/aa00jReservaSalasWar/aa00j10s01/excel");
	$("#salas_informe").attr("method","POST");
	$("#salas_informe").attr("target","_blank");
	$("#salas_informe").submit();
	
}

