jQuery(function($){

	$("#responsables").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j05s01",
		colNames: [
			CodigoUsuario,
			Nombre,
			Situacion,
			"bloq05",
			"usub05"
		],
		colModel: [
			{ 	name: "cresp05",
			 	label: "cresp05",
				align: "left",
				width: 60,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "nom05",
			 	label: "nom05",
				align: "left",
				width: 250,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "sit05",
			 	label: "sit05",
				align: "left",
				width: 70,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "bloq05",
			 	label: "bloq05",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "usub05",
			 	label: "usub05",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			}
        ],
        model:"Aa00j05s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "cresp05",
		sortname: "nom05",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
		/*
		toolbar:{
			newButtons : [{
				id: "btn_ver_detalle",
				obj : { i18nCaption: "ver_detalle", css: "rup-icon rup-icon-search" },
				click : function(){
					//Función de callback del evento click
					//Handler del evento jqGridAddEditBeforeShowForm
					$("#responsables").on("jqGridAddEditBeforeShowForm.customhandler", function(event, $form){
						//Una vez ejecutado se deshabilita el handler
						$("#responsables").off("jqGridAddEditBeforeShowForm.customhandler");
						//Ejemplo de configruación de los imput en modo lectura.
						$form.find("input").attr("readonly","readonly");
					});
					//Se invoca la función de edición de un registro.
					$("#responsables").rup_table("editElement");
				}
			}]
		},
		*/
        formEdit:{
        	detailForm: "#responsables_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodresponsables").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#responsables"), "aa00j05s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{
    			rules:{
    				"cresp05":{
    					required: true,
						maxlength: 20
    					},
    				"nom05":{
						required: true,
						maxlength: 1000
    					},
    				"sit05":{
						required: true,
						maxlength: 1
    					},
    				"bloq05":{
						required: true,
						integer: true,
						maxlength: 1
    					},
    				"usub05":{
						required: false,
						maxlength: 20
    					}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit05");
		}	,
        onPaging:function (bt){
         
        	$("#responsables").rup_table("deselectAllRows");
        }	
	});
	jQuery("#responsables").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit05")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#responsables").on("jqGridDblClickRow", function(event, form, oper) {
		  	 if(!todosEnAlta($(this),"sit05")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#responsables").on("rupTable_beforeEditRow",function(event, form, oper) {		 
		 return  todosEnAlta($(this),"sit05");	    
	});
	jQuery("#responsables").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		
		  $('input').change(function() { 
          haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#responsables").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j05s01", "nom05");
	});
	jQuery("#responsables").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return bloquear(oper, $(this), "aa00j05s01", "nom05");
	});
	jQuery("#responsables_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#responsables"), "aa00j05s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	$("#sit05_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});

//	$("#sit05_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/situacion/comboAB",
//		sourceParam: { label:"descripcion"+$.rup_utils.capitalizedLang(), value:"codigo" },
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	$("#responsables_detail_link_cancel").hide();
	  $("#responsables_cb div").hide();
	  $("#responsables").rup_table("cleanFilterForm");
	  $("#responsables").rup_table("filter");
});

function handlerSituacion(){
	if( bloquear('edit', $("#responsables"), "aa00j05s01", "nom05")){
		//llarmar a cambiar estado
		var cods= jQuery("#responsables").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j05s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#responsables"), "aa00j05s01")
	            	$("#responsables").rup_table("filter");
	            	$("#responsables").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#responsables"), "aa00j05s01")
				}
	    });
	}	
}

function desactivar(){
	$("[id='responsables_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='responsables_toolbar##Editar']").prop("disabled",true);
	$("[id='responsables_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='responsables_toolbar##Clonar']").prop("disabled",true);

}
function activar(){
	//
	$("[id='responsables_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='responsables_toolbar##Editar']").prop("disabled",false);
	$("[id='responsables_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='responsables_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#responsables").jqGrid('getGridParam','sortname');
	var ordasc=$("#responsables").jqGrid('getGridParam','sortorder');
	
	$("#tipoSalida").val(tipo);
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#nom05_filter_table2").val($("#nom05_filter_table").val());
	$("#sit05_filter_table2").val($("#sit05_filter_table").val());
	

	$("#responsables_informe").attr("action","/aa00jReservaSalasWar/aa00j05s01/excel");
	$("#responsables_informe").attr("method","POST");
	$("#responsables_informe").attr("target","_blank");
	$("#responsables_informe").submit();
	
}