jQuery(function($){

	$("#recursosGenerales").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j13s01",
		colNames: [
			"Codigo",
		
			Edificio,
			NombreEs,
			NombreEu,
			etDisponible,
			Situacion
		],
		
		colModel: [
			{ 	name: "crec13", 
			 	label: "Codigo",
				align: "left", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "aa00j03s01.nombre03",
			 	label: "Edificio",
				align: "left",
				width: 80,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "nomc13",
			 	label: "NombreEs",
				align: "left",
				width: 250,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "nome13",
			 	label: "NombreEu",
				align: "left",
				width: 250,
				editable: true,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "swdisp13",
			 	label: "etDisponible",
				align: "left",
				width: 70,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "sit13",
			 	label: "Situacion",
				align: "left",
				width: 70,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			}
        ],
        model:"Aa00j13s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
     
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "crec13",
		sortname: "crec13",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
        formEdit:{
        	detailForm: "#recursosGenerales_detail_div",
        	fillDataMethod: "clientSide",
        	addEditOptions:{
				reloadAfterSubmit:true,
                width:"540",
                ajaxEditOptions:{
                	/*beforeSubmit: function(a){
                		a =$("#Caracteristica_detail_form").data("caracteristicas");
                	}
                	$.extend(true, postData, { 
            			aa00j14s01s: $("#Caracteristica_detail_form").data("caracteristicas");
            		});*/
                }
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodrecursosGenerales").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#recursosGenerales"), "aa00j13s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"crec13":{
    					required: true,
						number: true,
						min: 0,
						max: 999
    					},
				
    				"aa00j03s01.cedif03":{
						required: true,
						number: true,
						min: 1,
						max: 999
    					},
    				"aa00j06s01.crest06":{
    					required: false,
						number: true,
						min: 0,
						max: 99
    					},
    				"sit13":{
						required: false
    					},
    				"bloq13":{
						required: true,
						number: true,
						min: 0,
						max: 1
    					},
    				"nomc13":{
						required: true
    					},
					"nome13":{
						required: true
    					},
    				"descc13":{
						required: false
    					},
    				"desce13":{
						required: false
    					},
    				"swdisp13":{
						required: true,
						number: true,
						min: 0,
						max: 1
    					},
    				"usub13":{
						required: false
    					}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit13");
			pintarFilaDisponible(rowid, rowdata, $(this), "swdisp13");
		},
        onPaging:function (bt){
         
        	$("#recursosGenerales").rup_table("deselectAllRows");
        }
	});
	jQuery("#recursosGenerales").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit13")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#recursosGenerales").on("jqGridDblClickRow", function(event, form, oper) {
		  	 if(!todosEnAlta($(this),"sit13")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#recursosGenerales").on("rupTable_beforeEditRow",function(event, form, oper) {		 
		 return  todosEnAlta($(this),"sit13");	    
	});
	$("#recursosGenerales").on("jqGridAddEditBeforeSubmit", function(event, postData){
		$.extend(true, postData, { 
			aa00j14s01s: $("#Caracteristica_detail_form").data("caracteristicas")
		});
		
//		postData["aa00j14s01s"] = $("#Caracteristica_detail_form").data("caracteristicas"); 


	});

	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#recursosGenerales").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j13s01", ($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"));
	});
	jQuery("#recursosGenerales").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		limpiarCampos();
		return bloquear(oper, $(this), "aa00j13s01", ($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"));
	});
	jQuery("#recursosGenerales_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#recursosGenerales"), "aa00j13s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */
	
	jQuery("#recursosGenerales").on("jqGridAddEditClickPgButtons", function(event, form, oper) {
		limpiarCampos();
	});

	jQuery("#recursosGenerales").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		cargarCaracteristicas($("#crec13_detail_table").val());
		cargarRestriccion($("#crest06_detail_table").rup_combo("value"));
		
		$('input').change(function() { 
            haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});
	
	function limpiarCampos() {
		$("#caracteristicas").empty();
		$("#Caracteristica_detail_form").data("caracteristicas",[]);

		$("#crec13_detail_table").val("");
	
		$("#cedif03_detail_table").rup_combo("clear");
		$("#swdisp13_detail_table").rup_combo("clear");

		$("#nomc13_detail_table").val("");
		$("#nome13_detail_table").val("");
		$("#descc13_detail_table").val("");
		$("#desce13_detail_table").val("");

		$("#carc14_detail_table").val("");
		$("#care14_detail_table").val("");
		
		$("#crest06_detail_table").rup_combo("select", "");
		$("#textoRestriccion").val("");
		$("#descc06_detail_table").val("");
		$("#desce06_detail_table").val("");
		$("#menc06_detail_table").val("");
		$("#mene06_detail_table").val("");
	}

	$("#cedif03_filter_table").rup_combo({
//		source: "/aa00jReservaSalasWar/aa00j03s01/combo",
//		sourceParam: { label:"nombre03", value:"cedif03" },
		loadFromSelect:true,  
		style: "dropdown",
		width:"300",
		disabled:  !(esTecnico||esAdmin),
		selected: ""+codEdificio,
		onLoadSuccess: function() {
			$("#recursosGenerales_filter_cleanLink").trigger('click');
		},
		blank:""
	});
	//Combo Edificio - DETALLE
	$("#cedif03_detail_table").rup_combo({
//		source: "/aa00jReservaSalasWar/aa00j03s01/combo",
//		sourceParam: { label:"nombre03", value:"cedif03" },
		loadFromSelect:true, 
		style: "dropdown",
		width:"300",
		disabled:  !(esTecnico||esAdmin),
		selected: ""+codEdificio,
		blank:""
	});
	
	//Combo Disponible - FILTRO
	$("#swdisp13_filter_table").rup_combo({
	
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});
	
	//Combo Disponible - DETALLE
	$("#swdisp13_detail_table").rup_combo({

		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});

	//Combo Situacion - FILTRO
	$("#sit13_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:""
	});
	
	//Combo Situacion - DETALLE
//	$("#sit13_detail_table").rup_combo({
//		loadFromSelect:true, 
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	
	//Combo Restricción - DETALLE
	$("#crest06_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/aa00j06s01/combo",
//		sourceParam: { label:($.rup_utils.capitalizedLang()=="Es" ? "descc06" : "desce06"), value:"crest06" },
		loadFromSelect:true, 
		style : "dropdown",
		width:"280",
		selected:"",
		blank:"",
		onLoadSuccess: function() {
			$("#crest06_detail_table").rup_combo("selectLabel",
					($.rup_utils.capitalizedLang()=="Es" ? $("#descc06_detail_table").val() : $("#desce06_detail_table").val()));
		},
		select: function(event, object){
			cargarRestriccion(object.value);
		}
	});

    jQuery("#recursosGenerales_detail_button_save").click(function () {
    	//Seleccionamos todos los responsables de la lista de responsables ocupados
    	$('#caracteristicas option').prop('selected', true);
    });
    $("#recursosGenerales_cb div").hide();
    $("#recursosGenerales_detail_link_cancel").hide();
	  $("#recursosGenerales").rup_table("cleanFilterForm");
	 $("#recursosGenerales").rup_table("filter");
});

function cargarRestriccion(codigo) {

	$("#textoRestriccion").val("");

	if (codigo.length>0) {
		$.rup_ajax({
			type: "GET",
			url: "/aa00jReservaSalasWar/aa00j06s01/" + codigo,
			dataType: "json",
			contentType: 'application/json',
			success: function(data, textStatus, jqXHR) {
				if (data != null) {
					$("#textoRestriccion").val($.rup_utils.capitalizedLang()=="Es" ? data.menc06 : data.mene06);
				}
			},
			error: function (XMLHttpRequest, textStatus, errorThrown) {
				alert(etError);
			}
		});
	}
}

function cargarCaracteristicas(codigo) {

	$("#caracteristicas").empty();
    $("#Caracteristica_detail_form").data("caracteristicas",[]);

	if (codigo.length>0) {
	    $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j14s01/obtenerCaracteristicasRecurso/" + codigo,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	                 for (var i=0; i<data.length; i++) {
	                	 $("#caracteristicas").append('<option value="' + data[i].carc14 + '">' + data[i].carc14 + '</option>');
	                	 $("#Caracteristica_detail_form").data("caracteristicas").push({carc14: data[i].carc14, care14: data[i].care14 });
	                 }
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
					alert(etErrorObtenerCaracteristicas);
				}
	    });
	}
}

function eliminarCaracteristica() {

	if ($('option:selected', $("#caracteristicas")).size() > 0) {
		$.rup_messages("msgConfirm", 
				{ title: etPregunta,
				   message: etPreguntaEliminarCaracteristicas,
				   OKFunction: function() {
					   $('option:selected', $("#caracteristicas")).each(function() {
						    var strValor = this.value;
						    $("#Caracteristica_detail_form").data("caracteristicas").map(function (caracteristica) {
						    	if (caracteristica.carc14 == strValor) {
						    		$("#Caracteristica_detail_form").data("caracteristicas").splice($.inArray(caracteristica, $("#Caracteristica_detail_form").data("caracteristicas")),1);
						    	}
						    });
						    this.remove();
					   });
				   }
				});
	}
}

function crearNuevaCaracteristica() {

	$("#Caracteristica_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevaCaracteristica,
		minWidth: 400,
		buttons:[{
			text: etGuardar,
			click: function() {
				var existe = 0;
				//Comprobamos que no exista ya una característica con la misma descripción en castellano
				$("#caracteristicas option").each(function() {
					var strAux = '';
					if ($.rup_utils.capitalizedLang()=="Es") {
						strAux=$("#carc14_detail_table").val();
					} else {
						strAux=$("#care14_detail_table").val();
					}
					if ($(this).val().trim().toUpperCase() == strAux.trim().toUpperCase()) {
						existe = 1;
					}
				});

				if (existe) {
					alert(etYaExisteCaracteristica);
				} else {
					$("#Caracteristica_detail_div").rup_dialog("close");
					//Añadimos el medio fijo al select
					var strAux = '';
					if ($.rup_utils.capitalizedLang()=="Es") {
						strAux=$("#carc14_detail_table").val();
					} else {
						strAux=$("#care14_detail_table").val();
					}
					$("#caracteristicas").append('<option value="' + strAux + '">' + strAux + '</option>');
					$("#Caracteristica_detail_form").data("caracteristicas").push({carc14: $("#carc14_detail_table").val(), care14: $("#care14_detail_table").val() });
				}
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#Caracteristica_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#carc14_detail_table").focus(); }
	});

	$("#carc14_detail_table").focus();
}

function crearNuevaRestriccion() {

	$("#Restriccion_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevaRestriccion,
		minWidth: 400,
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos la nuevo restricción
				var data = {descripcionEs:$("#descc06_detail_table").val(),
							descripcionEu:$("#desce06_detail_table").val(),
							mensajeEs:$("#menc06_detail_table").val(),
							mensajeEu:$("#mene06_detail_table").val()};

				$.rup_ajax({
					type: "POST",
					url: "/aa00jReservaSalasWar/aa00j06s01/anyadir",
					data: $.toJSON(data),
					dataType: "json",
					contentType: 'application/json',
					success: function(data, textStatus, jqXHR) {
						if (data != null) {
							if (isNaN(data)) {
								alert(data);
							} else {
								$("#Restriccion_detail_div").rup_dialog("close");
								$("#crest06_detail_table").rup_combo("reload");
								$("#crest06_filter_table").rup_combo("reload");
								cargarRestriccion(data);
							}
						}
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						alert(etErrorCrearRestriccion);
					}
				});
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#Restriccion_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#descc06_detail_table").focus(); }
	});
	
	$("#descc06_detail_table").focus();
}


function handlerSituacion(){
	
	if(bloquear('edit', $("#recursosGenerales"), "aa00j13s01", ($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"))){
		//llarmar a cambiar estado
		var cods= jQuery("#recursosGenerales").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j13s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#recursosGenerales"), "aa00j13s01");
	            	$("#recursosGenerales").rup_table("filter");
	            	$("#recursosGenerales").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#recursosGenerales"), "aa00j13s01");
				}
	    });
	}	
}

function desactivar(){
	$("[id='recursosGenerales_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='recursosGenerales_toolbar##Editar']").prop("disabled",true);
	$("[id='recursosGenerales_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='recursosGenerales_toolbar##Clonar']").prop("disabled",true);

}
function activar(){
	//
	$("[id='recursosGenerales_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='recursosGenerales_toolbar##Editar']").prop("disabled",false);
	$("[id='recursosGenerales_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='recursosGenerales_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#recursosGenerales").jqGrid('getGridParam','sortname');
	var ordasc=$("#recursosGenerales").jqGrid('getGridParam','sortorder');
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#nomc13_filter_table2").val($("#nomc13_filter_table").val());
	$("#tipoSalida").val(tipo);
	$("#nome13_filter_table2").val($("#nome13_filter_table").val());
	$("#cedif03_filter_table2").val($("#cedif03_filter_table").val());
	$("#swdisp13_filter_table2").val($("#swdisp13_filter_table").val());
	$("#sit13_filter_table2").val($("#sit13_filter_table").val());
	$("#recursos_informe").attr("action","/aa00jReservaSalasWar/aa00j13s01/excel");
	$("#recursos_informe").attr("method","POST");
	$("#recursos_informe").attr("target","_blank");
	$("#recursos_informe").submit();
	
}