//var haCambiado = false;

jQuery(function($){
	
	$("#reservas_detail_link_cancel").hide();
	
	if (getParameterByName("departamental") == "1") {
		$("#departamental").val("1");
		$("#cbSalaComun").prop("checked", false);
		$("#cbSalaDepartamental").prop("checked", true);
	} else {
		$("#departamental").val("");
		$("#cbSalaComun").prop("checked", true);
		$("#cbSalaDepartamental").prop("checked", false);
	}
	
	$("#reservas").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j20s01",
		colNames: [
			"Codigo",
			"CodigoSala",
			Sala,
			Asunto,
			Dia,
			HoraIni,
			HoraFin,
			Reservador,
			DepartamentoRes,			
			ANombreDe,
			Telefono,
			"CodigoDepartamento",
			Departamento,
			FueraHorario,
			Confirmada,
			Situacion,
			"Bloqueo",
			"UsuarioBloqueo",
			"telefono"
		],
		colModel: [
			{ 	name: "cod20",
			 	label: "Codigo",
				align: "right",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "csala20",
			 	label: "CodigoSala",
				align: "right",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "aa00j10s01.nombre10",
			 	label: Sala,
				align: "left",
				width: 150,
				editable: false,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "asun20",
			 	label: Asunto,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "diaMostrar",
			 	label: Dia,
				align: "center",
				width: 80,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "horaIniMostrar",
			 	label: HoraIni,
				align: "center",
				width: 60,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: false
			},
			{ 	name: "horaFinMostrar",
			 	label: HoraFin,
				align: "center",
				width: 60,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: false
			},
			{ 	name: "reser20",
			 	label: Reservador,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "aa00j07s01ByCdep20." + ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"),
			 	label: Departamento,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "anomd20",
			 	label: ANombreDe,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "tlfno20",
			 	label: Telefono,
				align: "left",
				width: 120,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "aa00j07s01ByCdepr20.cdep07",
			 	label: "CodigoDepartamento",
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "aa00j07s01ByCdepr20." + ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"),
			 	label: Departamento,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "swfhor20",
			 	label: FueraHorario,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "swconf20",
			 	label: Confirmada,
				align: "left",
				width: 120,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "sit20",
			 	label: Situacion,
				align: "left",
				width: 80,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "bloq20",
			 	label: "Bloqueo",
				align: "left",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "usub20",
			 	label: "UsuarioBloqueo",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "tlfno20",
			 	label: "telefono",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			}
			
        ],
        model:"Aa00j20s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "cod20",
		sortname: "dhcom20",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
        formEdit:{
        	detailForm: "#reservas_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"700"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
				
					jQuery("#delmodreservas").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#reservas"), "aa00j20s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
	//		checkOnUpdate : true,
         	validate:{
    			rules:{
            	  	"cod20":{required:true},
            	  	"a00j07s01ByCdep20.cdep07":{required:true},
                    "aa00j03s01.cedif03":{required:true},
            	  	"aa00j10s01.csala10":{required:true},
            	  	"diaMostrar":{required:true},
            	  	"horaIniMostrar":{required:true},
            	  	"horaFinMostrar":{required:true},
                    "asun20":{required:true},
                    "aa00j07s01ByCdep20.cdepr07":{required:true},
                    "responsable":{required:true},
                    "tlfno20":{required:true}
    			}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit20");
			pintarFilaConfirmada(rowid, rowdata, $(this), "swconf20", "sit20");
		},
		
        onPaging:function (bt){
         
        	$("#reservas").rup_table("deselectAllRows");
        }
	});
	$("#reservas_cb div").hide();
	$("#reservas").on("jqGridAddEditBeforeSubmit", function(event, postData){
		$.extend(postData,{
			horaIniMostrar: $("#hora_ini_reserva2").val(),
			horaFinMostrar: $("#hora_fin_reserva2").val()
		});
	});

	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#reservas").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquearSiAlta('edit', $(this), "aa00j20s01", "asun20");
	});
	jQuery("#reservas").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		limpiarCampos();
		return bloquearSiAlta(oper, $(this), "aa00j20s01", "asun20");
	});
	jQuery("#reservas_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#reservas"), "aa00j20s01");
		$("#reservas").rup_table("deselectAllRows");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	jQuery("#reservas").on("jqGridAddEditClickPgButtons", function(event, form, oper) {
		limpiarCampos();
	});

	jQuery("#reservas").on("jqGridAddEditAfterFillData", function(event, form, oper) {

		//Para controlar los radio buttons
    	if ($("#cdep07_reserva").val() > 0) {
    		$("#cbSalaDepartamental_detalle").attr('checked', 'checked');
    		$("#divDepartamentoReserva").show();
	    } else {
	    	$("#cbSalaComun_detalle").attr('checked', 'checked');
	    	$("#divDepartamentoReserva").hide();
	    }

		cargarDatosEdificio($("#cedif03_reserva").val(), $("#cod20_reserva").val());
		cargarDatosSala($("#csala10_reserva").val(), $("#cod20_reserva").val());
		
		$("#hora_ini_reserva2").val($("#hora_ini_reserva").val());
		$("#hora_fin_reserva2").val($("#hora_fin_reserva").val());
		
		if ($("#swconf20_reserva").val()=="1") {
			$("#fecha_reserva").rup_date("disable");
			$("#hora_ini_reserva2").rup_time("disable");
			$("#hora_fin_reserva2").rup_time("disable");
		} else {
			$("#fecha_reserva").rup_date("enable");
			$("#hora_ini_reserva2").rup_time("enable");
			$("#hora_fin_reserva2").rup_time("enable");
		}
		
        //Detectar cambio
		   $('input').change(function() { 
               haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 


	});

	function limpiarCampos() {
		$("#cod20").val("");
		$("#cdep07_reserva").rup_combo("select", "");
		//necesariaConfirmacion
		$("#cedif03_reserva").rup_combo("select", "");
		$("#fecha_reserva").val("");
		$("#hora_ini_reserva2").val("");
		$("#hora_fin_reserva2").val("");
		$("#hora_ini_reserva").val("");
		$("#hora_fin_reserva").val("");
		$("#csala10_reserva").rup_combo("select", "");
		$("#recursosEdificio").empty();
		$("#recursosSala").empty();
		$("#personas_reserva").val("");
		$("#asistentes_reserva").val("");
		$("#ippc_reserva").val("");
		$("#asunto_reserva").val("");
		$("#observaciones_reserva").val("");
		$("#cdepr07_reserva").rup_combo("select", "");
		$("#responsable_reserva").val("");
		$("#dni20").val("");
	}

	//Para controlar los radio buttons
    $("input[name='cbSalaComunDepartamental']").click(function(e) {
    	e.preventDefault();

   		realizarCambioComunDepartamental();
    });

    function realizarCambioComunDepartamental() {
    	if (getParameterByName("departamental") == "1") {
	   		$("#cbSalaComun").prop("checked", true);
			$("#cbSalaDepartamental").prop("checked", false);
		} else {
			$("#cbSalaComun").prop("checked", false);
			$("#cbSalaDepartamental").prop("checked", true);
		}
	    if ($("#cbSalaComun:checked").length > 0) {
		    $("#cdep07_reserva").rup_combo("disable");
	    } else {
	    	$("#cdep07_reserva").rup_combo("enable");
	    }
	    NuevaReserva();
    }

    function NuevaReserva(cbDepartamental) {
    	var departamental = 0;
    	if ($("#cbSalaDepartamental:checked").length > 0) {
    		departamental = 1;
    	}
    	window.location.href='modificarReserva?departamental='+departamental;
    }


	$("#cdep07_reserva").rup_combo({
		loadFromSelect:true,
		style: "dropdown",
		width:"280",
		disabled: true,
		blank:""
	});
	//$("#cdep07_reserva").rup_combo("clear");
	//Combo Departamento - DETALLE
	$("#cdepr07_reserva").rup_combo({
		loadFromSelect:true,
		style: "dropdown",
		width:"280",
		disabled: true,
		blank:""
	});
	$("#cdepr07_reserva").rup_combo("select","");
	//Combo Edificio - FILTRO
	$("#cedif03_filter_table").rup_combo({
		loadFromSelect:true,
		style: "dropdown",
		width:"280",
		blank:"",
		selected: ""
	});
	$("#cedif03_filter_table").rup_combo("setRupValue","");
	//Combo Edificio - DETALLE
	$("#cedif03_reserva").rup_combo({
		loadFromSelect:true,
		style: "dropdown",
		width:"216",
		disabled: true,
		blank:""
	});
	$("#cedif03_reserva").rup_combo("clear");
	//Combo Departamento - FILTRO
	if(esAdminDepto&& !$("#cbSalaComun:checked").length > 0)
	$("#cdep07_filter_table").rup_combo({
		loadFromSelect:true,
		style: "dropdown",
		width:"280",
		disabled:  $("#cbSalaComun:checked").length > 0,
		
		typeAhead: 10,
		
		onLoadSuccess: function(event, object) {
			//Iker: Petición desde otra página,
			//Si hay departamento deleccionar departamento y cargar edificio
			if(departamentoSeleccionado!="" && departamentoSeleccionado!="-1") {
				$("#cdep07_reserva").rup_combo("select", departamentoSeleccionado);
				departamentoSeleccionado="";
			}
		//	$("#reservas").rup_table("filter");
		}
	});
	else
		$("#cdep07_filter_table").rup_combo({
			loadFromSelect:true,
			style: "dropdown",
			width:"280",
			disabled:  !(esTecnico||esAdmin) || $("#cbSalaComun:checked").length > 0,
			selected: "",
			typeAhead: 10,
			blank:"",
			onLoadSuccess: function(event, object) {
				//Iker: Petición desde otra página,
				//Si hay departamento deleccionar departamento y cargar edificio
				if(departamentoSeleccionado!="" && departamentoSeleccionado!="-1") {
					$("#cdep07_reserva").rup_combo("select", departamentoSeleccionado);
					departamentoSeleccionado="";
				}
			//	$("#reservas").rup_table("filter");
			}
		});
		
	$("#cdep07_filter_table").rup_combo("clear");
	//Combo Departamento - DETALLE
	
	//Combo Sala - FILTRO
	if ($("#cbSalaDepartamental:checked").length > 0) {
		
		$("#cedif03_filter_table").rup_combo("disable");
		$("#csala10_filter_table").rup_combo({
			source: "/aa00jReservaSalasWar/aa00j10s01/combo",
			parent: [ "cdep07_filter_table" ],
			sourceParam: { label:"nombre10", value:"csala10" },
			style: "dropdown",
			width:"280",
			blank:"",
			change:function(event, object){//hay que cargar el edificio de la sala seleccionada
				var sala=object.value;
				if(sala!=""){
					$.getJSON( "../aa00j10s01/"+sala, function( data ) {
						$("#cedif03_filter_table").rup_combo("setRupValue",data.aa00j03s01.cedif03);
					
					});
				}
			}
		});
	} else {

		$("#cedif03_filter_table").rup_combo("enable");
		$("#csala10_filter_table").rup_combo({
			source: "/aa00jReservaSalasWar/aa00j10s01/combo",
			parent: [ "cedif03_filter_table" ],
			sourceParam: { label:"nombre10", value:"csala10" },
			style: "dropdown",
			width:"280",
			blank:""
		});	
	}
	$("#csala10_filter_table").rup_combo("clear");
	//Combo Sala - DETALLE
	$("#csala10_reserva").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j10s01/comboTodas",
		sourceParam: { label:"nombre10", value:"csala10" },
		style: "dropdown",
		width:"216",
		disabled: true,
		blank:""
	});
	$("#csala10_reserva").rup_combo("clear");
	//Para la fecha y la hora
	$("#fecha_filter_table").rup_date({
		multiSelect: 99,
		showButtonPanel: true,
		minDate:new Date()
	});


	$("#hora_ini_filter_table").rup_time({
		hour:8,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText>$("#hora_fin_filter_table").rup_time("getTime"))
				$("#hora_fin_filter_table").val(dateText);
		}
		});
	$("#hora_fin_filter_table").rup_time({
		hour:9,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText<$("#hora_ini_filter_table").rup_time("getTime"))
				$("#hora_ini_filter_table").val(dateText);
		}
		});
	//

	//Para la fecha y la hora
	$("#fecha_reserva").rup_date({
		//multiSelect: 99,
		showButtonPanel: true
	});

	
	$("#hora_ini_reserva2").rup_time({
		hour:8,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText>$("#hora_fin_reserva2").rup_time("getTime"))
				$("#hora_fin_reserva2").val(dateText);
		}
		});
	$("#hora_fin_reserva2").rup_time({
		hour:9,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText<$("#hora_ini_reserva2").rup_time("getTime"))
				$("#hora_ini_reserva2").val(dateText);
		}
		});
	//
	
	// Creacion del enlace de limpiar formulario.
	$("#reservas_filter_cleanLink").unbind("click");
	$("#reservas_filter_cleanLink").bind("click", function () {
		// TODO : poner como evento 
		//$self.rup_table("cleanFilterForm").rup_table("filter");
		//if (filterSettings.validate!==undefined){
		//	jQuery(".rup-maint_validateIcon", filterSettings.$filterContainer).remove();
		//}

	  //	$("#cedif03_filter_table").rup_combo("clear");
		$("#reservas").rup_table("cleanFilterForm");

    	if ($("#cbSalaComun:checked").length > 0) {
		    $("#cdep07_filter_table").rup_combo("disable");
		    $("#departamental").val("");
	    } else {
	    	$("#cdep07_filter_table").rup_combo("enable");
	    	$("#departamental").val("1");
	    }
       	$("#cedif03_filter_table").rup_combo("clear");
    	$("#csala10_filter_table").rup_combo("disable");
  
    	$("#sit20_filter_table").val("A");
    	
    	$("#reservas").rup_table("filter");

    	$("#reservas").rup_table("showSearchCriteria");
	});

	//Para controlar los radio buttons
    $("input[name='cbSalaComunDepartamental']").click(function(e) {
    	if ($("#cbSalaComun:checked").length > 0) {
		    $("#cdep07_filter_table").rup_combo("disable");
		    $("#departamental").val("");
	    } else {
	    	$("#cdep07_filter_table").rup_combo("enable");
	    	$("#departamental").val("1");
	    }
    });

	if (!(esTecnico||esAdmin||esAdminDepto)) {
		$("#trSalaDepartamental").hide();
		$("#trSalaDepartamental_detalle").hide();
	} else {
		$("#trSalaDepartamental").show();
		$("#trSalaDepartamental_detalle").show();
	}
	$("#reservas").rup_table("filter");

	$("#reservas").rup_table("showSearchCriteria");
	
});

function cargarDatosEdificio(cedif03, cod20) {
	cargarRecursosEdificio(cedif03, cod20);
}

function cargarDatosSala(csala10, cod20) {
	cargarRecursosSala(csala10, cod20);
}

function cargarRecursosEdificio(cedif03, cod20) {

	$("#recursosEdificio").empty();

	if (cedif03.length>0) {
	    $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j13s01/obtenerRecursosEdificio/" + cedif03,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	                 for (var i=0; i<data.length; i++) {
	                	 $("#recursosEdificio").append('<option value="' + data[i].crec13 + '">' + ($.rup_utils.capitalizedLang()=="Es" ? data[i].nomc13 : data[i].nome13) + '</option>');
	                 }
	                 
	                 //Cargamos los recursos ocupados en la reserva
	                 $.ajax({
	     	    		type: "POST",
	     	            url: "/aa00jReservaSalasWar/aa00j13s01/obtenerRecursosEdificioReservaSala/" + cod20,
	     	            dataType: "json",
	     	            async: false,
	     	            success: function(data) {
	     	                 for (var i=0; i<data.length; i++) {
	     	                	$("#recursosEdificio option[value="+data[i].crec13+"]").attr("selected",true);
	     	                 }
	     	            },
	     	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	     					alert(etErrorObtenerRecursosSala);
	     				}
	                 });

	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
					alert(etErrorObtenerRecursosEdificio);
				}
	    });
	}
}

function cargarRecursosSala(csala10, cod20) {

	$("#recursosSala").empty();

	if (csala10.length>0) {
	    $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j12s01/obtenerMediosFijosSala/" + csala10,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	                 for (var i=0; i<data.length; i++) {
	                	 $("#recursosSala").append('<option value="' + data[i].cmedf12 + '">' + data[i].nom12 + '</option>');
	                 }

	                 //Cargamos los recursos ocupados en la reserva
	                 $.ajax({
	     	    		type: "POST",
	     	            url: "/aa00jReservaSalasWar/aa00j12s01/obtenerMediosFijosSalaReserva/" + cod20,
	     	            dataType: "json",
	     	            async: false,
	     	            success: function(data) {
	     	                 for (var i=0; i<data.length; i++) {
	     	                	$("#recursosSala option[value="+data[i].cmedf12+"]").attr("selected",true);
	     	                 }
	     	            },
	     	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	     					alert(etErrorObtenerRecursosSala);
	     				}
	                 });
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
					alert(etErrorObtenerRecursosSala);
				}
	    });
    }
}

function modificar() {
	haCambiado=false;
	//Se invoca la función de edición de un registro.
	$("#reservas").rup_table("editElement");
}

function anular() {

	//Lo primero bloqueamos las filas
	bloquear('edit', $("#reservas"), "aa00j20s01", "asun20");

	$.rup_messages("msgConfirm", { title: etPregunta,
		   message: etPreguntaAnularReservas,
		   OKFunction: function() {
			   var selRows = $("#reservas").rup_table("getSelectedRows");
			   if (selRows[0] == null) {
				   //alert(etDebeSeleccionarUnaFila); //El mensaje sale en el método bloquear
			   } else {
				   var data = {codigosReservas:selRows};
				   $.rup_ajax({
	    	    		type: "POST",
	    	            url: "/aa00jReservaSalasWar/aa00j20s01/anular",
	    	            data: $.toJSON(data),
						dataType: "json",
	    	            async: false,
	    	            contentType: 'application/json',
	    	            success: function(data, textStatus, jqXHR) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					    desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}

	    	            	if (data != null) {
	    	            		if (data[0] != "") {
	    	            			alert(data[0]);
	    	            		}
	    	            		if (data[1] != "") {
	    	            			var codigos = data[1].split(",");
	    	            			$.each(codigos, function(index, value) {
	    	            				cambiarSituacion(value, $("#reservas"), "sit20", "B");
	    	            			});
	    	            		}
	    	            	}
	    	            	$("#reservas").rup_table("deselectAllRows");
	    	            	$("#reservas").rup_table("filter");
	    	            },
	    	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					    desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}
	    					alert(etErrorAnularReservasSalas);
	    				}
	                });
			   }
		   },
		   CANCELFunction: function() {
			   try {
				   //Al terminar desbloqueamos los registros
				   desbloquear(jQuery("#reservas"), "aa00j20s01");
			   } catch(e) {}
			   $("#reservas").rup_table("deselectAllRows");
		   }
	});

}
function borrar() {

	//Lo primero bloqueamos las filas
	bloquear('edit', $("#reservas"), "aa00j20s01", "asun20");

	$.rup_messages("msgConfirm", { title: etPregunta,
		   message: etPreguntaBorrarReservas,
		   OKFunction: function() {
			   var selRows = $("#reservas").rup_table("getSelectedRows");
			   if (selRows[0] == null) {
				   //alert(etDebeSeleccionarUnaFila); //El mensaje sale en el método bloquear
			   } else {
				   var data = {codigosReservas:selRows};
				   $.rup_ajax({
	    	    		type: "POST",
	    	            url: "/aa00jReservaSalasWar/aa00j20s01/borrar",
	    	            data: $.toJSON(data),
						dataType: "json",
	    	            async: false,
	    	            contentType: 'application/json',
	    	            success: function(data, textStatus, jqXHR) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					  //  desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}

	    	            	if (data != null) {
	    	            		if (data[0] != "") {
	    	            			alert(data[0]);
	    	            		}
	    	            		if (data[1] != "") {
	    	            			var codigos = data[1].split(",");
	    	            			$.each(codigos, function(index, value) {
	    	            				cambiarSituacion(value, $("#reservas"), "sit20", "B");
	    	            			});
	    	            		}
	    	            	}
	    	            	$("#reservas").rup_table("deselectAllRows");
	    	            	$("#reservas").rup_table("filter");
	    	            },
	    	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					    desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}
	    					alert(etErrorBorrarReservasSalas);
	    				}
	                });
			   }
		   },
		   CANCELFunction: function() {
			   try {
				   //Al terminar desbloqueamos los registros
				   desbloquear(jQuery("#reservas"), "aa00j20s01");
			   } catch(e) {}
			   $("#reservas").rup_table("deselectAllRows");
		   }
	});

}
function confirmar() {

	//Lo primero bloqueamos las filas
	bloquear('edit', $("#reservas"), "aa00j20s01", "asun20");

	$.rup_messages("msgConfirm", { title: etPregunta,
		   message: etPreguntaConfirmarReservas,
		   OKFunction: function() {
			   var selRows = $("#reservas").rup_table("getSelectedRows");
			   if (selRows[0] == null) {
				   //alert(etDebeSeleccionarUnaFila); //El mensaje sale en el método bloquear
			   } else {
				   var data = {codigosReservas:selRows};
				   $.rup_ajax({
	    	    		type: "POST",
	    	            url: "/aa00jReservaSalasWar/aa00j20s01/confirmar",
	    	            data: $.toJSON(data),
						dataType: "json",
	    	            async: false,
	    	            contentType: 'application/json',
	    	            success: function(data, textStatus, jqXHR) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					    desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}

	    	            	if (data != null) {
	    	            		if (data[0] != "") {
	    	            			alert(data[0]);
	    	            		}
	    	            		if (data[1] != "") {
	    	            			var codigos = data[1].split(",");
	    	            			$.each(codigos, function(index, value) {
	    	            				cambiarConfirmada(value, $("#reservas"), "swconf20", 1);
	    	            			});
	    	            		}
	    	            	}
	    	            	$("#reservas").rup_table("deselectAllRows");
	    	            },
	    	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	    	            	try {
	    	            		//Al terminar desbloqueamos los registros
	     					    desbloquear(jQuery("#reservas"), "aa00j20s01");
	    	            	} catch(e) {}

	    					alert(etErrorConfirmarReservasSalas);
	    				}
	                });
			   }
		   },
		   CANCELFunction: function() {
			   try {
				   //Al terminar desbloqueamos los registros
				   desbloquear(jQuery("#reservas"), "aa00j20s01");
			   } catch(e) {}
		   }
	});
}

//function cerrar(){
//	if(haCambiado)
//		$.rup_messages("msgConfirm", {
//			message: $.rup.i18nParse($.rup.i18n.base,"rup_table.saveAndContinue"),
//			title: $.rup.i18nParse($.rup.i18n.base,"rup_table.changes"),
//			OKFunction : function () {
//				$("#reservas_detail_div").rup_dialog("close");
//			}
//		});
//	else
//		$("#reservas_detail_div").rup_dialog("close");
//	
//}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaModificacion,"ayuda_feedback");
}