var haCambiado=false;
jQuery(function($){
	$("#reservas_detail_link_cancel").hide();
	$("#reservas").rup_table({

		url: "/aa00jReservaSalasWar/aa00j30s01",
		colNames: [
			"Codigo",
			"CodigoRecurso",
			Recurso,
			Asunto,
			Dia,
			HoraIni,
			HoraFin,
			Reservador,
			ANombreDe,
			Telefono,
			"CodigoDepartamento",
			Departamento,
			FueraHorario,
			Situacion,
			"Bloqueo",
			"UsuarioBloqueo"
		],
		colModel: [
			{ 	name: "cod30",
			 	label: "Codigo",
				align: "right",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "crec30",
			 	label: "CodigoRecurso",
				align: "right",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "aa00j13s01." + ($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"),
			 	label: Recurso,
				align: "left",
				width: 150,
				editable: false,
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "asun30",
			 	label: Asunto,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "diaMostrar",
			 	label: Dia,
				align: "center",
				width: 80,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "horaIniMostrar",
			 	label: HoraIni,
				align: "center",
				width: 60,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "horaFinMostrar",
			 	label: HoraFin,
				align: "center",
				width: 60,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "reser30",
			 	label: Reservador,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "anomd30",
			 	label: ANombreDe,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "tlfnor30",
			 	label: Telefono,
				align: "left",
				width: 120,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "aa00j07s01ByCdepr30.cdep07",
			 	label: "CodigoDepartamento",
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "aa00j07s01ByCdepr30." + ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"),
			 	label: Departamento,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true
			},
			{ 	name: "swfhor30",
			 	label: FueraHorario,
				align: "left",
				width: 150,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true
			},
			{ 	name: "sit30",
			 	label: Situacion,
				align: "left",
				width: 80,
				editable: true,
				ruptype: "combo",
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "bloq30",
			 	label: "Bloqueo",
				align: "left",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "usub30",
			 	label: "UsuarioBloqueo",
				align: "left",
				width: 150,
				editable: true,
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			}
        ],
        model:"Aa00j30s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	"search",
        	"multiselection"
         	],
		primaryKey: "cod30",
		sortname: "dhcom30",
		sortorder: "asc",
		loadOnStartUp: true,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
        formEdit:{
        	detailForm: "#reservas_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"700"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodreservas").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#reservas"), "aa00j30s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{
    			rules:{
            	  	"cod30":{required:true},
                    "aa00j03s01.cedif03":{required:true},
            	  	"diaMostrar":{required:true},
            	  	"horaIniMostrar":{required:true},
            	  	"horaFinMostrar":{required:true},
                    "asun30":{required:true},
                    "aa00j07s01ByCdep30.cdepr07":{required:true},
                    "responsable":{required:true}
    			}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit30");
		}
	});
	$("#reservas_cb div").hide();
	$("#reservas").on("jqGridAddEditBeforeSubmit", function(event, postData){
		$.extend(postData,{
			horaIniMostrar: $("#hora_ini_reserva2").val(),
			horaFinMostrar: $("#hora_fin_reserva2").val()
		});
	});

	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#reservas").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquearSiAlta('edit', $(this), "aa00j30s01", "asun30");
	});
	jQuery("#reservas").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		limpiarCampos();
		return bloquearSiAlta(oper, $(this), "aa00j30s01", "asun30");
	});
	jQuery("#reservas_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#reservas"), "aa00j30s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	jQuery("#reservas").on("jqGridAddEditClickPgButtons", function(event, form, oper) {
		limpiarCampos();
	});

	jQuery("#reservas").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		$("#hora_ini_reserva2").val($("#hora_ini_reserva").val());
		$("#hora_fin_reserva2").val($("#hora_fin_reserva").val());
	});

	function limpiarCampos() {
		$("#cod30").val("");
		$("#cedif03_reserva").rup_combo("select", "");
		$("#fecha_reserva").val("");
		$("#hora_ini_reserva2").val("");
		$("#hora_fin_reserva2").val("");
		$("#hora_ini_reserva").val("");
		$("#hora_fin_reserva").val("");
		$("#asunto_reserva").val("");
		$("#observaciones_reserva").val("");
		$("#cdepr07_reserva").val("");
		$("#responsable_reserva").val("");
		$("#dni30").val("");
		$("#crec13_reserva").rup_combo("select", "");
	}
	
	//Combo Departamento - FILTRO
	$("#cdep07_filter_table").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j07s01/combo",
		sourceParam: { label:($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"), value:"cdep07" },
		style: "dropdown",
		width:"280",
		disabled: !(esTecnico||esAdmin),
		selected: ""+codDeptoInterno,
		blank:""
	});
	
	//Combo Departamento - FILTRO
	$("#cdepr07_reserva").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j07s01/combo",
		sourceParam: { label:($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"), value:"cdep07" },
		style: "dropdown",
		width:"216",
		disabled: true,
		blank:""
	});

	//Combo Edificio - FILTRO
	$("#cedif03_filter_table").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j03s01/combo",
		sourceParam: { label:"nombre03", value:"cedif03" },
		style: "dropdown",
		width:"280",
		blank:""
	});

	//Combo Edificio - DETALLE
	$("#cedif03_reserva").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j03s01/combo",
		sourceParam: { label:"nombre03", value:"cedif03" },
		style: "dropdown",
		width:"216",
		blank:""
	});
	
	//Combo Recurso - FILTRO
	$("#crec13_filter_table").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j13s01/combo",
		sourceParam: { label:($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"), value:"crec13" },
		parent: [ "cedif03_filter_table" ],
		style: "dropdown",
		width:"280",
		blank:""
	});

	//Combo Recurso - DETALLE
	$("#crec13_reserva").rup_combo({
		source: "/aa00jReservaSalasWar/aa00j13s01/combo",
		sourceParam: { label:($.rup_utils.capitalizedLang()=="Es" ? "nomc13" : "nome13"), value:"crec13" },
		parent: [ "cedif03_reserva" ],
		style: "dropdown",
		width:"216"
	});

	//Para la fecha y la hora
	$("#fecha_filter_table").rup_date({
		multiSelect: 99,
		showButtonPanel: true
	});


	//

	$("#hora_ini_filter_table").rup_time({
		hour:8,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText>$("#hora_fin_filter_table").rup_time("getTime"))
				$("#hora_fin_filter_table").val(dateText);
		}
		});
	$("#hora_fin_filter_table").rup_time({
		hour:9,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText<$("#hora_ini_filter_table").rup_time("getTime"))
				$("#hora_ini_filter_table").val(dateText);
		}
		});
	//Para la fecha y la hora
	$("#fecha_reserva").rup_date({
		//multiSelect: 99,
		showButtonPanel: true
	});


	$("#hora_ini_reserva2").rup_time({
		hour:8,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText>$("#hora_fin_reserva2").rup_time("getTime"))
				$("#hora_fin_reserva2").val(dateText);
		}
		});
	$("#hora_fin_reserva2").rup_time({
		hour:9,
		minute:0,
		onSelect:function(dateText,inst){
			if(dateText<$("#hora_ini_reserva2").rup_time("getTime"))
				$("#hora_ini_reserva2").val(dateText);
		}
		});
	//
	
	// Creacion del enlace de limpiar formulario.
	$("#reservas_filter_cleanLink").unbind("click");
	$("#reservas_filter_cleanLink").bind("click", function () {
		// TODO : poner como evento 
		//$self.rup_table("cleanFilterForm").rup_table("filter");
		//if (filterSettings.validate!==undefined){
		//	jQuery(".rup-maint_validateIcon", filterSettings.$filterContainer).remove();
		//}
		
		$("#reservas").rup_table("cleanFilterForm");
    	
    	$("#sit30_filter_table").val("A");
    	
    	$("#reservas").rup_table("filter");

    	$("#reservas").rup_table("showSearchCriteria");
	});
	
	 //Detectar cambio
	   $('input').change(function() { 
        haCambiado = true; 
		}); 
		$('textarea').change(function() { 
		               haCambiado = true; 
		}); 
});

function modificar() {
	haCambiado=false;
	//Se invoca la función de edición de un registro.
	$("#reservas").rup_table("editElement");
}

function anular() {

	//Lo primero bloqueamos las filas
	bloquear('edit', $("#reservas"), "aa00j30s01", "asun30");

	$.rup_messages("msgConfirm", { title: etPregunta,
		   message: etPreguntaAnularReservas,
		   OKFunction: function() {
			   var selRows = $("#reservas").rup_table("getSelectedRows");
			   if (selRows[0] == null) {
				   //alert(etDebeSeleccionarUnaFila); //El mensaje sale en el método bloquear
			   } else {
				   var data = {codigosReservas:selRows};
				   $.rup_ajax({
	    	    		type: "POST",
	    	            url: "/aa00jReservaSalasWar/aa00j30s01/anular",
	    	            data: $.toJSON(data),
						dataType: "json",
	    	            async: false,
	    	            contentType: 'application/json',
	    	            success: function(data, textStatus, jqXHR) {
	    	            	if (data != null) {
	    	            		if (data[0] != "") {
	    	            			alert(data[0]);
	    	            		}
	    	            		if (data[1] != "") {
	    	            			var codigos = data[1].split(",");
	    	            			$.each(codigos, function(index, value) {
	    	            				cambiarSituacion(value, $("#reservas"), "sit30", "B");
	    	            			});
	    	            		}
	    	            	}
	    	            },
	    	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	    					alert(etErrorAnularReservasRecursos);
	    				}
	                });
			   }
			   //Al terminar desbloqueamos los registros
			   desbloquear(jQuery("#reservas"), "aa00j30s01");
		   },
		   CANCELFunction: function() {
			   //Al terminar desbloqueamos los registros
			   desbloquear(jQuery("#reservas"), "aa00j30s01");
		   }
	});
}

function cerrar(){
	if(haCambiado)
		$.rup_messages("msgConfirm", {
			message: $.rup.i18nParse($.rup.i18n.base,"rup_table.saveAndContinue"),
			title: $.rup.i18nParse($.rup.i18n.base,"rup_table.changes"),
			OKFunction : function () {
				$("#reservas_detail_div").rup_dialog("close");
			}
		});
	else
		$("#reservas_detail_div").rup_dialog("close");
	
}