jQuery(function($){

	$("#aa00j16s01").rup_table({
		
		url: "../aa00j16s01",
		colNames: [
			"id16",
			campo1,
			campo2,
			campo5,
			campo6,
			campo3,
			campo4,
			"usub16",
			"bloq16"
		],
		colModel: [
			{ 	name: "id16", 
			 	label: "id16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nomc16", 
			 	label: "nomc16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "nome16", 
			 	label: "nome16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "titc16", 
			 	label: "titc16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "tite16", 
			 	label: "tite16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "tipo16", 
			 	label: "tipo16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "sit16", 
			 	label: "sit16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "usub16", 
			 	label: "usub16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "bloq16", 
			 	label: "bloq16",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			}
        ],

        model:"Aa00j16s00",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"fluid",
        	"filter",
        	"multiselection"
         	],
		primaryKey: "id16",
		sortname: "nomc16",
		sortorder: "asc",
		loadOnStartUp: true,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
        formEdit:{
        	detailForm: "#aa00j16s01_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			validate:{ 
    			rules:{
    				"nomc16":{
    					required: true,
						maxlength: 150
    					},
    				"nome16":{
    					required: true,
						maxlength: 150
    					}
    				}
    		}	
        },
			toolbar:{
				defaultButtons:{
					add : true,
					edit : true,
					cancel : true,
					save : false,
					clone : false,
					"delete" : false
			
				},
				newButtons:[		
					
					{
						id:"aniadir",
						obj: {id:"aniadir",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.aniadir, css: "aniadir"},
						click: handlerAniadirSalas,
						ocultar:true,
						comportamiento:"edit"
						
					},
					{
						id:"refrescar",
						obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
						click: handlerSituacion,
						ocultar:true,
						comportamiento:"edit"
						
					}
					]
			},
			afterInsertRow : function(rowid, rowdata) {
				pintarFilaSituacion(rowid, rowdata, $(this), "sit16");
				if (rowdata["tipo16"] == '0') {
						rowdata["tipo16"] = tipo1;
				} else {
				    	rowdata["tipo16"] = tipo2;
				}
				 $(this).rup_grid("setRowData", rowid, rowdata);
			},

	        onPaging:function (bt){
	         
	        	$("#aa00j16s01").rup_table("deselectAllRows");
	        }
	});
	$("#aa00j16s01_cb div").hide();
	$("#aa00j16s01").rup_table("deselectAllRows");
	jQuery("#aa00j16s01").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j16s01", "nomc16");
	});
	jQuery("#aa00j16s01").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return bloquear(oper, $(this), "aa00j16s01", "nomc16");
	});
	jQuery("#aa00j16s01_detail_div").on("dialogclose", function() {
		desbloquear($("#aa00j16s01"), "aa00j16s01");
		$("#aa00j16s01").rup_table("deselectAllRows");
	});
	jQuery("#aa00j16s01").on("jqGridAddEditAfterFillData", function(event, form, oper) {
		
		  $('input').change(function() { 
      haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});
	$("#restarsala").bind("click", restaSala);
	$("#sumarsala").bind("click", sumaSala);
	$("#subirsala").bind("click", subir);
	$("#bajarsala").bind("click", bajar);
	//Combo Situacion - FILTRO
	$("#sit16_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:2
	});
	$("#tipo16_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"180",
		selected:2
	});
	
	$("#sit16_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:2
	});
	$("#tipo16_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"180",
		selected:2
	});
	$("#aa00j16s01_detail_link_cancel").hide();
	// $("#aa00j16s01").rup_table("cleanFilterForm");
	//  $("#aa00j16s01").rup_table("filter");
});

function handlerSituacion(){
	
	if(bloquear('edit', $("#aa00j16s01"), "aa00j16s01", "nomc16")){
		//llarmar a cambiar estado
		var cods= jQuery("#aa00j16s01").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j16s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#aa00j16s01"), "aa00j16s01");
	            	$("#aa00j16s01").rup_table("filter");
	            	$("#aa00j16s01").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#aa00j16s01"), "aa00j16s01");
	            	$("#aa00j16s01").rup_table("deselectAllRows");
				}
	    });
	}	
}
function handlerAniadirSalas(){	
	$("#aa00j16s01_salas_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevoSitio,
		width:800,
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos el nuevo sitio / ubicación
				var $op = $('#salaslistado option');
				var id=$("#aa00j16s01").rup_table("getSelectedRows");
				if($op.length){
					var data={};
					data.codigo= parseInt(id);
					data.salas=[];
					for(i=0;i<$op.length;i++){
						data.salas.push(parseInt($op[i].value));
					}
				

					$.rup_ajax({
						type: "POST",
						url: "/aa00jReservaSalasWar/aa00j16s01/actualizar",
						async: false,
						data: $.toJSON(data),
						dataType: "json",
						contentType: 'application/json',
						success: function(data, textStatus, jqXHR) {
							$("#aa00j16s01_salas_div").rup_dialog("close");
						},
						error: function (XMLHttpRequest, textStatus, errorThrown) {
							alert(etErrorCrearNuevoSitio);
						}
					});
					
					
				}
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#aa00j16s01_salas_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  
			var id=$("#aa00j16s01").rup_table("getSelectedRows")[0];
			$.rup_ajax({
				type: "GET",
				url: "/aa00jReservaSalasWar/aa00j16s01/salas/"+id,
				contentType: 'application/json',
				dataType: "json",
				success: function(data, textStatus, jqXHR) {
					var texto="";
					for(i=0;i<data.length;i++){
						texto+="<option value='"+data[i].csala10+"'>"+data[i].nombre10+"</option>";
					}
					$("#salaslistado").html(texto);
					$.rup_ajax({
						type: "GET",
						url: "/aa00jReservaSalasWar/aa00j16s01/nosalas/"+id,
						contentType: 'application/json',
						dataType: "json",
						success: function(data2, textStatus, jqXHR) {
							var texto="";
							for(i=0;i<data2.length;i++){
								texto+="<option value='"+data2[i].csala10+"'>"+data2[i].nombre10+"</option>";
							}
							$("#salasnolistado").html(texto);
							
						}
					});
				}
			});
			
		}
	});
	
}
function sumaSala() {
	 var index=$('#salasnolistado').prop('selectedIndex');
    $('#salasnolistado option:selected').remove().appendTo('#salaslistado');
    if( $('#salasnolistado').length<=index)index--;
    $('#salasnolistado').prop('selectedIndex',index);
}

function restaSala() {
	$('#salaslistado option:selected').remove().appendTo('#salasnolistado');
}
function subir(){
	var $op = $('#salaslistado option:selected');
	if($op.length)
        $op.first().prev().before($op); 
  
}
function bajar(){
	var $op = $('#salaslistado option:selected');
	if($op.length){
      
	        $op.last().next().after($op);
	}	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaGestionListado,"ayuda_feedback");
}