jQuery(function($){

	$("#Edificios").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j03s01",
		colNames: [
			"Codigo",
			"Sitio",
			Nombre,
			Sitio,
			"Bloqueo",
			Telefono,
			Situacion,
			"UsuarioBloqueo"
		],
		colModel: [
			{ 	name: "cedif03",
			 	label: "Codigo",
				align: "left",
				width: 50,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: false,
				sortable: false
			},
			{ 	name: "aa00j02s01.csitio02",
			 	label: "Sitio",
				align: "left",
				width: 200,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: true,
				resizable: true,
				sortable: true
			},
			{ 	name: "nombre03",
			 	label: "Nombre",
				align: "left",
				width: 200,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "aa00j02s01.nombre02",
			 	label: "Sitio",
				align: "left",
				width: 200,
				editable: true,
				firstsortorder: "asc",
				fixed: false,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "bloq03",
			 	label: "Bloqueo",
				align: "left",
				width: 50,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: false,
				sortable: false
			},
			{ 	name: "tlfno03",
			 	label: "Telefono",
				align: "left",
				width: 150,
				editable: true,
				fixed: true,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "sit03",
			 	label: "Situacion",
				align: "left",
				width: 80,
				editable: true,
				firstsortorder: "asc",
				fixed: true,
				hidden: false,
				resizable: true,
				sortable: true
			},
			{ 	name: "usub03",
			 	label: "UsuarioBloqueo",
				align: "left",
				width: 150,
				editable: false,
				fixed: false,
				hidden: true,
				resizable: false,
				sortable: false
			}
        ],
        model:"Aa00j03s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "cedif03",
	
		sortname: "nombre03",
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : !tieneEdificios?true:false,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
        formEdit:{
        	detailForm: "#Edificios_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodEdificios").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#Edificios"), "aa00j03s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{
    			rules:{
    				"cedif03":{
						required: true,
						number: true,
						min: 1,
						max: 999
    					},
    				"aa00j02s01.csitio02":{
						required: true,
						integer: true
    					},
    				"nombre03":{
						required: true
    					},
    				"sit03":{
						required: true
    					},
    				"bloq03":{
						required: true,
						integer: true
    					},
    				"tlfno03":{
						required: false
    					},
    				"usub03":{
						required: false
    					},
    				"aa00j05s01s.cresp05":{
    					required: false
    				}
    			}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit03");
		},
        onPaging:function (bt){
         
        	$("#Edificios").rup_table("deselectAllRows");
        }
	});
	jQuery("#Edificios").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit03")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#Edificios").on("jqGridDblClickRow", function(event, form, oper) {
		 //var situacion=$(this).rup_table("getRowData", form)["sit02"];
	//	 if(oper)
		 	 if(!todosEnAlta($(this),"sit03")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#Edificios").on("rupTable_beforeEditRow",function(event, form, oper) {
		 
		 return  todosEnAlta($(this),"sit03");
	    
	});
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#Edificios").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j03s01", "nombre03");
	});
	jQuery("#Edificios").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		limpiarCampos();
		return bloquear(oper, $(this), "aa00j03s01", "nombre03");
	});
	jQuery("#Edificios_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#Edificios"), "aa00j03s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	jQuery("#Edificios").on("jqGridAddEditAfterFillData", function(event, form, oper) { //jqGridAddEditAfterShowForm
		cargarDatosEdificio();
		 $('input').change(function() { 
             haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});

	jQuery("#Edificios").on("jqGridAddEditClickPgButtons", function(event, form, oper) {
		limpiarCampos();
	});
	
	function limpiarCampos() {
		$("#cedif03_detail_table").val("");
		$("#tlfno03_detail_table").val("");
		
		$("#csitio02_detail_table").rup_combo("selectLabel", "");
		//$("#sit03_detail_table").rup_combo("selectLabel", "");
		
		$("#responsablesLibres").empty();
	    $("#responsablesOcupados").empty();
	    
	    $("#nombre02_detail_table").val("");
	    $("#codigo05_detail_table").val("");
	    $("#nombre05_detail_table").val("");
	}

	function cargarDatosEdificio() {
		cargarResponsables($("#cedif03_detail_table").val());
	}

    jQuery("#Edificios_detail_button_save").click(function () {
    	//Seleccionamos todos los responsables de la lista de responsables ocupados
    	$('#responsablesOcupados option').prop('selected', true);
    });

	$("#csitio02_detail_table").rup_combo({
		loadFromSelect:true,
		selected:0,
		style : "dropdown",
		width:"140",
		blank:"",
		onLoadSuccess: function() {
			$("#csitio02_detail_table").rup_combo("selectLabel", $("#nombre02_detail_table").val());
		}
	});

	$("#csitio02_filter_table").rup_combo({
		loadFromSelect:true,
		selected:0,
		style : "dropdown",
		width:"140",
		blank:""
	});

	$("#sit03_filter_table").rup_combo({
		loadFromSelect:true, 
		
		style : "dropdown",
		width:"80",
		selected:""
	});
	
//	$("#sit03_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/situacion/comboAB",
//		sourceParam: { label:"descripcion"+$.rup_utils.capitalizedLang(), value:"codigo" },
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	$("#Edificios_detail_link_cancel").hide();
	$("#siguienteResponsables").bind("click", restaResponsable);
	$("#anteriorResponsables").bind("click", sumaResponsable);
	  $("#Edificios_cb div").hide();
	  $("#Edificios").rup_table("cleanFilterForm");
	  $("#Edificios").rup_table("filter");
});


function crearNuevoSitio() {

	$("#Sitios_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevoSitio,
		width:500,
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos el nuevo sitio / ubicación
				var data = {nombre:$("#nombre02_detail_table").val()};

				$.rup_ajax({
					type: "POST",
					url: "/aa00jReservaSalasWar/aa00j02s01/anyadir",
					async: false,
					data: $.toJSON(data),
					dataType: "json",
					contentType: 'application/json',
					success: function(data, textStatus, jqXHR) {
						if (data != null) {
							if (isNaN(data)) {
								alert(data);
							} else {
								$("#Sitios_detail_div").rup_dialog("close");
								$("#csitio02_detail_table").rup_combo("reload");
								$("#csitio02_filter_table").rup_combo("reload");
							}
						}
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						alert(etErrorCrearNuevoSitio);
					}
				});
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#Sitios_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#nombre02_detail_table").focus(); }
	});
	
	$("#nombre02_detail_table").focus();
	
}

function crearNuevoResponsable() {

	$("#Responsables_detail_div").rup_dialog({
		type: $.rup.dialog.DIV,
		autoOpen: true,
		modal: true,
		resizable: false,
		title: etCrearNuevoResponsable,
	
		buttons:[{
			text: etGuardar,
			click: function() {
				//Guardamos el nuevo responsable
				$("#codigo05_detail_table").val($("#codigo05_detail_table").val().toUpperCase());
				$("#codigo05_detail_table").val($("#codigo05_detail_table").val().replace(/\s+/g, ''));
				var data = {codigo:$("#codigo05_detail_table").val(),
							nombre:$("#nombre05_detail_table").val()};

				$.rup_ajax({
					type: "POST",
					url: "/aa00jReservaSalasWar/aa00j05s01/anyadir",
					async: false,
					data: $.toJSON(data),
					dataType: "json",
					contentType: 'application/json',
					success: function(data, textStatus, jqXHR) {
						if (data != null) {
							if (data!=$("#codigo05_detail_table").val()) {
								alert(data);
							} else {
								$("#Responsables_detail_div").rup_dialog("close");
								$("#responsablesOcupados").append('<option value="' + data + '">' + $("#nombre05_detail_table").val() + '</option>');
							}
						}
					},
					error: function (XMLHttpRequest, textStatus, errorThrown) {
						alert(etErrorCrearNuevoResponsable);
					}
				});
			}
		},
		{
			text: etCancelar,
			click: function() {
				$("#Responsables_detail_div").rup_dialog("close");
			},
			btnType:$.rup.dialog.LINK
		}],
		open: function(event, ui) {  $("#codigo05_detail_table").focus(); }
	});
	
	$("#nombre02_detail_table").focus();
}

/* INI - GESTIÓN DE LOS RESPONSABLES DEL EDIFICIO */
function cargarResponsables(codEdificio) {

	$("#responsablesLibres").empty();
    $("#responsablesOcupados").empty();

	if (codEdificio.length>0) {
	    $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j05s01/obtenerResponsablesEdificio/" + codEdificio,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	                 var miselect=$("#responsablesOcupados");
	                 $("#responsablesOcupados").empty();
	                 for (var i=0; i<data.length; i++) {
	                	 miselect.append('<option value="' + data[i].cresp05 + '">' + data[i].nom05 + '</option>');
	                 }
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
					alert(etErrorObtenerResponsables);
				}
	    });
	}

	if (codEdificio.length==0) {
		codEdificio=-1;
	}
    $.ajax({
    		type: "POST",
    		url: "/aa00jReservaSalasWar/aa00j05s01/obtenerResponsablesEdificioLibres/" + codEdificio,
    		dataType: "json",
    		async: false,
    		success: function(data2) {
            	var miselect2=$("#responsablesLibres");
            	$("#responsablesLibres").empty();
            	for (var i=0; i<data2.length; i++) {
            		miselect2.append('<option value="' + data2[i].cresp05 + '">' + data2[i].nom05 + '</option>');
            	}
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
				alert(etErrorObtenerResponsables);
			}
    });
}

function sumaResponsable() {
    !$('#responsablesLibres option:selected').remove().appendTo('#responsablesOcupados');
    // deseleccionamos los combos
    //$("#responsablesLibres").val([]);
    //$("#responsablesOcupados").val([]);
}

function restaResponsable() {
	!$('#responsablesOcupados option:selected').remove().appendTo('#responsablesLibres');
	// deseleccionamos los combos
	//$("#responsablesLibres").val([]);
	//$("#responsablesOcupados").val([]);
}
/* FIN - GESTIÓN DE LOS RESPONSABLES DEL EDIFICIO */


function handlerSituacion(){
	if(bloquear('edit',jQuery("#Edificios"), "aa00j03s01", "nombre03")){
		//llarmar a cambiar estado
		var cods= jQuery("#Edificios").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j03s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#Edificios"), "aa00j03s01");
	            	$("#Edificios").rup_table("filter");
	            	$("#Edificios").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#Edificios"), "aa00j03s01");
				}
	    });
	}	
}

function desactivar(){
	$("[id='Edificios_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='Edificios_toolbar##Editar']").prop("disabled",true);
	$("[id='Edificios_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='Edificios_toolbar##Clonar']").prop("disabled",true);

}
function activar(){
	//
	$("[id='Edificios_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='Edificios_toolbar##Editar']").prop("disabled",false);
	$("[id='Edificios_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='Edificios_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}
function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#Edificios").jqGrid('getGridParam','sortname');
	var ordasc=$("#Edificios").jqGrid('getGridParam','sortorder');
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#tipoSalida").val(tipo);
	$("#nombre03_filter_table2").val($("#nombre03_filter_table").val());
	$("#csitio02_filter_table2").val($("#csitio02_filter_table").val());
	$("#sit03_filter_table2").val($("#sit03_filter_table").val());

	$("#edificios_informe").attr("action","/aa00jReservaSalasWar/aa00j03s01/excel");
	$("#edificios_informe").attr("method","POST");
	$("#edificios_informe").attr("target","_blank");
	$("#edificios_informe").submit();
	
}