jQuery(function($){

	$("#Departamentos").rup_table({
		rowNum:20,
		url: "/aa00jReservaSalasWar/aa00j07s01",
		colNames: [
			"cdep07",
			DescripcionEs,
			DescripcionEu,
			Situacion,
			"bloq07",
			"usub07",
			"codxlnet07"
		],
		colModel: [
			{ 	name: "cdep07", 
			 	label: "cdep07",
				align: "left", 
				width: 150, 
				editable: false, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "descc07", 
			 	label: "descc07",
				align: "", 
				width: 300, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "desce07", 
			 	label: "desce07",
				align: "", 
				width: 300, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "sit07", 
			 	label: "sit07",
				align: "", 
				width: 70, 
				editable: true, 
				fixed: false, 
				hidden: false, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "bloq07", 
			 	label: "bloq07",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "usub07", 
			 	label: "usub07",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			},
			{ 	name: "codxlnet07", 
			 	label: "codxlnet07",
				align: "", 
				width: 150, 
				editable: true, 
				fixed: false, 
				hidden: true, 
				resizable: true, 
				sortable: true
			}
        ],
        model:"Aa00j07s01",
        usePlugins:[
			"formEdit",
        	"feedback",
			"toolbar",
        	"contextMenu",
        	"fluid",
        	"filter",
        	
        	"multiselection"
         	],
		primaryKey: "cdep07",
		sortname: ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"),
		sortorder: "asc",
		loadOnStartUp: false,
		filter:{
            clearSearchFormMode:"reset",
            showHidden:true
		},
		multiselection:{
			headerContextMenu_enabled : false
		},
		toolbar:{
			defaultButtons:{
				add : true,
				edit : true,
				cancel : true,
				save : false,
				clone : false,
				"delete" : true
		
			},
			newButtons:[		
				{
					id:"refrescar",
					obj: {id:"refrescar",i18nCaption:$.rup.i18n.app.botonerasMantGenerales.estado, css: "situacion"},
					click: handlerSituacion,
					ocultar:true,
					comportamiento:"edit"
					
				},
				{
					id:"excel",
					obj: {id:"excel",i18nCaption:"Excel", css: "excel"},
					click: handlerExcel,
					ocultar:true,
					comportamiento:"add"
					
				},
				{
					id:"pdf",
					obj: {id:"pdf",i18nCaption:"Pdf", css: "pdf"},
					click: handlerPdf,
					ocultar:true,
					comportamiento:"add"
					
				}]
		},
        formEdit:{
        	detailForm: "#Departamentos_detail_div",
			fillDataMethod: "clientSide",
			addEditOptions:{
				reloadAfterSubmit:true,
                width:"660"
			},
			deleteOptions:{
				/* INI: BLOQUEO Y DESBLOQUEO */
				afterShowForm:function(){
					jQuery("#delmodDepartamentos").off("dialogclose.bloqueo").on("dialogclose.bloqueo", function() {
						desbloquear(jQuery("#Departamentos"), "aa00j07s01");
					});
				}
				/* FIN: BLOQUEO Y DESBLOQUEO */
			},
         	validate:{ 
    			rules:{
    				"cdep07":{
    					required: true,
						number: true,
						min: 1,
						max: 99,
						maxlength: 2
    					},
    				"descc07":{
    					required: true,
						maxlength: 50
    					},
    				"desce07":{
    					required: true,
						maxlength: 50
    					},
    				"sit07":{
    					required: true,
						maxlength: 1
    					},
    				"bloq07":{
    					required: true,
						integer: true,
						maxlength: 1
    					},
    				"usub07":{
    					required: false,
						maxlength: 20
    					},
    				"codxlnet07":{
        				required: false,
    					maxlength: 6
        				}
    				}
    		}
        },
		afterInsertRow : function(rowid, rowdata) {
			pintarFilaSituacion(rowid, rowdata, $(this), "sit07");
		},
        onPaging:function (bt){
         
        	$("#Departamentos").rup_table("deselectAllRows");
        }
	});
	jQuery("#Departamentos").on("jqGridSelectRow", function(event, form, oper) {
//		 situacion=$(this).rup_table("getRowData", form)["sit02"];
		 if(oper)
		 	 if(!todosEnAlta($(this),"sit07")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
		 
	});
	jQuery("#Departamentos").on("jqGridDblClickRow", function(event, form, oper) {
		 //var situacion=$(this).rup_table("getRowData", form)["sit02"];
	//	 if(oper)
		 	 if(!todosEnAlta($(this),"sit07")){
		 		desactivar();
		 	 }
		 	 else{
		 		activar();
		 	 }
	});
	jQuery("#Departamentos").on("rupTable_beforeEditRow",function(event, form, oper) {
		 
		 return  todosEnAlta($(this),"sit07");
	    
	});
	/* INI: BLOQUEO Y DESBLOQUEO */
	jQuery("#Departamentos").on("rupTable_beforeDeleteRow", function(event, row) {
		return bloquear('edit', $(this), "aa00j07s01", ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"));
	});
	jQuery("#Departamentos").on("jqGridAddEditBeforeInitData", function(event, form, oper) {
		return bloquear(oper, $(this), "aa00j07s01", ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"));
	});
	jQuery("#Departamentos_detail_div").on("dialogclose", function() {
		desbloquear(jQuery("#Departamentos"), "aa00j07s01");
	});
	/* FIN: BLOQUEO Y DESBLOQUEO */

	$("#sit07_filter_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"80",
		selected:"A"
		
	});
	$("#codxlnet07_detail_table").rup_combo({
		loadFromSelect:true, 
		style : "dropdown",
		width:"400",
		selected:"",
		blank:""
	});
	jQuery("#Departamentos").on("jqGridAddEditAfterFillData", function(event, form, oper) {
	
		  $('input').change(function() { 
              haCambiado = true; 
			}); 
			$('textarea').change(function() { 
			               haCambiado = true; 
			}); 
			$('select').change(function() { 
	               haCambiado = true; 
			}); 
	});

//	$("#sit07_detail_table").rup_combo({
//		source : "/aa00jReservaSalasWar/situacion/comboAB",
//		sourceParam: { label:"descripcion"+$.rup_utils.capitalizedLang(), value:"codigo" },
//		style : "dropdown",
//		width:"80",
//		selected:""
//	});
	 $("#Departamentos_detail_link_cancel").hide();
	  $("#Departamentos_cb div").hide();
	  $("#Departamentos").rup_table("cleanFilterForm");
	  $("#Departamentos").rup_table("filter");
	  $("#Departamentos").rup_table("showSearchCriteria");
});


function handlerSituacion(){
	if(bloquear('edit',jQuery("#Departamentos"), "aa00j07s01", ($.rup_utils.capitalizedLang()=="Es" ? "descc07" : "desce07"))){
		//llarmar a cambiar estado
		var cods= jQuery("#Departamentos").rup_table("getSelectedRows").join();
		   $.ajax({
	    		type: "POST",
	            url: "/aa00jReservaSalasWar/aa00j07s01/cambiarSituacion/" + cods,
	            dataType: "json",
	            async: false,
	            success: function(data) {
	            	desbloquear(jQuery("#Departamentos"), "aa00j07s01");
	            	$("#Departamentos").rup_table("filter");
	            	$("#Departamentos").rup_table("deselectAllRows");
	            },
	            error: function (XMLHttpRequest, textStatus, errorThrown) {
	            	desbloquear(jQuery("#Departamentos"), "aa00j07s01");
				}
	    });
	}	
}

function desactivar(){
	$("[id='Departamentos_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='Departamentos_toolbar##Editar']").prop("disabled",true);
	$("[id='Departamentos_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary ui-button-disabled ui-state-disabled");
	$("[id='Departamentos_toolbar##Clonar']").prop("disabled",true);
}
function activar(){
	$("[id='Departamentos_toolbar##Editar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='Departamentos_toolbar##Editar']").prop("disabled",false);
	$("[id='Departamentos_toolbar##Clonar']").attr("class","rup-toolbar_button ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-primary");
	$("[id='Departamentos_toolbar##Clonar']").prop("disabled",false);
	
}
function openHelp(){
	crearAyuda($.rup.i18n.app.ayudaEdicion,"ayuda_feedback");
}

function handlerExcel(){
	handler(0);
}
function handlerPdf(){
	handler(1);
}
function handler(tipo){
	var ordcol=$("#Departamentos").jqGrid('getGridParam','sortname');
	var ordasc=$("#Departamentos").jqGrid('getGridParam','sortorder');
	$("#sidx").val(ordcol);
	$("#sord").val(ordasc);
	$("#descc07_filter_table2").val($("#descc07_filter_table").val());
	$("#desce07_filter_table2").val($("#desce07_filter_table").val());
	$("#sit07_filter_table2").val($("#sit07_filter_table").val());
	$("#tipoSalida").val(tipo);
	$("#departamentos_informe").attr("action","/aa00jReservaSalasWar/aa00j07s01/excel");
	$("#departamentos_informe").attr("method","POST");
	$("#departamentos_informe").attr("target","_blank");
	$("#departamentos_informe").submit();
	
}