<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
	version="1.0">

	<xsl:import href="estilos.xsl"/>
	
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:layout-master-set>
		    <fo:simple-page-master 
			margin-right="1.5cm"
			margin-left="1.5cm"
			margin-bottom="0.2cm"
			margin-top="0.3cm"
			page-width="21cm"
			page-height="29.7cm"
			master-name="first">
				<fo:region-body margin-top="2.5cm" margin-bottom="2.5cm"/>
				<fo:region-before extent="2cm" margin-bottom="0cm"/>
				<fo:region-after extent="2cm" margin-bottom="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>  
		<fo:page-sequence master-reference="first"> 
			<fo:static-content flow-name="xsl-region-before">
				<fo:block margin-left="7.7cm">
				
				</fo:block>
			</fo:static-content> 
			<fo:static-content flow-name="xsl-region-after">
				<fo:block text-align="center" font-size="10pt">
					<!--fo:external-graphic src="c:/datos/t64a/file/imgs/behe.gif" /-->
					<fo:block text-align="right" margin-top="1cm">
						-<fo:page-number/>-
					</fo:block>
				</fo:block>
			</fo:static-content> 
			<fo:flow flow-name="xsl-region-body">
				<fo:table border-collapse="collapse" table-layout="fixed"    margin-bottom="10pt"  width="100%">
					<fo:table-column column-width="50%"/>
					<fo:table-column column-width="50%"/>

					<fo:table-body>
						<fo:table-row >
							<fo:table-cell xsl:use-attribute-sets="cabeceraprincipal" number-columns-spanned="2"> 
								<fo:block>Leku zerrenda:</fo:block>								
							</fo:table-cell>
						</fo:table-row>					
						<fo:table-row >
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Izena</fo:block>								
								</fo:table-cell>										
								<fo:table-cell xsl:use-attribute-sets="cabecera" > 
									<fo:block>Egoera</fo:block>								
								</fo:table-cell>
									
							</fo:table-row>
						<xsl:for-each select="datos/lineas/elemento">
							<fo:table-row xsl:use-attribute-sets="bordenormal" >
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="nombre"/></fo:block>								
								</fo:table-cell>							
							
								<fo:table-cell xsl:use-attribute-sets="linea" > 
									 <xsl:choose>
										 <xsl:when  test="contains(situacion, &apos;A&apos; )">
													 	<fo:block> Alta</fo:block>		
										</xsl:when>
										<xsl:otherwise>
											 	<fo:block>Baja</fo:block>		
										</xsl:otherwise>	
									</xsl:choose>						
								</fo:table-cell>
						
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>
				<fo:block  font-family="Helvetica" font-size="7pt" padding="20pt" >Elementu kopurua:<xsl:value-of select="count(datos/lineas/elemento)"/></fo:block>
			</fo:flow>
		</fo:page-sequence>
	</fo:root>	
</xsl:template>
</xsl:stylesheet>
