<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
	version="1.0">

	<xsl:import href="estilos.xsl"/>
	
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
		<fo:layout-master-set>
		    <fo:simple-page-master 
			margin-right="1.5cm"
			margin-left="1.5cm"
			margin-bottom="0.2cm"
			margin-top="0.3cm"
			page-width="21cm"
			page-height="29.7cm"
			master-name="first">
				<fo:region-body margin-top="2.5cm" margin-bottom="2.5cm"/>
				<fo:region-before extent="2cm" margin-bottom="0cm"/>
				<fo:region-after extent="2cm" margin-bottom="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>  
		<fo:page-sequence master-reference="first"> 
			<fo:static-content flow-name="xsl-region-before">
				<fo:block margin-left="7.7cm">
				
				</fo:block>
			</fo:static-content> 
			<fo:static-content flow-name="xsl-region-after">
				<fo:block text-align="center" font-size="10pt">
					<!--fo:external-graphic src="c:/datos/t64a/file/imgs/behe.gif" /-->
					<fo:block text-align="right" margin-top="1cm">
						-<fo:page-number/>-
					</fo:block>
				</fo:block>
			</fo:static-content> 
			<fo:flow flow-name="xsl-region-body">
				<fo:block  xsl:use-attribute-sets="titulolistado"  ><xsl:value-of select="datos/cabecera/linea[6]"/></fo:block>
				<fo:block  xsl:use-attribute-sets="titulolistado"  ><xsl:value-of select="datos/cabecera/linea[5]"/></fo:block>	
				<fo:block  xsl:use-attribute-sets="tituloivap" border-top="1pt solid black"  margin-top="10pt" padding-top="10pt">
				<fo:inline margin-right="50%">
					<xsl:choose>
						<xsl:when test="datos/cabecera/linea[2]=1">Urtarrila / Enero</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=2">Otsaila / Febrero</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=3">Martxoa / Marzo</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=4">Apirila / Abril</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=5">Maiatza / Mayo</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=6">Ekaina / Junio</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=7">Uztaila / Julio</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=8">Abuztua / Agosto</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=9">Iraila / Septiembre</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=10">Urria / Octubre</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=11">Azaroa / Noviembre</xsl:when>
						<xsl:when test="datos/cabecera/linea[2]=12">Abendua / Diciembre</xsl:when>						
					</xsl:choose>
				</fo:inline>
				<fo:inline width="3cm" text-align="center" border="1pt solid black" space-start="150pt" padding-top="4pt">
		
				Eguna / Da:	<xsl:value-of select="datos/cabecera/linea[1]"/>
				</fo:inline>
			</fo:block>
				<fo:table border-collapse="collapse" table-layout="fixed"    margin-top="10pt"  width="100%" padding="4pt"  >
					<fo:table-column column-width="35%"/>
					<fo:table-column column-width="10%"/>
					<fo:table-column column-width="35%"/>
					<fo:table-column column-width="20%"/>
					<fo:table-body>
						<fo:table-row >
								<fo:table-cell xsl:use-attribute-sets="cabeceralistado" > 
									<fo:block>Ikasgela</fo:block>								
									<fo:block>Aula</fo:block>				
								</fo:table-cell>										
								<fo:table-cell xsl:use-attribute-sets="cabeceralistado" > 
									<fo:block>Ordua</fo:block>
									<fo:block>Hora</fo:block>								
								</fo:table-cell>
								<fo:table-cell xsl:use-attribute-sets="cabeceralistado" > 
									<fo:block>Ikastaroa</fo:block>								
									<fo:block>Curso</fo:block>
								</fo:table-cell>								
								<fo:table-cell xsl:use-attribute-sets="cabeceralistado" > 
									<fo:block>Tlfnoa</fo:block>								
									<fo:block>Tlfno</fo:block>								
								</fo:table-cell>	
							</fo:table-row>

						<xsl:for-each select="datos/lineas/elemento">
							<fo:table-row xsl:use-attribute-sets="bordenormal" >
							
								<xsl:choose>
										<xsl:when test="not(preceding-sibling::elemento[nombreSala = current()/nombreSala])">
										<xsl:variable name="numFilas" select="codReserva"/>
										
											<fo:table-cell xsl:use-attribute-sets="lineaizquierda" number-rows-spanned="{$numFilas}">
												<fo:block>
													<xsl:value-of select="nombreSala"/>
												</fo:block>
											</fo:table-cell>
										</xsl:when>
									</xsl:choose>
								
						
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="horaInicio"/></fo:block>								
								</fo:table-cell>		
							
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="asunto"/></fo:block>								
								</fo:table-cell>	
			
								<fo:table-cell xsl:use-attribute-sets="lineaizquierda" > 
									<fo:block><xsl:value-of select="telefono"/></fo:block>								
								</fo:table-cell>	
							</fo:table-row>
						</xsl:for-each>
					</fo:table-body>
				</fo:table>

			</fo:flow>
		</fo:page-sequence>
	</fo:root>	
</xsl:template>
</xsl:stylesheet>
