package com.ejie.aa00j.view;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.MimeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.view.xslt.XsltView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.ejie.aa00j.model.ImprimibleEnPdf;

/**
 * Permite crear PDFs transformando xml+xsltfo a pdf. La plantilla se carga con
 * el nombre que devuelve el controles
 * 
 * @author iaizpurl
 * 
 */
public class XsltFoView extends XsltView {
	private static final Logger logger = LoggerFactory
			.getLogger(ExcelView.class);

	/**
	 * Crea un XML String , pasando de un ArrayList de asignaciones a texto
	 * 
	 * @param datos
	 * @return
	 */
	private String toXML(ArrayList<ImprimibleEnPdf> datos,
			ArrayList<String> datosCabecera) {
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements
			Document doc = docBuilder.newDocument();

			Element rootElement = doc.createElement("datos");
			doc.appendChild(rootElement);
			if (datosCabecera != null) {
				Element cabecera = doc.createElement("cabecera");
				Element linea;
				for (String dato : datosCabecera) {
					linea = doc.createElement("linea");
					linea.appendChild(doc.createTextNode(dato));
					cabecera.appendChild(linea);

				}
				rootElement.appendChild(cabecera);
			}

			Element asignaciones = doc.createElement("lineas");
			rootElement.appendChild(asignaciones);
			Iterator<ImprimibleEnPdf> iter = datos.iterator();
			ImprimibleEnPdf elemento;

			while (iter.hasNext()) {
				elemento = (ImprimibleEnPdf) iter.next();
				asignaciones.appendChild(elemento.toXML(doc));

			}

			return nodeToString(doc);
		} catch (Exception e) {

			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		return null;
	}

	private String nodeToString(Node node) {// element

		StringWriter sw = new StringWriter();

		try {

			Transformer t = TransformerFactory.newInstance().newTransformer();

			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");

			t.setOutputProperty(OutputKeys.INDENT, "yes");

			t.transform(new DOMSource(node), new StreamResult(sw));

		} catch (TransformerException te) {

			StackTraceElement[] stackTraceElements = Thread.currentThread()

			.getStackTrace();

			for (StackTraceElement stackTrace : stackTraceElements) {

				logger.error(stackTrace.getClassName() + "  "

				+ stackTrace.getMethodName() + " "

				+ stackTrace.getLineNumber());

			}

			// System.out.println("nodeToString Transformer Exception");

		}

		return sw.toString();

	}

	@SuppressWarnings("unchecked")
	@Override
	protected void renderMergedOutputModel(Map model,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		XsltFoView.logger.info("XSLT VIEWER");
		FopFactory fopFactory = FopFactory.newInstance();
		FOUserAgent foUserAgent = fopFactory.newFOUserAgent();

		ServletOutputStream out = null;

		try {

			out = response.getOutputStream();
			response.setContentType(MimeConstants.MIME_PDF);
			// Construct fop with desired output format
			Fop fop = fopFactory.newFop(MimeConstants.MIME_PDF, foUserAgent,
					out);

			// Setup XSLT
			// TransformerFactory factory = TransformerFactory.newInstance(
			// "net.sf.saxon.TransformerFactoryImpl", null);
			TransformerFactory factory = TransformerFactory.newInstance();
			// Create new transformer and get the stylesheet using
			// getStylesheetSource() from superclass (XsltView)
			// there must be an XSL file in WEB-INF/xsl with file name
			// equal to the name of the view
			Transformer transformer = factory.newTransformer(super
					.getStylesheetSource());

			transformer.setParameter("versionParam", "2.0");
			ArrayList<String> datosCabecera = (ArrayList<String>) model
					.get("datosCabecera");
			// Setup input for XSLT transformation
			StringReader xmlReader = new StringReader(toXML(
					(ArrayList<ImprimibleEnPdf>) model.get("datos"),
					datosCabecera));
			Source src = new StreamSource(xmlReader);

			// Resulting SAX events (the generated FO) must be piped through to
			// FOP
			Result res = new SAXResult(fop.getDefaultHandler());

			// Start XSLT transformation and FOP processing
			transformer.transform(src, res);
		} finally {
			out.close();
		}

	}
}
