package com.ejie.aa00j.view;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.view.document.AbstractExcelView;

import com.ejie.aa00j.model.ImprimibleEnExcel;

/**
 * Crea una salida excel para las consultas detalle por meses y años.
 * 
 * @author iaizpurl
 * 
 */
public class ExcelView extends AbstractExcelView {
	private static final Logger logger = LoggerFactory
			.getLogger(ExcelView.class);
	/** Message source for i18n lookups */
	@Autowired
	private MessageSource messageSource;

	public MessageSource getMessageSource() {
		return messageSource;
	}

	public void setMessageSource(MessageSource messageSource) {
		this.messageSource = messageSource;
	}

	public ExcelView() {

	}

	public ExcelView(MessageSource msgSource) {
		this.messageSource = msgSource;

	}

	Map<String, HSSFCellStyle> estilos;

	@Override
	/**
	 * Crea el fichero con los siguientes datos que recibe en el modelo:
	 * detailsyears-->Años que se piden
	 * detailsmonths-->Meses que se piden
	 * detallesrecaudaciones-->Recaudaciones que se piden
	 * ListaDetalle-->Los datos
	 */
	protected void buildExcelDocument(Map<String, Object> model,
			HSSFWorkbook book, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		ExcelView.logger.info("Creando fichero");
		// Locale locale = RequestContextUtils.getLocale(request);
		// recuperar datos
		ArrayList<ImprimibleEnExcel> datos = (ArrayList<ImprimibleEnExcel>) model
				.get("datos");
		String titulo = (String) model.get("titulo");

		estilos = createStyles(book);

		HSSFSheet sheet = book.createSheet("datos");

		// Obtener el iterator
		Iterator<ImprimibleEnExcel> mainiterator = datos.iterator();

		int row = 5;
		HSSFCell c = null;
		boolean first = true;
		ImprimibleEnExcel linea;
		Object dato;
		int col, count = 0;

		Iterator<Object> elementosIter;

		Iterator<String> cabeceraIter;
		Iterator<Integer> anchurasIter;
		while (mainiterator.hasNext()) {
			linea = mainiterator.next();

			if (first) {// escribimos las cabeceras de la tabla
				col = 0;
				cabeceraIter = linea.cabecerasExcel(messageSource).iterator();
				while (cabeceraIter.hasNext()) {
					count++;
					// escribimos el campo
					c = getCell(sheet, row, col);
					c.setCellStyle(this.estilos.get("cabecera"));
					c.setCellValue(cabeceraIter.next());
					col++;
				}
				anchurasIter = linea.anchosColumnas().iterator();
				col = 0;
				while (anchurasIter.hasNext()) {
					sheet.setColumnWidth(col, 256 * anchurasIter.next());
					col++;
				}
				first = false;
			}
			row++;
			col = 0;
			elementosIter = linea.elementosExcel(messageSource).iterator();
			while (elementosIter.hasNext()) {
				dato = elementosIter.next();
				c = getCell(sheet, row, col);
				c.setCellStyle(this.estilos.get("datos"));
				if (dato instanceof Integer)
					c.setCellValue((Integer) dato);
				else if (dato instanceof Double)
					c.setCellValue((Double) dato);
				else if (dato instanceof Date)
					c.setCellValue((Date) dato);
				else if (dato instanceof String)
					c.setCellValue((String) dato);
				col++;
			}

		}
		// titulo
		CellRangeAddress range = new CellRangeAddress(3, 3, 0, count - 1);
		sheet.addMergedRegion(range);
		c = getCell(sheet, 3, 0);
		c.setCellStyle(this.estilos.get("titulo"));
		c.setCellValue(titulo);
		c.getRow().setHeight((short) 500);
	}

	public static Map<String, HSSFCellStyle> createStyles(HSSFWorkbook wb) {
		Map<String, HSSFCellStyle> styles = new HashMap<String, HSSFCellStyle>();
		// titulo principal
		HSSFDataFormat dfImporte = wb.createDataFormat();

		HSSFFont fontcabecera = wb.createFont();
		// cabecera tablas
		fontcabecera.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontcabecera.setColor(HSSFColor.BLACK.index);
		fontcabecera.setFontHeightInPoints((short) 12);
		HSSFCellStyle cabecera = wb.createCellStyle();
		cabecera.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
		cabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		cabecera.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		cabecera.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		cabecera.setBorderRight(HSSFCellStyle.BORDER_THIN);
		cabecera.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
		cabecera.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		cabecera.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
		cabecera.setBorderTop(HSSFCellStyle.BORDER_THIN);
		cabecera.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
		cabecera.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		cabecera.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);

		cabecera.setFont(fontcabecera);
		cabecera.setWrapText(true);
		styles.put("cabecera", cabecera);

		HSSFCellStyle propdat = wb.createCellStyle();
		propdat.cloneStyleFrom(cabecera);
		propdat.setBorderRight(HSSFCellStyle.BORDER_THIN);
		propdat.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		propdat.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderTop(HSSFCellStyle.BORDER_THIN);
		propdat.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		propdat.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
		propdat.setFillForegroundColor(HSSFColor.GREY_50_PERCENT.index);
		HSSFFont fontter = wb.createFont();
		// cabecera tablas
		fontter.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontter.setColor(HSSFColor.WHITE.index);
		fontter.setFontHeightInPoints((short) 24);
		propdat.setFont(fontter);
		propdat.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		propdat.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		propdat.setWrapText(true);
		styles.put("titulo", propdat);

		// datos
		HSSFFont fontdatos = wb.createFont();
		fontdatos.setBoldweight(HSSFFont.BOLDWEIGHT_NORMAL);
		fontdatos.setColor(HSSFColor.BLACK.index);
		fontdatos.setFontHeightInPoints((short) 12);
		fontdatos.setFontName("Arial");
		HSSFCellStyle datos = wb.createCellStyle();
		datos.setFillForegroundColor(HSSFColor.WHITE.index);
		datos.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		datos.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		datos.setFont(fontdatos);
		datos.setWrapText(true);
		datos.setBorderRight(HSSFCellStyle.BORDER_THIN);
		datos.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		datos.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderTop(HSSFCellStyle.BORDER_THIN);
		datos.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		datos.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);
		datos.setDataFormat(dfImporte.getFormat("#,##0"));
		styles.put("datos", datos);

		HSSFCellStyle suma = wb.createCellStyle();
		suma.cloneStyleFrom(datos);
		suma.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		suma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
		suma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		styles.put("datossuma", suma);

		HSSFCellStyle porcentaje = wb.createCellStyle();
		porcentaje.cloneStyleFrom(datos);
		porcentaje.setDataFormat(dfImporte.getFormat("#,##0.0"));
		styles.put("datosporcentaje", porcentaje);

		HSSFCellStyle porcentajesuma = wb.createCellStyle();
		porcentajesuma.cloneStyleFrom(porcentaje);
		porcentajesuma.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
		porcentajesuma.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		styles.put("datosporcentajesuma", porcentajesuma);

		// Años y meses (negrita y centrado)
		HSSFFont font = wb.createFont();
		font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		font.setColor(HSSFColor.BLACK.index);
		font.setFontHeightInPoints((short) 8);
		font.setFontName("Arial");
		HSSFCellStyle bold = wb.createCellStyle();
		bold.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		bold.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		bold.setFont(font);

		styles.put("negrita", bold);

		HSSFCellStyle boldcoma1lima = wb.createCellStyle();
		boldcoma1lima.cloneStyleFrom(datos);
		boldcoma1lima.setDataFormat(dfImporte.getFormat("#,##0"));
		boldcoma1lima.setFillForegroundColor(HSSFColor.LIME.index);
		boldcoma1lima.setFont(font);
		styles.put("formatlima", boldcoma1lima);

		HSSFCellStyle boldcoma1 = wb.createCellStyle();
		boldcoma1.cloneStyleFrom(bold);
		boldcoma1.setDataFormat(dfImporte.getFormat("#,##0"));
		styles.put("negritaformat", boldcoma1);

		HSSFCellStyle boldcoma = wb.createCellStyle();
		boldcoma.cloneStyleFrom(bold);
		boldcoma.setDataFormat(dfImporte.getFormat("#,##0.0"));
		styles.put("negritacoma", boldcoma);

		HSSFCellStyle boldcomalima = wb.createCellStyle();
		boldcomalima.cloneStyleFrom(datos);
		boldcomalima.setDataFormat(dfImporte.getFormat("#,##0.0"));
		boldcomalima.setFillForegroundColor(HSSFColor.LIME.index);
		boldcomalima.setFont(font);
		styles.put("comalima", boldcomalima);

		HSSFCellStyle hiddenstyle = wb.createCellStyle();
		hiddenstyle.setHidden(true);
		styles.put("oculta", bold);
		return styles;
	}
}
