package com.ejie.aa00j.control;

import java.util.ArrayList;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa00j.ldap.SecurityHelpperException;
import com.ejie.aa00j.ldap.SecurityHelpperXLNets;
import com.ejie.aa00j.ldap.aa00jDepartamentoXLNET;
import com.ejie.aa00j.ldap.aa00jPersonaXLNET;
import com.ejie.aa00j.ldap.aa00jServicioXLNET;
import com.ejie.aa00j.service.SiNoService;

@Controller
@RequestMapping(value = "/xlnets")
public class XlnetsController {
	@Autowired
	SiNoService sino;

	@RequestMapping(value = "/servicios/{departamento}", method = RequestMethod.GET)
	public String getServiciosXLNETs(@PathVariable String departamento,
			Model model) {
		// aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		// ArrayList<aa00jServicioXLNET> servs = ps.getPersonaXLNET()
		// .getServicios();
		SecurityHelpperXLNets sh = new SecurityHelpperXLNets();
		ArrayList<aa00jServicioXLNET> servs;
		try {
			servs = sh.getServiciosXLNETs(departamento);
			model.addAttribute("servicios", servs);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return "personaservicioXLNET";
	}

	@RequestMapping(value = "/personas", method = RequestMethod.GET)
	public @ResponseBody
	ArrayList<aa00jPersonaXLNET> getPersonas(@RequestParam String servicio,
			Model model) throws SecurityHelpperException {
		ArrayList<aa00jPersonaXLNET> personas;

		SecurityHelpperXLNets xlnets = new SecurityHelpperXLNets();
		personas = xlnets.getPersonasXLNETs(servicio);
		return personas;

	}

	@RequestMapping(value = "/departamentos", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<aa00jDepartamentoXLNET> getDepartamentos()
			throws SecurityHelpperException {
		ArrayList<aa00jDepartamentoXLNET> departamentos;

		SecurityHelpperXLNets xlnets = new SecurityHelpperXLNets();
		departamentos = xlnets.getDepartamentosXLNETs();
		return departamentos;
	}

	@RequestMapping(value = "/rellenardatos", method = RequestMethod.GET)
	public void rellenardatos() throws SecurityHelpperException {

		SecurityHelpperXLNets xlnets = new SecurityHelpperXLNets();
		String[] partes;
		aa00jPersonaXLNET persona = null;
		ArrayList<String> nombres = sino
				.obtenerNombres("select distinct reser20  as nombre from aa00j20t00 where reser20 is not null and trunc(dhcom20)>=trunc(SYSDATE)");

		for (String nombre : nombres) {
			partes = nombre.split(",");
			try {
				persona = xlnets.getPersonasXLNETs(null, null,
						partes[1].trim(), partes[0].trim(), null).get(0);
				sino.updatePr(
						"UPDATE aa00j20t00 set organ20=?, email20=? where reser20=?",
						nombre, persona.getCodigo(), persona.getEMail());

			} catch (Exception e) {
			} // System.out.print(persona);
		}

		nombres = sino
				.obtenerNombres("select distinct anomd20 as nombre from aa00j20t00 where anomd20 is not null and trunc(dhcom20)>=trunc(SYSDATE)");

		for (String nombre : nombres) {
			partes = nombre.split(",");
			try {
				persona = xlnets.getPersonasXLNETs(null, null,
						partes[1].trim(), partes[0].trim(), null).get(0);
				sino.updatePr(
						"UPDATE aa00j20t00 set dni20=?, emailr20=? where anomd20=?",
						nombre, persona.getCodigo(), persona.getEMail());

			} catch (Exception e) {
			} // System.out.print(persona);
		}

	}
}
