package com.ejie.aa00j.control;

import java.io.IOException;
import java.util.ArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.aa00j.service.Aa00j20s01Service;
import com.ejie.aa00j.service.Aa00j30s01Service;
import com.ejie.aa00j.service.ComunReservaService;

@Component
@Transactional
public class TimerController {
	private static final Logger logger = LoggerFactory
			.getLogger(TimerController.class);
	@Autowired
	private Aa00j20s01Service salasService;
	@Autowired
	private Aa00j30s01Service recursosReservaService;
	@Autowired
	private ComunReservaService comunService;
	@Autowired
	private PropertiesFactoryBean appConfiguration;

	private boolean isTriggerNode() {
		String host;
		try {
			host = this.appConfiguration.getObject().getProperty(
					"nombrecluster");
		} catch (IOException e) {
			host = "wl11_extra_jaso_apps112";

		}

		String hostName = "";

		TimerController.logger.info("Cluster --"
				+ System.getProperty("weblogic.Name"));
		hostName = System.getProperty("weblogic.Name");

		return hostName.equals(host);
	}

	/**
	 * Proceso automático que se ejecuta a una hora de la matrugada 0 0 7 * *
	 * (todos los días alas 7) -Discrimina por nodo del cluster (solamente se
	 * ejecuta por el nodo definido en el properties) 1-Busca la lista de
	 * reservas de salas a anular (sin confirmar y en alta con fecha menor o
	 * igual a hoy 2-Envia mails de anulacion a cada una de esas reservas
	 * 3-Anula las reservas de los recursos asociados a esas reservas 4-Busca la
	 * lista de reservas de salas sin confirmar y en alta en los próximos 15
	 * días 5-Manda un mail a confirmación por cada reserva 6-Manda el resto de
	 * mails no enviados
	 */
	@Scheduled(cron = "0 0 7 * * ?")
	public void gestionarReservas() {

		if (isTriggerNode()) {
			TimerController.logger.info("Dar de baja antiguas");
			/****************************************************
			 * DAR DE BAJA ANTIGUAS
			 ***************************************************/
			// buscamos las antiguas
			ArrayList<Aa00j20s01> listaanular = salasService
					.obtenerOcupacionesAanular();
			TimerController.logger.info("Numero reservas a anular ="
					+ listaanular.size());
			for (Aa00j20s01 reservaSala : listaanular) {
				try {

					TimerController.logger
							.info("Enviando mails anulacion para la reserva "
									+ reservaSala.getCod20());

					int enviadoOk = comunService.enviarMailsAnulacionReserva(
							reservaSala.getAa00j10s01(),
							reservaSala.getEmail20(),// reservador.getEMail(),
							reservaSala.getEmailr20(), reservaSala.getAsun20(),
							reservaSala.getDiaMostrar(),
							reservaSala.getHoraIniMostrar(),
							reservaSala.getHoraFinMostrar());
					loguearYmarcar(enviadoOk, reservaSala, null, true, true);
					// anular las reservas de los recursos asociados a la
					// reserva de sala
					TimerController.logger
							.info("Anulando las reservas de los recursos relacionados a la reserva de sala "
									+ reservaSala.getCod20());
					recursosReservaService.anularPorReservaSala(
							reservaSala.getCod20(), "Sistema");
				} catch (Exception e) {

					TimerController.logger
							.error("No se ha podido enviar un correo a "
									+ reservaSala.getReser20()
									+ " sobre la reserva "
									+ reservaSala.getCod20());
				}
			}
			TimerController.logger.info("Anular");
			salasService.darDeBajaAntiguas();
			/**
			 * Las reservas se los recursos no tienen un estado de confirmado,
			 * por lo que no se pueden anular las antiguas
			 */
			// Anular las reservas de los recursos sin relacion con reservas de
			// salas
			// ArrayList<Aa00j30s01> listaanularrecursos =
			// recursosReservaService
			// .obtenerOcupacionesAanular();
			// recursosReservaService.darDeBajaAntiguas();
			// Fin de anulación-->
			/************************************
			 * MANDAR MENSAJES PARA RESERVAS SIN CONFIRMAR
			 *************************************/
			TimerController.logger
					.info("Envio mails de las reservas sin confirmar________________");
			// Obtener lista de ocupaciones sin confirmar
			ArrayList<Aa00j20s01> lista = salasService
					.obtenerOcupacionesSinConfirmar();
			TimerController.logger.info("Numero reservas sin confirmar="
					+ lista.size());

			for (Aa00j20s01 reservaSala : lista) {
				try {

					TimerController.logger
							.info("Enviando mails para la reserva de sala "
									+ reservaSala.getCod20());

					int enviadoOk = comunService
							.enviarMailsConfirmacionReserva(
									reservaSala.getAa00j10s01(),
									reservaSala.getEmail20(),// reservador.getEMail(),
									reservaSala.getEmailr20(),
									reservaSala.getAsun20(),
									reservaSala.getDiaMostrar(),
									reservaSala.getHoraIniMostrar(),
									reservaSala.getHoraFinMostrar(), true);
					loguearYmarcar(enviadoOk, reservaSala, null, true, true);
				} catch (Exception e) {

					TimerController.logger
							.error("No se ha podido enviar un correo a "
									+ reservaSala.getReser20()
									+ " sobre la reserva "
									+ reservaSala.getCod20());
				}
			}
			/*****************************************
			 * MANDAR MENSAJES A LAS RESERVAS SIN MAIL ENVIADO
			 * 
			 * Esto no debería de ejecutarse casi nunca, el sistema no es capáz
			 * de reconocer errores externos en el envío del mail 8buzón lleno,
			 * no existe destinatario....)
			 * 
			 *****************************************/
			TimerController.logger
					.info("Obtener las reservas de salas que no hayan enviado sus mails____________________________");
			ArrayList<Aa00j20s01> lista2 = salasService
					.obtenerReservasSinEnviar();
			TimerController.logger
					.info("Enviar mail y apuntar estado de envío");
			String cor1 = null, cor2 = null;
			for (Aa00j20s01 reservaSala : lista2) {
				try {

					TimerController.logger
							.info("Enviando mails para la reserva de sala "
									+ reservaSala.getCod20());
					if (reservaSala.getSwmaile20() != 1)
						cor1 = reservaSala.getEmail20();
					else
						cor1 = null;
					if (reservaSala.getSwmailer20() != 1)
						cor2 = reservaSala.getEmailr20();
					else
						cor2 = null;
					int enviadoOk = comunService
							.enviarMailsConfirmacionReserva(
									reservaSala.getAa00j10s01(),
									cor1,// reservador.getEMail(),
									cor2, reservaSala.getAsun20(),
									reservaSala.getDiaMostrar(),
									reservaSala.getHoraIniMostrar(),
									reservaSala.getHoraFinMostrar(), true);
					loguearYmarcar(enviadoOk, reservaSala, null, true, true);
				} catch (Exception e) {

					TimerController.logger
							.error("No se ha podido enviar un correo a "
									+ reservaSala.getReser20()
									+ " sobre la reserva "
									+ reservaSala.getCod20());
				}
			}
			/*
			 * TimerController.logger .info(
			 * "Obtener las reservas de recursos que no hayan enviado sus mails"
			 * ); ArrayList<Aa00j30s01> listares = recursosReservaService
			 * .obtenerReservasSinEnviar();
			 * TimerController.logger.info("emails de reservas a mandar : " +
			 * listares.size());
			 * 
			 * for (Aa00j30s01 reservarecurso : listares) {
			 * TimerController.logger
			 * .info("Enviar mail y apuntar estado de envío");
			 * 
			 * if (reservarecurso.getSwmaile30() != 1) cor1 =
			 * reservarecurso.getEmail30(); else cor1 = null; if
			 * (reservarecurso.getSwmailer30() != 1) cor2 =
			 * reservarecurso.getEmailr30(); else cor2 = null; int enviadoOk =
			 * comunService.enviarMailsConfirmacionReserva( null, cor1,//
			 * reservador.getEMail(), cor2, reservarecurso.getAsun30(),
			 * reservarecurso.getDiaMostrar(),
			 * reservarecurso.getHoraIniMostrar(),
			 * reservarecurso.getHoraFinMostrar()); loguearYmarcar(enviadoOk,
			 * null, reservarecurso, true, true); }
			 */

		}

	}

	private void loguearYmarcar(int estadoenvio, Aa00j20s01 reservaSala,
			Aa00j30s01 reservaRecurso, boolean salas, boolean recursos) {
		int env1 = 1;
		int env2 = 1;
		String email1 = "";
		String email2 = "";
		if (reservaSala != null) {
			email1 = reservaSala.getEmail20();
			email2 = reservaSala.getEmailr20();
		} else {
			email1 = reservaRecurso.getEmail30();
			email2 = reservaRecurso.getEmailr30();
		}
		if (estadoenvio == aa00jConstantes.ENVIOOK) {
			TimerController.logger.info("Email  enviado a " + email1 + " y "
					+ email2);
			env1 = 1;
			env2 = 1;
		} else if (estadoenvio == aa00jConstantes.ENVIOMAL) {
			TimerController.logger.info("No se ha podido enviar mails a "
					+ email1 + " y " + email2);
			env1 = 0;
			env2 = 0;
		} else if (estadoenvio == aa00jConstantes.ENVIOMALRESERVADOR) {
			TimerController.logger.info("Se ha podido enviar mails a " + email1
					+ " y no se ha podido mandar a  " + email2);
			env1 = 1;
			env2 = 0;
		} else if (estadoenvio == aa00jConstantes.ENVIOMALRESPONSABLE) {
			TimerController.logger.info("Se ha podido enviar mails a " + email2
					+ " y no se ha podido mandar a  " + email1);
			env1 = 0;
			env2 = 1;

		}
		if (env1 != 0 || env2 != 0) {
			// Se marcan los campos de mail enviado correctamente
			if (reservaSala != null) {
				if (salas)
					salasService.marcarEnviado(reservaSala.getCod20(), env1,
							env2);
				if (recursos)
					recursosReservaService.actualizarMailsEnviadosReservaSala(
							reservaSala.getCod20(), env1, env2);
			} else {
				recursosReservaService.actualizarMailsEnviados(
						reservaRecurso.getCod30(), env1, env2);
			}
		}

	}
}
