package com.ejie.aa00j.control;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j02s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j16s00;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.SalaEstadistica;
import com.ejie.aa00j.model.SalaHorariosReservados;
import com.ejie.aa00j.service.Aa00j02s01Service;
import com.ejie.aa00j.service.Aa00j03s01Service;
import com.ejie.aa00j.service.Aa00j07s01Service;
import com.ejie.aa00j.service.Aa00j10s01Service;
import com.ejie.aa00j.service.Aa00j12s01Service;
import com.ejie.aa00j.service.Aa00j13s01Service;
import com.ejie.aa00j.service.Aa00j16s00Service;
import com.ejie.aa00j.service.EstadisticasService;
import com.ejie.aa00j.service.ListadosService;
import com.ejie.aa00j.service.SalasReservadasService;

@Controller
@RequestMapping(value = "/consultas")
/**
 * Esta clase es el controler de las consultas: permite redirigir a las pantallas y devolver los resultados
 */
public class ConsultasController {
	private static final Logger logger = LoggerFactory
			.getLogger(ConsultasController.class);

	@Autowired
	private SalasReservadasService salasReservadasService;

	@Autowired
	private Aa00j03s01Service edificiosService;
	@Autowired
	private Aa00j12s01Service mediosFijosService;

	@Autowired
	private Aa00j07s01Service departamentosService;
	@Autowired
	private Aa00j02s01Service sitiosService;

	@Autowired
	private Aa00j10s01Service salasService;
	@Autowired
	private Aa00j13s01Service resursosService;
	@Autowired
	private EstadisticasService estadisticasService;
	@Autowired
	private ListadosService listadosService;

	@Autowired
	private Aa00j16s00Service listadosGestService;
	@Autowired
	private PropertiesFactoryBean appConfiguration;

	// private Aa00j02s01Service ubicacionesService;

	/**
	 * Metodo de presentacion de la tabla de ocupaciones.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/panelOcupacion", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		ConsultasController.logger.info("[GET - View] : panel de ocupación");
		List<Option> ubicaciones = this.edificiosService.getListForOption(true,
				false);
		model.addAttribute("ubicaciones", ubicaciones);
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		return "panelOcupacion";
	}

	@RequestMapping(value = "/consultaPendientes", method = RequestMethod.GET)
	public String getFormPendientes(Model model) {
		ConsultasController.logger.info("[GET - View] : consultaPendientes");

		List<Aa00j02s01> ubicaciones = this.sitiosService.obtenerCombo();
		model.addAttribute("sitios", ubicaciones);

		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		return "consultaPendientes";
	}

	@RequestMapping(value = "/estadisticas", method = RequestMethod.GET)
	public String getFormEstadisticas(Model model) {
		ConsultasController.logger.info("[GET - View] : getFormEstadisticas");

		List<Aa00j02s01> ubicaciones = this.sitiosService.obtenerCombo();
		model.addAttribute("sitios", ubicaciones);
		model.addAttribute("anioactual",
				Calendar.getInstance().get(Calendar.YEAR) + 1);
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		return "estadisticas";
	}

	/**
	 * Metodo de presentacion del formulario de consulta de salas.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/consultaAsistida", method = RequestMethod.GET)
	public String getFormSalas(Model model) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");
		List<Option> ubicaciones = this.edificiosService.getListForOption(
				false, false);
		model.addAttribute("ubicaciones", ubicaciones);
		List<Option> mediosFijos = this.mediosFijosService.getListForOption();
		model.addAttribute("mediosFijos", mediosFijos);
		return "consultaAsistida";
	}

	/**
	 * Metodo de presentacion del formulario de consulta de salas.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/consultaSalas", method = RequestMethod.GET)
	public String getFormSalas2(Model model) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");
		List<Option> ubicaciones = this.edificiosService.getListForOption(true,
				false);
		model.addAttribute("edificios", ubicaciones);
		// List<Option> mediosFijos =
		// this.mediosFijosService.getListForOption();
		// model.addAttribute("mediosFijos", mediosFijos);
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		return "consultaSalas";
	}

	@RequestMapping(value = "/salasReservadas", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<SalaHorariosReservados> getSalasReservas(
			@RequestParam String dia,
			@RequestParam(value = "departamento", required = false) Integer departamento,
			@RequestParam(value = "edificio", required = false) Integer edificio,
			@RequestParam(value = "sala", required = false) Integer sala,
			Locale local) {
		// Date dia1 = new Date(dia);
		String[] dias = dia.split(",");
		ConsultasController.logger.info("[w] : getSalasReservas");
		SimpleDateFormat sdf;
		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");
		if (dias.length == 1) {
			Date day;
			try {
				day = sdf.parse(dias[0]);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				// e.printStackTrace();
				day = null;
			}
			return salasReservadasService.getHorarios(day, departamento,
					edificio, sala);
		} else {
			ArrayList<Date> dates = new ArrayList<Date>();

			for (String date : dias) {

				try {
					dates.add(sdf.parse(date));
				} catch (ParseException e) {

					// TODO Auto-generated catch block
					// e.printStackTrace();
					dates.add(null);
				}
			}
			return salasReservadasService.getHorarios(dates, sala);
		}
	}

	/**
	 * Metodo de presentacion del formulario de consulta de salas.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/comboMixtoOld", method = RequestMethod.GET)
	public @ResponseBody
	List<Map<String, List<Option>>> comboSalasYrecursos(
			@RequestParam(value = "sitios", required = true) int sitio,
			Model model, Locale local) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");

		List<Option> salas = this.salasService.salasPorSitio(sitio);

		// if (locale.getLanguage().contains("eu"))
		List<Option> recursos = this.resursosService.recursosPorSitio(sitio);
		HashMap<String, List<Option>> mapa = new HashMap<String, List<Option>>();
		mapa.put("Salas", salas);
		ArrayList<Map<String, List<Option>>> salida = new ArrayList<Map<String, List<Option>>>();
		salida.add(mapa);
		HashMap<String, List<Option>> mapa2 = new HashMap<String, List<Option>>();

		mapa2.put("Recursos", recursos);
		salida.add(mapa2);
		return salida;
	}

	@RequestMapping(value = "/comboSalas", method = RequestMethod.GET)
	public @ResponseBody
	List<Option> comboSalas(
			@RequestParam(value = "edificios", required = true) int sitio,
			Model model, Locale local) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");

		List<Option> salas = this.salasService.salasPorSitio(sitio);
		return salas;
	}

	/**
	 * Metodo de presentacion del formulario de consulta de salas.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/comboMixto2", method = RequestMethod.GET)
	public @ResponseBody
	List<Map<String, List<Option>>> comboSalasYrecursos2(
			@RequestParam(value = "departamentos", required = true) int departamento,
			Model model, Locale local) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");

		List<Option> salas = this.salasService
				.salasPorDepartamento(departamento);
		// if (locale.getLanguage().contains("eu"))
		// List<Option> recursos = this.resursosService.recursosPorSitio(sitio);
		HashMap<String, List<Option>> mapa = new HashMap<String, List<Option>>();
		mapa.put("Salas", salas);
		ArrayList<Map<String, List<Option>>> salida = new ArrayList<Map<String, List<Option>>>();
		salida.add(mapa);
		// HashMap<String, List<Option>> mapa2 = new HashMap<String,
		// List<Option>>();
		//
		// mapa2.put("Recursos", recursos);
		// salida.add(mapa2);
		return salida;
	}

	@RequestMapping(value = "/comboSalas2", method = RequestMethod.GET)
	public @ResponseBody
	List<Option> comboSalas2(
			@RequestParam(value = "departamentos", required = true) int departamento,
			Model model, Locale local) {
		ConsultasController.logger.info("[GET - View] : consultasSalas");

		List<Option> salas = this.salasService
				.salasPorDepartamento(departamento);
		return salas;
	}

	@RequestMapping(value = "/estadisticaMensual", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<SalaEstadistica> estatisticaMensual(
			@RequestParam(value = "departamento", required = false) Integer departamento,
			@RequestParam(value = "sitio", required = false) Integer sitio,
			@RequestParam(value = "sala", required = false) Integer sala,
			@RequestParam(value = "fecha", required = false) Integer anio,
			Locale local) {
		return estadisticasService.estadisticasMensuales(sala, sitio,
				departamento, anio);

	}

	@RequestMapping(value = "/estadisticaAnual", method = RequestMethod.POST)
	public @ResponseBody
	ArrayList<SalaEstadistica> estatisticAnual(
			@RequestParam(value = "departamento", required = false) Integer departamento,
			@RequestParam(value = "sitio", required = false) Integer sitio,
			@RequestParam(value = "sala", required = false) Integer sala,
			Locale local) {
		return estadisticasService.estadisticasAnuales(sala, sitio,
				departamento);

	}

	@RequestMapping(value = "/formularioListado", method = RequestMethod.GET)
	public String getFormListado(Model model) {
		ConsultasController.logger.info("[GET - View] : getFormEstadisticas");

		List<Option> ubicaciones = this.edificiosService.getListForOption(true,
				true);
		model.addAttribute("ubicaciones", ubicaciones);
		List<Option> ubicaciones2 = this.edificiosService.getListForOption(
				false, false);
		model.addAttribute("ubicacionesrec", ubicaciones2);
		/*
		 * List<Option> edificioses =
		 * this.edificiosService.obtenerComboListado(); List<Option>
		 * departamentoses = this.departamentosService .obtenerComboListado();
		 * edificioses.addAll(departamentoses);
		 * model.addAttribute("edificioslistadoesp", edificioses);
		 */
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		Aa00j16s00 aa00j16s00 = new Aa00j16s00();
		aa00j16s00.setSit16("A");
		List<Aa00j16s00> list = listadosGestService.findAll(aa00j16s00, null);
		model.addAttribute("listados", list);
		return "formulariolistado";
	}

	@RequestMapping(value = "/listadoSalas", method = RequestMethod.POST)
	public String listadoSalas(
			@RequestParam int orden,
			@RequestParam(value = "departamental") int departamental,
			@RequestParam(value = "aa00j07s01ByCdep20.cdep07", required = false) Integer departamento,
			@RequestParam(value = "aa00j03s01.cedif03", required = false) Integer edificio,
			@RequestParam(value = "salas1", required = false) Integer sala1,
			@RequestParam(value = "salas2", required = false) Integer sala2,
			@RequestParam(value = "dia1", required = false) String dia,
			@RequestParam(value = "dia2", required = false) String dia2,
			@RequestParam(value = "nuevos", required = false) Integer nuevos,
			Model model, Locale local) {
		SimpleDateFormat sdf;

		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");

		Date fecha1 = null, fecha2 = null;

		try {
			fecha1 = sdf.parse(dia);
			fecha2 = sdf.parse(dia2);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fecha1 = null;
			fecha2 = null;
		}
		Integer sala;
		if (departamental == 0)
			sala = sala1;
		else
			sala = sala2;
		model.addAttribute("modo", 1);
		boolean n;
		if (nuevos == 1)
			n = true;
		else
			n = false;
		model.addAttribute("listado", listadosService.listadoSalas(orden,
				departamental, edificio, departamento, sala, fecha1, fecha2, n));
		if (orden == aa00jConstantes.ORDENFECHAS)
			return "listadosalasporfecha";
		else
			return "listadosalasporsala";

	}

	@RequestMapping(value = "/listadoRecursos", method = RequestMethod.POST)
	public String listadoRecursos(
			@RequestParam int orden,

			@RequestParam(value = "aa00j13s01.aa00j03s01.cedif03", required = false) Integer edificio,
			@RequestParam(value = "recurso", required = false) Integer recurso,
			@RequestParam(value = "dia1", required = false) String dia,
			@RequestParam(value = "dia2", required = false) String dia2,
			Model model, Locale local) {
		SimpleDateFormat sdf;

		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");

		Date fecha1 = null, fecha2 = null;

		try {
			fecha1 = sdf.parse(dia);
			fecha2 = sdf.parse(dia2);

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fecha1 = null;
			fecha2 = null;
		}
		model.addAttribute("modo", 2);
		model.addAttribute("listado", listadosService.listadoRecursos(orden,
				edificio, recurso, fecha1, fecha2));
		if (orden == aa00jConstantes.ORDENFECHAS)
			return "listadosalasporfecha";
		else
			return "listadosalasporsala";

	}

	@RequestMapping(value = "/listadoIvap", method = RequestMethod.POST)
	public String listadoSalas(
			@RequestParam(value = "dia1", required = false) String date,
			@RequestParam(value = "tipoform", required = false) String tipoform,
			Model model, Locale local) {
		int sala = 0;
		char tipo;
		char tipo2;
		Date fecha1 = null;
		String salida = "";
		SimpleDateFormat sdf;
		String nombreSala = "";
		boolean esListadoDepartamento = false;
		try {
			sala = Integer.parseInt(tipoform.substring(1, tipoform.length()));
			tipo = tipoform.charAt(0);
			tipo2 = tipoform.charAt(1);
			if (aa00jConstantes.LISTADOIVAP == tipo) {
				salida = "IVAP";
				esListadoDepartamento = true;
				nombreSala = "Ivap";
			} else if (aa00jConstantes.LISTADOLAKUA == tipo && tipo2 == '1') {
				salida = "LAKUA";
				esListadoDepartamento = false;
				nombreSala = "Lakua";
			} else if (aa00jConstantes.LISTADOLAKUA == tipo && tipo2 != '1') {
				salida = "LAKUA";
				esListadoDepartamento = false;
				nombreSala = "Gran Vía";
			}

			if (local.getLanguage().contains("eu"))
				sdf = new SimpleDateFormat("yyyy/MM/dd");
			else
				sdf = new SimpleDateFormat("dd/MM/yyyy");
			fecha1 = sdf.parse(date);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();

		}
		model.addAttribute("listado", listadosService.listadoSalas(sala,
				fecha1, esListadoDepartamento));

		Calendar cal = Calendar.getInstance();
		cal.setTime(fecha1);

		model.addAttribute("dia", cal.get(Calendar.DAY_OF_MONTH));

		model.addAttribute("mes", cal.get(Calendar.MONTH));
		sdf = new SimpleDateFormat("yyyy/MM/dd");
		model.addAttribute("fechaeusk", sdf.format(fecha1));
		sdf = new SimpleDateFormat("dd/MM/yyyy");
		model.addAttribute("fechacast", sdf.format(fecha1));
		model.addAttribute("nombreSala", nombreSala);
		return salida;
	}

	@RequestMapping(value = "/listadoGestionado", method = RequestMethod.POST)
	public String listadosGetionados(
			@RequestParam(value = "dia1", required = false) String date,
			@RequestParam(value = "tipoform", required = false) int tipoform,
			Model model, Locale local) {

		Date fecha1 = null;
		String salida = "";
		SimpleDateFormat sdf;
		String nombreC = "";
		String nombreE = "";

		try {

			Aa00j16s00 elem = new Aa00j16s00();
			elem.setId16(new BigDecimal(Integer.parseInt("" + tipoform)));
			elem = listadosGestService.find(elem);
			nombreC = elem.getTitc16();
			nombreE = elem.getTite16();
			if (aa00jConstantes.TIPOINFORMEIVAP.equals("" + elem.getTipo16())) {
				salida = "IVAPPDF";

			} else if (aa00jConstantes.TIPOINFORMELAKUA.equals(""
					+ elem.getTipo16())) {
				salida = "LAKUAPDF";

			}

			if (local.getLanguage().contains("eu"))
				sdf = new SimpleDateFormat("yyyy/MM/dd");
			else
				sdf = new SimpleDateFormat("dd/MM/yyyy");
			fecha1 = sdf.parse(date);

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();

		}
		model.addAttribute("datos",
				listadosService.listadoSalas(tipoform, fecha1));

		Calendar cal = Calendar.getInstance();
		cal.setTime(fecha1);

		ArrayList<String> cabecera = new ArrayList<String>();
		cabecera.add("" + cal.get(Calendar.DAY_OF_MONTH));
		cabecera.add("" + cal.get(Calendar.MONTH));
		sdf = new SimpleDateFormat("yyyy/MM/dd");
		cabecera.add("" + sdf.format(fecha1));
		sdf = new SimpleDateFormat("dd/MM/yyyy");
		cabecera.add("" + sdf.format(fecha1));
		cabecera.add("" + nombreC);
		cabecera.add("" + nombreE);
		model.addAttribute("datosCabecera", cabecera);
		return salida;
	}

	/**
	 * Metodo de presentacion de la tabla de ocupaciones.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/calendario", method = RequestMethod.GET)
	public String getCalendario(Model model) {
		ConsultasController.logger.info("[GET - View] : panel de ocupación");
		List<Option> ubicaciones = this.edificiosService.getListForOption(true,
				false);
		model.addAttribute("ubicaciones", ubicaciones);
		return "calendario";
	}

}
