package com.ejie.aa00j.control;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.aa00j.model.forms.FormBloqueo;
import com.ejie.aa00j.service.Aa00jDesbloqueosTablasService;

/**
 * Aa00jDesbloqueosTablasDetalleController generated by VDIAZSAN, 19-mar-2014
 * 15:50
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/desbloqueosTablasDetalle")
public class Aa00jDesbloqueosTablasDetalleController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00jDesbloqueosTablasController.class);

	@Autowired
	private Aa00jDesbloqueosTablasService aa00jDesbloqueosTablasService;

	@Autowired(required = false)
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ModelAndView
	 */
	@RequestMapping(value = "mantDesbloqueosDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		logger.info("[GET - jqGrid] : Obtener Detalle desbloqueo tablas ");

		model.addAttribute("defaultLanguage", this.appConfiguration
				.get("aa00jOrgDocumentalWar.default.language"));
		model.addAttribute("defaultLayout", this.appConfiguration
				.get("aa00jOrgDocumentalWar.default.language"));
		model.addAttribute("tablaID", request.getParameter("tablaID"));
		model.addAttribute("bloqueoID", request.getParameter("bloqueoID"));

		return new ModelAndView("detalleDesbloqueoTabla", "model", model);

	}

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param tabla97
	 *            String
	 * @return Aa00j98s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{tabla97}/{bloqueo}", method = RequestMethod.GET)
	public String get(@PathVariable String tabla97,
			@PathVariable String bloqueo, Model model) {
		logger.info("Devuelve el listado de tablas");
		String campobloqueo = bloqueo;

		model.addAttribute("registros", this.aa00jDesbloqueosTablasService
				.obtenerRegistrosBloqueados(tabla97, campobloqueo));
		return "detalleDesbloqueoTabla";

	}

	@RequestMapping(value = "desbloquearRegistro", method = RequestMethod.POST)
	public @ResponseBody
	int desploquearRegistro(@RequestBody FormBloqueo frm) {

		return this.aa00jDesbloqueosTablasService.desbloquearRegistro(
				frm.getTabla(), frm.getCampos(), frm.getValores(),
				frm.getCampoBloqueo());
	}

	@RequestMapping(value = "desbloquearTabla", method = RequestMethod.POST)
	public @ResponseBody
	int desploquearTabla(@RequestBody FormBloqueo frm) {

		return this.aa00jDesbloqueosTablasService.desbloquearRegistro(
				frm.getTabla(), null, null, frm.getCampoBloqueo());
	}
}