package com.ejie.aa00j.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa00j.model.Aa00j97s01;
import com.ejie.aa00j.service.Aa00jDesbloqueosTablasService;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;

/**
 * Aa00jDesbloqueosTablasController generated by VDIAZSAN, 18-mar-2014 12:21
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/desbloqueosTablas")
public class Aa00jDesbloqueosTablasController {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00jDesbloqueosTablasController.class);

	@Autowired
	private Aa00jDesbloqueosTablasService aa00jDesbloqueosTablasService;

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param tabla97
	 *            String
	 * @return Aa00j97s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{tabla97}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j97s01 get(@PathVariable String tabla97) {
		Aa00j97s01 aa00j97s01 = new Aa00j97s01();
		aa00j97s01.setTabla97(tabla97);
		aa00j97s01 = this.aa00jDesbloqueosTablasService.find(aa00j97s01);
		Aa00jDesbloqueosTablasController.logger
				.info("[GET - findBy_PK] : Obtener Aa00j97s01 por PK");
		return aa00j97s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00jDesbloqueosTablasController.logger
				.info("[GET - View] : desbloqueosTablas");
		return "desbloqueosTablas";
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j97s01
	 *            Aa00j97s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j97s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j97s01> getAll(@ModelAttribute Aa00j97s01 filterAa00j97s01) {
		Aa00jDesbloqueosTablasController.logger
				.info("[GET - find_ALL] : Obtener Aa00j97s01 por filtro");
		return this.aa00jDesbloqueosTablasService.findAll(filterAa00j97s01,
				null);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j97s01
	 *            Aa00j12s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j97s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j97s01> filter(
			@RequestJsonBody(param = "filter") Aa00j97s01 filterAa00j97s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00jDesbloqueosTablasController.logger
				.info("[POST - filter] : Obtener Aa00j12s01s");
		return this.aa00jDesbloqueosTablasService.filter(filterAa00j97s01,
				jqGridRequestDto, false);
	}

	/**
	 * Method 'getAutocompleteNombreTablas'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa00j97s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTablaCas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j97s01> getAutocompleteNombreTablasCas(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa00j97s01 aa00j97s01 = new Aa00j97s01();

		aa00j97s01.setDesc97(q);

		return this.aa00jDesbloqueosTablasService.findTabla(aa00j97s01, c);

	}

	/**
	 * Method 'getAutocompleteNombreTablas'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            Boolean
	 * 
	 * @return List<Aa00j97s01>
	 */
	@RequestMapping(value = "/autocompleteDenoTablaEusk", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j97s01> getAutocompleteNombreTablasEusk(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		Aa00j97s01 aa00j97s01 = new Aa00j97s01();

		aa00j97s01.setDese97(q);

		return this.aa00jDesbloqueosTablasService.findTabla(aa00j97s01, c);

	}

}