package com.ejie.aa00j.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.aa00j.service.Aa00j03s01Service;
import com.ejie.aa00j.service.Aa00j07s01Service;
import com.ejie.aa00j.service.Aa00j30s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j30s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j30s01")
public class Aa00j30s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j30s01Controller.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa00j30s01Service aa00j30s01Service;
	@Autowired
	private Aa00j03s01Service edificiosService;
	@Autowired
	private Aa00j07s01Service departamentosService;

	// @Autowired
	// private Aa00j13s01Service aa00j13s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cod30
	 *            Long
	 * @return Aa00j30s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cod30}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j30s01 get(@PathVariable Long cod30) {
		Aa00j30s01 aa00j30s01 = new Aa00j30s01();
		aa00j30s01.setCod30(cod30);
		aa00j30s01 = this.aa00j30s01Service.find(aa00j30s01);
		Aa00j30s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j30s01 por PK");
		return aa00j30s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j30s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j30s01> getAll(@ModelAttribute Aa00j30s01 filterAa00j30s01) {
		Aa00j30s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j30s01 por filtro");
		return this.aa00j30s01Service.findAll(filterAa00j30s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j30s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j30s01 edit(@RequestBody Aa00j30s01 aa00j30s01) {
		Aa00j30s01 aa00j30s01Aux = this.aa00j30s01Service.update(aa00j30s01);
		Aa00j30s01Controller.logger
				.info("[PUT] : Aa00j30s01 actualizado correctamente");
		return aa00j30s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j30s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j30s01 add(@RequestBody Aa00j30s01 aa00j30s01) {
		Aa00j30s01 aa00j30s01Aux = this.aa00j30s01Service.add(aa00j30s01);
		Aa00j30s01Controller.logger
				.info("[POST] : Aa00j30s01 insertado correctamente");
		return aa00j30s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cod30
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j30s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{cod30}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j30s01 remove(@PathVariable Long cod30) {
		Aa00j30s01 aa00j30s01 = new Aa00j30s01();
		aa00j30s01.setCod30(cod30);
		this.aa00j30s01Service.remove(aa00j30s01);
		Aa00j30s01Controller.logger
				.info("[DELETE] : Aa00j30s01 borrado correctamente");
		return aa00j30s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j30s01Controller.logger.info("[GET - View] : aa00j30s01");

		return "aa00j30s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j30s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j30s01> filter(
			@RequestJsonBody(param = "filter") Aa00j30s01 filterAa00j30s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j30s01s");
		return this.aa00j30s01Service.filter(filterAa00j30s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j30s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j30s01>> search(
			@RequestJsonBody(param = "filter") Aa00j30s01 filterAa00j30s01,
			@RequestJsonBody(param = "search") Aa00j30s01 searchAa00j30s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01Controller.logger
				.info("[POST - search] : Buscar Aa00j30s01s");
		return this.aa00j30s01Service.search(filterAa00j30s01,
				searchAa00j30s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j30s01 filterAa00j30s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j30s01s");
		this.aa00j30s01Service.removeMultiple(filterAa00j30s01,
				jqGridRequestDto, false);
		Aa00j30s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j30s01 filterAa00j30s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j30s01s jerarquia");
		return this.aa00j30s01Service.jerarquia(filterAa00j30s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j30s01 filterAa00j30s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j30s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j30s01s jerarquia - Hijos");
		return this.aa00j30s01Service.jerarquiaChildren(filterAa00j30s01,
				jqGridRequestDto);
	}

	@RequestMapping(value = "/nuevaReserva", method = RequestMethod.GET)
	public String getFormNuevaReserva(Model model) {
		Aa00j30s01Controller.logger.info("[GET - View] : aa00j30s01");
		model.addAttribute("edificios", edificiosService.obtenerCombo());

		model.addAttribute("departamentos",
				this.departamentosService.obtenerCombo());
		return "reservarrecurso";
	}

	@RequestMapping(value = "/guardarReserva", method = RequestMethod.POST)
	public @ResponseBody
	Aa00j30s01 guardarReserva(@RequestBody Aa00j30s01 aa00j30s01) {
		try {

			Aa00j30s01Controller.logger
					.info("[POST] : Aa00j30s01 INI: guardarReserva");

			aa00j30s01 = this.aa00j30s01Service.guardarReserva(aa00j30s01);

			Aa00j30s01Controller.logger
					.info("[POST] : Aa00j30s01 insertado correctamente");

			return aa00j30s01;

		} catch (Throwable e) {
			Aa00j30s01Controller.logger
					.error("[POST] : Aa00j30s01 error al reservar recurso (guardarReserva): "
							+ e.getMessage());
			if (aa00j30s01.getPantallaMensajeError() == null) {
				aa00j30s01.setPantallaMensajeError(this.appMessageSource
						.getMessage("etErrorAlReservarRecurso", null,
								LocaleContextHolder.getLocale()));
			}
			return aa00j30s01;
		}
	}

	@RequestMapping(value = "/modificarReserva", method = RequestMethod.GET)
	public String getFormModificarReserva(Model model) {
		Aa00j30s01Controller.logger.info("[GET - View] : aa00j30s01");
		model.addAttribute("edificios", edificiosService.obtenerCombo());
		model.addAttribute("departamentos",
				this.departamentosService.obtenerCombo());
		return "modificarreservarecurso";
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cod30
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cod30}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long cod30) {

		return this.aa00j30s01Service.bloquear(cod30);
	}

	/**
	 * Method 'bloquearSiAlta'.
	 * 
	 * @param cod30
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquearSiAlta/{cod30}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquearSiAlta(@PathVariable Long cod30) {

		return this.aa00j30s01Service.bloquearSiAlta(cod30);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cod30
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cod30}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long cod30) {

		return this.aa00j30s01Service.desbloquear(cod30);
	}

	@RequestMapping(value = "/anular", method = RequestMethod.POST)
	public @ResponseBody
	String[] anular(
			@RequestJsonBody(param = "codigosReservas") List<String> codigosReservas) {

		return this.aa00j30s01Service.anular(codigosReservas);
	}

	/**
	 * Devuelve una los datos de las reservas del recurso de entrada en la fecha
	 * de entrada
	 * 
	 * @param sala
	 * @param dias
	 * @param local
	 * @return
	 */
	@RequestMapping(value = "/ocupacionesRecursos", method = RequestMethod.POST)
	public @ResponseBody
	List<Aa00j30s01> obtenerOcupacionesRecursoFechas(@RequestParam String sala,
			@RequestParam String dias, Locale local) {

		String[] diasarray = dias.split(",");
		ArrayList<Date> fechas = new ArrayList<Date>();

		SimpleDateFormat sdf;
		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");

		for (String current : diasarray) {

			try {
				fechas.add(sdf.parse(current));
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return this.aa00j30s01Service.obtenerOcupacionesRecursosFechas(
				Long.parseLong(sala), fechas);

	}
}