package com.ejie.aa00j.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormSala;
import com.ejie.aa00j.service.Aa00j03s01Service;
import com.ejie.aa00j.service.Aa00j07s01Service;
import com.ejie.aa00j.service.Aa00j10s01Service;
import com.ejie.aa00j.service.Aa00j20s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j20s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j20s01")
public class Aa00j20s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j20s01Controller.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa00j10s01Service aa00j10s01Service;

	@Autowired
	private Aa00j20s01Service aa00j20s01Service;
	@Autowired
	private Aa00j07s01Service departamentosService;
	@Autowired
	private Aa00j03s01Service edificiosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cod20
	 *            Long
	 * @return Aa00j20s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cod20}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j20s01 get(@PathVariable Long cod20) {
		Aa00j20s01 aa00j20s01 = new Aa00j20s01();
		aa00j20s01.setCod20(cod20);
		aa00j20s01 = this.aa00j20s01Service.find(aa00j20s01);
		Aa00j20s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j20s01 por PK");
		return aa00j20s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j20s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j20s01> getAll(@ModelAttribute Aa00j20s01 filterAa00j20s01) {
		Aa00j20s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j20s01 por filtro");
		return this.aa00j20s01Service.findAll(filterAa00j20s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j20s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j20s01 edit(@RequestBody Aa00j20s01 aa00j20s01) {
		Aa00j20s01 aa00j20s01Aux = this.aa00j20s01Service.update(aa00j20s01);
		Aa00j20s01Controller.logger
				.info("[PUT] : Aa00j20s01 actualizado correctamente");
		return aa00j20s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j20s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j20s01 add(@RequestBody Aa00j20s01 aa00j20s01) {
		Aa00j20s01 aa00j20s01Aux = this.aa00j20s01Service.add(aa00j20s01);
		Aa00j20s01Controller.logger
				.info("[POST] : Aa00j20s01 insertado correctamente");
		return aa00j20s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cod20
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j20s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{cod20}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j20s01 remove(@PathVariable Long cod20) {
		Aa00j20s01 aa00j20s01 = new Aa00j20s01();
		aa00j20s01.setCod20(cod20);
		this.aa00j20s01Service.remove(aa00j20s01);
		Aa00j20s01Controller.logger
				.info("[DELETE] : Aa00j20s01 borrado correctamente");
		return aa00j20s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j20s01Controller.logger.info("[GET - View] : aa00j20s01");
		return "aa00j20s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j20s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j20s01> filter(
			@RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto, Locale locale) {
		Aa00j20s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j20s01s");
		return this.aa00j20s01Service.filter(filterAa00j20s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j20s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j20s01>> search(
			@RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
			@RequestJsonBody(param = "search") Aa00j20s01 searchAa00j20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01Controller.logger
				.info("[POST - search] : Buscar Aa00j20s01s");
		return this.aa00j20s01Service.search(filterAa00j20s01,
				searchAa00j20s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j20s01s");
		this.aa00j20s01Service.removeMultiple(filterAa00j20s01,
				jqGridRequestDto, false);
		Aa00j20s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j20s01s jerarquia");
		return this.aa00j20s01Service.jerarquia(filterAa00j20s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j20s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j20s01s jerarquia - Hijos");
		return this.aa00j20s01Service.jerarquiaChildren(filterAa00j20s01,
				jqGridRequestDto);
	}

	/**
	 * Method 'unBind' Aa00j21s01
	 * 
	 * @param cod20
	 *            Long
	 * @param aa00j12s01Cmedf12
	 *            Long
	 */
	@RequestMapping(value = "/unbindAa00j21s01", method = RequestMethod.POST)
	public void unBindAa00j21s01(
			@RequestParam(value = "cod20", required = false) Long cod20,
			@RequestParam(value = "aa00j12s01Cmedf12", required = false) Long aa00j12s01Cmedf12) {
		Aa00j20s01 aa00j20s01 = new Aa00j20s01();
		Aa00j12s01 aa00j12s01 = new Aa00j12s01();
		if (cod20 != null) {
			aa00j20s01.setCod20(cod20);
		}
		if (aa00j12s01Cmedf12 != null) {
			aa00j12s01.setCmedf12(aa00j12s01Cmedf12);
		}
		aa00j20s01.getAa00j12s01s().add(aa00j12s01);
		this.aa00j20s01Service.removeAa00j21s01(aa00j20s01);
	}

	/**
	 * Method 'bind' Aa00j21s01
	 * 
	 * @param cod20
	 *            Long
	 * @param aa00j12s01Cmedf12
	 *            Long
	 */
	@RequestMapping(value = "/bindAa00j21s01", method = RequestMethod.POST)
	public void bindAa00j21s01(
			@RequestParam(value = "cod20", required = false) Long cod20,
			@RequestParam(value = "aa00j12s01Cmedf12", required = false) Long aa00j12s01Cmedf12) {
		Aa00j20s01 aa00j20s01 = new Aa00j20s01();
		Aa00j12s01 aa00j12s01 = new Aa00j12s01();
		if (cod20 != null) {
			aa00j20s01.setCod20(cod20);
		}
		if (aa00j12s01Cmedf12 != null) {
			aa00j12s01.setCmedf12(aa00j12s01Cmedf12);
		}
		aa00j20s01.getAa00j12s01s().add(aa00j12s01);
		this.aa00j20s01Service.addAa00j21s01(aa00j20s01);
	}

	@RequestMapping(value = "/nuevaReserva", method = RequestMethod.GET)
	public String getFormNuevaReserva(Model model) {
		Aa00j20s01Controller.logger.info("[GET - View] : aa00j20s01");
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		List<Aa00j07s01> departamentosall = this.departamentosService
				.obtenerCombo();
		model.addAttribute("departamentosall", departamentosall);
		List<Option> edificios = this.edificiosService.getListForOption(false,
				false);
		model.addAttribute("edificios", edificios);
		// aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		// model.addAttribute("telefono", ps.getPersonaXLNET().getTelefono());
		return "reservarsala";
	}

	/**
	 * Añadida por Iker Desde la búsqueda asistida, a seleccionado valores, le
	 * han aparecido salas y quiere reservar una Recibe un formulario con el
	 * codigo de sala, días seleccionados y horas seleecionadas, y las precarga
	 * en el jsp
	 * 
	 * @param edificio
	 * @param sala
	 * @param dias
	 * @param horaInicio
	 * @param horaFin
	 * @param model
	 * @return
	 */
	@RequestMapping(value = "/nuevaReserva", method = RequestMethod.POST)
	public String getFormNuevaReservaPost(@RequestParam String edificio,
			@RequestParam String sala, @RequestParam String dias,
			@RequestParam String horaInicio, @RequestParam String horaFinal,

			Model model) {

		Aa00j20s01Controller.logger.info("[GET - View] : aa00j20s01");
		Aa00j10s01 aa00j10s01 = null;
		aa00j10s01 = this.aa00j10s01Service.find(new Aa00j10s01(Long
				.parseLong(sala)));
		model.addAttribute("edificio", aa00j10s01.getAa00j03s01().getCedif03());
		if (aa00j10s01.getAa00j07s01() != null
				&& aa00j10s01.getAa00j07s01().getDescc07() != null
				&& aa00j10s01.getAa00j07s01().getDescc07().length() > 0)
			model.addAttribute("departamento", aa00j10s01.getAa00j07s01()
					.getCdep07());
		else
			model.addAttribute("departamento", -1);
		model.addAttribute("sala", sala);
		model.addAttribute("dias", dias);
		model.addAttribute("horaInicio", horaInicio);
		model.addAttribute("horaFin", horaFinal);
		return this.getFormNuevaReserva(model);
	}

	@RequestMapping(value = "/comprobarAsistentesCapacidad", method = RequestMethod.POST)
	public String comprobarAsistentesCapacidad(
			@RequestParam(value = "codSala", required = true) Long codSala,
			@RequestParam(value = "numAsistentes", required = false) Long numAsistentes) {

		StringBuffer ret = new StringBuffer();
		String strRetorno = "";

		Aa00j10s01 aa00j10s01 = this.aa00j10s01Service.find(new Aa00j10s01(
				codSala));
		if (aa00j10s01 != null) {
			if (aa00j10s01.getNcap10() < numAsistentes) {
				ret.append(this.appMessageSource.getMessage(
						"etErrorAsistentesCapacidad", null,
						LocaleContextHolder.getLocale()));
				strRetorno = ret.toString().replace(":?",
						aa00j10s01.getNcap10().toString());
			}
		}

		return strRetorno;
	}

	@RequestMapping(value = "/guardarReserva", method = RequestMethod.POST)
	public @ResponseBody
	Aa00j20s01 guardarReserva(@RequestBody Aa00j20s01 aa00j20s01) {
		try {

			Aa00j20s01Controller.logger
					.info("[POST] : Aa00j20s01 INI: guardarReserva");
			// Iker
			// Se relelnan los campos de la sala necesarios para buscar los
			// datos en la tabla 15 de horarios edificios
			aa00j20s01.setAa00j10s01(this.aa00j10s01Service.find(aa00j20s01
					.getAa00j10s01()));
			aa00j20s01 = this.aa00j20s01Service.guardarReserva(aa00j20s01);

			Aa00j20s01Controller.logger
					.info("[POST] : Aa00j20s01 insertado correctamente");

			return aa00j20s01;

		} catch (Throwable e) {
			Aa00j20s01Controller.logger
					.error("[POST] : Aa00j20s01 error al reservar sala (guardarReserva): "
							+ e.getMessage());
			if (aa00j20s01.getPantallaMensajeError() == null) {
				aa00j20s01.setPantallaMensajeError(this.appMessageSource
						.getMessage("etErrorAlReservarSala", null,
								LocaleContextHolder.getLocale()));
			}
			return aa00j20s01;
		}
	}

	@RequestMapping(value = "/modificarReserva", method = RequestMethod.GET)
	public String getFormModificarReserva(Model model) {
		Aa00j20s01Controller.logger.info("[GET - View] : aa00j20s01");
		List<Aa00j07s01> departamentos = this.departamentosService
				.obtenerComboControlado();
		model.addAttribute("departamentos", departamentos);
		List<Aa00j07s01> departamentosall = this.departamentosService
				.obtenerCombo();
		model.addAttribute("departamentosall", departamentosall);
		List<Option> edificios = this.edificiosService.getListForOption(false,
				false);
		model.addAttribute("edificios", edificios);
		return "modificarreservasala";
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cod20
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cod20}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long cod20) {

		return this.aa00j20s01Service.bloquear(cod20);
	}

	/**
	 * Method 'bloquearSiAlta'.
	 * 
	 * @param cod20
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquearSiAlta/{cod20}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquearSiAlta(@PathVariable Long cod20) {

		return this.aa00j20s01Service.bloquearSiAlta(cod20);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cod20
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cod20}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long cod20) {

		return this.aa00j20s01Service.desbloquear(cod20);
	}

	@RequestMapping(value = "/anular", method = RequestMethod.POST)
	public @ResponseBody
	String[] anular(
			@RequestJsonBody(param = "codigosReservas") List<String> codigosReservas) {

		return this.aa00j20s01Service.anular(codigosReservas);
	}

	@RequestMapping(value = "/borrar", method = RequestMethod.POST)
	public @ResponseBody
	String[] borrar(
			@RequestJsonBody(param = "codigosReservas") List<String> codigosReservas) {

		return this.aa00j20s01Service.borrar(codigosReservas);
	}

	@RequestMapping(value = "/confirmar", method = RequestMethod.POST)
	public @ResponseBody
	String[] confirmar(
			@RequestJsonBody(param = "codigosReservas") List<String> codigosReservas) {

		return this.aa00j20s01Service.confirmar(codigosReservas);
	}

	@RequestMapping(value = "/ocupacionesSala", method = RequestMethod.POST)
	public @ResponseBody
	List<Aa00j20s01> obtenerOcupacionesSalaFechas(@RequestParam String sala,
			@RequestParam String departamento, @RequestParam String edificio,
			@RequestParam String dias, Locale local) {

		String[] diasarray = dias.split(",");
		ArrayList<Date> fechas = new ArrayList<Date>();

		SimpleDateFormat sdf;
		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");

		for (String current : diasarray) {

			try {
				if (current != null && current.length() > 0)
					fechas.add(sdf.parse(current));
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return this.aa00j20s01Service.obtenerOcupacionesSalaFechas(
				Long.parseLong(sala), Long.parseLong(departamento),
				Long.parseLong(edificio), fechas);

	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	@RequestMapping(value = "/sinConfirmar", method = RequestMethod.POST)
	// public @ResponseBody
	// JQGridResponseDto<Aa00j20s01> filter(
	// @RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
	// // @RequestJsonBody JQGridRequestDto jqGridRequestDto)
	public @ResponseBody
	JQGridResponseDto<Aa00j20s01> obtenerOcupacionesSinConfirmar(
			@RequestJsonBody(param = "filter") FormSala form, Model model,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto, Locale local) {
		Integer sala;
		if (form.getDepartamentos() != -1 && form.getSala2() != null)
			sala = Integer.parseInt(form.getSala2());
		else if (form.getDepartamentos() == -1 && form.getSala1() != null) {
			if (form.getSala1().equals("-1"))
				sala = -1;
			else
				sala = Integer.parseInt(form.getSala1().substring(1,
						form.getSala1().length()));
		} else {
			sala = -1;
		}
		SimpleDateFormat sdf;
		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");
		ArrayList<Date> dates = new ArrayList<Date>();
		if (form.getDias() != null) {
			String[] dias = form.getDias().split(",");
			for (String date : dias) {

				try {
					dates.add(sdf.parse(date));
				} catch (ParseException e) {

					// TODO Auto-generated catch block
					e.printStackTrace();
					dates.add(null);
				}
			}
		}
		return this.aa00j20s01Service.obtenerOcupacionesSinConfirmar(dates,
				sala, form.getDepartamentos(), form.getSitios(),
				jqGridRequestDto);
	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	@RequestMapping(value = "/anuladas", method = RequestMethod.POST)
	// public @ResponseBody
	// JQGridResponseDto<Aa00j20s01> filter(
	// @RequestJsonBody(param = "filter") Aa00j20s01 filterAa00j20s01,
	// // @RequestJsonBody JQGridRequestDto jqGridRequestDto)
	public @ResponseBody
	JQGridResponseDto<Aa00j20s01> obtenerAnuladas(
			@RequestJsonBody(param = "filter") FormSala form, Model model,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto, Locale local) {
		Integer sala;
		if (form.getDepartamentos() != -1 && form.getSala2() != null)
			sala = Integer.parseInt(form.getSala2());
		else if (form.getDepartamentos() == -1 && form.getSala1() != null) {
			if (form.getSala1().equals("-1"))
				sala = -1;
			else
				sala = Integer.parseInt(form.getSala1().substring(1,
						form.getSala1().length()));
		} else {
			sala = -1;
		}
		SimpleDateFormat sdf;
		if (local.getLanguage().contains("eu"))
			sdf = new SimpleDateFormat("yyyy/MM/dd");
		else
			sdf = new SimpleDateFormat("dd/MM/yyyy");
		ArrayList<Date> dates = new ArrayList<Date>();
		if (form.getDias() != null) {
			String[] dias = form.getDias().split(",");
			for (String date : dias) {

				try {
					dates.add(sdf.parse(date));
				} catch (ParseException e) {

					// TODO Auto-generated catch block
					e.printStackTrace();
					dates.add(null);
				}
			}
		}
		return this.aa00j20s01Service.obtenerOcupacionesAnuladas(dates, sala,
				form.getDepartamentos(), form.getSitios(), jqGridRequestDto);
	}
}