package com.ejie.aa00j.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j16s00;
import com.ejie.aa00j.service.Aa00j10s01Service;
import com.ejie.aa00j.service.Aa00j16s00Service;
import com.ejie.aa00j.service.Aa00j17s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j16s00Controller generated by UDA, 04-jun-2014 11:18:47.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j16s01")
public class Aa00j16s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j16s01Controller.class);

	@Autowired
	private Aa00j16s00Service listadosService;
	@Autowired
	private Aa00j10s01Service salasService;
	@Autowired
	private Aa00j17s01Service salasListadoService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param id16
	 *            BigDecimal
	 * @return Aa00j16s00 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{id16}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j16s00 get(@PathVariable BigDecimal id16) {
		Aa00j16s00 aa00j16s00 = new Aa00j16s00();
		aa00j16s00.setId16(id16);
		aa00j16s00 = this.listadosService.find(aa00j16s00);
		Aa00j16s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j16s00 por PK");
		return aa00j16s00;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j16s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j16s00> getAll(@ModelAttribute Aa00j16s00 filterAa00j16s00) {
		Aa00j16s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j16s00 por filtro");
		return this.listadosService.findAll(filterAa00j16s00, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00 Bean que contiene la informacion a modificar.
	 * @return Aa00j16s00 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j16s00 edit(@RequestBody Aa00j16s00 aa00j16s00) {
		Aa00j16s00 aa00j16s00Aux = this.listadosService.update(aa00j16s00);
		Aa00j16s01Controller.logger
				.info("[PUT] : Aa00j16s00 actualizado correctamente");
		return aa00j16s00Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j16s00
	 *            Aa00j16s00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j16s00 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j16s00 add(@RequestBody Aa00j16s00 aa00j16s00) {
		Aa00j16s00 aa00j16s00Aux = this.listadosService.add(aa00j16s00);
		Aa00j16s01Controller.logger
				.info("[POST] : Aa00j16s00 insertado correctamente");
		return aa00j16s00Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param id16
	 *            BigDecimal Identificador del objeto que se desea eliminar.
	 * @return Aa00j16s00 Bean eliminado.
	 */
	@RequestMapping(value = "/{id16}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j16s00 remove(@PathVariable BigDecimal id16) {
		Aa00j16s00 aa00j16s00 = new Aa00j16s00();
		aa00j16s00.setId16(id16);
		this.listadosService.remove(aa00j16s00);
		Aa00j16s01Controller.logger
				.info("[DELETE] : Aa00j16s00 borrado correctamente");
		return aa00j16s00;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j16s01Controller.logger.info("[GET - View] : aa00j16s00");
		model.addAttribute("SITUACION_ALTA", aa00jConstantes.SITUACION_ALTA);
		model.addAttribute("SITUACION_BAJA", aa00jConstantes.SITUACION_BAJA);
		model.addAttribute("SITUACION_TODAS", aa00jConstantes.SITUACION_TODAS);

		model.addAttribute("TIPOINFORMEIVAP", aa00jConstantes.TIPOINFORMEIVAP);
		model.addAttribute("TIPOINFORMELAKUA", aa00jConstantes.TIPOINFORMELAKUA);
		model.addAttribute("TIPOINFORMETODAS", aa00jConstantes.TIPOINFORMETODAS);

		return "aa00j16s00";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j16s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j16s00> filter(
			@RequestJsonBody(param = "filter") Aa00j16s00 filterAa00j16s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j16s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j16s00s");
		return this.listadosService.filter(filterAa00j16s00, jqGridRequestDto,
				false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j16s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j16s00>> search(
			@RequestJsonBody(param = "filter") Aa00j16s00 filterAa00j16s00,
			@RequestJsonBody(param = "search") Aa00j16s00 searchAa00j16s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j16s01Controller.logger
				.info("[POST - search] : Buscar Aa00j16s00s");
		return this.listadosService.search(filterAa00j16s00, searchAa00j16s00,
				jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j16s00 filterAa00j16s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j16s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j16s00s");
		this.listadosService.removeMultiple(filterAa00j16s00, jqGridRequestDto,
				false);
		Aa00j16s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j16s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j16s00>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j16s00 filterAa00j16s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j16s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j16s00s jerarquia");
		return this.listadosService.jerarquia(filterAa00j16s00,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j16s00
	 *            Aa00j16s00 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j16s00>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j16s00>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j16s00 filterAa00j16s00,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j16s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j16s00s jerarquia - Hijos");
		return this.listadosService.jerarquiaChildren(filterAa00j16s00,
				jqGridRequestDto);
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param csala10
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{listado}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long listado) {

		return this.listadosService.bloquear(listado);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param csala10
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{listado}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long listado) {

		return this.listadosService.desbloquear(listado);
	}

	@RequestMapping(value = "/salas/{id16}", method = RequestMethod.GET)
	public @ResponseBody
	ArrayList<Aa00j10s01> getSalas(@PathVariable BigDecimal id16) {
		Aa00j16s01Controller.logger
				.info("[GET - findBy_PK] : Obtener salas del listado por PK");
		return (ArrayList<Aa00j10s01>) this.salasService
				.obtenerSalasListado(id16.intValue());
	}

	@RequestMapping(value = "/nosalas/{id16}", method = RequestMethod.GET)
	public @ResponseBody
	ArrayList<Aa00j10s01> getNoSalas(@PathVariable BigDecimal id16) {
		Aa00j16s01Controller.logger
				.info("[GET - findBy_PK] : Obtener salas que no son del listado por PK");
		return (ArrayList<Aa00j10s01>) this.salasService
				.obtenerSalasNoListado(id16.intValue());
	}

	@RequestMapping(value = "/actualizar", method = RequestMethod.POST)
	public @ResponseBody
	boolean guardarSalas(@RequestJsonBody(param = "codigo") int codigo,
			@RequestJsonBody(param = "salas") int[] salas) {
		Aa00j16s01Controller.logger
				.info("[GET - findBy_PK] : actualizar salas del listado por PK");
		salasListadoService.addElements(codigo, salas);
		return true;
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "cambiarSituacion/{ids}", method = RequestMethod.POST)
	public @ResponseBody
	boolean cambiarSituacion(@PathVariable String ids) {
		return this.listadosService.cambiarSituacion(ids);
	}

}
