package com.ejie.aa00j.control;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.model.Aa00j15s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormCalendario;
import com.ejie.aa00j.service.Aa00j03s01Service;
import com.ejie.aa00j.service.Aa00j15s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j15s01Controller generated by UDA, 20-mar-2014 15:55:01.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j15s01")
public class Aa00j15s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j15s01Controller.class);

	@Autowired
	private Aa00j15s01Service calendarioEdificioService;
	@Autowired
	private Aa00j03s01Service edificiosService;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cedif15
	 *            Long
	 * @param fecha15
	 *            Long
	 * @return Aa00j15s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cedif15}/{fecha15}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j15s01 get(@PathVariable Long cedif15, @PathVariable Long fecha15) {
		Aa00j15s01 aa00j15s01 = new Aa00j15s01();
		aa00j15s01.setCedif15(cedif15);
		aa00j15s01.setFecha15(fecha15);
		aa00j15s01 = this.calendarioEdificioService.find(aa00j15s01);
		Aa00j15s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j15s01 por PK");
		return aa00j15s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j15s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j15s01> getAll(@ModelAttribute Aa00j15s01 filterAa00j15s01) {
		Aa00j15s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j15s01 por filtro");
		return this.calendarioEdificioService.findAll(filterAa00j15s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j15s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j15s01 edit(@RequestBody Aa00j15s01 aa00j15s01) {
		Aa00j15s01 aa00j15s01Aux = this.calendarioEdificioService
				.update(aa00j15s01);
		Aa00j15s01Controller.logger
				.info("[PUT] : Aa00j15s01 actualizado correctamente");
		return aa00j15s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j15s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j15s01 add(@RequestBody Aa00j15s01 aa00j15s01) {
		Aa00j15s01 aa00j15s01Aux = this.calendarioEdificioService
				.add(aa00j15s01);
		Aa00j15s01Controller.logger
				.info("[POST] : Aa00j15s01 insertado correctamente");
		return aa00j15s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cedif15
	 *            Long
	 * @param fecha15
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j15s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{cedif15}/{fecha15}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j15s01 remove(@PathVariable Long cedif15, @PathVariable Long fecha15) {
		Aa00j15s01 aa00j15s01 = new Aa00j15s01();
		aa00j15s01.setCedif15(cedif15);
		aa00j15s01.setFecha15(fecha15);
		this.calendarioEdificioService.remove(aa00j15s01);
		Aa00j15s01Controller.logger
				.info("[DELETE] : Aa00j15s01 borrado correctamente");
		return aa00j15s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j15s01Controller.logger.info("[GET - View] : aa00j15s01");

		List<Option> ubicaciones = this.edificiosService.getListForOption(
				false, true);
		model.addAttribute("ubicaciones", ubicaciones);

		Calendar cal = Calendar.getInstance();

		model.addAttribute("anioactual", cal.get(Calendar.YEAR));
		return "fechasedificio";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j15s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j15s01> filter(
			@RequestJsonBody(param = "filter") FormCalendario form,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		if (form.getCrear().equals("crear")) {
			Aa00j15s01Controller.logger
					.info("Crear calendario: borrar si exiten y crear datos");
			this.calendarioEdificioService.borrar(form.getEdificio(),
					form.getAnio());
			this.calendarioEdificioService.crear(form.getEdificio(),
					form.getAnio());
		}
		Aa00j15s01Controller.logger.info("Obtener datos para grid");
		return this.calendarioEdificioService.filter(form.getEdificio(),
				form.getAnio(), jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j15s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j15s01>> search(
			@RequestJsonBody(param = "filter") Aa00j15s01 filterAa00j15s01,
			@RequestJsonBody(param = "search") Aa00j15s01 searchAa00j15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01Controller.logger
				.info("[POST - search] : Buscar Aa00j15s01s");
		return this.calendarioEdificioService.search(filterAa00j15s01,
				searchAa00j15s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j15s01 filterAa00j15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j15s01s");
		this.calendarioEdificioService.removeMultiple(filterAa00j15s01,
				jqGridRequestDto, false);
		Aa00j15s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j15s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j15s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j15s01 filterAa00j15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j15s01s jerarquia");
		return this.calendarioEdificioService.jerarquia(filterAa00j15s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j15s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j15s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j15s01 filterAa00j15s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j15s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j15s01s jerarquia - Hijos");
		return this.calendarioEdificioService.jerarquiaChildren(
				filterAa00j15s01, jqGridRequestDto);
	}

	/**
	 * Actualiza la hora inicio
	 * 
	 * @param edificio
	 * @param anio
	 * @param horainicio
	 * @return
	 */
	@RequestMapping(value = "/horaInicio", method = RequestMethod.POST)
	public @ResponseBody
	int actualizarHoraInicio(@RequestParam Long edificio,
			@RequestParam int anio, @RequestParam String horainicio) {
		Aa00j15s01Controller.logger.info("Actualizar hora incio");

		return this.calendarioEdificioService.actualizarHoraInicio(edificio,
				anio, horainicio);
	}

	/**
	 * Actualiza la hora fin
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	@RequestMapping(value = "/horaFin", method = RequestMethod.POST)
	public @ResponseBody
	int actualizarHoraFin(@RequestParam Long edificio, @RequestParam int anio,
			@RequestParam String horafin) {
		Aa00j15s01Controller.logger.info("Actualizar hora fin");

		return this.calendarioEdificioService.actualizarHoraFin(edificio, anio,
				horafin);
	}

	/**
	 * Actualiza la hora fin
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	@RequestMapping(value = "/horaFinViernes", method = RequestMethod.POST)
	public @ResponseBody
	int actualizarHoraFinViernes(@RequestParam Long edificio,
			@RequestParam int anio, @RequestParam String horafin) {
		Aa00j15s01Controller.logger.info("Actualizar hora fin");

		return this.calendarioEdificioService.actualizarHoraFinViernes(
				edificio, anio, horafin);
	}

	/**
	 * Borra el calendario del edificio y el año
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	@RequestMapping(value = "/borrarCalendario", method = RequestMethod.POST)
	public @ResponseBody
	int borrarCalendario(@RequestParam Long edificio, @RequestParam int anio) {
		Aa00j15s01Controller.logger.info("Borrar calendario del edificio");

		return this.calendarioEdificioService.borrar(edificio, anio);
	}

	/**
	 * Crea la jornada intensiva para el edificio entre las fechas
	 * 
	 * @param edificio
	 * @param fdesde
	 * @param fhasta
	 * @param hinit
	 * @param hfin
	 * @param local
	 * @return
	 */
	@RequestMapping(value = "/crearIntensiva", method = RequestMethod.POST)
	public @ResponseBody
	int crearIntensiva(@RequestParam Long edificio,
			@RequestParam String fdesde, @RequestParam String fhasta,
			@RequestParam String hinit, @RequestParam String hfin, Locale local) {
		Aa00j15s01Controller.logger.info("Crear jornada intensiva entre "
				+ fdesde + "--" + fhasta);

		return this.calendarioEdificioService.crearIntensiva(edificio, hinit,
				hfin, fdesde, fhasta, local);
	}
}
