package com.ejie.aa00j.control;

import java.sql.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormConsultaAsistida;
import com.ejie.aa00j.service.Aa00j03s01Service;
import com.ejie.aa00j.service.Aa00j04s01Service;
import com.ejie.aa00j.service.Aa00j06s01Service;
import com.ejie.aa00j.service.Aa00j07s01Service;
import com.ejie.aa00j.service.Aa00j10s01Service;
import com.ejie.aa00j.service.Aa00j12s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import com.ejie.x38.util.DateTimeManager;

/**
 * Aa00j10s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j10s01")
public class Aa00j10s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j10s01Controller.class);
	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private Aa00j10s01Service aa00j10s01Service;
	@Autowired
	private Aa00j12s01Service aa00j12s01Service;
	@Autowired
	private Aa00j07s01Service departamentosService;
	@Autowired
	private Aa00j03s01Service edificiosService;
	@Autowired
	private Aa00j06s01Service restriccionesService;
	@Autowired
	private Aa00j04s01Service textosReservaService;

	@InitBinder
	protected void initBinder(HttpServletRequest request,
			ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class,
				new ByteArrayMultipartFileEditor());
		binder.registerCustomEditor(
				Date.class,
				new CustomDateEditor(DateTimeManager
						.getDateTimeFormat(LocaleContextHolder.getLocale()),
						true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param csala10
	 *            Long
	 * @return Aa00j10s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{csala10}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j10s01 get(@PathVariable Long csala10) {
		Aa00j10s01 aa00j10s01 = new Aa00j10s01();
		aa00j10s01.setCsala10(csala10);
		aa00j10s01 = this.aa00j10s01Service.find(aa00j10s01);
		Aa00j10s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j10s01 por PK");
		return aa00j10s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j10s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j10s01> getAll(@ModelAttribute Aa00j10s01 filterAa00j10s01) {
		Aa00j10s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j10s01 por filtro");
		return this.aa00j10s01Service.findAll(filterAa00j10s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j10s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j10s01 edit(
			@ModelAttribute Aa00j10s01 aa00j10s01,
			@RequestParam(value = "aa00j11s01.foto11", required = false) MultipartFile foto11,
			@RequestParam(value = "aa00j11s01.croq11", required = false) MultipartFile croq11)
			throws Exception {
		aa00j10s01.trim();
		Aa00j10s01 aa00j10s01Aux = this.aa00j10s01Service.update(aa00j10s01);
		Aa00j10s01Controller.logger
				.info("[PUT] : Aa00j10s01 actualizado correctamente");
		return aa00j10s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j10s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j10s01 add(
			@ModelAttribute Aa00j10s01 aa00j10s01,
			@RequestParam(value = "aa00j11s01.foto11", required = false) MultipartFile foto11,
			@RequestParam(value = "aa00j11s01.croq11", required = false) MultipartFile croq11)
			throws Exception {
		aa00j10s01.trim();
		Aa00j10s01 aa00j10s01Aux;
		if (aa00j10s01.getCsala10() == null) {
			aa00j10s01Aux = this.aa00j10s01Service.add(aa00j10s01);
			Aa00j10s01Controller.logger
					.info("[POST] : Aa00j10s01 insertado correctamente");
		} else {
			aa00j10s01Aux = this.aa00j10s01Service.update(aa00j10s01);
			Aa00j10s01Controller.logger
					.info("[POST] : Aa00j10s01 actualizado correctamente");
		}

		return aa00j10s01Aux;
	}

	@RequestMapping(value = "/anyadir", method = RequestMethod.POST)
	public @ResponseBody
	Aa00j10s01 anyadir(@ModelAttribute Aa00j10s01 aa00j10s01,
			@RequestParam(value = "foto", required = false) MultipartFile foto,
			HttpServletRequest request) throws Exception {
		Aa00j10s01 aa00j10s01Aux = this.aa00j10s01Service.add(aa00j10s01);
		return aa00j10s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param csala10
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j10s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{csala10}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j10s01 remove(@PathVariable Long csala10) throws Exception {
		Aa00j10s01 aa00j10s01 = new Aa00j10s01();
		aa00j10s01.setCsala10(csala10);
		this.aa00j10s01Service.remove(aa00j10s01);
		Aa00j10s01Controller.logger
				.info("[DELETE] : Aa00j10s01 borrado correctamente");
		return aa00j10s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		if (!ps.isEsTecnico() && !ps.isEsAdmin()) {
			model.addAttribute("departamentos",
					this.departamentosService.obtenerComboControlado());
		} else {
			model.addAttribute("departamentos",
					this.departamentosService.obtenerCombo());
		}
		model.addAttribute("edificios",
				this.edificiosService.getListForOption(true, true));
		model.addAttribute("restricciones",
				this.restriccionesService.obtenerCombo());
		model.addAttribute("textosReserva",
				this.textosReservaService.obtenerCombo());
		// Guardamos los parámetros estáticos en el modelo para poder
		// utilizarlos en el jsp mediante jstl
		model.addAttribute("SI", aa00jConstantes.SI);
		model.addAttribute("NO", aa00jConstantes.NO);
		model.addAttribute("SI_NO_TODAS", aa00jConstantes.SI_NO_TODAS);
		model.addAttribute("SITUACION_ALTA", aa00jConstantes.SITUACION_ALTA);
		model.addAttribute("SITUACION_BAJA", aa00jConstantes.SITUACION_BAJA);
		model.addAttribute("SITUACION_TODAS", aa00jConstantes.SITUACION_TODAS);
		Aa00j10s01Controller.logger.info("[GET - View] : aa00j10s01");
		return "salas";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j10s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j10s01> filter(
			@RequestJsonBody(param = "filter") Aa00j10s01 filterAa00j10s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j10s01s");
		return this.aa00j10s01Service.filter(filterAa00j10s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j10s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j10s01>> search(
			@RequestJsonBody(param = "filter") Aa00j10s01 filterAa00j10s01,
			@RequestJsonBody(param = "search") Aa00j10s01 searchAa00j10s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01Controller.logger
				.info("[POST - search] : Buscar Aa00j10s01s");
		return this.aa00j10s01Service.search(filterAa00j10s01,
				searchAa00j10s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j10s01 filterAa00j10s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto)
			throws Exception {
		Aa00j10s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j10s01s");
		this.aa00j10s01Service.removeMultiple(filterAa00j10s01,
				jqGridRequestDto, false);
		Aa00j10s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j10s01 filterAa00j10s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j10s01s jerarquia");
		return this.aa00j10s01Service.jerarquia(filterAa00j10s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j10s01 filterAa00j10s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j10s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j10s01s jerarquia - Hijos");
		return this.aa00j10s01Service.jerarquiaChildren(filterAa00j10s01,
				jqGridRequestDto);
	}

	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j10s01> getCombo(
			@RequestParam(value = "aa00j07s01ByCdep20.cdep07", required = false) Long codD1,
			@RequestParam(value = "aa00j03s01.cedif03", required = false) Long codE1,
			@RequestParam(value = "aa00j07s01ByCdep20.cdep07", required = false) Long codD2,
			@RequestParam(value = "aa00j10s01.aa00j03s01.cedif03", required = false) Long codE2) {
		Long codDepartamento = codD1;
		Long codEdificio = codE1;
		if (codD2 != null) {
			codDepartamento = codD2;
		}
		if (codE2 != null) {
			codEdificio = codE2;
		}
		return this.aa00j10s01Service
				.obtenerCombo(codDepartamento, codEdificio);
	}

	@RequestMapping(value = "/comboTodas", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j10s01> getComboTodas() {
		return this.aa00j10s01Service.obtenerComboTodas();
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param csala10
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{csala10}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long csala10) {

		return this.aa00j10s01Service.bloquear(csala10);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param csala10
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{csala10}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long csala10) {

		return this.aa00j10s01Service.desbloquear(csala10);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j10s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/consultaAsistida", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j10s01> consultaAsistida(
			@RequestJsonBody(param = "filter") FormConsultaAsistida form,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto, Locale local) {
		Aa00j10s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j10s01s");
		return this.aa00j10s01Service.consultaAsistida(form, jqGridRequestDto,
				local);
	}

	@RequestMapping(value = "/contarSalasConMedios", method = RequestMethod.POST)
	public @ResponseBody
	long numeroSalasConMedios(@RequestBody FormConsultaAsistida form) {

		return this.aa00j10s01Service.numeroSalasConMedios(form
				.getMediosFijos());
	}

	/**
	 * Metodo de presentacion del formulario detalleAsistidas
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maintAsistida", method = RequestMethod.GET)
	public String getFormDetalle(Model model) {
		Aa00j10s01Controller.logger.info("[GET - View] : detalleAsistidas");
		return "detalleAsistidas";
	}

	/**
	 * Una copia del get, pero que también carga la lista de medios fijos
	 * Posible mejora, sacar solamente los datos necesarios (no utilizar las
	 * sqls generadas por uda)
	 * 
	 * @param csala10
	 *            Long
	 * @return Aa00j10s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/salaMedio/{csala10}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j10s01 getSalaMedio(@PathVariable Long csala10) {
		Aa00j10s01 aa00j10s01 = new Aa00j10s01();
		aa00j10s01.setCsala10(csala10);
		aa00j10s01 = this.aa00j10s01Service.find(aa00j10s01);
		Aa00j10s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j10s01 por PK");

		List<Aa00j12s01> med = this.aa00j12s01Service
				.obtenerMediosFijosSala(csala10);
		if (med != null)
			aa00j10s01.setAa00j12s01s(med);
		return aa00j10s01;

	}

	/**
	 * Metodo de presentacion del formulario de consulta de salas.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/comboporsitio", method = RequestMethod.GET)
	public @ResponseBody
	List<Option> comboSalas(
			@RequestParam(value = "sitios", required = true) int sitio,
			Model model, Locale local) {

		List<Option> salas = this.aa00j10s01Service.salasPorSitio(sitio);

		return salas;
	}

	@RequestMapping(value = "/comboPorDep", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j10s01> getComboPorDep(
			@RequestParam(value = "departamentos", required = false) Long codDepartamento) {

		return this.aa00j10s01Service.obtenerCombo(codDepartamento, null);
	}

	@RequestMapping(value = "/comboPorEdif", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j10s01> getComboPorEdif(
			@RequestParam(value = "ubicaciones", required = false) Long ubicaciones) {

		return this.aa00j10s01Service.obtenerCombo(null, ubicaciones);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "cambiarSituacion/{ids}", method = RequestMethod.POST)
	public @ResponseBody
	boolean cambiarSituacion(@PathVariable String ids) {
		return this.aa00j10s01Service.cambiarSituacion(ids);
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j10s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.POST)
	public String excel(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, int tipoSalida, Model model,
			Locale locale) {

		Aa00j10s01Controller.logger.info("[POST - Excel] : Obtener excel");
		List<Aa00j10s01> res = this.aa00j10s01Service.findAllLike(
				filterAa00j10s01, jqGridRequestDto, false);
		model.addAttribute("datos", res);
		String titulo = this.appMessageSource.getMessage("etListSalas", null,
				LocaleContextHolder.getLocale());

		if (aa00jConstantes.TIPOEXCEL == tipoSalida) {
			model.addAttribute("titulo", titulo);
			return "excelView";
		} else {

			return locale.getLanguage() + "ListadoSalas";
		}
	}

}