package com.ejie.aa00j.control;

import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.ldap.SecurityHelpperException;
import com.ejie.aa00j.ldap.SecurityHelpperXLNets;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.service.Aa00j07s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j07s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j07s01")
public class Aa00j07s01Controller {
	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j07s01Controller.class);

	@Autowired
	private Aa00j07s01Service aa00j07s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param cdep07
	 *            Long
	 * @return Aa00j07s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{cdep07}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j07s01 get(@PathVariable Long cdep07) {
		Aa00j07s01 aa00j07s01 = new Aa00j07s01();
		aa00j07s01.setCdep07(cdep07);
		aa00j07s01 = this.aa00j07s01Service.find(aa00j07s01);
		Aa00j07s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j07s01 por PK");
		return aa00j07s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j07s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j07s01> getAll(@ModelAttribute Aa00j07s01 filterAa00j07s01) {
		Aa00j07s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j07s01 por filtro");
		return this.aa00j07s01Service.findAll(filterAa00j07s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j07s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j07s01 edit(@RequestBody Aa00j07s01 aa00j07s01) throws Exception {
		Aa00j07s01 aa00j07s01Aux = this.aa00j07s01Service.update(aa00j07s01);
		Aa00j07s01Controller.logger
				.info("[PUT] : Aa00j07s01 actualizado correctamente");
		return aa00j07s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j07s01
	 *            Aa00j07s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j07s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j07s01 add(@RequestBody Aa00j07s01 aa00j07s01) throws Exception {
		Aa00j07s01 aa00j07s01Aux = this.aa00j07s01Service.add(aa00j07s01);
		Aa00j07s01Controller.logger
				.info("[POST] : Aa00j07s01 insertado correctamente");
		return aa00j07s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param cdep07
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j07s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{cdep07}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j07s01 remove(@PathVariable Long cdep07) throws Exception {
		Aa00j07s01 aa00j07s01 = new Aa00j07s01();
		aa00j07s01.setCdep07(cdep07);
		this.aa00j07s01Service.remove(aa00j07s01);
		Aa00j07s01Controller.logger
				.info("[DELETE] : Aa00j07s01 borrado correctamente");
		return aa00j07s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j07s01Controller.logger.info("[GET - View] : aa00j07s01");
		model.addAttribute("SITUACION_ALTA", aa00jConstantes.SITUACION_ALTA);
		model.addAttribute("SITUACION_BAJA", aa00jConstantes.SITUACION_BAJA);
		model.addAttribute("SITUACION_TODAS", aa00jConstantes.SITUACION_TODAS);

		SecurityHelpperXLNets xlnets = new SecurityHelpperXLNets();
		try {
			model.addAttribute("departamentosxlent",
					xlnets.getDepartamentosYOrganismosXLNETs());
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			model.addAttribute("departamentosxlent", null);
		}
		return "departamentos";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j07s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j07s01> filter(
			@RequestJsonBody(param = "filter") Aa00j07s01 filterAa00j07s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j07s01s");
		return this.aa00j07s01Service.filter(filterAa00j07s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j07s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j07s01>> search(
			@RequestJsonBody(param = "filter") Aa00j07s01 filterAa00j07s01,
			@RequestJsonBody(param = "search") Aa00j07s01 searchAa00j07s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01Controller.logger
				.info("[POST - search] : Buscar Aa00j07s01s");
		return this.aa00j07s01Service.search(filterAa00j07s01,
				searchAa00j07s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j07s01 filterAa00j07s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto)
			throws Exception {
		Aa00j07s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j07s01s");
		this.aa00j07s01Service.removeMultiple(filterAa00j07s01,
				jqGridRequestDto, false);
		Aa00j07s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j07s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j07s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j07s01 filterAa00j07s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j07s01s jerarquia");
		return this.aa00j07s01Service.jerarquia(filterAa00j07s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j07s01
	 *            Aa00j07s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j07s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j07s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j07s01 filterAa00j07s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j07s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j07s01s jerarquia - Hijos");
		return this.aa00j07s01Service.jerarquiaChildren(filterAa00j07s01,
				jqGridRequestDto);
	}

	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j07s01> getCombo() {

		return this.aa00j07s01Service.obtenerCombo();
	}

	@RequestMapping(value = "/comboControlado", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j07s01> getComboControlado() {

		return this.aa00j07s01Service.obtenerComboControlado();
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cdep07
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{cdep07}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long cdep07) {

		return this.aa00j07s01Service.bloquear(cdep07);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cdep07
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{cdep07}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long cdep07) {

		return this.aa00j07s01Service.desbloquear(cdep07);
	}

	@RequestMapping(value = "/obtenerCodigoXlnet/{cdep07}", method = RequestMethod.GET)
	public @ResponseBody
	String obtenerCodigoXlnet(@PathVariable Long cdep07) {
		return this.aa00j07s01Service.obtenerCodigoXlnet(cdep07);
	}

	@RequestMapping(value = "/obtenerCodigoPorXlnet/{codDeptoXlnet}", method = RequestMethod.GET)
	public @ResponseBody
	Long obtenerCodigoPorXlnet(@PathVariable String codDeptoXlnet) {
		return this.aa00j07s01Service.obtenerCodigoPorXlnet(codDeptoXlnet);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "cambiarSituacion/{ids}", method = RequestMethod.POST)
	public @ResponseBody
	boolean cambiarSituacion(@PathVariable String ids) {
		return this.aa00j07s01Service.cambiarSituacion(ids);
	}

	@RequestMapping(value = "/excel", method = RequestMethod.POST)
	public String excel(Aa00j07s01 filterAa00j07s01,
			JQGridRequestDto jqGridRequestDto, int tipoSalida, Model model,
			Locale locale) {

		Aa00j07s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j10s01s");

		List<Aa00j07s01> res = this.aa00j07s01Service.findAllLike(
				filterAa00j07s01, jqGridRequestDto, false);

		model.addAttribute("datos", res);
		String titulo = this.appMessageSource.getMessage("etListDepartamentos",
				null, LocaleContextHolder.getLocale());
		if (aa00jConstantes.TIPOEXCEL == tipoSalida) {
			model.addAttribute("titulo", titulo);
			return "excelView";
		} else {

			return locale.getLanguage() + "ListadoDepartamentos";
		}
	}
}