package com.ejie.aa00j.control;

import com.ejie.aa00j.service.Aa00j06s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.model.Aa00j06s01;

/**
 * Aa00j06s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j06s01")
public class Aa00j06s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j06s01Controller.class);

	@Autowired
	private Aa00j06s01Service aa00j06s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param crest06
	 *            Long
	 * @return Aa00j06s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{crest06}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j06s01 get(@PathVariable Long crest06) {
		Aa00j06s01 aa00j06s01 = new Aa00j06s01();
		aa00j06s01.setCrest06(crest06);
		aa00j06s01 = this.aa00j06s01Service.find(aa00j06s01);
		Aa00j06s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j06s01 por PK");
		return aa00j06s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j06s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j06s01> getAll(@ModelAttribute Aa00j06s01 filterAa00j06s01) {
		Aa00j06s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j06s01 por filtro");
		return this.aa00j06s01Service.findAll(filterAa00j06s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j06s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j06s01 edit(@RequestBody Aa00j06s01 aa00j06s01) throws Exception {
		Aa00j06s01 aa00j06s01Aux = this.aa00j06s01Service.update(aa00j06s01);
		Aa00j06s01Controller.logger
				.info("[PUT] : Aa00j06s01 actualizado correctamente");
		return aa00j06s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j06s01
	 *            Aa00j06s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j06s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j06s01 add(@RequestBody Aa00j06s01 aa00j06s01) throws Exception {
		Aa00j06s01 aa00j06s01Aux = this.aa00j06s01Service.add(aa00j06s01);
		Aa00j06s01Controller.logger
				.info("[POST] : Aa00j06s01 insertado correctamente");
		return aa00j06s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param crest06
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j06s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{crest06}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j06s01 remove(@PathVariable Long crest06) throws Exception {
		Aa00j06s01 aa00j06s01 = new Aa00j06s01();
		aa00j06s01.setCrest06(crest06);
		this.aa00j06s01Service.remove(aa00j06s01);
		Aa00j06s01Controller.logger
				.info("[DELETE] : Aa00j06s01 borrado correctamente");
		return aa00j06s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j06s01Controller.logger.info("[GET - View] : aa00j06s01");
		return "aa00j06s01";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j06s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j06s01> filter(
			@RequestJsonBody(param = "filter") Aa00j06s01 filterAa00j06s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j06s01s");
		return this.aa00j06s01Service.filter(filterAa00j06s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j06s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j06s01>> search(
			@RequestJsonBody(param = "filter") Aa00j06s01 filterAa00j06s01,
			@RequestJsonBody(param = "search") Aa00j06s01 searchAa00j06s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01Controller.logger
				.info("[POST - search] : Buscar Aa00j06s01s");
		return this.aa00j06s01Service.search(filterAa00j06s01,
				searchAa00j06s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j06s01 filterAa00j06s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto)
			throws Exception {
		Aa00j06s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j06s01s");
		this.aa00j06s01Service.removeMultiple(filterAa00j06s01,
				jqGridRequestDto, false);
		Aa00j06s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j06s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j06s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j06s01 filterAa00j06s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j06s01s jerarquia");
		return this.aa00j06s01Service.jerarquia(filterAa00j06s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j06s01
	 *            Aa00j06s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j06s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j06s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j06s01 filterAa00j06s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j06s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j06s01s jerarquia - Hijos");
		return this.aa00j06s01Service.jerarquiaChildren(filterAa00j06s01,
				jqGridRequestDto);
	}

	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j06s01> getCombo() {

		return this.aa00j06s01Service.obtenerCombo();
	}

	@RequestMapping(value = "/anyadir", method = RequestMethod.POST)
	public @ResponseBody
	String anyadir(
			@RequestJsonBody(param = "descripcionEs") String descripcionEs,
			@RequestJsonBody(param = "descripcionEu") String descripcionEu,
			@RequestJsonBody(param = "mensajeEs") String mensajeEs,
			@RequestJsonBody(param = "mensajeEu") String mensajeEu)
			throws Exception {
		return this.aa00j06s01Service.anyadir(descripcionEs, descripcionEu,
				mensajeEs, mensajeEu);
	}
}