package com.ejie.aa00j.control;

import java.util.List;
import java.util.Locale;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.service.Aa00j04s01Service;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j04s01Controller generated by UDA, 16-oct-2013 13:02:18.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/aa00j04s01")
public class Aa00j04s01Controller {

	private static final Logger logger = LoggerFactory
			.getLogger(Aa00j04s01Controller.class);
	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private Aa00j04s01Service aa00j04s01Service;

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 * @param ctexto04
	 *            Long
	 * @return Aa00j04s01 Objeto correspondiente al identificador indicado.
	 */
	@RequestMapping(value = "/{ctexto04}", method = RequestMethod.GET)
	public @ResponseBody
	Aa00j04s01 get(@PathVariable Long ctexto04) {
		Aa00j04s01 aa00j04s01 = new Aa00j04s01();
		aa00j04s01.setCtexto04(ctexto04);
		aa00j04s01 = this.aa00j04s01Service.find(aa00j04s01);
		Aa00j04s01Controller.logger
				.info("[GET - findBy_PK] : Obtener Aa00j04s01 por PK");
		return aa00j04s01;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 * @return List<Aa00j04s01> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j04s01> getAll(@ModelAttribute Aa00j04s01 filterAa00j04s01) {
		Aa00j04s01Controller.logger
				.info("[GET - find_ALL] : Obtener Aa00j04s01 por filtro");
		return this.aa00j04s01Service.findAll(filterAa00j04s01, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01 Bean que contiene la informacion a modificar.
	 * @return Aa00j04s01 Bean resultante de la modificacion.
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa00j04s01 edit(@RequestBody Aa00j04s01 aa00j04s01) throws Exception {
		Aa00j04s01 aa00j04s01Aux = this.aa00j04s01Service.update(aa00j04s01);
		Aa00j04s01Controller.logger
				.info("[PUT] : Aa00j04s01 actualizado correctamente");
		return aa00j04s01Aux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 * @param aa00j04s01
	 *            Aa00j04s01 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 * @return Aa00j04s01 Bean resultante del proceso de creacion.
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa00j04s01 add(@RequestBody Aa00j04s01 aa00j04s01) throws Exception {
		Aa00j04s01 aa00j04s01Aux = this.aa00j04s01Service.add(aa00j04s01);
		Aa00j04s01Controller.logger
				.info("[POST] : Aa00j04s01 insertado correctamente");
		return aa00j04s01Aux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 * @param ctexto04
	 *            Long Identificador del objeto que se desea eliminar.
	 * @return Aa00j04s01 Bean eliminado.
	 */
	@RequestMapping(value = "/{ctexto04}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa00j04s01 remove(@PathVariable Long ctexto04) throws Exception {
		Aa00j04s01 aa00j04s01 = new Aa00j04s01();
		aa00j04s01.setCtexto04(ctexto04);
		this.aa00j04s01Service.remove(aa00j04s01);
		Aa00j04s01Controller.logger
				.info("[DELETE] : Aa00j04s01 borrado correctamente");
		return aa00j04s01;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		Aa00j04s01Controller.logger.info("[GET - View] : aa00j04s01");
		model.addAttribute("SITUACION_ALTA", aa00jConstantes.SITUACION_ALTA);
		model.addAttribute("SITUACION_BAJA", aa00jConstantes.SITUACION_BAJA);
		model.addAttribute("SITUACION_TODAS", aa00jConstantes.SITUACION_TODAS);
		return "textosReserva";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<Aa00j04s01> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<Aa00j04s01> filter(
			@RequestJsonBody(param = "filter") Aa00j04s01 filterAa00j04s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01Controller.logger
				.info("[POST - filter] : Obtener Aa00j04s01s");
		return this.aa00j04s01Service.filter(filterAa00j04s01,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param searchAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de busqueda a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 * @return TableRowDto<Aa00j04s01> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody
	List<TableRowDto<Aa00j04s01>> search(
			@RequestJsonBody(param = "filter") Aa00j04s01 filterAa00j04s01,
			@RequestJsonBody(param = "search") Aa00j04s01 searchAa00j04s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01Controller.logger
				.info("[POST - search] : Buscar Aa00j04s01s");
		return this.aa00j04s01Service.search(filterAa00j04s01,
				searchAa00j04s01, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 * @return List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * 
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<String> removeMultiple(
			@RequestJsonBody(param = "filter") Aa00j04s01 filterAa00j04s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto)
			throws Exception {
		Aa00j04s01Controller.logger
				.info("[POST - search] : [POST - removeMultiple] : Eliminar multiples Aa00j04s01s");
		this.aa00j04s01Service.removeMultiple(filterAa00j04s01,
				jqGridRequestDto, false);
		Aa00j04s01Controller.logger.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE - JERARQUIA
	 */

	/**
	 * Operacion de filtrado del componente RUP_TABLE para presentar los
	 * registros mediante visualizacion jerarquica.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j04s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquia/filter", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j04s01>> jerarquia(
			@RequestJsonBody(param = "filter") Aa00j04s01 filterAa00j04s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j04s01s jerarquia");
		return this.aa00j04s01Service.jerarquia(filterAa00j04s01,
				jqGridRequestDto, false);
	}

	/**
	 * Recupera los hijos de los registros desplegados en la visualizacion
	 * jerarquica.
	 * 
	 * @param filterAa00j04s01
	 *            Aa00j04s01 Bean que contiene los parametros de filtrado a
	 *            emplear.
	 * @param jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j04s01>> Dto que contiene el
	 *         resultado del filtrado realizado por el componente RUP_TABLE.
	 */
	@RequestMapping(value = "/jerarquiaChildren", method = RequestMethod.POST)
	public @ResponseBody
	JQGridResponseDto<JerarquiaDto<Aa00j04s01>> jerarquiaChildren(
			@RequestJsonBody(param = "filter") Aa00j04s01 filterAa00j04s01,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		Aa00j04s01Controller.logger
				.info("[POST - jerarquia] : Obtener Aa00j04s01s jerarquia - Hijos");
		return this.aa00j04s01Service.jerarquiaChildren(filterAa00j04s01,
				jqGridRequestDto);
	}

	@RequestMapping(value = "/combo", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa00j04s01> getCombo() {

		return this.aa00j04s01Service.obtenerCombo();
	}

	@RequestMapping(value = "/anyadir", method = RequestMethod.POST)
	public @ResponseBody
	String anyadir(@RequestJsonBody(param = "titulo") String titulo,
			@RequestJsonBody(param = "textoEs") String textoEs,
			@RequestJsonBody(param = "textoEu") String textoEu)
			throws Exception {
		return this.aa00j04s01Service.anyadir(titulo, textoEs, textoEu);
	}

	/**
	 * Method 'bloquear'.
	 * 
	 * @param cdep07
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "bloquear/{ctexto04}", method = RequestMethod.POST)
	public @ResponseBody
	boolean bloquear(@PathVariable Long ctexto04) {

		return this.aa00j04s01Service.bloquear(ctexto04);
	}

	/**
	 * Method 'desbloquear'.
	 * 
	 * @param cdep07
	 *            Long
	 * @return boolean
	 */
	@RequestMapping(value = "desbloquear/{ctexto04}", method = RequestMethod.POST)
	public @ResponseBody
	boolean desbloquear(@PathVariable Long ctexto04) {

		return this.aa00j04s01Service.desbloquear(ctexto04);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * @param ids
	 * @return
	 */
	@RequestMapping(value = "cambiarSituacion/{ids}", method = RequestMethod.POST)
	public @ResponseBody
	boolean cambiarSituacion(@PathVariable String ids) {
		return this.aa00j04s01Service.cambiarSituacion(ids);
	}

	@RequestMapping(value = "/excel", method = RequestMethod.POST)
	public String excel(Aa00j04s01 filterAa00j04s01,
			JQGridRequestDto jqGridRequestDto, int tipoSalida, Model model,
			Locale locale) {

		Aa00j04s01Controller.logger.info("[POST - Excel] : listado");

		List<Aa00j04s01> res = this.aa00j04s01Service.findAllLike(
				filterAa00j04s01, jqGridRequestDto, false);

		model.addAttribute("datos", res);
		String titulo = this.appMessageSource.getMessage("etListTextos", null,
				LocaleContextHolder.getLocale());
		if (aa00jConstantes.TIPOEXCEL == tipoSalida) {
			model.addAttribute("titulo", titulo);
			return "excelView";
		} else {

			return locale.getLanguage() + "ListadoTextosReserva";
		}
	}
}