package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.model.SituacionModel;

@Service(value = "situacionService")
public class SituacionServiceImpl implements SituacionService {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	public String obtSituacion(String codigo) {

		if (aa00jConstantes.SITUACION_ALTA.equals(codigo)) {
			return this.appMessageSource.getMessage("etSituacionAlta", null,
					LocaleContextHolder.getLocale());
		} else if (aa00jConstantes.SITUACION_BAJA.equals(codigo)) {
			return this.appMessageSource.getMessage("etSituacionBaja", null,
					LocaleContextHolder.getLocale());
		} else {
			return this.appMessageSource.getMessage("etSituacionTodas", null,
					LocaleContextHolder.getLocale());
		}
	}

	public String obtCodigoSituacion(String situacion) {

		if (situacion != null) {
			if (situacion.equals(this.appMessageSource.getMessage(
					"etSituacionAlta", null, LocaleContextHolder.getLocale()))) {
				return aa00jConstantes.SITUACION_ALTA;
			} else if (situacion.equals(this.appMessageSource.getMessage(
					"etSituacionBaja", null, LocaleContextHolder.getLocale()))) {
				return aa00jConstantes.SITUACION_BAJA;
			} else {
				return aa00jConstantes.SITUACION_TODAS;
			}
		}

		return null;
	}

	public ArrayList<SituacionModel> obtenerSituaciones() {

		Locale lES = new Locale("ES");
		Locale lEU = new Locale("EU");

		ArrayList<SituacionModel> situaciones = new ArrayList<SituacionModel>();

		// ALTA
		situaciones
				.add(new SituacionModel(aa00jConstantes.SITUACION_ALTA,
						this.appMessageSource.getMessage("etSituacionAlta",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionAlta", null, lEU)));

		// BAJA
		situaciones
				.add(new SituacionModel(aa00jConstantes.SITUACION_BAJA,
						this.appMessageSource.getMessage("etSituacionBaja",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionBaja", null, lEU)));

		// TODAS
		situaciones
				.add(new SituacionModel(aa00jConstantes.SITUACION_TODAS,
						this.appMessageSource.getMessage("etSituacionTodas",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionTodas", null, lEU)));

		return situaciones;
	}

	public ArrayList<SituacionModel> obtenerSituacionesAB() {

		Locale lES = new Locale("ES");
		Locale lEU = new Locale("EU");

		ArrayList<SituacionModel> situaciones = new ArrayList<SituacionModel>();

		// ALTA
		situaciones
				.add(new SituacionModel(aa00jConstantes.SITUACION_ALTA,
						this.appMessageSource.getMessage("etSituacionAlta",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionAlta", null, lEU)));

		// BAJA
		situaciones
				.add(new SituacionModel(aa00jConstantes.SITUACION_BAJA,
						this.appMessageSource.getMessage("etSituacionBaja",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionBaja", null, lEU)));

		return situaciones;
	}
}