package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.model.SiNoModel;

@Service(value = "siNoService")
public class SiNoServiceImpl implements SiNoService {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private ComunDao comunDao;

	public String obtSiNo(String codigo) {

		if (aa00jConstantes.SI.equals(codigo)) {
			return this.appMessageSource.getMessage("etSi", null,
					LocaleContextHolder.getLocale());
		} else if (aa00jConstantes.NO.equals(codigo)) {
			return this.appMessageSource.getMessage("etNo", null,
					LocaleContextHolder.getLocale());
		} else {
			return this.appMessageSource.getMessage("etTodas", null,
					LocaleContextHolder.getLocale());
		}
	}

	public String obtCodigoSiNo(String siNo) {

		if (siNo != null) {
			if (siNo.equals(this.appMessageSource.getMessage("etSi", null,
					LocaleContextHolder.getLocale()))) {
				return aa00jConstantes.SI;
			} else if (siNo.equals(this.appMessageSource.getMessage("etNo",
					null, LocaleContextHolder.getLocale()))) {
				return aa00jConstantes.NO;
			} else {
				return aa00jConstantes.SI_NO_TODAS;
			}
		}

		return "";
	}

	public ArrayList<SiNoModel> obtenerSiNo() {

		Locale lES = new Locale("ES");
		Locale lEU = new Locale("EU");

		ArrayList<SiNoModel> situaciones = new ArrayList<SiNoModel>();

		// ALTA
		situaciones.add(new SiNoModel(aa00jConstantes.SI, this.appMessageSource
				.getMessage("etSi", null, lES), this.appMessageSource
				.getMessage("etSi", null, lEU)));

		// BAJA
		situaciones.add(new SiNoModel(aa00jConstantes.NO, this.appMessageSource
				.getMessage("etNo", null, lES), this.appMessageSource
				.getMessage("etNo", null, lEU)));

		return situaciones;
	}

	public ArrayList<SiNoModel> obtenerSiNoTodas() {

		Locale lES = new Locale("ES");
		Locale lEU = new Locale("EU");

		ArrayList<SiNoModel> situaciones = new ArrayList<SiNoModel>();

		// ALTA
		situaciones.add(new SiNoModel(aa00jConstantes.SI, this.appMessageSource
				.getMessage("etSi", null, lES), this.appMessageSource
				.getMessage("etSi", null, lEU)));

		// BAJA
		situaciones.add(new SiNoModel(aa00jConstantes.NO, this.appMessageSource
				.getMessage("etNo", null, lES), this.appMessageSource
				.getMessage("etNo", null, lEU)));

		// TODAS
		situaciones
				.add(new SiNoModel(aa00jConstantes.SI_NO_TODAS,
						this.appMessageSource.getMessage("etSituacionTodas",
								null, lES), this.appMessageSource.getMessage(
								"etSituacionTodas", null, lEU)));

		return situaciones;
	}

	public ArrayList<String> obtenerNombres(String sql) {
		return this.comunDao.obtenerNombres(sql);
	}

	public boolean updatePr(String sql, String nombre, String codigo,
			String email) {
		return this.comunDao.updatePr(sql, nombre, codigo, email);
	}
}