package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa00j.dao.SalaReservasDao;
import com.ejie.aa00j.model.SalaHorariosReservados;

@Service(value = "salasReservadasService")
public class SalasReservadasServiceImpl implements SalasReservadasService {
	private static final Logger logger = LoggerFactory
			.getLogger(SalasReservadasServiceImpl.class);
	@Autowired
	private SalaReservasDao salasReservadasDao;

	public ArrayList<SalaHorariosReservados> getHorarios(Date dia,
			Integer departamento, Integer edificio, Integer sala) {
		this.logger.info("Entra en el service, llama al DAO");
		return this.salasReservadasDao.getHorarios(dia, departamento, edificio,
				sala);
	}

	/**
	 * Devuelve una lista de reservas para una sala , en unos días
	 * 
	 * @param dias
	 * @param sala
	 * @return
	 */
	public ArrayList<SalaHorariosReservados> getHorarios(ArrayList<Date> dias,
			Integer sala) {
		this.logger.info("Entra en el service, llama al DAO");
		return this.salasReservadasDao.getHorarios(dias, sala);
	}
}