/**
 * 
 */
package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa00j.dao.ListadosDao;
import com.ejie.aa00j.model.SalaReserva;

/**
 * @author iaizpurl
 * 
 */
@Service(value = "listadosService")
public class ListadosServiceImpl implements ListadosService {
	private static final Logger logger = LoggerFactory
			.getLogger(ListadosServiceImpl.class);

	@Autowired
	ListadosDao listadosDao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.aa00j.service.ListadosService#listadoSalas()
	 */
	@Override
	public ArrayList<SalaReserva> listadoSalas(int orden, int departamental,
			Integer edificio, Integer departamento, Integer sala, Date fecha1,
			Date fecha2, boolean nuevas) {
		// TODO Auto-generated method stub
		ListadosServiceImpl.logger.info("Service Listado Salas");
		return this.listadosDao.listadoSalas(orden, departamental, edificio,
				departamento, sala, fecha1, fecha2, nuevas);
	}

	/**
	 * devuelve un array con los recursos reservados según los parametros para
	 * el listado
	 * 
	 * @param orden
	 * @param edificio
	 * @param departamento
	 * @param sala
	 * @param fecha1
	 * @param fecha2
	 * @return
	 */
	@Override
	public ArrayList<SalaReserva> listadoRecursos(int orden, Integer edificio,
			Integer recurso, Date fecha1, Date fecha2) {
		ListadosServiceImpl.logger.info("Service Listado reservas");
		return this.listadosDao.listadoRecursos(orden, edificio, recurso,
				fecha1, fecha2);
	}

	/**
	 * Devuelve un array list para el listado de reservas
	 * 
	 * @param fechas
	 * @param fecha
	 * @return
	 */
	public ArrayList<SalaReserva> listadoSalas(int salas, Date fecha,
			boolean esListadoDepartamento) {
		ListadosServiceImpl.logger.info("Service Listado reservas");
		return this.listadosDao.listadoSalas(salas, fecha,
				esListadoDepartamento);
	}

	public ArrayList<SalaReserva> listadoSalas(int tipoinf, Date fecha) {
		ListadosServiceImpl.logger.info("Service Listado reservas");
		return this.listadosDao.listadoSalas(tipoinf, fecha);

	}
}
