/**
 * 
 */
package com.ejie.aa00j.service;

import java.util.ArrayList;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejie.aa00j.dao.EstadisticasDao;
import com.ejie.aa00j.model.SalaEstadistica;

/**
 * @author iaizpurl
 * 
 */
@Service(value = "estadisticasService")
public class EstadisticasServiceImpl implements EstadisticasService {
	private static final Logger logger = LoggerFactory
			.getLogger(EstadisticasServiceImpl.class);

	@Autowired
	EstadisticasDao estadisticasDao;

	/**
	 * Devuelve una lista de estadísticas
	 * 
	 * @param idSala
	 * @param sitio
	 * @param departamento
	 * @param anio
	 * @return
	 */
	@Override
	public ArrayList<SalaEstadistica> estadisticasMensuales(Integer idSala,
			Integer sitio, Integer departamento, Integer anio) {
		EstadisticasServiceImpl.logger
				.info("Entra en el service-->Estadisticas mensuales");
		// TODO Auto-generated method stub
		return estadisticasDao.estadisticasMensuales(idSala, sitio,
				departamento, anio);
	}

	/**
	 * Devuelve una lista de estadísticas anuales (últimos 5 años)
	 * 
	 * @param idSala
	 * @param sitio
	 * @param departamento
	 * @return
	 */
	@Override
	public ArrayList<SalaEstadistica> estadisticasAnuales(Integer idSala,
			Integer sitio, Integer departamento) {
		EstadisticasServiceImpl.logger
				.info("Entra en el service-->Estadisticas anuales");
		// TODO Auto-generated method stub
		return estadisticasDao.estadisticasAnuales(idSala, sitio, departamento);
	}

}
