package com.ejie.aa00j.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.ldap.aa00jPersonaXLNET;
import com.ejie.aa00j.model.Aa00j06s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j15s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Aa00j30s01;

@Service(value = "comunReservaService")
public class ComunReservaServiceImpl implements ComunReservaService {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunReservaService.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private Aa00j06s01Service aa00j06s01Service;

	@Autowired
	private Aa00j10s01Service aa00j10s01Service;

	@Autowired
	private Aa00j13s01Service aa00j13s01Service;

	@Autowired
	private Aa00j20s01Service aa00j20s01Service;

	@Autowired
	private Aa00j30s01Service aa00j30s01Service;
	@Autowired
	private Aa00j15s01Service calendarioEdificiosService;

	public String comprobarDisponibilidad(Aa00j20s01 aa00j20s01,
			aa00jPersonaSesion ps, Long codReservaExcluir) {

		StringBuffer ret = new StringBuffer();
		Long codSala = (long) -1;
		if (aa00j20s01.getAa00j10s01() != null) {
			codSala = aa00j20s01.getAa00j10s01().getCsala10();
		}

		if (codSala > 0) {
			Aa00j10s01 sala = this.aa00j10s01Service.find(new Aa00j10s01(
					codSala));

			// COMPROBAMOS RESTRICCIÓN DE BLOQUEO DE LA SALA
			if (!esTecnicoOAdminDepto(ps, aa00j20s01)) {
				if (sala.getSit10().equals(aa00jConstantes.SITUACION_BAJA)) {
					ret.append(this.appMessageSource.getMessage(
							"etSalaRestriccionBloqueo", null,
							LocaleContextHolder.getLocale()));
					ret.append(" ");
					ret.append(sala.getAa00j03s01().getTlfno03());
				} else if (sala.getAa00j06s01() != null) {
					Aa00j06s01 restriccion = this.aa00j06s01Service
							.find(new Aa00j06s01(sala.getAa00j06s01()
									.getCrest06()));
					if (restriccion != null
							&& restriccion.getDescc06().toUpperCase()
									.equals("BLOQUEO")) {
						ret.append(this.appMessageSource.getMessage(
								"etSalaRestriccionBloqueo", null,
								LocaleContextHolder.getLocale()));
						ret.append(" ");
						ret.append(sala.getAa00j03s01().getTlfno03());
					}
				}
			}

			if (ret.length() == 0) {
				if (!esTecnicoOAdminDepto(ps, aa00j20s01)) {
					if (comprobarFueraDeHorario(aa00j20s01.getDias(),
							aa00j20s01.getHoraIni(), aa00j20s01.getHoraFin(),
							aa00j20s01.getAa00j10s01().getAa00j03s01()
									.getCedif03().intValue())) {
						String strTelefono = sala.getAa00j03s01().getTlfno03();
						if (strTelefono == null || strTelefono.isEmpty()) {
							strTelefono = "-";
						}
						String strAux = this.appMessageSource.getMessage(
								"etReservaFueraDeHorario", null,
								LocaleContextHolder.getLocale());
						strAux = strAux.replace(":1", strTelefono);
						ret.append(strAux);
					}
				}
			}

			// Si es Técnico o es Administrador departamental y está haciendo
			// reserva para departamento
			// Entonces se le permite hacer reservas para más de 2 meses
			if (ret.length() == 0) {
				if (!esTecnicoOAdminDepto(ps, aa00j20s01)) {
					if (esMasDeDosMeses(aa00j20s01.getDias())) {
						ret.append(this.appMessageSource.getMessage(
								"etReservaMasDeDosMeses", null,
								LocaleContextHolder.getLocale()));
					}
				}
			}

			// Si es Técnico o es Administrador departamental y está haciendo
			// reserva para departamento
			// Entonces se le permite hacer reservas para hoy
			if (ret.length() == 0) {
				if (!esTecnicoOAdminDepto(ps, aa00j20s01)) {
					if (comprobarHoy(aa00j20s01.getDias())) {
						ret.append(this.appMessageSource.getMessage(
								"etReservaHoy", null,
								LocaleContextHolder.getLocale()));
					}
				}
			}

			if (ret.length() == 0) {
				Calendar cIni = null;
				Calendar cFin = null;

				String fechas = aa00j20s01.getDias().replace("-", "/");

				for (String fecha : fechas.split(",")) {
					cIni = obtenerFechaHora(fecha, aa00j20s01.getHoraIni());
					cFin = obtenerFechaHora(fecha, aa00j20s01.getHoraFin());

					boolean salaDisponible = this.aa00j20s01Service
							.existeSalaDisponible(aa00j20s01.getAa00j10s01()
									.getCsala10(),
									new Date(cIni.getTimeInMillis()), new Date(
											cFin.getTimeInMillis()),
									codReservaExcluir);

					if (!salaDisponible) {
						// Buscamos las ocupaciones de la sala para la fecha en
						// curso
						List<Aa00j20s01> aa00j20s01s = this.aa00j20s01Service
								.obtenerOcupacionesFechas(aa00j20s01
										.getAa00j10s01().getCsala10(),
										new Date(cIni.getTimeInMillis()),
										new Date(cFin.getTimeInMillis()),
										codReservaExcluir);

						if (aa00j20s01s != null && aa00j20s01s.size() > 0) {
							for (Aa00j20s01 salaOcupada : aa00j20s01s) {

								SimpleDateFormat sdf = new SimpleDateFormat(
										"HH:mm");
								String strHoraIni = sdf.format(salaOcupada
										.getDhcom20().getTime());
								String strHoraFin = sdf.format(salaOcupada
										.getDhfin20().getTime());

								ret.append("<br/>");
								ret.append(fecha).append(" ")
										.append(strHoraIni);
								ret.append(" - ");
								ret.append(fecha).append(" ")
										.append(strHoraFin);
							}
						}
					}
				}

				if (ret.length() > 0) {
					ret.insert(0, this.appMessageSource.getMessage(
							"etSalaOcupadaParaLasSiguientesFechas", null,
							LocaleContextHolder.getLocale()));
				}
			}
		}

		return ret.toString();
	}

	public String comprobarDisponibilidadRecursos(List<Aa00j13s01> aa00j13s01s,
			String strDias, String strHoraIni, String strHoraFin,
			aa00jPersonaSesion ps, Long codReservaExcluir,
			Long codReservaSalaExcluir) {

		StringBuffer ret = new StringBuffer();

		if (aa00j13s01s != null && aa00j13s01s.size() > 0) {

			for (Aa00j13s01 aa00j13s01 : aa00j13s01s) {
				Aa00j13s01 recurso = this.aa00j13s01Service.find(aa00j13s01);

				// COMPROBAMOS RESTRICCIÓN DE BLOQUEO DEL RECURSO
				if (recurso.getSit13().equals(aa00jConstantes.SITUACION_BAJA)) {
					ret.append(this.appMessageSource.getMessage(
							"etRecursoRestriccionBloqueo", null,
							LocaleContextHolder.getLocale()));
					ret.append(" ");
					ret.append(recurso.getAa00j03s01().getTlfno03());
					String nom;
					if (LocaleContextHolder.getLocale().getLanguage()
							.toUpperCase().equals("EU")) {
						nom = recurso.getNome13();
					} else {
						nom = recurso.getNomc13();
					}
					ret = ret.replace(ret.indexOf(":1", 0),
							ret.indexOf(":1", 0) + 2, nom);
				} else if (recurso.getAa00j06s01() != null) {
					Aa00j06s01 restriccion = this.aa00j06s01Service
							.find(new Aa00j06s01(recurso.getAa00j06s01()
									.getCrest06()));
					if (restriccion != null
							&& restriccion.getDescc06().toUpperCase()
									.equals("BLOQUEO")) {
						ret.append(this.appMessageSource.getMessage(
								"etRecursoRestriccionBloqueo", null,
								LocaleContextHolder.getLocale()));
						ret.append(" ");
						ret.append(recurso.getAa00j03s01().getTlfno03());
						String nom;
						if (LocaleContextHolder.getLocale().getLanguage()
								.toUpperCase().equals("EU")) {
							nom = recurso.getNome13();
						} else {
							nom = recurso.getNomc13();
						}
						ret = ret.replace(ret.indexOf(":1", 0),
								ret.indexOf(":1", 0) + 2, nom);
					}
				}

				if (ret.length() == 0) {
					if (!ps.isEsTecnico() && !ps.isEsAdmin()) {
						if (comprobarFueraDeHorario(strDias, strHoraIni,
								strHoraFin, recurso.getAa00j03s01()
										.getCedif03().intValue())) {
							String strTelefono = recurso.getAa00j03s01()
									.getTlfno03();
							if (strTelefono == null || strTelefono.isEmpty()) {
								strTelefono = "-";
							}
							String strAux = this.appMessageSource.getMessage(
									"etReservaFueraDeHorario", null,
									LocaleContextHolder.getLocale());
							strAux = strAux.replace(":1", strTelefono);
							ret.append(strAux);
						}
					}
				}

				// Si es Técnico
				// Entonces se le permite hacer reservas para más de 2 meses
				if (ret.length() == 0) {
					if (!ps.isEsTecnico() && !ps.isEsAdmin()) {
						if (esMasDeDosMeses(strDias)) {
							ret.append(this.appMessageSource.getMessage(
									"etReservaMasDeDosMeses", null,
									LocaleContextHolder.getLocale()));
						}
					}
				}

				// Si es Técnico
				// Entonces se le permite hacer reservas para hoy
				if (ret.length() == 0) {
					if (!ps.isEsTecnico() && !ps.isEsAdmin()) {
						if (comprobarHoy(strDias)) {
							ret.append(this.appMessageSource.getMessage(
									"etReservaHoy", null,
									LocaleContextHolder.getLocale()));
						}
					}
				}

				if (ret.length() == 0) {
					Calendar cIni = null;
					Calendar cFin = null;

					String fechas = strDias.replace("-", "/");
					for (String fecha : fechas.split(",")) {
						cIni = obtenerFechaHora(fecha, strHoraIni);
						cFin = obtenerFechaHora(fecha, strHoraFin);

						boolean recursoDisponible = this.aa00j30s01Service
								.existeRecursoDisponible(recurso.getCrec13(),
										new Date(cIni.getTimeInMillis()),
										new Date(cFin.getTimeInMillis()),
										codReservaExcluir,
										codReservaSalaExcluir);

						if (!recursoDisponible) {
							// Buscamos las ocupaciones del recurso para la
							// fecha en curso
							List<Aa00j30s01> aa00j30s01s = this.aa00j30s01Service
									.obtenerOcupacionesFechas(
											recurso.getCrec13(),
											new Date(cIni.getTimeInMillis()),
											new Date(cFin.getTimeInMillis()),
											codReservaExcluir,
											codReservaSalaExcluir);

							if (aa00j30s01s != null && aa00j30s01s.size() > 0) {
								ret.append("<br/>");
								if (LocaleContextHolder.getLocale()
										.getLanguage().toUpperCase()
										.equals("EU")) {
									ret.append(recurso.getNome13());
								} else {
									ret.append(recurso.getNomc13());
								}
								for (Aa00j30s01 recursoOcupado : aa00j30s01s) {
									SimpleDateFormat sdf = new SimpleDateFormat(
											"HH:mm");
									String miStrHoraIni = sdf
											.format(recursoOcupado.getDhcom30()
													.getTime());
									String miStrHoraFin = sdf
											.format(recursoOcupado.getDhfin30()
													.getTime());

									ret.append("<br/>");
									ret.append(fecha).append(" ")
											.append(miStrHoraIni);
									ret.append(" - ");
									ret.append(fecha).append(" ")
											.append(miStrHoraFin);
								}
							}
						}
					}

					if (ret.length() > 0) {
						ret.insert(0, this.appMessageSource.getMessage(
								"etRecursoOcupadoParaLasSiguientesFechas",
								null, LocaleContextHolder.getLocale()));
					}
				}
			}
		}

		return ret.toString();
	}

	public boolean comprobarFueraDeHorario(String strDias, String strHoraIni,
			String strHoraFin, int edificio) {
		// devuelve si la reserva se pide para dentro de la jornada de trabajo o
		// no
		// El horario de reserva es:
		// Jornada partida de lunes a jueves de 8:00 a 17:00, viernes de 8:00 a
		// 15:00
		// Jornada intensiva de 8:00 a 14:30

		boolean fueraDeHorario = false;

		Calendar c = null;
		Calendar c2 = null;
		String fechas = strDias.replace("-", "/");

		for (String fecha : fechas.split(",")) {
			c = obtenerFechaHora(fecha, strHoraIni);
			c2 = obtenerFechaHora(fecha, strHoraFin);
			fueraDeHorario = fueraDeHorario
					|| comprobarFueraDeHorario(c, c2, edificio);
		}

		return fueraDeHorario;
	}

	public boolean comprobarFueraDeHorario(Calendar c, Calendar c2, int edificio) {
		// devuelve si la reserva se pide para dentro de la jornada de trabajo o
		// no
		// El horario de reserva es:
		// Jornada partida de lunes a jueves de 8:00 a 17:00, viernes de 8:00 a
		// 15:00
		// Jornada intensiva de 8:00 a 14:30

		boolean fueraDeHorario = false;
		Aa00j15s01 horario;
		// SI ES FIN DE SEMANA
		if (c.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY
				|| c.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {

			fueraDeHorario = true;

		} else if (esFestivo(c)) {

			fueraDeHorario = true;

		} else {
			// Cambiado por iker, control del calendario por la tabla 15,
			// horarios de los edificios.
			// Si existe para el día un horario establecido, se utiliza ese
			// para
			// comprobar si es fuera de horario.
			int fechaint = c.get(Calendar.YEAR) * 10000
					+ (c.get(Calendar.MONTH) + 1) * 100 + c.get(Calendar.DATE);
			horario = this.calendarioEdificiosService.find(edificio, fechaint);
			if (horario == null) {// no existe, comprobacion ordinaria
				// Si no lo es, se hacen las comprobaciones estandar.
				if (esJornadaIntensiva(c)) {
					// si es jornada intensiva, Y mas tarde de las 16:00 o antes
					// de las 8:00
					fueraDeHorario = fueradeH(c, c2, 8, 0, 16, 0);
				} else {
					// if (esJornadaIntensiva(c)) {
					// // la reserva está dentro del horario de trabajo
					// fueraDeHorario = false;
					// } else {
					if (c.get(Calendar.DAY_OF_WEEK) == Calendar.FRIDAY) {
						// si es viernes y mas tarde de las 15 o antes de
						// las 8:00
						// alert("es viernes");
						fueraDeHorario = fueradeH(c, c2, 8, 0, 15, 0);
						;
					} else {
						fueraDeHorario = fueradeH(c, c2, 8, 0, 19, 0);
						// si es un día normal, y más tarde de las 19:00
						// o antes de las 8:00 o las 19:00 y más tarde
						// de las 19:00

					}
					// }
				}
			} else {
				if (horario.getHfin15() == null)
					fueraDeHorario = true;
				else {
					int hora1 = Integer.parseInt(horario.getHinit15()
							.split(":")[0]);
					int minutos1 = Integer.parseInt(horario.getHinit15().split(
							":")[1]);
					int hora2 = Integer
							.parseInt(horario.getHfin15().split(":")[0]);
					int minutos2 = Integer.parseInt(horario.getHfin15().split(
							":")[1]);
					// if ((c.get(Calendar.HOUR_OF_DAY) > hora1 || (c
					// .get(Calendar.HOUR_OF_DAY) == hora1 && c
					// .get(Calendar.MINUTE) >= minutos1))
					// && (c2.get(Calendar.HOUR_OF_DAY) < hora2 || (c2
					// .get(Calendar.HOUR_OF_DAY) < hora2 && c2
					// .get(Calendar.MINUTE) <= minutos2))) {
					// fueraDeHorario = false;
					// } else {
					// fueraDeHorario = true;
					// }
					fueraDeHorario = fueradeH(c, c2, hora1, minutos1, hora2,
							minutos2);
				}

			}
		}

		return fueraDeHorario;
	}

	public boolean fueradeH(Calendar c, Calendar c2, int hora1, int minutos1,
			int hora2, int minutos2) {
		if ((c.get(Calendar.HOUR_OF_DAY) > hora1 || (c
				.get(Calendar.HOUR_OF_DAY) == hora1 && c.get(Calendar.MINUTE) >= minutos1))
				&& (c2.get(Calendar.HOUR_OF_DAY) < hora2 || (c2
						.get(Calendar.HOUR_OF_DAY) == hora2 && c2
						.get(Calendar.MINUTE) <= minutos2))) {
			return false;
		} else {
			return true;
		}
	}

	public boolean esMasDeDosMeses(String strDias) {
		// devuelve si la reserva se pide para dentro de los dos meses
		// siguientes

		boolean ret = false;

		Calendar c = null;
		Calendar cHoyMas2Meses = Calendar.getInstance();
		cHoyMas2Meses.add(Calendar.MONTH, 2);

		String fechas = strDias.replace("-", "/");

		for (String fecha : fechas.split(",")) {
			c = obtenerFecha(fecha);
			if (cHoyMas2Meses.compareTo(c) <= 0) {
				ret = true;
			}
		}

		return ret;
	}

	private boolean comprobarHoy(String strDias) {
		// devuelve si la reserva se pide para hoy

		boolean ret = false;

		Calendar c = null;
		Calendar cHoy = Calendar.getInstance();

		String fechas = strDias.replace("-", "/");

		for (String fecha : fechas.split(",")) {
			c = obtenerFecha(fecha);
			if (c.get(Calendar.YEAR) == cHoy.get(Calendar.YEAR)
					&& c.get(Calendar.MONTH) == cHoy.get(Calendar.MONTH)
					&& c.get(Calendar.DAY_OF_MONTH) == cHoy
							.get(Calendar.DAY_OF_MONTH)) {
				ret = true;
			}
		}

		return ret;
	}

	public Calendar obtenerFecha(String fecha) {
		Calendar c = Calendar.getInstance();
		if (LocaleContextHolder.getLocale().getLanguage().toUpperCase()
				.equals("EU")) {
			c.set(Integer.parseInt(fecha.split("/")[0]),
					Integer.parseInt(fecha.split("/")[1]) - 1,
					Integer.parseInt(fecha.split("/")[2]));
		} else {
			c.set(Integer.parseInt(fecha.split("/")[2]),
					Integer.parseInt(fecha.split("/")[1]) - 1,
					Integer.parseInt(fecha.split("/")[0]));
		}
		return c;
	}

	public Calendar obtenerFechaHora(String fecha, String hora) {
		Calendar c = Calendar.getInstance();
		if (LocaleContextHolder.getLocale().getLanguage().toUpperCase()
				.equals("EU")) {
			c.set(Integer.parseInt(fecha.split("/")[0]),
					Integer.parseInt(fecha.split("/")[1]) - 1,
					Integer.parseInt(fecha.split("/")[2]),
					Integer.parseInt(hora.split(":")[0]),
					Integer.parseInt(hora.split(":")[1]), 00);
		} else {
			c.set(Integer.parseInt(fecha.split("/")[2]),
					Integer.parseInt(fecha.split("/")[1]) - 1,
					Integer.parseInt(fecha.split("/")[0]),
					Integer.parseInt(hora.split(":")[0]),
					Integer.parseInt(hora.split(":")[1]), 00);
		}

		return c;
	}

	public boolean esFestivo(Calendar fecha) {
		// devuelve true si el dia está catalogado como festivo
		boolean ret = false;

		int anyo = fecha.get(Calendar.YEAR);
		ArrayList<Calendar> arrFestivos = new ArrayList<Calendar>();
		Calendar c = Calendar.getInstance();

		c.set(anyo, 1 - 1, 1);
		arrFestivos.add(c); // 1/01

		c.set(anyo, 1 - 1, 6);
		arrFestivos.add(c); // 6/01

		c.set(anyo, 5 - 1, 1);
		arrFestivos.add(c); // 1/05

		c.set(anyo, 7 - 1, 25);
		arrFestivos.add(c); // 25/07

		c.set(anyo, 8 - 1, 15);
		arrFestivos.add(c); // 15/08

		c.set(anyo, 11 - 1, 1);
		arrFestivos.add(c); // 1/11

		c.set(anyo, 12 - 1, 6);
		arrFestivos.add(c); // 6/12

		c.set(anyo, 12 - 1, 8);
		arrFestivos.add(c); // 8/12

		c.set(anyo, 12 - 1, 24);
		arrFestivos.add(c); // 24/12

		c.set(anyo, 12 - 1, 25);
		arrFestivos.add(c); // 25/12

		c.set(anyo, 12 - 1, 31);
		arrFestivos.add(c); // 31/12

		for (Calendar aux : arrFestivos) {
			if (aux.get(Calendar.MONTH) == fecha.get(Calendar.MONTH)
					&& aux.get(Calendar.DAY_OF_MONTH) == fecha
							.get(Calendar.DAY_OF_MONTH)) {
				ret = true;
			}
		}
		return ret;
	}

	public boolean esJornadaIntensiva(Calendar fecha) {
		// devuelve true si el mes es de junio a septiembre (periodo de jornada
		// intensiva)
		boolean esIntensiva = false;

		// la jornada intensiva es de junio(6-1) a septiembre(9-1)
		int m = fecha.get(Calendar.MONTH);
		if ((m >= 5) && (m <= 8)) {
			esIntensiva = true;
		}

		return esIntensiva;
	}

	public boolean esAntesDe15Dias(Calendar fecha) {
		Calendar hoy = Calendar.getInstance();
		hoy.add(Calendar.DAY_OF_MONTH, 15);
		return ((hoy.compareTo(fecha)) >= 0);
	}

	public boolean esTecnicoOAdminDepto(aa00jPersonaSesion ps,
			Aa00j20s01 aa00j20s01) {
		return (ps.isEsTecnico() || ps.isEsAdmin() || (ps.isEsAdminDepto() && aa00j20s01
				.getAa00j07s01ByCdep20() != null));
	}

	public String comprobarCampos(String strDias, String strHoraIni,
			String strHoraFin) {

		StringBuffer ret = new StringBuffer();

		// La hora fin tiene que ser posterior a la hora inicio
		// La fecha inicio tiene que ser superior a la actual
		String horaIni = String.format("%1$2s", strHoraIni.split(":")[0])
				.replaceAll(" ", "0");
		String minutoIni = String.format("%1$2s", strHoraIni.split(":")[1])
				.replaceAll(" ", "0");
		long ini = Long.parseLong(horaIni.concat(minutoIni));

		String horaFin = String.format("%1$2s", strHoraFin.split(":")[0])
				.replaceAll(" ", "0");
		String minutoFin = String.format("%1$2s", strHoraFin.split(":")[1])
				.replaceAll(" ", "0");
		long fin = Long.parseLong(horaFin.concat(minutoFin));
		if (fin <= ini) {
			ret.append(this.appMessageSource.getMessage(
					"HoraHastaDebeSerMayorAHoraDesde", null,
					LocaleContextHolder.getLocale()));
		}

		if (ret.length() == 0) {
			Calendar c = Calendar.getInstance();
			String horaActual = String.format("%1$2s",
					c.get(Calendar.HOUR_OF_DAY)).replaceAll(" ", "0");
			String minutoActual = String
					.format("%1$2s", c.get(Calendar.MINUTE)).replaceAll(" ",
							"0");
			long ahora = Long.parseLong(horaActual.concat(minutoActual));
			// if (ini < ahora) {
			String fechas = strDias;
			for (String fecha : fechas.split(",")) {
				Calendar cIni = this.obtenerFecha(fecha);
				// Modificado por Iker . Las condiciones no estaban bien
				if (cIni.get(Calendar.YEAR) < c.get(Calendar.YEAR)
						|| (cIni.get(Calendar.YEAR) == c.get(Calendar.YEAR) && cIni
								.get(Calendar.MONTH) < c.get(Calendar.MONTH))
						|| (cIni.get(Calendar.YEAR) == c.get(Calendar.YEAR)
								&& cIni.get(Calendar.MONTH) == c
										.get(Calendar.MONTH) && cIni
								.get(Calendar.DAY_OF_MONTH) < c
								.get(Calendar.DAY_OF_MONTH))
						|| (ini < ahora
								&& cIni.get(Calendar.YEAR) == c
										.get(Calendar.YEAR)
								&& cIni.get(Calendar.MONTH) == c
										.get(Calendar.MONTH) && cIni
								.get(Calendar.DAY_OF_MONTH) == c
								.get(Calendar.DAY_OF_MONTH))) {
					if (ret.length() == 0) {
						ret.append(this.appMessageSource.getMessage(
								"FechaDesdeDebeSerMayorAFechaAhora", null,
								LocaleContextHolder.getLocale()));
					}
				}
			}
			// }
		}

		return ret.toString();
	}

	/* INI: CORREOS ELECTRÓNICOS */

	/* INI: NUEVA */
	public int enviarMailsNuevaReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin) {
		int resultado = aa00jConstantes.ENVIOMAL;
		try {

			String retorno = "";

			// 1º Mandamos un correo al reservador
			ComunReservaServiceImpl.logger
					.info("1º Mandamos un correo de nueva reserva al reservador --> "
							+ correoReservador);
			retorno = this.enviarMailNuevaReserva(aa00j10s01, correoReservador,
					reservador.getCodigo(), reservador, responsable, strAsunto,
					aa00j12s01s, aa00j13s01s, strDias, strHoraIni, strHoraFin);
			if (retorno.equals(""))
				resultado -= aa00jConstantes.ENVIOMALRESERVADOR;
			// 2º Si el reservador no es el responsable, mandamos también un
			// mail al responsable
			if (!correoReservador.equals(correoResponsable)) {
				ComunReservaServiceImpl.logger
						.info("1º Mandamos un correo de nueva reserva al responsable --> "
								+ correoResponsable);
				retorno = this.enviarMailNuevaReserva(aa00j10s01,
						correoResponsable, responsable.getCodigo(), reservador,
						responsable, strAsunto, aa00j12s01s, aa00j13s01s,
						strDias, strHoraIni, strHoraFin);
				if (retorno.equals(""))
					resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			} else {
				resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			}

		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("ERROR en enviarMailsNuevaReserva: "
							+ ex.getMessage());

		}
		return resultado;
	}

	private String enviarMailNuevaReserva(Aa00j10s01 aa00j10s01,
			String destinatario, String codigoDestinatario,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin) throws Exception {
		ComunReservaServiceImpl.logger
				.info("enviarMailNuevaReserva - INICIO: ");

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			String remitente = this.appConfiguration.getObject().getProperty(
					"user.mail.remitente");

			if (remitente == null || remitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = destinatario;

				String from = remitente;

				ComunReservaServiceImpl.logger
						.info("enviarMailNuevaReserva - ENVIAR MAIL from: "
								+ remitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta línea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesión con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);

				String asunto = this.appMessageSource.getMessage(
						"reserva.email.asunto", null, lCas)
						+ " = "
						+ this.appMessageSource.getMessage(
								"reserva.email.asunto", null, lEus);

				/* CASTELLANO */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.email.titulo", null, lCas) + "</p>");
				contenido.append("<p>");
				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.reservador", null, lCas)
						+ "</b>");
				contenido.append(" ").append(reservador.getNombre())
						.append(" ").append(reservador.getApellidos());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.responsable", null, lCas)
						+ "</b>");
				contenido.append(" ").append(responsable.getNombre())
						.append(" ").append(responsable.getApellidos());

				if (aa00j10s01 != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textosala", null, lCas)
							+ "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.textoasunto", null, lCas)
						+ "</b>");
				contenido.append(" ").append(strAsunto);

				if (aa00j12s01s != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textorecursosfijos", null,
									lCas) + "</b>");
					for (Aa00j12s01 aa00j12s01 : aa00j12s01s) {
						contenido.append("<br/>-")
								.append(aa00j12s01.getNom12());
					}
				}

				if (aa00j13s01s != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textorecursosmoviles", null,
									lCas) + "</b>");
					for (Aa00j13s01 aa00j13s01 : aa00j13s01s) {
						contenido.append("<br/>-").append(
								aa00j13s01.getNomc13());
					}
				}

				contenido
						.append("<br/><b>"
								+ this.appMessageSource.getMessage(
										"reserva.email.textodias", null, lCas)
								+ "</b>");
				for (String fecha : strDias.split(",")) {
					contenido.append("<br/>-").append(fecha);
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.textohoras", null, lCas)
						+ "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				if (aa00j10s01 != null) {
					contenido.append("<p>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.email.textoenlace", null, lCas));
					contenido.append("<a href='"
							+ this.obtenerUrlModificacionConfirmacion() + "'>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.email.enlace", null, lCas));
					contenido.append("</a>");
					contenido.append("</p>");
				}

				contenido
						.append("<p>"
								+ this.appMessageSource.getMessage(
										"reserva.email.despedida", null, lCas)
								+ "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* EUSKERA */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.email.titulo", null, lEus) + "</p>");
				contenido.append("<p>");
				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.reservador", null, lEus)
						+ "</b>");
				contenido.append(" ").append(reservador.getNombre())
						.append(" ").append(reservador.getApellidos());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.responsable", null, lEus)
						+ "</b>");
				contenido.append(" ").append(responsable.getNombre())
						.append(" ").append(responsable.getApellidos());

				if (aa00j10s01 != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textosala", null, lEus)
							+ "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.textoasunto", null, lEus)
						+ "</b>");
				contenido.append(" ").append(strAsunto);

				if (aa00j12s01s != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textorecursosfijos", null,
									lEus) + "</b>");
					for (Aa00j12s01 aa00j12s01 : aa00j12s01s) {
						contenido.append("<br/>-")
								.append(aa00j12s01.getNom12());
					}
				}

				if (aa00j13s01s != null) {
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"reserva.email.textorecursosmoviles", null,
									lEus) + "</b>");
					for (Aa00j13s01 aa00j13s01 : aa00j13s01s) {
						contenido.append("<br/>-").append(
								aa00j13s01.getNome13());
					}
				}

				contenido
						.append("<br/><b>"
								+ this.appMessageSource.getMessage(
										"reserva.email.textodias", null, lEus)
								+ "</b>");
				for (String fecha : strDias.split(",")) {
					contenido.append("<br/>-").append(fecha);
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.email.textohoras", null, lEus)
						+ "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				if (aa00j10s01 != null) {
					contenido.append("<p>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.email.textoenlace", null, lEus));
					contenido.append("<a href='"
							+ this.obtenerUrlModificacionConfirmacion() + "'>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.email.enlace", null, lEus));
					contenido.append("</a>");
					contenido.append("</p>");
				}

				contenido
						.append("<p>"
								+ this.appMessageSource.getMessage(
										"reserva.email.despedida", null, lEus)
								+ "</p>");
				/**/

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));
				String emailoculto = this.appConfiguration.getObject()
						.getProperty("emailCopiaOculta");
				if (emailoculto != null && !emailoculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(emailoculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();
				mbp1.setText(contenido.toString());
				mbp1.setHeader("Content-Type", "text/html; charset=ISO-8859-1");

				// create the Multipart and add its parts to it
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				ComunReservaServiceImpl.logger
						.info("enviarMailNuevaReserva - FIN. ");

				return "";
			}
		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("enviarMailNuevaReserva - ENVIAR MAIL to:" + to
							+ " " + codigoDestinatario + " " + ex.getMessage());
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	private String obtenerUrlModificacionConfirmacion() {
		String strUrl = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest().getRequestURL()
				.toString();
		String strContextPath = ((ServletRequestAttributes) RequestContextHolder
				.currentRequestAttributes()).getRequest().getContextPath();
		strUrl = strUrl.substring(0, strUrl.indexOf(strContextPath)
				+ strContextPath.length())
				+ "/aa00j20s01/modificarReserva";
		return strUrl;
	}

	/* FIN: NUEVA */

	/* INI: ANULACIÓN */
	public int enviarMailsAnulacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin) {
		int resultado = aa00jConstantes.ENVIOMAL;
		try {

			String retorno = "";

			// 1º Mandamos un correo al reservador
			ComunReservaServiceImpl.logger
					.info("1º Mandamos un correo de anulación al reservador --> "
							+ correoReservador);
			retorno = this.enviarMailAnulacionReserva(aa00j10s01,
					correoReservador, strAsunto, strDias, strHoraIni,
					strHoraFin);
			if (retorno.equals(""))
				resultado -= aa00jConstantes.ENVIOMALRESERVADOR;
			// 2º Si el reservador no es el responsable, mandamos también un
			// mail al responsable
			if (!correoReservador.equals(correoResponsable)) {
				ComunReservaServiceImpl.logger
						.info("1º Mandamos un correo de anulación al responsable --> "
								+ correoResponsable);
				retorno = this.enviarMailAnulacionReserva(aa00j10s01,
						correoResponsable, strAsunto, strDias, strHoraIni,
						strHoraFin);
				if (retorno.equals(""))
					resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			} else {
				resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			}

		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("ERROR en enviarMailsAnulacionReserva: "
							+ ex.getMessage());

		}
		return resultado;
	}

	private String enviarMailAnulacionReserva(Aa00j10s01 aa00j10s01,
			String destinatario, String strAsunto, String strDias,
			String strHoraIni, String strHoraFin) throws Exception {
		ComunReservaServiceImpl.logger
				.info("enviarMailAnulacionReserva - INICIO: ");

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			String remitente = this.appConfiguration.getObject().getProperty(
					"user.mail.remitente");

			if (remitente == null || remitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = destinatario;

				String from = remitente;

				ComunReservaServiceImpl.logger
						.info("enviarMailAnulacionReserva - ENVIAR MAIL from: "
								+ remitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta línea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesión con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);

				String asunto = this.appMessageSource.getMessage(
						"reserva.anulacion.email.asunto", null, lCas)
						+ " = "
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.asunto", null, lEus);

				/* CASTELLANO */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.titulo", null, lCas)
						+ "</p>");

				contenido.append("<p>");
				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.anulacion.email.textosala", null,
									lCas) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.textoasunto", null,
								lCas) + "</b>");
				contenido.append(" ").append(strAsunto);

				contenido.append("<br/><b>"
						+ this.appMessageSource
								.getMessage(
										"reserva.anulacion.email.textodias",
										null, lCas) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.textohoras", null,
								lCas) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource
								.getMessage(
										"reserva.anulacion.email.despedida",
										null, lCas) + "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* EUSKERA */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.titulo", null, lEus)
						+ "</p>");

				contenido.append("<p>");
				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.anulacion.email.textosala", null,
									lEus) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.textoasunto", null,
								lEus) + "</b>");
				contenido.append(" ").append(strAsunto);

				contenido.append("<br/><b>"
						+ this.appMessageSource
								.getMessage(
										"reserva.anulacion.email.textodias",
										null, lEus) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.anulacion.email.textohoras", null,
								lEus) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource
								.getMessage(
										"reserva.anulacion.email.despedida",
										null, lEus) + "</p>");
				/**/

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));
				String emailoculto = this.appConfiguration.getObject()
						.getProperty("emailCopiaOculta");
				if (emailoculto != null && !emailoculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(emailoculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();
				mbp1.setText(contenido.toString());
				mbp1.setHeader("Content-Type", "text/html; charset=ISO-8859-1");

				// create the Multipart and add its parts to it
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				ComunReservaServiceImpl.logger
						.info("enviarMailAnulacionReserva - FIN. ");

				return "";
			}
		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("enviarMailAnulacionReserva - ENVIAR MAIL to:" + to
							+ " " + ex.getMessage());
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	/* FIN: ANULACIÓN */

	/* INI: CONFIRMACIÓN */
	public int enviarMailsConfirmacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin) {
		return enviarMailsConfirmacionReserva(aa00j10s01, correoReservador,
				correoResponsable, strAsunto, strDias, strHoraIni, strHoraFin,
				false);
	}

	public int enviarMailsConfirmacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin, boolean aviso) {
		int resultado = aa00jConstantes.ENVIOMAL;
		try {

			String retorno = "";
			if (correoReservador != null && correoReservador.length() > 0) {
				// 1º Mandamos un correo al reservador
				ComunReservaServiceImpl.logger
						.info("1º Mandamos un correo de confirmación al reservador --> "
								+ correoReservador);
				retorno = this.enviarMailConfirmacionReserva(aa00j10s01,
						correoReservador, strAsunto, strDias, strHoraIni,
						strHoraFin, aviso);
				// email copia a EVA
				// this.enviarMailConfirmacionReserva(aa00j10s01,
				// "E-Linaje@ejie.es", "COPIA " + correoReservador + " "
				// + strAsunto, strDias, strHoraIni, strHoraFin,
				// aviso);
			}
			if (retorno.equals(""))
				resultado -= aa00jConstantes.ENVIOMALRESERVADOR;
			// 2º Si el reservador no es el responsable, mandamos también un
			// mail al responsable
			if (correoReservador != null
					&& !correoReservador.equals(correoResponsable)) {
				if (correoResponsable != null && correoResponsable.length() > 0) {
					ComunReservaServiceImpl.logger
							.info("1º Mandamos un correo de confirmación al responsable --> "
									+ correoResponsable);
					retorno = this.enviarMailConfirmacionReserva(aa00j10s01,
							correoResponsable, strAsunto, strDias, strHoraIni,
							strHoraFin, aviso);
					// email copia a EVA
					// this.enviarMailConfirmacionReserva(aa00j10s01,
					// "E-Linaje@ejie.es", "COPIA " + correoResponsable
					// + " " + strAsunto, strDias, strHoraIni,
					// strHoraFin, aviso);
				}
				if (retorno.equals(""))
					resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			} else {
				resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			}

		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("ERROR en enviarMailsConfirmacionReserva: "
							+ ex.getMessage());

		}
		return resultado;
	}

	public String enviarMailConfirmacionReserva(Aa00j10s01 aa00j10s01,
			String destinatario, String strAsunto, String strDias,
			String strHoraIni, String strHoraFin, boolean aviso)
			throws Exception {
		ComunReservaServiceImpl.logger
				.info("enviarMailConfirmacionReserva - INICIO: ");

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			String remitente = this.appConfiguration.getObject().getProperty(
					"user.mail.remitente");

			if (remitente == null || remitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = destinatario;

				String from = remitente;

				ComunReservaServiceImpl.logger
						.info("enviarMailConfirmacionReserva - ENVIAR MAIL from: "
								+ remitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta línea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesión con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);

				String asunto = this.appMessageSource.getMessage(
						"reserva.confirmacion.email.asunto", null, lCas)
						+ " = "
						+ this.appMessageSource
								.getMessage(
										"reserva.confirmacion.email.asunto",
										null, lEus);

				/* CASTELLANO */
				StringBuffer contenido = new StringBuffer("<p>");
				if (!aviso)
					contenido.append(this.appMessageSource.getMessage(
							"reserva.confirmacion.email.titulo", null, lCas));
				else
					contenido.append(this.appMessageSource.getMessage(
							"reserva.confirmacion.email.titulo2", null, lCas));
				contenido.append("</p>");

				contenido.append("<p>");
				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.confirmacion.email.textosala",
									null, lCas) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textoasunto", null,
								lCas) + "</b>");
				contenido.append(" ").append(strAsunto);

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textodias", null,
								lCas) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textohoras", null,
								lCas) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.despedida", null,
								lCas) + "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* EUSKERA */
				contenido.append("<p>");
				if (!aviso)
					contenido.append(this.appMessageSource.getMessage(
							"reserva.confirmacion.email.titulo", null, lEus));
				else
					contenido.append(this.appMessageSource.getMessage(
							"reserva.confirmacion.email.titulo2", null, lEus));

				contenido.append("</p><p>");
				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.confirmacion.email.textosala",
									null, lEus) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textoasunto", null,
								lEus) + "</b>");
				contenido.append(" ").append(strAsunto);

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textodias", null,
								lEus) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.textohoras", null,
								lEus) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.confirmacion.email.despedida", null,
								lEus) + "</p>");
				/**/

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));
				String emailoculto = this.appConfiguration.getObject()
						.getProperty("emailCopiaOculta");
				if (emailoculto != null && !emailoculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(emailoculto));

				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();
				mbp1.setText(contenido.toString());
				mbp1.setHeader("Content-Type", "text/html; charset=ISO-8859-1");

				// create the Multipart and add its parts to it
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				ComunReservaServiceImpl.logger
						.info("enviarMailConfirmacionReserva - FIN. ");

				return "";
			}
		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("enviarMailConfirmacionReserva - ENVIAR MAIL to:"
							+ to + " " + ex.getMessage());
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	/* FIN: CONFIRMACIÓN */

	/* INI: MODIFICACIÓN */
	public int enviarMailsModificarReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin) {

		int resultado = aa00jConstantes.ENVIOMAL;
		String retorno = "";
		try {
			// 1º Mandamos un correo al reservador
			ComunReservaServiceImpl.logger
					.info("1º Mandamos un correo de modificación de reserva al reservador --> "
							+ correoReservador);
			retorno = this.enviarMailModificarReserva(aa00j10s01,
					correoReservador, reservador.getCodigo(), reservador,
					responsable, strAsunto, aa00j12s01s, aa00j13s01s, strDias,
					strHoraIni, strHoraFin);
			if (retorno.equals(""))
				resultado -= aa00jConstantes.ENVIOMALRESERVADOR;
			// 2º Si el reservador no es el responsable, mandamos también un
			// mail al responsable
			if (!correoReservador.equals(correoResponsable)) {
				ComunReservaServiceImpl.logger
						.info("1º Mandamos un correo de modificación de reserva al responsable --> "
								+ correoResponsable);
				retorno = this.enviarMailModificarReserva(aa00j10s01,
						correoResponsable, responsable.getCodigo(), reservador,
						responsable, strAsunto, aa00j12s01s, aa00j13s01s,
						strDias, strHoraIni, strHoraFin);
				if (retorno.equals(""))
					resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			} else {
				resultado -= aa00jConstantes.ENVIOMALRESPONSABLE;
			}

		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("ERROR en enviarMailsModificarReserva: "
							+ ex.getMessage());

		}
		return resultado;
	}

	private String enviarMailModificarReserva(Aa00j10s01 aa00j10s01,
			String destinatario, String codigoDestinatario,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin) throws Exception {
		ComunReservaServiceImpl.logger
				.info("enviarMailModificarReserva - INICIO: ");

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			String remitente = this.appConfiguration.getObject().getProperty(
					"user.mail.remitente");

			if (remitente == null || remitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = destinatario;

				String from = remitente;

				ComunReservaServiceImpl.logger
						.info("enviarMailNuevaReserva - ENVIAR MAIL from: "
								+ remitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta línea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesión con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);

				String asunto = this.appMessageSource.getMessage(
						"reserva.modificacion.email.asunto", null, lCas)
						+ " = "
						+ this.appMessageSource
								.getMessage(
										"reserva.modificacion.email.asunto",
										null, lEus);

				/* CASTELLANO */
				StringBuffer contenido = new StringBuffer(
						"<p>"
								+ this.appMessageSource.getMessage(
										"reserva.modificacion.email.titulo",
										null, lCas) + "</p>");
				contenido.append("<p>");

				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.modificacion.email.textosala",
									null, lCas) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
					contenido.append("<br/>");
				}

				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textoasunto", null,
								lCas) + "</b>");
				contenido.append(" ").append(strAsunto);

				if (aa00j12s01s != null) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource
											.getMessage(
													"reserva.modificacion.email.textorecursosfijos",
													null, lCas) + "</b>");
					for (Aa00j12s01 aa00j12s01 : aa00j12s01s) {
						contenido.append("<br/>-")
								.append(aa00j12s01.getNom12());
					}
				}

				if (aa00j13s01s != null) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource
											.getMessage(
													"reserva.modificacion.email.textorecursosmoviles",
													null, lCas) + "</b>");
					for (Aa00j13s01 aa00j13s01 : aa00j13s01s) {
						contenido.append("<br/>-").append(
								aa00j13s01.getNomc13());
					}
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textodias", null,
								lCas) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textohoras", null,
								lCas) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				if (aa00j10s01 != null) {
					contenido.append("<p>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.modificacion.email.textoenlace", null,
							lCas));
					contenido.append("<a href='"
							+ this.obtenerUrlModificacionConfirmacion() + "'>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.modificacion.email.enlace", null, lCas));
					contenido.append("</a>");
					contenido.append("</p>");
				}

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.despedida", null,
								lCas) + "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* EUSKERA */
				contenido.append("<p>"
						+ this.appMessageSource
								.getMessage(
										"reserva.modificacion.email.titulo",
										null, lEus) + "</p>");
				contenido.append("<p>");

				if (aa00j10s01 != null) {
					contenido.append("<b>"
							+ this.appMessageSource.getMessage(
									"reserva.modificacion.email.textosala",
									null, lEus) + "</b>");
					contenido.append(" ").append(aa00j10s01.getNombre10());
					contenido.append("<br/>");
				}

				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textoasunto", null,
								lEus) + "</b>");
				contenido.append(" ").append(strAsunto);

				if (aa00j12s01s != null) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource
											.getMessage(
													"reserva.modificacion.email.textorecursosfijos",
													null, lEus) + "</b>");
					for (Aa00j12s01 aa00j12s01 : aa00j12s01s) {
						contenido.append("<br/>-")
								.append(aa00j12s01.getNom12());
					}
				}

				if (aa00j13s01s != null) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource
											.getMessage(
													"reserva.modificacion.email.textorecursosmoviles",
													null, lEus) + "</b>");
					for (Aa00j13s01 aa00j13s01 : aa00j13s01s) {
						contenido.append("<br/>-").append(
								aa00j13s01.getNome13());
					}
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textodias", null,
								lEus) + "</b>");
				contenido.append(" ").append(strDias);
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.textohoras", null,
								lEus) + "</b>");
				contenido.append(" ").append(strHoraIni).append(" - ")
						.append(strHoraFin);
				contenido.append("</p>");

				if (aa00j10s01 != null) {
					contenido.append("<p>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.modificacion.email.textoenlace", null,
							lEus));
					contenido.append("<a href='"
							+ this.obtenerUrlModificacionConfirmacion() + "'>");
					contenido.append(this.appMessageSource.getMessage(
							"reserva.modificacion.email.enlace", null, lEus));
					contenido.append("</a>");
					contenido.append("</p>");
				}

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"reserva.modificacion.email.despedida", null,
								lEus) + "</p>");
				/**/

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));
				String emailoculto = this.appConfiguration.getObject()
						.getProperty("emailCopiaOculta");
				if (emailoculto != null && !emailoculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(emailoculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();
				mbp1.setText(contenido.toString());
				mbp1.setHeader("Content-Type", "text/html; charset=ISO-8859-1");

				// create the Multipart and add its parts to it
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				ComunReservaServiceImpl.logger
						.info("enviarMailNuevaReserva - FIN. ");

				return "";
			}
		} catch (Exception ex) {
			ComunReservaServiceImpl.logger
					.error("enviarMailNuevaReserva - ENVIAR MAIL to:" + to
							+ " " + codigoDestinatario + " " + ex.getMessage());
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	/* FIN: MODIFICACIÓN */
	/* FIN: CORREOS ELECTRÓNICOS */

	public String obtenerDeptoCodUsuarioBusquedas(String departamental,
			String departamento) {
		aa00jPersonaSesion ps = new aa00jSeguridad().getUsuario();
		String codDepto = "";
		String codUsuario = "";
		if (ps.isEsTecnico() || ps.isEsAdmin()) {
			// Puede ver todas
			codUsuario = "";
		} else if (ps.isEsAdminDepto()) {
			// Puede ver las de su depto
			try {
				if ("1".equals(departamental)) {
					codUsuario = "";
					codDepto = ps.getDepartamentoInterno();
				} else {
					codUsuario = ps.getPersonaXLNET().getCodigo();
				}
			} catch (Exception e) {
				codDepto = "ERROR";
				codUsuario = "ERROR";
			}
		} else {
			// Solo puede ver las suyas
			try {
				codUsuario = ps.getPersonaXLNET().getCodigo();
			} catch (Exception e) {
				codUsuario = "ERROR";
			}
		}

		if ("1".equals(departamental) && !ps.isEsAdminDepto()) {
			codDepto = departamento;
		}

		return codDepto + "#" + codUsuario;
	}
}