package com.ejie.aa00j.service;

import java.util.Calendar;
import java.util.List;

import com.ejie.aa00j.classes.aa00jPersonaSesion;
import com.ejie.aa00j.ldap.aa00jPersonaXLNET;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j20s01;

public interface ComunReservaService {

	public String comprobarDisponibilidad(Aa00j20s01 aa00j20s01,
			aa00jPersonaSesion ps, Long codReservaExcluir);

	public String comprobarDisponibilidadRecursos(List<Aa00j13s01> aa00j13s01s,
			String strDias, String strHoraIni, String strHoraFin,
			aa00jPersonaSesion ps, Long codReservaExcluir,
			Long codReservaSalaExcluir);

	public boolean comprobarFueraDeHorario(String strDias, String strHoraIni,
			String strHoraFin, int edificio);

	public boolean comprobarFueraDeHorario(Calendar c, Calendar c2, int edificio);

	public boolean esMasDeDosMeses(String strDias);

	public Calendar obtenerFecha(String fecha);

	public Calendar obtenerFechaHora(String fecha, String hora);

	public boolean esFestivo(Calendar fecha);

	public boolean esJornadaIntensiva(Calendar fecha);

	public boolean esAntesDe15Dias(Calendar fecha);

	public boolean esTecnicoOAdminDepto(aa00jPersonaSesion ps,
			Aa00j20s01 aa00j20s01);

	public String comprobarCampos(String strDias, String strHoraIni,
			String strHoraFin);

	/* CORREOS ELECTRÓNICOS */
	public int enviarMailsNuevaReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin);

	public int enviarMailsAnulacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin);

	public int enviarMailsConfirmacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin);

	public int enviarMailsConfirmacionReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			String strAsunto, String strDias, String strHoraIni,
			String strHoraFin, boolean aviso);

	public int enviarMailsModificarReserva(Aa00j10s01 aa00j10s01,
			String correoReservador, String correoResponsable,
			aa00jPersonaXLNET reservador, aa00jPersonaXLNET responsable,
			String strAsunto, List<Aa00j12s01> aa00j12s01s,
			List<Aa00j13s01> aa00j13s01s, String strDias, String strHoraIni,
			String strHoraFin);

	/**/

	public String obtenerDeptoCodUsuarioBusquedas(String departamental,
			String departamento);
}