package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.dao.Aa00jDesbloqueosTablasDao;

import com.ejie.aa00j.model.Aa00j97s01;
import com.ejie.aa00j.model.Aa00j98s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00jDesbloqueosTablasServiceImpl generated by VDIAZSAN, 18-mar-2014
 * 12:26:50.
 * 
 * @author VDIAZSAN
 */

@Service(value = "aa00jDesbloqueosTablasService")
public class Aa00jDesbloqueosTablasServiceImpl implements
		Aa00jDesbloqueosTablasService {

	@Autowired
	private Aa00jDesbloqueosTablasDao aa00jDesbloqueosTablasDao;

	/**
	 * Finds a list of rows in the Aa00j12s01 table.
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j97s01>
	 */
	public List<Aa00j97s01> findAll(Aa00j97s01 aa00j97s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j97s01>) this.aa00jDesbloqueosTablasDao.findAll(
				aa00j97s01, jqGridRequestDto);
	}

	/**
	 * Filter method in the Aa00j12s01 table.
	 * 
	 * @param filterAa00j97s01
	 *            Aa00j97s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j97s01>
	 */
	public JQGridResponseDto<Aa00j97s01> filter(Aa00j97s01 filterAa00j97s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j97s01> listaAa00j97s01 = this.aa00jDesbloqueosTablasDao
				.findAll(filterAa00j97s01, jqGridRequestDto);
		Long recordNum = this.aa00jDesbloqueosTablasDao
				.findAllCount(filterAa00j97s01 != null ? filterAa00j97s01
						: new Aa00j97s01());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j97s01>> reorderSelection = this.aa00jDesbloqueosTablasDao
					.reorderSelection(filterAa00j97s01, jqGridRequestDto);
			return new JQGridResponseDto<Aa00j97s01>(jqGridRequestDto,
					recordNum, listaAa00j97s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j97s01>(jqGridRequestDto, recordNum,
				listaAa00j97s01);
	}

	/**
	 * Finds a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j97s01
	 *            Aa00j97s01
	 * @return Aa00j97s01
	 */
	public Aa00j97s01 find(Aa00j97s01 aa00j97s01) {
		return (Aa00j97s01) this.aa00jDesbloqueosTablasDao.find(aa00j97s01);
	}

	@Override
	public List<Aa00j97s01> findTabla(Aa00j97s01 aa00j97s01, Boolean c) {

		return this.aa00jDesbloqueosTablasDao.findTabla(aa00j97s01, c);
	}

	/**
	 * Finds a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j98s01
	 *            Aa00j98s01
	 * @return Aa00j98s01
	 */
	public List<Aa00j98s01> findDetalle(Aa00j98s01 aa00j98s01) {
		return (List<Aa00j98s01>) this.aa00jDesbloqueosTablasDao
				.findDetalle(aa00j98s01);
	}

	/**
	 * Devuelve una lista de registros bloqueados en la tabla. Es genérico,
	 * utiliza la tabla 98 para poder crear la select de la tabla
	 * 
	 * @param tabla
	 * @param campobloqueo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class, readOnly = true)
	public ArrayList<LinkedHashMap<Object, Object>> obtenerRegistrosBloqueados(
			String tabla, String campobloqueo) {
		return this.aa00jDesbloqueosTablasDao.obtenerRegistrosBloqueados(tabla,
				campobloqueo);
	}

	/**
	 * Desbloquea el registro de la tabla tabla identificado por campos y
	 * registros
	 * 
	 * @param tabla
	 * @param campos
	 * @param registros
	 * @param campoBloq
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int desbloquearRegistro(String tabla, String[] campos,
			String[] registros, String campoBloq) {
		return this.aa00jDesbloqueosTablasDao.desbloquearRegistro(tabla,
				campos, registros, campoBloq);

	}

}