package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.MyRuntimeException;
import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.dao.Aa00j04s01Dao;
import com.ejie.aa00j.dao.Aa00j07s01Dao;
import com.ejie.aa00j.dao.Aa00j13s01Dao;
import com.ejie.aa00j.dao.Aa00j30s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.ldap.SecurityHelpperXLNets;
import com.ejie.aa00j.ldap.aa00jPersonaXLNET;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j30s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j30s01Service")
public class Aa00j30s01ServiceImpl implements Aa00j30s01Service {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunReservaService.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j04s01Dao aa00j04s01Dao;

	@Autowired
	private Aa00j07s01Dao aa00j07s01Dao;
	@Autowired
	private Aa00j13s01Dao aa00j13s01Dao;
	@Autowired
	private Aa00j30s01Dao aa00j30s01Dao;

	@Autowired
	private ComunReservaService comunReserva;

	/**
	 * Inserts a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j30s01 add(Aa00j30s01 aa00j30s01) {
		return this.aa00j30s01Dao.add(aa00j30s01);
	}

	/**
	 * Updates a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j30s01 update(Aa00j30s01 aa00j30s01) {
		try {
			boolean ok = true;

			aa00jPersonaXLNET reservador = new aa00jSeguridad().getUsuario()
					.getPersonaXLNET();

			Aa00j30s01ServiceImpl.logger.info("INICIO Aa00j30s01.update");

			aa00j30s01.setPantallaMensaje("");
			aa00j30s01.setPantallaMensajeError("");
			aa00j30s01.setPantallaMensajeOk("");

			aa00j30s01.setDias(aa00j30s01.getDiaMostrar());
			aa00j30s01.setHoraIni(aa00j30s01.getHoraIniMostrar());
			aa00j30s01.setHoraFin(aa00j30s01.getHoraFinMostrar());

			String disponibilidad = this.comunReserva.comprobarCampos(
					aa00j30s01.getDias(), aa00j30s01.getHoraIni(),
					aa00j30s01.getHoraFin());

			// TIENE QUE HABER SELECCIONADO AL MENOS UN RECURSO GENERAL PARA
			// RESERVAR
			if (aa00j30s01.getAa00j13s01() == null
					|| aa00j30s01.getAa00j13s01().getCrec13() == null) {
				disponibilidad = this.appMessageSource.getMessage(
						"DebeSeleccionarAlgunRecursoParaReservar", null,
						LocaleContextHolder.getLocale());
			} else {
				aa00j30s01.setAa00j13s01s(new ArrayList<Aa00j13s01>());
				aa00j30s01.getAa00j13s01s().add(aa00j30s01.getAa00j13s01());
			}
			//

			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva
						.comprobarDisponibilidadRecursos(
								aa00j30s01.getAa00j13s01s(),
								aa00j30s01.getDias(), aa00j30s01.getHoraIni(),
								aa00j30s01.getHoraFin(),
								new aa00jSeguridad().getUsuario(),
								aa00j30s01.getCod30(), null);
			}

			if (disponibilidad.isEmpty()) {
				String fechas = aa00j30s01.getDias();
				Calendar cIni = this.comunReserva.obtenerFechaHora(fechas,
						aa00j30s01.getHoraIni());
				Calendar cFin = this.comunReserva.obtenerFechaHora(fechas,
						aa00j30s01.getHoraFin());
				aa00j30s01.setDhcom30(new Date(cIni.getTimeInMillis()));
				aa00j30s01.setDhfin30(new Date(cFin.getTimeInMillis()));

				if (this.comunReserva.comprobarFueraDeHorario(cIni, cFin,
						aa00j30s01.getAa00j13s01s().get(0).getAa00j03s01()
								.getCedif03().intValue())) {
					aa00j30s01.setSwfhor30(1);
				} else {
					aa00j30s01.setSwfhor30(0);
				}

				// Actualizamos las observaciones
				// Actualizamos el asunto
				// Actulizamos la fecha y hora inicio y la fecha y hora fin
				// Actualizamos el recurso reservado
				ok = this.aa00j30s01Dao.actualizarDatos(aa00j30s01.getCod30(),
						aa00j30s01.getObs30(), aa00j30s01.getAsun30(),
						aa00j30s01.getDhcom30(), aa00j30s01.getDhfin30(),
						aa00j30s01.getSwfhor30(), aa00j30s01.getAa00j13s01()
								.getCrec13());

				/* COGEMOS LOS DATOS DE XLNETS */
				String correoReservador = "";
				String correoResponsable = "";
				aa00jPersonaXLNET responsable = null;
				if (ok) {
					// Rellenamos los datos del reservador
					correoReservador = reservador.getEMail();

					// Rellenamos los datos del responsable
					try {
						responsable = new SecurityHelpperXLNets()
								.getPersonasXLNETs(null, aa00j30s01.getDni30(),
										null, null, null).get(0);
						correoResponsable = responsable.getEMail();
					} catch (Exception e) {
					}
					//
				}
				aa00j30s01.setEmail30(correoReservador);
				aa00j30s01.setEmailr30(correoResponsable);
				if (!ok) {
					Aa00j30s01ServiceImpl.logger
							.info("reserva de recurso actualizada ERROR --> "
									+ aa00j30s01.getCod30() + " por: "
									+ reservador.getCodigo());
					aa00j30s01.setPantallaMensajeError(this.appMessageSource
							.getMessage("etErrorAlActualizarReserva", null,
									LocaleContextHolder.getLocale()));
				} else {
					Aa00j30s01ServiceImpl.logger
							.info("reserva de recurso actualizada --> "
									+ aa00j30s01.getCod30() + " por: "
									+ reservador.getCodigo());

					/* MANDAMOS LOS MAILS */
					List<Aa00j13s01> aa00j13s01s = new ArrayList<Aa00j13s01>();
					aa00j13s01s.add(aa00j30s01.getAa00j13s01());
					int mailsEnviados = this.comunReserva
							.enviarMailsModificarReserva(null,
									correoReservador, correoResponsable,
									reservador, responsable,
									aa00j30s01.getAsun30(), null, aa00j13s01s,
									aa00j30s01.getDias(),
									aa00j30s01.getHoraIniMostrar(),
									aa00j30s01.getHoraFinMostrar());
					if (mailsEnviados != aa00jConstantes.ENVIOMAL) {
						int env1 = 1;
						int env2 = 1;
						if (mailsEnviados == aa00jConstantes.ENVIOMALRESERVADOR)
							env1 = 0;
						else if (mailsEnviados == aa00jConstantes.ENVIOMALRESPONSABLE)
							env2 = 0;
						this.aa00j30s01Dao.actualizarMailsEnviados(
								aa00j30s01.getCod30(), env1, env2);
					}
					/**/

					aa00j30s01.setPantallaMensaje("OK");
				}

				if (aa00j30s01.getPantallaMensaje() == null
						|| !aa00j30s01.getPantallaMensaje().equals("OK")) {
					throw new Exception();
				}

				Aa00j30s01ServiceImpl.logger.info("FIN Aa00j30s01.update");
				return aa00j30s01;
			} else {
				aa00j30s01.setPantallaMensajeError(disponibilidad);
				Aa00j30s01ServiceImpl.logger.info("FIN Aa00j30s01.update ");
				throw new Exception();
			}
		} catch (Exception e) {
			Aa00j30s01ServiceImpl.logger
					.error("ERROR en Aa00j30s01.update --> " + e.getMessage());
			if (aa00j30s01.getPantallaMensajeError() == null) {
				aa00j30s01.setPantallaMensajeError(this.appMessageSource
						.getMessage("etErrorAlActualizarReserva", null,
								LocaleContextHolder.getLocale()));
			}
			throw new MyRuntimeException(aa00j30s01.getPantallaMensajeError());
		}
	}

	/**
	 * Finds a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	public Aa00j30s01 find(Aa00j30s01 aa00j30s01) {
		return (Aa00j30s01) this.aa00j30s01Dao.find(aa00j30s01);
	}

	/**
	 * Deletes a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j30s01 aa00j30s01) {
		this.aa00j30s01Dao.remove(aa00j30s01);
	}

	/**
	 * Finds a list of rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j30s01>
	 */
	public List<Aa00j30s01> findAll(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codDepto = "";
		String codUsuario = "";
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(null,
				null);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/
		return (List<Aa00j30s01>) this.aa00j30s01Dao.findAll(aa00j30s01,
				jqGridRequestDto, codDepto, codUsuario);
	}

	/**
	 * Finds rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j30s01>
	 */
	public List<Aa00j30s01> findAllLike(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codDepto = "";
		String codUsuario = "";
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(null,
				null);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/
		return (List<Aa00j30s01>) this.aa00j30s01Dao.findAllLike(aa00j30s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario,
				LocaleContextHolder.getLocale());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa00j30s01Dao.removeMultiple(filterAa00j30s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j30s01>
	 */
	public JQGridResponseDto<Aa00j30s01> filter(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codDepto = "";
		String codUsuario = "";
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(null,
				null);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/
		List<Aa00j30s01> listaAa00j30s01 = this.aa00j30s01Dao.findAllLike(
				filterAa00j30s01, jqGridRequestDto, false, codDepto,
				codUsuario, LocaleContextHolder.getLocale());
		Long recordNum = this.aa00j30s01Dao.findAllLikeCount(
				filterAa00j30s01 != null ? filterAa00j30s01 : new Aa00j30s01(),
				false, codDepto, codUsuario, LocaleContextHolder.getLocale());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j30s01>> reorderSelection = this.aa00j30s01Dao
					.reorderSelection(filterAa00j30s01, jqGridRequestDto,
							startsWith, codDepto, codUsuario);
			return new JQGridResponseDto<Aa00j30s01>(jqGridRequestDto,
					recordNum, listaAa00j30s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j30s01>(jqGridRequestDto, recordNum,
				listaAa00j30s01);
	}

	/**
	 * Searches rows in the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param searchAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	public List<TableRowDto<Aa00j30s01>> search(Aa00j30s01 filterAa00j30s01,
			Aa00j30s01 searchAa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codDepto = "";
		String codUsuario = "";
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(null,
				null);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/
		return this.aa00j30s01Dao.search(filterAa00j30s01, searchAa00j30s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario);
	}

	/**
	 * Reorder the selection made in Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codDepto = "";
		String codUsuario = "";
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(null,
				null);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/
		return this.aa00j30s01Dao.reorderSelection(filterAa00j30s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquia(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j30s01>> listaAa00j30s01 = this.aa00j30s01Dao
				.findAllLikeJerarquia(filterAa00j30s01, jqGridRequestDto);
		Long recordNum = this.aa00j30s01Dao.findAllLikeCountJerarquia(
				filterAa00j30s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j30s01>>(
				jqGridRequestDto, recordNum, listaAa00j30s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquiaChildren(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j30s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j30s01Dao.findAllChild(filterAa00j30s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public boolean existeRecursoDisponible(Long crec30, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir) {
		return this.aa00j30s01Dao.existeRecursoDisponible(crec30, fechaHoraIni,
				fechaHoraFin, codReservaExcluir, codReservaSalaExcluir);
	}

	public List<Aa00j30s01> obtenerOcupacionesFechas(Long crec30,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir) {
		return (List<Aa00j30s01>) this.aa00j30s01Dao.obtenerOcupacionesFechas(
				crec30, fechaHoraIni, fechaHoraFin, codReservaExcluir,
				codReservaSalaExcluir);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Aa00j30s01 guardarReserva(Aa00j30s01 aa00j30s01) {
		try {
			Aa00j30s01ServiceImpl.logger
					.info("INICIO Aa00j30s01.guardarReserva ");

			ArrayList<Long> codigosReservaRecursoCreados = new ArrayList<Long>();

			aa00j30s01.setPantallaMensaje("");
			aa00j30s01.setPantallaMensajeError("");
			aa00j30s01.setPantallaMensajeOk("");

			aa00j30s01.setSit30(aa00jConstantes.SITUACION_ALTA);

			String disponibilidad = this.comunReserva.comprobarCampos(
					aa00j30s01.getDias(), aa00j30s01.getHoraIni(),
					aa00j30s01.getHoraFin());

			// TIENE QUE HABER SELECCIONADO AL MENOS UN RECURSO GENERAL PARA
			// RESERVAR
			if (aa00j30s01.getAa00j13s01s() == null
					|| aa00j30s01.getAa00j13s01s().size() == 0) {
				disponibilidad = this.appMessageSource.getMessage(
						"DebeSeleccionarAlgunRecursoParaReservar", null,
						LocaleContextHolder.getLocale());
			}
			//

			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva
						.comprobarDisponibilidadRecursos(
								aa00j30s01.getAa00j13s01s(),
								aa00j30s01.getDias(), aa00j30s01.getHoraIni(),
								aa00j30s01.getHoraFin(),
								new aa00jSeguridad().getUsuario(), null, null);
			}

			if (disponibilidad.isEmpty()) {

				/* COGEMOS LOS DATOS DE XLNETS */
				String correoReservador = "";
				String correoResponsable = "";

				// Rellenamos los datos del reservador
				aa00jPersonaXLNET reservador = new aa00jSeguridad()
						.getUsuario().getPersonaXLNET();
				aa00j30s01.setOrgan30(reservador.getCodigo());
				aa00j30s01.setReser30(reservador.getApellidos() + ", "
						+ reservador.getNombre());
				aa00j30s01.setTlfno30(reservador.getTelefono());
				long codDepto = this.aa00j07s01Dao
						.obtenerCodigoPorXlnet(reservador.getCodDepto());
				if (codDepto > 0) {
					aa00j30s01.setAa00j07s01ByCdep30(new Aa00j07s01(codDepto));
				}
				correoReservador = reservador.getEMail();
				aa00j30s01.setEmail30(correoReservador);

				// Rellenamos los datos del responsable
				aa00jPersonaXLNET responsable = null;
				long codDeptoResponsable = -1;
				try {
					responsable = new SecurityHelpperXLNets()
							.getPersonasXLNETs(aa00j30s01.getDni30(), null,
									null, null, null).get(0);
					aa00j30s01.setAnomd30(responsable.getApellidos() + ", "
							+ responsable.getNombre());
					aa00j30s01.setDni30(aa00j30s01.getDni30());
					aa00j30s01.setCresp30(responsable.getCodigo());
					aa00j30s01.setTlfnor30(responsable.getTelefono());
					codDeptoResponsable = this.aa00j07s01Dao
							.obtenerCodigoPorXlnet(responsable.getCodDepto());
					if (codDeptoResponsable > 0) {
						aa00j30s01.setAa00j07s01ByCdepr30(new Aa00j07s01(
								codDeptoResponsable));
					}
					correoResponsable = responsable.getEMail();
					aa00j30s01.setEmailr30(correoResponsable);
				} catch (Exception e) {
				}
				//

				/**/

				Aa00j30s01 aa00j30s01Aux = null;
				Calendar cIni;
				Calendar cFin;
				String fechas = aa00j30s01.getDias();
				// Iker cargar la información del recurso para poder comprobar
				// el
				// horario del edificio
				// Hay que ver si se pide reservar más de un elemento quizás sea
				// suficiente con guardar los datos del primero (siempre es el
				// mismo
				// edificio)

				List<Aa00j13s01> aa00j13s01s = new ArrayList<Aa00j13s01>();
				for (Aa00j13s01 aa00j13s01 : aa00j30s01.getAa00j13s01s()) {
					aa00j13s01s.add(this.aa00j13s01Dao.find(aa00j13s01));
				}
				aa00j30s01.setAa00j13s01s(aa00j13s01s);

				for (String fecha : fechas.split(",")) {
					cIni = this.comunReserva.obtenerFechaHora(fecha,
							aa00j30s01.getHoraIni());
					cFin = this.comunReserva.obtenerFechaHora(fecha,
							aa00j30s01.getHoraFin());

					aa00j30s01.setDhcom30(new Date(cIni.getTimeInMillis()));
					aa00j30s01.setDhfin30(new Date(cFin.getTimeInMillis()));

					if (this.comunReserva.comprobarFueraDeHorario(cIni, cFin,
							aa00j30s01.getAa00j13s01s().get(0).getAa00j03s01()
									.getCedif03().intValue())) {
						aa00j30s01.setSwfhor30(1);
					} else {
						aa00j30s01.setSwfhor30(0);
					}

					// Añadimos los medios móviles reservados
					if (aa00j30s01.getAa00j13s01s() != null
							&& aa00j30s01.getAa00j13s01s().size() > 0) {

						for (Aa00j13s01 aa00j13s01 : aa00j30s01
								.getAa00j13s01s()) {
							aa00j30s01.setAa00j13s01(aa00j13s01);
							aa00j30s01Aux = this.aa00j30s01Dao.add(aa00j30s01);
							/**/
							codigosReservaRecursoCreados.add(aa00j30s01Aux
									.getCod30());
							/**/
							Aa00j30s01ServiceImpl.logger
									.info("reserva de recurso guardada --> "
											+ aa00j30s01Aux.getCod30()
											+ " por: " + reservador.getCodigo());
						}
					}
				}
				if (aa00j30s01Aux == null) {
					aa00j30s01.setPantallaMensajeError(this.appMessageSource
							.getMessage("etErrorAlReservarSala", null,
									LocaleContextHolder.getLocale()));
				} else {

					/* MANDAMOS LOS MAILS */
					int mailsEnviados = this.comunReserva
							.enviarMailsNuevaReserva(null, correoReservador,
									correoResponsable, reservador, responsable,
									aa00j30s01.getAsun30(), null,
									aa00j30s01.getAa00j13s01s(),
									aa00j30s01.getDias(),
									aa00j30s01.getHoraIni(),
									aa00j30s01.getHoraFin());
					if (mailsEnviados != aa00jConstantes.ENVIOMAL) {
						int env1 = 1;
						int env2 = 1;
						if (mailsEnviados == aa00jConstantes.ENVIOMALRESERVADOR)
							env1 = 0;
						else if (mailsEnviados == aa00jConstantes.ENVIOMALRESPONSABLE)
							env2 = 0;
						for (Long codRR : codigosReservaRecursoCreados) {
							this.aa00j30s01Dao.actualizarMailsEnviados(codRR,
									env1, env2);
						}
					}
					/**/

					aa00j30s01.setPantallaMensaje("OK");

					// INI: PARA EL TEXTO DE LA RESERVA
					String telefono = "";
					String textoReserva = "";

					Aa00j04s01 aa00j04s01 = this.aa00j04s01Dao
							.find(new Aa00j04s01((long) -1));
					if (aa00j04s01 != null) {
						if (LocaleContextHolder.getLocale().getLanguage()
								.toUpperCase().equals("EU")) {
							textoReserva = aa00j04s01.getTrese04();
						} else {
							textoReserva = aa00j04s01.getTresc04();
						}
					}

					textoReserva = textoReserva.replace(":1", telefono);
					textoReserva = textoReserva.replace("\r\n", "\n");
					textoReserva = textoReserva.replace("\n", "<br/>");
					aa00j30s01.setPantallaMensajeOk(textoReserva);
					// FIN: PARA EL TEXTO DE LA RESERVA
				}

				if (aa00j30s01.getPantallaMensaje() == null
						|| !aa00j30s01.getPantallaMensaje().equals("OK")) {
					throw new MyRuntimeException();
				}

				Aa00j30s01ServiceImpl.logger
						.info("FIN Aa00j30s01.guardarReserva ");
				return aa00j30s01;
			} else {
				aa00j30s01.setPantallaMensajeError(disponibilidad);
				Aa00j30s01ServiceImpl.logger
						.info("FIN Aa00j30s01.guardarReserva ");
				return aa00j30s01;
			}
		} catch (Exception e) {
			Aa00j30s01ServiceImpl.logger
					.error("ERROR en Aa00j30s01.guardarReserva --> "
							+ e.getMessage());
			aa00j30s01.setPantallaMensajeError(this.appMessageSource
					.getMessage("etErrorAlReservarRecurso", null,
							LocaleContextHolder.getLocale()));
			throw new MyRuntimeException();
		}
	}

	public boolean bloquear(Long cod30) {

		return this.comunDao.bloquear("cod30", cod30.toString());
	}

	public boolean bloquearSiAlta(Long cod30) {

		return this.comunDao.bloquearSiAlta("cod30", cod30.toString());
	}

	public boolean desbloquear(Long cod30) {

		return this.comunDao.desbloquear("cod30", cod30.toString());
	}

	public String[] anular(List<String> codigosReservas) {
		Aa00j30s01ServiceImpl.logger.info("INICIO Aa00j30s01.anular");
		String[] retorno = new String[2];
		try {
			aa00jPersonaXLNET reservador = new aa00jSeguridad().getUsuario()
					.getPersonaXLNET();
			String usuario = reservador.getCodigo();

			StringBuffer ret = new StringBuffer();
			StringBuffer yaAnuladas = new StringBuffer();
			StringBuffer errorAnular = new StringBuffer();
			StringBuffer ok = new StringBuffer();

			boolean anulada = false;
			if (codigosReservas != null && codigosReservas.size() > 0) {

				for (String codigo : codigosReservas) {
					anulada = this.aa00j30s01Dao.anular(Long.parseLong(codigo),
							usuario);
					if (anulada) {
						Aa00j30s01ServiceImpl.logger
								.info("Se ha anulado la reserva del recurso: "
										+ codigo + ". Usuario de anulación: "
										+ usuario);
						ok.append(",").append(codigo);

						Aa00j30s01 aa00j30s01Aux = new Aa00j30s01(
								Long.parseLong(codigo));
						aa00j30s01Aux = this.aa00j30s01Dao.find(aa00j30s01Aux);

						// OBTENEMOS LOS DATOS DE LOS CORREOS DE XLNETS
						String correoReservador = reservador.getEMail();
						String correoResponsable = "";
						try {
							aa00jPersonaXLNET responsable = new SecurityHelpperXLNets()
									.getPersonasXLNETs(
											aa00j30s01Aux.getAnomd30(), null,
											null, null, null).get(0);
							correoResponsable = responsable.getEMail();
						} catch (Exception e) {
						}

						//
						/* MANDAMOS LOS MAILS */
						this.comunReserva.enviarMailsAnulacionReserva(null,
								correoReservador, correoResponsable,
								aa00j30s01Aux.getAsun30(),
								aa00j30s01Aux.getDiaMostrar(),
								aa00j30s01Aux.getHoraIniMostrar(),
								aa00j30s01Aux.getHoraFinMostrar());
						/**/
					} else {
						Aa00j30s01 aa00j30s01Aux = new Aa00j30s01(
								Long.parseLong(codigo));
						aa00j30s01Aux = this.aa00j30s01Dao.find(aa00j30s01Aux);
						if (aa00j30s01Aux.getSit30().equals(
								aa00jConstantes.SITUACION_BAJA)) {
							yaAnuladas = yaAnuladas.append(this
									.textoDetalleReserva(aa00j30s01Aux));
						} else {
							errorAnular = errorAnular.append(this
									.textoDetalleReserva(aa00j30s01Aux));
						}
					}
				}
			}

			if (yaAnuladas != null && yaAnuladas.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasAnuladas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(yaAnuladas);
			}
			if (errorAnular != null && errorAnular.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorAlAnularReservas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(errorAnular);
			}

			retorno[0] = ret.toString();
			if (ok.length() > 0) {
				retorno[1] = ok.substring(1);
			} else {
				retorno[1] = "";
			}

		} catch (Exception e) {
			Aa00j30s01ServiceImpl.logger
					.error("ERROR en Aa00j30s01.anular --> " + e.getMessage());
			retorno[0] = this.appMessageSource.getMessage(
					"etErrorAlAnularReserva", null,
					LocaleContextHolder.getLocale());
			retorno[1] = "";
		}

		Aa00j30s01ServiceImpl.logger.info("FIN Aa00j30s01.anular");

		return retorno;
	}

	private StringBuffer textoDetalleReserva(Aa00j30s01 aa00j30s01) {
		return new StringBuffer()
				.append("-")
				.append(aa00j30s01.getAa00j13s01().getNomc13())
				.append(" / ")
				.append(aa00j30s01.getAa00j13s01().getNome13())
				.append(", ")
				.append(this.appMessageSource.getMessage("etDia", null,
						LocaleContextHolder.getLocale()))
				.append(" ")
				.append(aa00j30s01.getDiaMostrar())
				.append(", ")
				.append(this.appMessageSource.getMessage("etDe", null,
						LocaleContextHolder.getLocale()))
				.append(" ")
				.append(aa00j30s01.getHoraIniMostrar())
				.append(" ")
				.append(this.appMessageSource.getMessage("etA", null,
						LocaleContextHolder.getLocale())).append(" ")
				.append(aa00j30s01.getHoraFinMostrar()).append("<br/>");
	}

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada parael recurso
	 * de entrada de entrada
	 * 
	 * @param csala20
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j30s01> obtenerOcupacionesRecursosFechas(Long csala30,
			ArrayList<Date> fechas) {
		return this.aa00j30s01Dao.obtenerOcupacionesRecursosFechas(csala30,
				fechas);
	}

	/**
	 * 
	 */
	public boolean anularPorReservaSala(Long codrsala30, String usuario) {
		return this.aa00j30s01Dao.anularPorReservaSala(codrsala30, usuario);
	}

	public boolean actualizarMailsEnviadosReservaSala(Long codrsala30,
			int mailsEnviados, int mailsEnviadoR) {
		return this.aa00j30s01Dao.actualizarMailsEnviadosReservaSala(
				codrsala30, mailsEnviados, mailsEnviadoR);
	}

	public boolean actualizarMailsEnviados(Long cod30, int mailsEnviados,
			int mailsEnviadoR) {
		return this.aa00j30s01Dao.actualizarMailsEnviados(cod30, mailsEnviados,
				mailsEnviadoR);
	}

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j30s01> obtenerReservasSinEnviar() {
		return this.aa00j30s01Dao.obtenerReservasSinEnviar();
	}
}