package com.ejie.aa00j.service;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.aa00j.model.Aa00j30s01;

/**
 * Aa00j30s01Service generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j30s01Service {

	/**
	 * Inserts a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 add(Aa00j30s01 aa00j30s01);

	/**
	 * Updates a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 update(Aa00j30s01 aa00j30s01);

	/**
	 * Finds a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @return Aa00j30s01
	 */
	Aa00j30s01 find(Aa00j30s01 aa00j30s01);

	/**
	 * Deletes a single row in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 */
	void remove(Aa00j30s01 aa00j30s01);

	/**
	 * Finds a list of rows in the Aa00j30s01 table.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j30s01>
	 */
	List<Aa00j30s01> findAll(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa00j30s01 table using like.
	 * 
	 * @param aa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j30s01>
	 */
	List<Aa00j30s01> findAllLike(Aa00j30s01 aa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j30s01>
	 */
	JQGridResponseDto<Aa00j30s01> filter(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param searchAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j30s01>>
	 */
	List<TableRowDto<Aa00j30s01>> search(Aa00j30s01 filterAa00j30s01,
			Aa00j30s01 searchAa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa00j30s01 filterAa00j30s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquia(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j30s01 table.
	 * 
	 * @param filterAa00j30s01
	 *            Aa00j30s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j30s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j30s01>> jerarquiaChildren(
			Aa00j30s01 filterAa00j30s01, JQGridRequestDto jqGridRequestDto);

	boolean existeRecursoDisponible(Long crec30, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir);

	List<Aa00j30s01> obtenerOcupacionesFechas(Long crec30, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir,
			Long codReservaSalaExcluir);

	Aa00j30s01 guardarReserva(Aa00j30s01 aa00j30s01);

	boolean bloquear(Long cod30);

	boolean bloquearSiAlta(Long cod30);

	boolean desbloquear(Long cod30);

	String[] anular(List<String> codigosReservas);

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada parael recurso
	 * de entrada de entrada
	 * 
	 * @param csala20
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j30s01> obtenerOcupacionesRecursosFechas(Long csala30,
			ArrayList<Date> fechas);

	public boolean anularPorReservaSala(Long codrsala30, String usuario);

	public boolean actualizarMailsEnviadosReservaSala(Long codrsala30,
			int mailsEnviados, int mailsEnviadoR);

	public boolean actualizarMailsEnviados(Long cod30, int mailsEnviados,
			int mailsEnviadoR);

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j30s01> obtenerReservasSinEnviar();
}