package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.MyRuntimeException;
import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.classes.aa00jSeguridad;
import com.ejie.aa00j.dao.Aa00j04s01Dao;
import com.ejie.aa00j.dao.Aa00j07s01Dao;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.aa00j.dao.Aa00j12s01Dao;
import com.ejie.aa00j.dao.Aa00j13s01Dao;
import com.ejie.aa00j.dao.Aa00j20s01Dao;
import com.ejie.aa00j.dao.Aa00j30s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.ldap.SecurityHelpperXLNets;
import com.ejie.aa00j.ldap.aa00jPersonaXLNET;
import com.ejie.aa00j.model.Aa00j04s01;
import com.ejie.aa00j.model.Aa00j07s01;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Aa00j30s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j20s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j20s01Service")
public class Aa00j20s01ServiceImpl implements Aa00j20s01Service {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunReservaService.class);

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j20s01Dao aa00j20s01Dao;

	@Autowired
	private ComunReservaService comunReserva;

	@Autowired
	private Aa00j04s01Dao aa00j04s01Dao;

	@Autowired
	private Aa00j07s01Dao aa00j07s01Dao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;

	@Autowired
	private Aa00j12s01Dao aa00j12s01Dao;

	@Autowired
	private Aa00j13s01Dao aa00j13s01Dao;

	@Autowired
	private Aa00j30s01Dao aa00j30s01Dao;

	/**
	 * Inserts a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j20s01 add(Aa00j20s01 aa00j20s01) {
		return this.aa00j20s01Dao.add(aa00j20s01);
	}

	/**
	 * Updates a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j20s01 update(Aa00j20s01 aa00j20s01) {

		try {
			boolean ok = true;

			Aa00j20s01ServiceImpl.logger.info("INICIO Aa00j20s01.update");

			aa00j20s01.setPantallaMensaje("");
			aa00j20s01.setPantallaMensajeError("");
			aa00j20s01.setPantallaMensajeOk("");

			aa00j20s01.setDias(aa00j20s01.getDiaMostrar());
			aa00j20s01.setHoraIni(aa00j20s01.getHoraIniMostrar());
			aa00j20s01.setHoraFin(aa00j20s01.getHoraFinMostrar());

			String disponibilidad = this.comunReserva.comprobarCampos(
					aa00j20s01.getDias(), aa00j20s01.getHoraIni(),
					aa00j20s01.getHoraFin());

			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva.comprobarDisponibilidad(
						aa00j20s01, new aa00jSeguridad().getUsuario(),
						aa00j20s01.getCod20());
			}
			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva
						.comprobarDisponibilidadRecursos(
								aa00j20s01.getAa00j13s01s(),
								aa00j20s01.getDias(), aa00j20s01.getHoraIni(),
								aa00j20s01.getHoraFin(),
								new aa00jSeguridad().getUsuario(), null,
								aa00j20s01.getCod20());
			}

			if (disponibilidad.isEmpty()) {
				String fechas = aa00j20s01.getDias();
				Calendar cIni = this.comunReserva.obtenerFechaHora(fechas,
						aa00j20s01.getHoraIni());
				Calendar cFin = this.comunReserva.obtenerFechaHora(fechas,
						aa00j20s01.getHoraFin());
				aa00j20s01.setDhcom20(new Date(cIni.getTimeInMillis()));
				aa00j20s01.setDhfin20(new Date(cFin.getTimeInMillis()));

				if (this.comunReserva.comprobarFueraDeHorario(cIni, cFin,
						aa00j20s01.getAa00j10s01().getAa00j03s01().getCedif03()
								.intValue())) {
					aa00j20s01.setSwfhor20(1);
				} else {
					aa00j20s01.setSwfhor20(0);
				}
				// Modificado por iker: no llega el getNecesarioaConfirmacion,
				// como es un update se mira el estado si esta confirmado, se
				// deja igual
				// si no, se aplica lo de los 15 días
				// if (aa00j20s01.getNecesariaConfirmacion() != null) {
				aa00j20s01.setSwautc20(0);
				if (aa00j20s01.getSwconf20() != 1) {
					if (this.comunReserva.esAntesDe15Dias(cIni)) {
						aa00j20s01.setSwconf20(1);
					} else {
						aa00j20s01.setSwconf20(0);
					}
				}
				/*
				 * } else { aa00j20s01.setSwautc20(1);
				 * aa00j20s01.setSwconf20(1); }
				 */

				// Actualizamos las observaciones
				// Actualizamos el asunto
				// Actualizamos la fecha y hora inicio y la fecha y hora fin
				ok = this.aa00j20s01Dao.actualizarDatos(aa00j20s01.getCod20(),
						aa00j20s01.getObs20(), aa00j20s01.getAsun20(),
						aa00j20s01.getDhcom20(), aa00j20s01.getDhfin20(),
						aa00j20s01.getSwfhor20(), aa00j20s01.getSwconf20(),
						aa00j20s01.getSwautc20(), aa00j20s01.getTlfno20());

				// Actualizamos los recursos fijos de la sala
				if (ok) {
					this.aa00j20s01Dao.removeAa00j21s01Reserva(aa00j20s01
							.getCod20());
					if (aa00j20s01.getAa00j12s01s() != null
							&& aa00j20s01.getAa00j12s01s().size() > 0) {
						this.aa00j20s01Dao.addAa00j21s01(aa00j20s01);
					}
				}

				/* COGEMOS LOS DATOS DE XLNETS */
				String correoReservador = "";
				String correoResponsable = "";
				aa00jPersonaXLNET reservador = new aa00jSeguridad()
						.getUsuario().getPersonaXLNET();
				aa00jPersonaXLNET responsable = null;
				if (ok) {
					// Rellenamos los datos del reservador
					correoReservador = reservador.getEMail();

					// Rellenamos los datos del responsable
					try {
						responsable = new SecurityHelpperXLNets()
								.getPersonasXLNETs(null, aa00j20s01.getDni20(),
										null, null, null).get(0);
						correoResponsable = responsable.getEMail();
					} catch (Exception e) {
					}
					//
				}

				// Actualizamos los recursos móviles del edificio
				if (ok) {
					this.aa00j30s01Dao.eliminarPorReservaSala(aa00j20s01
							.getCod20());

					if (aa00j20s01.getAa00j13s01s() != null
							&& aa00j20s01.getAa00j13s01s().size() > 0) {

						Aa00j30s01 aa00j30s01Aux = null;
						Aa00j30s01 aa00j30s01 = new Aa00j30s01();
						aa00j30s01.setDhcom30(aa00j20s01.getDhcom20());
						aa00j30s01.setDhfin30(aa00j20s01.getDhfin20());
						aa00j30s01.setAsun30(aa00j20s01.getAsun20());
						aa00j30s01.setSwfhor30(aa00j20s01.getSwfhor20());
						aa00j30s01.setOrgan30(aa00j20s01.getOrgan20());
						aa00j30s01.setReser30(aa00j20s01.getReser20());
						aa00j30s01.setTlfno30(aa00j20s01.getTlfno20());
						aa00j30s01.setSit30(aa00jConstantes.SITUACION_ALTA);
						aa00j30s01.setAa00j07s01ByCdep30(aa00j20s01
								.getAa00j07s01ByCdep20());
						aa00j30s01.setAnomd30(aa00j20s01.getAnomd20());
						// aa00j30s01.setDni30(aa00j20s01.getDni20());
						aa00j30s01.setTlfnor30(aa00j20s01.getTlfnor20());
						aa00j30s01.setAa00j07s01ByCdepr30(aa00j20s01
								.getAa00j07s01ByCdepr20());
						aa00j30s01.setAa00j20s01(aa00j20s01);
						aa00j30s01
								.setObs30("Reserva conjunta la reserva de sala número: "
										+ aa00j20s01.getCod20());

						for (Aa00j13s01 aa00j13s01 : aa00j20s01
								.getAa00j13s01s()) {
							aa00j30s01.setAa00j13s01(aa00j13s01);
							aa00j30s01Aux = this.aa00j30s01Dao.add(aa00j30s01);
							Aa00j20s01ServiceImpl.logger
									.info("reserva de recurso guardada (actualizar reserva sala) --> "
											+ aa00j30s01Aux.getCod30()
											+ " por: " + reservador.getCodigo());
							if (aa00j30s01Aux == null) {
								ok = false;
							}
						}
					}
				}

				if (!ok) {
					Aa00j20s01ServiceImpl.logger
							.info("reserva de sala actualizada ERROR --> "
									+ aa00j20s01.getCod20() + " por: "
									+ reservador.getCodigo());
					aa00j20s01.setPantallaMensajeError(this.appMessageSource
							.getMessage("etErrorAlActualizarReserva", null,
									LocaleContextHolder.getLocale()));
				} else {
					Aa00j20s01ServiceImpl.logger
							.info("reserva de sala actualizada --> "
									+ aa00j20s01.getCod20() + " por: "
									+ reservador.getCodigo());

					/* MANDAMOS LOS MAILS */
					Aa00j10s01 aa00j10s01Aux = this.aa00j10s01Dao
							.find(aa00j20s01.getAa00j10s01());
					StringBuffer codigos12 = new StringBuffer();
					if (aa00j20s01.getAa00j12s01s() != null
							&& aa00j20s01.getAa00j12s01s().size() > 0) {
						for (Aa00j12s01 aa00j12s01Aux : aa00j20s01
								.getAa00j12s01s()) {
							codigos12 = codigos12.append(",").append(
									aa00j12s01Aux.getCmedf12());
						}
					}
					StringBuffer codigos13 = new StringBuffer();
					if (aa00j20s01.getAa00j13s01s() != null
							&& aa00j20s01.getAa00j13s01s().size() > 0) {
						for (Aa00j13s01 aa00j13s01Aux : aa00j20s01
								.getAa00j13s01s()) {
							codigos13 = codigos13.append(",").append(
									aa00j13s01Aux.getCrec13());
						}
					}
					List<Aa00j12s01> aa00j12s01s = null;
					List<Aa00j13s01> aa00j13s01s = null;
					if (codigos12 != null && codigos12.length() > 0) {
						aa00j12s01s = this.aa00j12s01Dao
								.obtenerVarios(codigos12.substring(1));
					}
					if (codigos13 != null && codigos13.length() > 0) {
						aa00j13s01s = this.aa00j13s01Dao
								.obtenerVarios(codigos13.substring(1));
					}

					int mailsEnviados = this.comunReserva
							.enviarMailsModificarReserva(aa00j10s01Aux,
									correoReservador, correoResponsable,
									reservador, responsable,
									aa00j20s01.getAsun20(), aa00j12s01s,
									aa00j13s01s, aa00j20s01.getDias(),
									aa00j20s01.getHoraIniMostrar(),
									aa00j20s01.getHoraFinMostrar());
					if (mailsEnviados != aa00jConstantes.ENVIOMAL) {
						int env1 = 1;
						int env2 = 1;
						if (mailsEnviados == aa00jConstantes.ENVIOMALRESERVADOR)
							env1 = 0;
						else if (mailsEnviados == aa00jConstantes.ENVIOMALRESPONSABLE)
							env2 = 0;
						this.aa00j20s01Dao.actualizarMailsEnviados(
								aa00j20s01.getCod20(), env1, env2);
						this.aa00j30s01Dao.actualizarMailsEnviadosReservaSala(
								aa00j20s01.getCod20(), env1, env2);
					}
					/**/

					aa00j20s01.setPantallaMensaje("OK");
				}

				if (aa00j20s01.getPantallaMensaje() == null
						|| !aa00j20s01.getPantallaMensaje().equals("OK")) {
					throw new Exception();
				}

				Aa00j20s01ServiceImpl.logger.info("FIN Aa00j20s01.update");
				return aa00j20s01;
			} else {
				aa00j20s01.setPantallaMensajeError(disponibilidad);
				Aa00j20s01ServiceImpl.logger.info("FIN Aa00j20s01.update ");
				throw new Exception();
			}
		} catch (Exception e) {
			Aa00j20s01ServiceImpl.logger
					.error("ERROR en Aa00j20s01.update --> " + e.getMessage());
			if (aa00j20s01.getPantallaMensajeError() == null) {
				aa00j20s01.setPantallaMensajeError(this.appMessageSource
						.getMessage("etErrorAlActualizarReserva", null,
								LocaleContextHolder.getLocale()));
			}
			throw new MyRuntimeException(aa00j20s01.getPantallaMensajeError());
		}
	}

	/**
	 * Finds a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	public Aa00j20s01 find(Aa00j20s01 aa00j20s01) {
		return (Aa00j20s01) this.aa00j20s01Dao.find(aa00j20s01);
	}

	/**
	 * Deletes a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j20s01 aa00j20s01) {
		this.aa00j20s01Dao.remove(aa00j20s01);
	}

	/**
	 * Finds a list of rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j20s01>
	 */
	public List<Aa00j20s01> findAll(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codAux = "";
		String codDepto = "";
		String codUsuario = "";
		if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			codAux = aa00j20s01.getAa00j07s01ByCdep20().getCdep07() + "";
		}
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(
				aa00j20s01.getDepartamental(), codAux);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/

		return (List<Aa00j20s01>) this.aa00j20s01Dao.findAll(aa00j20s01,
				jqGridRequestDto, codDepto, codUsuario);
	}

	/**
	 * Finds rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j20s01>
	 */
	public List<Aa00j20s01> findAllLike(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codAux = "";
		String codDepto = "";
		String codUsuario = "";
		if (aa00j20s01.getAa00j07s01ByCdep20() != null) {
			codAux = aa00j20s01.getAa00j07s01ByCdep20().getCdep07() + "";
		}
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(
				aa00j20s01.getDepartamental(), codAux);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/

		return (List<Aa00j20s01>) this.aa00j20s01Dao.findAllLike(aa00j20s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario,
				LocaleContextHolder.getLocale());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa00j20s01Dao.removeMultiple(filterAa00j20s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j20s01>
	 */
	public JQGridResponseDto<Aa00j20s01> filter(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codAux = "";
		String codDepto = "";
		String codUsuario = "";
		if (filterAa00j20s01.getAa00j07s01ByCdep20() != null) {
			codAux = filterAa00j20s01.getAa00j07s01ByCdep20().getCdep07() + "";
		}
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(
				filterAa00j20s01.getDepartamental(), codAux);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/

		List<Aa00j20s01> listaAa00j20s01 = this.aa00j20s01Dao.findAllLike(
				filterAa00j20s01, jqGridRequestDto, false, codDepto,
				codUsuario, LocaleContextHolder.getLocale());
		Long recordNum = this.aa00j20s01Dao.findAllLikeCount(
				filterAa00j20s01 != null ? filterAa00j20s01 : new Aa00j20s01(),
				false, codDepto, codUsuario, LocaleContextHolder.getLocale());
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j20s01>> reorderSelection = this.aa00j20s01Dao
					.reorderSelection(filterAa00j20s01, jqGridRequestDto,
							startsWith, codDepto, codUsuario);
			return new JQGridResponseDto<Aa00j20s01>(jqGridRequestDto,
					recordNum, listaAa00j20s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j20s01>(jqGridRequestDto, recordNum,
				listaAa00j20s01);
	}

	/**
	 * Searches rows in the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param searchAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	public List<TableRowDto<Aa00j20s01>> search(Aa00j20s01 filterAa00j20s01,
			Aa00j20s01 searchAa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codAux = "";
		String codDepto = "";
		String codUsuario = "";
		if (filterAa00j20s01.getAa00j07s01ByCdep20() != null) {
			codAux = filterAa00j20s01.getAa00j07s01ByCdep20().getCdep07() + "";
		}
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(
				filterAa00j20s01.getDepartamental(), codAux);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/

		return this.aa00j20s01Dao.search(filterAa00j20s01, searchAa00j20s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario);
	}

	/**
	 * Reorder the selection made in Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		/* OBTENEMOS LOS DATOS DE XLNETS */
		String codAux = "";
		String codDepto = "";
		String codUsuario = "";
		if (filterAa00j20s01.getAa00j07s01ByCdep20() != null) {
			codAux = filterAa00j20s01.getAa00j07s01ByCdep20().getCdep07() + "";
		}
		String aux = this.comunReserva.obtenerDeptoCodUsuarioBusquedas(
				filterAa00j20s01.getDepartamental(), codAux);
		if (aux != null && aux.length() > 0) {
			String[] arrAux = aux.split("#");
			if (arrAux.length > 0) {
				codDepto = aux.split("#")[0];
			}
			if (arrAux.length > 1) {
				codUsuario = aux.split("#")[1];
			}
		}
		/**/

		return this.aa00j20s01Dao.reorderSelection(filterAa00j20s01,
				jqGridRequestDto, startsWith, codDepto, codUsuario);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquia(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j20s01>> listaAa00j20s01 = this.aa00j20s01Dao
				.findAllLikeJerarquia(filterAa00j20s01, jqGridRequestDto);
		Long recordNum = this.aa00j20s01Dao.findAllLikeCountJerarquia(
				filterAa00j20s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j20s01>>(
				jqGridRequestDto, recordNum, listaAa00j20s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquiaChildren(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j20s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j20s01Dao.findAllChild(filterAa00j20s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j20s01 addAa00j21s01(Aa00j20s01 aa00j20s01) {
		return this.aa00j20s01Dao.addAa00j21s01(aa00j20s01);
	}

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAa00j21s01(Aa00j20s01 aa00j20s01) {
		this.aa00j20s01Dao.removeAa00j21s01(aa00j20s01);
	}

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j20s01
	 */
	public Aa00j20s01 findAa00j21s01(Aa00j20s01 aa00j20s01,
			Aa00j12s01 aa00j12s01, Pagination pagination) {
		return this.aa00j20s01Dao.findAa00j21s01(aa00j20s01, aa00j12s01,
				pagination);
	}

	/**
	 * Counts rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Long
	 */
	public Long findAa00j21s01Count(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01) {
		return this.aa00j20s01Dao.findAa00j21s01Count(aa00j20s01, aa00j12s01);
	}

	public boolean existeSalaDisponible(Long csala20, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir) {
		return this.aa00j20s01Dao.existeSalaDisponible(csala20, fechaHoraIni,
				fechaHoraFin, codReservaExcluir);
	}

	public List<Aa00j20s01> obtenerOcupacionesFechas(Long csala20,
			Date fechaHoraIni, Date fechaHoraFin, Long codReservaExcluir) {
		return (List<Aa00j20s01>) this.aa00j20s01Dao.obtenerOcupacionesFechas(
				csala20, fechaHoraIni, fechaHoraFin, codReservaExcluir);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Aa00j20s01 guardarReserva(Aa00j20s01 aa00j20s01) {
		try {
			Aa00j20s01ServiceImpl.logger
					.info("INICIO Aa00j20s01.guardarReserva ");

			ArrayList<Long> codigosReservaSalaCreados = new ArrayList<Long>();

			aa00j20s01.setPantallaMensaje("");
			aa00j20s01.setPantallaMensajeError("");
			aa00j20s01.setPantallaMensajeOk("");

			aa00j20s01.setSit20(aa00jConstantes.SITUACION_ALTA);

			String disponibilidad = this.comunReserva.comprobarCampos(
					aa00j20s01.getDias(), aa00j20s01.getHoraIni(),
					aa00j20s01.getHoraFin());

			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva.comprobarDisponibilidad(
						aa00j20s01, new aa00jSeguridad().getUsuario(), null);
			}
			if (disponibilidad.isEmpty()) {
				disponibilidad = this.comunReserva
						.comprobarDisponibilidadRecursos(
								aa00j20s01.getAa00j13s01s(),
								aa00j20s01.getDias(), aa00j20s01.getHoraIni(),
								aa00j20s01.getHoraFin(),
								new aa00jSeguridad().getUsuario(), null, null);
			}

			if (disponibilidad.isEmpty()) {

				// En las observaciones ponemos
				if (aa00j20s01.getIp20() == null) {
					aa00j20s01.setIp20("-");
				}
				StringBuffer observaciones = new StringBuffer();
				String numAsistentes = "-";
				String numAsistentesEnCabecera = "-";
				// String ipEquipoInformatico = "-";
				if (aa00j20s01.getNumAsistentes() != null) {
					numAsistentes = aa00j20s01.getNumAsistentes().toString();
				}
				if (aa00j20s01.getNumAsistentesEnCabecera() != null) {
					numAsistentesEnCabecera = aa00j20s01
							.getNumAsistentesEnCabecera().toString();
				}
				// if (aa00j20s01.getIp20() != null) {
				// ipEquipoInformatico = aa00j20s01.getIp20().toString();
				// }
				boolean ponerComa = false;
				if (LocaleContextHolder.getLocale().getLanguage().toUpperCase()
						.equals("EU")) {
					if (!numAsistentes.equals("-")) {
						observaciones.append("Bertatuak: ").append(
								numAsistentes);
						ponerComa = true;
					}
					if (!numAsistentesEnCabecera.equals("-")) {
						if (ponerComa)
							observaciones.append(". ");
						observaciones.append("Goialdean: ")
								.append(numAsistentesEnCabecera).append(".");
					}
					// observaciones.append(" Ekipo informatikoaren IP: ").append(
					// ipEquipoInformatico);
				} else {
					if (!numAsistentes.equals("-")) {
						observaciones.append("Asistentes: ").append(
								numAsistentes);
						ponerComa = true;
					}
					if (!numAsistentesEnCabecera.equals("-")) {
						if (ponerComa)
							observaciones.append(". ");
						observaciones.append("En cabecera: ")
								.append(numAsistentesEnCabecera).append(".");
					}
					// observaciones.append(" IP del equipo informático: ")
					// .append(ipEquipoInformatico);
				}
				aa00j20s01.setObs20(observaciones.toString());

				/* COGEMOS LOS DATOS DE XLNETS */
				String correoReservador = "";
				String correoResponsable = "";

				// Rellenamos los datos del reservador
				aa00jPersonaXLNET reservador = new aa00jSeguridad()
						.getUsuario().getPersonaXLNET();
				aa00j20s01.setOrgan20(reservador.getCodigo());
				aa00j20s01.setReser20(reservador.getApellidos() + ", "
						+ reservador.getNombre());
				// Ahora el teléfono viene desde el formulario

				// aa00j20s01.setTlfno20(reservador.getTelefono());
				long codDepto = this.aa00j07s01Dao
						.obtenerCodigoPorXlnet(reservador.getCodDepto());
				if (codDepto > 0) {
					aa00j20s01.setAa00j07s01ByCdep20(new Aa00j07s01(codDepto));
				}
				correoReservador = reservador.getEMail();

				// Rellenamos los datos del responsable
				aa00jPersonaXLNET responsable = null;
				long codDeptoResponsable = -1;
				try {
					responsable = new SecurityHelpperXLNets()
							.getPersonasXLNETs(aa00j20s01.getDni20(), null,
									null, null, null).get(0);
					aa00j20s01.setAnomd20(responsable.getApellidos() + ", "
							+ responsable.getNombre());
					aa00j20s01.setDni20(aa00j20s01.getDni20());
					aa00j20s01.setTlfnor20(responsable.getTelefono());
					codDeptoResponsable = this.aa00j07s01Dao
							.obtenerCodigoPorXlnet(responsable.getCodDepto());
					if (codDeptoResponsable > 0) {
						aa00j20s01.setAa00j07s01ByCdepr20(new Aa00j07s01(
								codDeptoResponsable));
					}
					correoResponsable = responsable.getEMail();
				} catch (Exception e) {
				}
				//

				/**/

				Aa00j20s01 aa00j20s01Aux = null;
				Calendar cIni;
				Calendar cFin;
				String fechas = aa00j20s01.getDias();
				for (String fecha : fechas.split(",")) {
					cIni = this.comunReserva.obtenerFechaHora(fecha,
							aa00j20s01.getHoraIni());
					cFin = this.comunReserva.obtenerFechaHora(fecha,
							aa00j20s01.getHoraFin());

					aa00j20s01.setDhcom20(new Date(cIni.getTimeInMillis()));
					aa00j20s01.setDhfin20(new Date(cFin.getTimeInMillis()));

					if (this.comunReserva.comprobarFueraDeHorario(cIni, cFin,
							aa00j20s01.getAa00j10s01().getAa00j03s01()
									.getCedif03().intValue())) {
						aa00j20s01.setSwfhor20(1);
					} else {
						aa00j20s01.setSwfhor20(0);
					}

					if (aa00j20s01.getNecesariaConfirmacion() != null) {
						aa00j20s01.setSwautc20(0);
						if (this.comunReserva.esAntesDe15Dias(cIni)) {
							aa00j20s01.setSwconf20(1);
						} else {
							aa00j20s01.setSwconf20(0);
						}
					} else {
						aa00j20s01.setSwautc20(1);
						aa00j20s01.setSwconf20(1);
					}
					aa00j20s01.setEmail20(correoReservador);
					aa00j20s01.setEmailr20(correoResponsable);

					// Añadimos la reserva
					aa00j20s01Aux = this.aa00j20s01Dao.add(aa00j20s01);
					aa00j20s01.setCod20(aa00j20s01Aux.getCod20());

					/**/
					codigosReservaSalaCreados.add(aa00j20s01.getCod20());
					Aa00j20s01ServiceImpl.logger
							.info("reserva de sala guardada --> "
									+ aa00j20s01.getCod20() + " por: "
									+ reservador.getCodigo());
					/**/

					// Añadimos los medios fijos reservados
					this.aa00j20s01Dao.addAa00j21s01(aa00j20s01);

					// Añadimos los medios móviles reservados
					if (aa00j20s01.getAa00j13s01s() != null
							&& aa00j20s01.getAa00j13s01s().size() > 0) {

						Aa00j30s01 aa00j30s01Aux = null;
						Aa00j30s01 aa00j30s01 = new Aa00j30s01();
						aa00j30s01.setDhcom30(aa00j20s01.getDhcom20());
						aa00j30s01.setDhfin30(aa00j20s01.getDhfin20());
						aa00j30s01.setAsun30(aa00j20s01.getAsun20());
						aa00j30s01.setSwfhor30(aa00j20s01.getSwfhor20());
						aa00j30s01.setOrgan30(aa00j20s01.getOrgan20());
						aa00j30s01.setReser30(aa00j20s01.getReser20());
						aa00j30s01.setTlfno30(aa00j20s01.getTlfno20());
						aa00j30s01.setSit30(aa00jConstantes.SITUACION_ALTA);
						aa00j30s01.setEmail30(correoReservador);
						aa00j30s01.setEmailr30(correoResponsable);
						// // Comentar
						// para que
						// pete
						if (codDepto > 0) {
							aa00j30s01.setAa00j07s01ByCdep30(new Aa00j07s01(
									codDepto));
						}
						aa00j30s01.setAnomd30(aa00j20s01.getAnomd20());
						aa00j30s01.setCresp30(aa00j20s01.getDni20());
						aa00j30s01.setTlfnor30(aa00j20s01.getTlfnor20());
						if (codDeptoResponsable > 0) {
							aa00j30s01.setAa00j07s01ByCdepr30(new Aa00j07s01(
									codDeptoResponsable));
						}
						aa00j30s01.setAa00j20s01(aa00j20s01);
						aa00j30s01
								.setObs30("Reserva conjunta la reserva de sala número: "
										+ aa00j20s01.getCod20());

						for (Aa00j13s01 aa00j13s01 : aa00j20s01
								.getAa00j13s01s()) {
							aa00j30s01.setAa00j13s01(aa00j13s01); // Comentar
																	// para que
																	// pete
							aa00j30s01Aux = this.aa00j30s01Dao.add(aa00j30s01);
							Aa00j20s01ServiceImpl.logger
									.info("reserva de recurso guardada --> "
											+ aa00j30s01Aux.getCod30()
											+ " por: " + reservador.getCodigo());
							if (aa00j30s01Aux == null) {
								aa00j20s01Aux = null;
							}
						}
					}
				}
				if (aa00j20s01Aux == null) {
					aa00j20s01.setPantallaMensajeError(this.appMessageSource
							.getMessage("etErrorAlReservarSala", null,
									LocaleContextHolder.getLocale()));
				} else {

					/* MANDAMOS LOS MAILS */
					Aa00j10s01 aa00j10s01Aux = this.aa00j10s01Dao
							.find(aa00j20s01.getAa00j10s01());
					StringBuffer codigos12 = new StringBuffer();
					if (aa00j20s01.getAa00j12s01s() != null
							&& aa00j20s01.getAa00j12s01s().size() > 0) {
						for (Aa00j12s01 aa00j12s01Aux : aa00j20s01
								.getAa00j12s01s()) {
							codigos12 = codigos12.append(",").append(
									aa00j12s01Aux.getCmedf12());
						}
					}
					StringBuffer codigos13 = new StringBuffer();
					if (aa00j20s01.getAa00j13s01s() != null
							&& aa00j20s01.getAa00j13s01s().size() > 0) {
						for (Aa00j13s01 aa00j13s01Aux : aa00j20s01
								.getAa00j13s01s()) {
							codigos13 = codigos13.append(",").append(
									aa00j13s01Aux.getCrec13());
						}
					}
					List<Aa00j12s01> aa00j12s01s = null;
					List<Aa00j13s01> aa00j13s01s = null;
					if (codigos12 != null && codigos12.length() > 0) {
						aa00j12s01s = this.aa00j12s01Dao
								.obtenerVarios(codigos12.substring(1));
					}
					if (codigos13 != null && codigos13.length() > 0) {
						aa00j13s01s = this.aa00j13s01Dao
								.obtenerVarios(codigos13.substring(1));
					}

					int mailsEnviados = this.comunReserva
							.enviarMailsNuevaReserva(aa00j10s01Aux,
									correoReservador, correoResponsable,
									reservador, responsable,
									aa00j20s01.getAsun20(), aa00j12s01s,
									aa00j13s01s, aa00j20s01.getDias(),
									aa00j20s01.getHoraIniMostrar(),
									aa00j20s01.getHoraFinMostrar());
					if (mailsEnviados != aa00jConstantes.ENVIOMAL) {
						int env1 = 1;
						int env2 = 1;
						if (mailsEnviados == aa00jConstantes.ENVIOMALRESERVADOR)
							env1 = 0;
						else if (mailsEnviados == aa00jConstantes.ENVIOMALRESPONSABLE)
							env2 = 0;
						for (Long codRS : codigosReservaSalaCreados) {
							this.aa00j20s01Dao.actualizarMailsEnviados(codRS,
									env1, env2);
							this.aa00j30s01Dao
									.actualizarMailsEnviadosReservaSala(codRS,
											env1, env2);
						}
					}
					/**/

					aa00j20s01.setPantallaMensaje("OK");

					// INI: PARA EL TEXTO DE LA RESERVA
					String telefono = "";
					String textoReserva = "";
					Aa00j10s01 aa00j10s01 = this.aa00j10s01Dao
							.find(new Aa00j10s01(aa00j20s01Aux.getAa00j10s01()
									.getCsala10()));

					if (aa00j10s01 != null && aa00j10s01.getTlfno10() != null) {
						telefono = aa00j10s01.getTlfno10();
					} else if (aa00j10s01 != null
							&& aa00j10s01.getAa00j03s01() != null
							&& aa00j10s01.getAa00j03s01().getTlfno03() != null) {
						telefono = aa00j10s01.getAa00j03s01().getTlfno03();
					}

					if (aa00j10s01 != null
							&& aa00j10s01.getAa00j04s01() != null
							&& aa00j10s01.getAa00j04s01().getCtexto04() != null
							&& aa00j10s01.getAa00j04s01().getCtexto04() > 0) {
						if (LocaleContextHolder.getLocale().getLanguage()
								.toUpperCase().equals("EU")) {
							textoReserva = aa00j10s01.getAa00j04s01()
									.getTrese04();
						} else {
							textoReserva = aa00j10s01.getAa00j04s01()
									.getTresc04();
						}
					}
					if (textoReserva == null || textoReserva.length() == 0) {
						Aa00j04s01 aa00j04s01 = this.aa00j04s01Dao
								.find(new Aa00j04s01((long) 1));
						if (aa00j04s01 != null) {
							if (LocaleContextHolder.getLocale().getLanguage()
									.toUpperCase().equals("EU")) {
								textoReserva = aa00j04s01.getTrese04();
							} else {
								textoReserva = aa00j04s01.getTresc04();
							}
						}
					}

					textoReserva = textoReserva.replace(":1", telefono);
					textoReserva = textoReserva.replace("\r\n", "\n");
					textoReserva = textoReserva.replace("\n", "<br/>");
					aa00j20s01.setPantallaMensajeOk(textoReserva);
					// FIN: PARA EL TEXTO DE LA RESERVA
				}

				if (aa00j20s01.getPantallaMensaje() == null
						|| !aa00j20s01.getPantallaMensaje().equals("OK")) {
					throw new Exception();
				}

				Aa00j20s01ServiceImpl.logger
						.info("FIN Aa00j20s01.guardarReserva ");
				return aa00j20s01;
			} else {
				aa00j20s01.setPantallaMensajeError(disponibilidad);
				Aa00j20s01ServiceImpl.logger
						.info("FIN Aa00j20s01.guardarReserva ");
				throw new Exception();
			}
		} catch (Exception e) {
			Aa00j20s01ServiceImpl.logger
					.error("ERROR en Aa00j20s01.guardarReserva --> "
							+ e.getMessage());
			if (aa00j20s01.getPantallaMensajeError() == null) {
				aa00j20s01.setPantallaMensajeError(this.appMessageSource
						.getMessage("etErrorAlReservarSala", null,
								LocaleContextHolder.getLocale()));
			}
			throw new MyRuntimeException(aa00j20s01.getPantallaMensajeError());
		}
	}

	public boolean bloquear(Long cod20) {

		return this.comunDao.bloquear("cod20", cod20.toString());
	}

	public boolean bloquearSiAlta(Long cod20) {

		return this.comunDao.bloquearSiAlta("cod20", cod20.toString());
	}

	public boolean desbloquear(Long cod20) {

		return this.comunDao.desbloquear("cod20", cod20.toString());
	}

	public String[] anular(List<String> codigosReservas) {
		Aa00j20s01ServiceImpl.logger.info("INICIO Aa00j20s01.anular");
		String[] retorno = new String[2];
		try {
			aa00jPersonaXLNET reservador = new aa00jSeguridad().getUsuario()
					.getPersonaXLNET();
			String usuario = reservador.getCodigo();

			StringBuffer ret = new StringBuffer();
			StringBuffer yaAnuladas = new StringBuffer();
			StringBuffer errorAnular = new StringBuffer();
			StringBuffer ok = new StringBuffer();

			boolean anulada = false;
			if (codigosReservas != null && codigosReservas.size() > 0) {

				for (String codigo : codigosReservas) {
					anulada = this.aa00j20s01Dao.anular(Long.parseLong(codigo),
							usuario);
					this.aa00j30s01Dao.anularPorReservaSala(
							Long.parseLong(codigo), usuario);
					if (anulada) {
						Aa00j20s01ServiceImpl.logger
								.info("Se ha anulado la reserva de la sala: "
										+ codigo
										+ " y todas sus reservas de recursos generales asociadas. Usuario de anulación: "
										+ usuario);
						ok.append(",").append(codigo);

						Aa00j20s01 aa00j20s01Aux = new Aa00j20s01(
								Long.parseLong(codigo));
						aa00j20s01Aux = this.aa00j20s01Dao.find(aa00j20s01Aux);

						// OBTENEMOS LOS DATOS DE LOS CORREOS DE XLNETS
						String correoReservador = reservador.getEMail();
						String correoResponsable = "";
						try {
							aa00jPersonaXLNET responsable = new SecurityHelpperXLNets()
									.getPersonasXLNETs(
											aa00j20s01Aux.getAnomd20(), null,
											null, null, null).get(0);
							correoResponsable = responsable.getEMail();
						} catch (Exception e) {
						}
						//
						/* MANDAMOS LOS MAILS */
						this.comunReserva.enviarMailsAnulacionReserva(
								aa00j20s01Aux.getAa00j10s01(),
								correoReservador, correoResponsable,
								aa00j20s01Aux.getAsun20(),
								aa00j20s01Aux.getDiaMostrar(),
								aa00j20s01Aux.getHoraIniMostrar(),
								aa00j20s01Aux.getHoraFinMostrar());
						/**/
					} else {
						Aa00j20s01 aa00j20s01Aux = new Aa00j20s01(
								Long.parseLong(codigo));
						aa00j20s01Aux = this.aa00j20s01Dao.find(aa00j20s01Aux);
						if (aa00j20s01Aux.getSit20().equals(
								aa00jConstantes.SITUACION_BAJA)) {
							yaAnuladas = yaAnuladas.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						} else {
							errorAnular = errorAnular.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						}
					}
				}
			}

			if (yaAnuladas != null && yaAnuladas.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasAnuladas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(yaAnuladas);
			}
			if (errorAnular != null && errorAnular.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorAlAnularReservas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(errorAnular);
			}

			retorno[0] = ret.toString();
			if (ok.length() > 0) {
				retorno[1] = ok.substring(1);
			} else {
				retorno[1] = "";
			}

		} catch (Exception e) {
			Aa00j20s01ServiceImpl.logger
					.error("ERROR en Aa00j20s01.anular --> " + e.getMessage());
			retorno[0] = this.appMessageSource.getMessage(
					"etErrorAlAnularReserva", null,
					LocaleContextHolder.getLocale());
			retorno[1] = "";
		}

		Aa00j20s01ServiceImpl.logger.info("FIN Aa00j20s01.anular");

		return retorno;
	}

	public String[] borrar(List<String> codigosReservas) {
		Aa00j20s01ServiceImpl.logger.info("INICIO Aa00j20s01.borrar");
		String[] retorno = new String[2];
		try {
			aa00jPersonaXLNET reservador = new aa00jSeguridad().getUsuario()
					.getPersonaXLNET();
			String usuario = reservador.getCodigo();

			StringBuffer ret = new StringBuffer();
			StringBuffer yaAnuladas = new StringBuffer();
			StringBuffer errorAnular = new StringBuffer();
			StringBuffer ok = new StringBuffer();

			boolean anulada = false;
			if (codigosReservas != null && codigosReservas.size() > 0) {

				for (String codigo : codigosReservas) {
					Aa00j20s01 aa00j20s01Aux = new Aa00j20s01(
							Long.parseLong(codigo));
					aa00j20s01Aux = this.aa00j20s01Dao.find(aa00j20s01Aux);

					this.aa00j30s01Dao.eliminarPorReservaSala(Long
							.parseLong(codigo));
					this.aa00j20s01Dao.removeAa00j21s01Reserva(Long
							.parseLong(codigo));
					anulada = this.aa00j20s01Dao.borrar(Long.parseLong(codigo));

					if (anulada) {
						Aa00j20s01ServiceImpl.logger
								.info("Se ha borrado la reserva de la sala: "
										+ codigo
										+ " y todas sus reservas de recursos generales asociadas. Usuario de anulación: "
										+ usuario);
						ok.append(",").append(codigo);

						// OBTENEMOS LOS DATOS DE LOS CORREOS DE XLNETS
						String correoReservador = reservador.getEMail();
						String correoResponsable = "";
						try {
							aa00jPersonaXLNET responsable = new SecurityHelpperXLNets()
									.getPersonasXLNETs(
											aa00j20s01Aux.getAnomd20(), null,
											null, null, null).get(0);
							correoResponsable = responsable.getEMail();
						} catch (Exception e) {
						}
						//
						/* MANDAMOS LOS MAILS */
						this.comunReserva.enviarMailsAnulacionReserva(
								aa00j20s01Aux.getAa00j10s01(),
								correoReservador, correoResponsable,
								aa00j20s01Aux.getAsun20(),
								aa00j20s01Aux.getDiaMostrar(),
								aa00j20s01Aux.getHoraIniMostrar(),
								aa00j20s01Aux.getHoraFinMostrar());
						/**/
					} else {

						if (aa00j20s01Aux.getSit20().equals(
								aa00jConstantes.SITUACION_BAJA)) {
							yaAnuladas = yaAnuladas.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						} else {
							errorAnular = errorAnular.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						}
					}
				}
			}

			if (yaAnuladas != null && yaAnuladas.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasAnuladas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(yaAnuladas);
			}
			if (errorAnular != null && errorAnular.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorAlAnularReservas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(errorAnular);
			}

			retorno[0] = ret.toString();
			if (ok.length() > 0) {
				retorno[1] = ok.substring(1);
			} else {
				retorno[1] = "";
			}

		} catch (Exception e) {
			Aa00j20s01ServiceImpl.logger
					.error("ERROR en Aa00j20s01.anular --> " + e.getMessage());
			retorno[0] = this.appMessageSource.getMessage(
					"etErrorAlAnularReserva", null,
					LocaleContextHolder.getLocale());
			retorno[1] = "";
		}

		Aa00j20s01ServiceImpl.logger.info("FIN Aa00j20s01.anular");

		return retorno;
	}

	public String[] confirmar(List<String> codigosReservas) {
		Aa00j20s01ServiceImpl.logger.info("INICIO Aa00j20s01.confirmar");
		String[] retorno = new String[2];
		try {
			aa00jPersonaXLNET reservador = new aa00jSeguridad().getUsuario()
					.getPersonaXLNET();
			String usuario = reservador.getCodigo();

			StringBuffer ret = new StringBuffer();
			StringBuffer anuladas = new StringBuffer();
			StringBuffer yaConfirmadas = new StringBuffer();
			StringBuffer antesQuinceDias = new StringBuffer();
			StringBuffer errorConfirmar = new StringBuffer();
			StringBuffer ok = new StringBuffer();

			boolean confirmada = false;
			if (codigosReservas != null && codigosReservas.size() > 0) {

				for (String codigo : codigosReservas) {

					confirmada = this.aa00j20s01Dao
							.confirmarSiQuinceDiasOMenos(
									Long.parseLong(codigo), usuario);
					// this.aa00j30s01Dao.confirmar(Long.parseLong(codigo),
					// usuario);
					if (confirmada) {
						Aa00j20s01ServiceImpl.logger
								.info("Se ha confirmado la reserva de la sala: "
										+ codigo
										+ " y todas sus reservas de recursos generales asociadas. Usuario de confirmación: "
										+ usuario);
						ok.append(",").append(codigo);

						Aa00j20s01 aa00j20s01Aux = new Aa00j20s01(
								Long.parseLong(codigo));
						aa00j20s01Aux = this.aa00j20s01Dao.find(aa00j20s01Aux);

						// OBTENEMOS LOS DATOS DE LOS CORREOS DE XLNETS
						String correoReservador = reservador.getEMail();
						String correoResponsable = "";
						try {
							aa00jPersonaXLNET responsable = new SecurityHelpperXLNets()
									.getPersonasXLNETs(
											aa00j20s01Aux.getAnomd20(), null,
											null, null, null).get(0);
							correoResponsable = responsable.getEMail();
						} catch (Exception e) {
						}
						//
						/* MANDAMOS LOS MAILS */
						this.comunReserva.enviarMailsConfirmacionReserva(
								aa00j20s01Aux.getAa00j10s01(),
								correoReservador, correoResponsable,
								aa00j20s01Aux.getAsun20(),
								aa00j20s01Aux.getDiaMostrar(),
								aa00j20s01Aux.getHoraIniMostrar(),
								aa00j20s01Aux.getHoraFinMostrar());
						/**/
					} else {
						Aa00j20s01 aa00j20s01Aux = new Aa00j20s01(
								Long.parseLong(codigo));
						aa00j20s01Aux = this.aa00j20s01Dao.find(aa00j20s01Aux);
						if (aa00j20s01Aux.getSit20().equals(
								aa00jConstantes.SITUACION_BAJA)) {
							anuladas = anuladas.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						} else if (aa00j20s01Aux.getSwconf20().equals(1)) {
							yaConfirmadas = yaConfirmadas.append(this
									.textoDetalleReserva(aa00j20s01Aux));
						} else {
							Calendar c = Calendar.getInstance();
							c.setTime(aa00j20s01Aux.getDhcom20());
							if (!this.comunReserva.esAntesDe15Dias(c)) {
								antesQuinceDias = antesQuinceDias.append(this
										.textoDetalleReserva(aa00j20s01Aux));
							} else {
								errorConfirmar = errorConfirmar.append(this
										.textoDetalleReserva(aa00j20s01Aux));
							}
						}
					}
				}
			}

			if (anuladas != null && anuladas.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasConfirmarAnuladas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(anuladas);
			}
			if (yaConfirmadas != null && yaConfirmadas.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasConfirmarConfirmadas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(yaConfirmadas);
			}
			if (antesQuinceDias != null && antesQuinceDias.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorReservasConfirmarAntesQuinceDias", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(antesQuinceDias);
			}
			if (errorConfirmar != null && errorConfirmar.length() > 0) {
				if (ret.length() > 0) {
					ret = ret.append("<br/>");
				}
				ret = ret.append(this.appMessageSource.getMessage(
						"etErrorAlConfirmarReservas", null,
						LocaleContextHolder.getLocale()));
				ret = ret.append("<br/>");
				ret = ret.append(errorConfirmar);
			}

			retorno[0] = ret.toString();
			if (ok.length() > 0) {
				retorno[1] = ok.substring(1);
			} else {
				retorno[1] = "";
			}

		} catch (Exception e) {
			Aa00j20s01ServiceImpl.logger
					.error("ERROR en Aa00j20s01.confirmar --> "
							+ e.getMessage());
			retorno[0] = this.appMessageSource.getMessage(
					"etErrorAlConfirmarReserva", null,
					LocaleContextHolder.getLocale());
			retorno[1] = "";
		}

		Aa00j20s01ServiceImpl.logger.info("FIN Aa00j20s01.confirmar");

		return retorno;
	}

	private StringBuffer textoDetalleReserva(Aa00j20s01 aa00j20s01) {
		return new StringBuffer()
				.append("-")
				.append(aa00j20s01.getAa00j10s01().getNombre10())
				.append(", ")
				.append(this.appMessageSource.getMessage("etDia", null,
						LocaleContextHolder.getLocale()))
				.append(" ")
				.append(aa00j20s01.getDiaMostrar())
				.append(", ")
				.append(this.appMessageSource.getMessage("etDe", null,
						LocaleContextHolder.getLocale()))
				.append(" ")
				.append(aa00j20s01.getHoraIniMostrar())
				.append(" ")
				.append(this.appMessageSource.getMessage("etA", null,
						LocaleContextHolder.getLocale())).append(" ")
				.append(aa00j20s01.getHoraFinMostrar()).append("<br/>");
	}

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada para la sala de
	 * entrada
	 * 
	 * @param csala20
	 * @param departamento
	 * @param edificio
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j20s01> obtenerOcupacionesSalaFechas(Long csala20,
			Long departamento, Long edificio, ArrayList<Date> fechas) {
		Aa00j20s01ServiceImpl.logger.info("obtenerOcupacionesSalaFechas");
		return this.aa00j20s01Dao.obtenerOcupacionesSalaFechas(csala20,
				departamento, edificio, fechas);
	}

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public JQGridResponseDto<Aa00j20s01> obtenerOcupacionesSinConfirmar(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto) {
		List<Aa00j20s01> lista = this.aa00j20s01Dao
				.obtenerOcupacionesSinConfirmar(dias, sala, departamento,
						edificio, jqGridRequestDto);

		Long recordNum = this.aa00j20s01Dao.obtenerOcupacionesSinConfirmarNum(
				dias, sala, departamento, edificio);

		return new JQGridResponseDto<Aa00j20s01>(jqGridRequestDto, recordNum,
				lista);
	}

	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar() {
		ArrayList<Aa00j20s01> lista = this.aa00j20s01Dao
				.obtenerOcupacionesSinConfirmar();

		return lista;
	}

	/**
	 * Devuelve una lista de reservas anuladas para una sala y el usuario (si el
	 * usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public JQGridResponseDto<Aa00j20s01> obtenerOcupacionesAnuladas(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto) {
		List<Aa00j20s01> lista = this.aa00j20s01Dao.obtenerAnuladas(dias, sala,
				departamento, edificio, jqGridRequestDto);

		Long recordNum = this.aa00j20s01Dao.obtenerAnuladasNum(dias, sala,
				departamento, edificio);

		return new JQGridResponseDto<Aa00j20s01>(jqGridRequestDto, recordNum,
				lista);
	}

	/**
	 * Marca el campo mensaje como enviado en la reserva
	 * 
	 * @param cod20
	 * @return
	 */
	public boolean marcarEnviado(Long cod20) {
		return this.aa00j20s01Dao.marcarEnviado(cod20);
	}

	public boolean marcarEnviado(Long cod20, Integer reservador,
			Integer responsable) {
		return this.aa00j20s01Dao.actualizarMailsEnviados(cod20, reservador,
				responsable);
	}

	/**
	 * Dar de baja reservas sin confirmar con fecha menor o igual a la actual
	 * que no estén confirmadas, estén de alta y se les haya enviado un mail
	 * para que confirmen
	 * 
	 * @return
	 */
	public int darDeBajaAntiguas() {
		return this.aa00j20s01Dao.darDeBajaAntiguas();

	}

	/**
	 * Devuelve una lista de reservas para una sala que hay que anular(sin
	 * confirmar con fecha anterior o igual a hoy
	 * 
	 * 
	 * 
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesAanular() {
		return this.aa00j20s01Dao.obtenerOcupacionesAanular();
	}

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j20s01> obtenerReservasSinEnviar() {
		return this.aa00j20s01Dao.obtenerReservasSinEnviar();
	}
}