package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j20s01Service generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j20s01Service {

	/**
	 * Inserts a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 add(Aa00j20s01 aa00j20s01);

	/**
	 * Updates a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 update(Aa00j20s01 aa00j20s01);

	/**
	 * Finds a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 find(Aa00j20s01 aa00j20s01);

	/**
	 * Deletes a single row in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 */
	void remove(Aa00j20s01 aa00j20s01);

	/**
	 * Finds a list of rows in the Aa00j20s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j20s01>
	 */
	List<Aa00j20s01> findAll(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa00j20s01 table using like.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j20s01>
	 */
	List<Aa00j20s01> findAllLike(Aa00j20s01 aa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Filter method in the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j20s01>
	 */
	JQGridResponseDto<Aa00j20s01> filter(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param searchAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j20s01>>
	 */
	List<TableRowDto<Aa00j20s01>> search(Aa00j20s01 filterAa00j20s01,
			Aa00j20s01 searchAa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa00j20s01 filterAa00j20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquia(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j20s01 table.
	 * 
	 * @param filterAa00j20s01
	 *            Aa00j20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j20s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j20s01>> jerarquiaChildren(
			Aa00j20s01 filterAa00j20s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Aa00j20s01
	 */
	Aa00j20s01 addAa00j21s01(Aa00j20s01 aa00j20s01);

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 */
	void removeAa00j21s01(Aa00j20s01 aa00j20s01);

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j20s01
	 */
	Aa00j20s01 findAa00j21s01(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01,
			Pagination pagination);

	/**
	 * Counts rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return List
	 */
	Long findAa00j21s01Count(Aa00j20s01 aa00j20s01, Aa00j12s01 aa00j12s01);

	boolean existeSalaDisponible(Long csala20, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir);

	List<Aa00j20s01> obtenerOcupacionesFechas(Long csala20, Date fechaHoraIni,
			Date fechaHoraFin, Long codReservaExcluir);

	Aa00j20s01 guardarReserva(Aa00j20s01 aa00j20s01);

	boolean bloquear(Long cod20);

	boolean bloquearSiAlta(Long cod20);

	boolean desbloquear(Long cod20);

	String[] anular(List<String> codigosReservas);

	String[] borrar(List<String> codigosReservas);

	String[] confirmar(List<String> codigosReservas);

	/**
	 * Devuelve la lista de ocupaciones en las fechas de entrada para la sala de
	 * entrada
	 * 
	 * @param csala20
	 * @param departamento
	 * @param edificio
	 * @param fechas
	 * 
	 * @return
	 */
	public List<Aa00j20s01> obtenerOcupacionesSalaFechas(Long csala20,
			Long departamento, Long edificio, ArrayList<Date> fechas);

	/**
	 * Devuelve una lista de reservas para una sala sin confirmar y en alta para
	 * el usuario (si el usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public JQGridResponseDto<Aa00j20s01> obtenerOcupacionesSinConfirmar(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto);

	/**
	 * Devuelve una lista de reservas anuladas para una sala y el usuario (si el
	 * usuario es tecnico, se devuelven todas)
	 * 
	 * @param dias
	 * @param sala
	 * @param departamento
	 * @param edificio
	 * @return
	 */
	public JQGridResponseDto<Aa00j20s01> obtenerOcupacionesAnuladas(
			ArrayList<Date> dias, Integer sala, Integer departamento,
			Integer edificio, JQGridRequestDto jqGridRequestDto);

	public ArrayList<Aa00j20s01> obtenerOcupacionesSinConfirmar();

	/**
	 * Marca el campo mensaje como enviado en la reserva
	 * 
	 * @param cod20
	 * @return
	 */
	public boolean marcarEnviado(Long cod20);

	/**
	 * Marca el campo mensaje como enviado en la reserva
	 * 
	 * @param cod20
	 * @return
	 */
	public boolean marcarEnviado(Long cod20, Integer reservador,
			Integer responsable);

	/**
	 * Dar de baja reservas sin confirmar con fecha menor o igual a la actual
	 * que no estén confirmadas, estén de alta y se les haya enviado un mail
	 * para que confirmen
	 * 
	 * @return
	 */
	public int darDeBajaAntiguas();

	/**
	 * Devuelve una lista de reservas para una sala que hay que anular(sin
	 * confirmar con fecha anterior o igual a hoy
	 * 
	 * 
	 * 
	 * 
	 * @return
	 */
	public ArrayList<Aa00j20s01> obtenerOcupacionesAanular();

	/**
	 * Devuelve una lista de reservas que tengan alguno de los estados de mail
	 * sin enviar
	 * 
	 * @return
	 */

	public ArrayList<Aa00j20s01> obtenerReservasSinEnviar();
}