package com.ejie.aa00j.service;

import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.dao.Aa00j15s01Dao;
import com.ejie.aa00j.model.Aa00j15s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j15s01ServiceImpl generated by UDA, 20-mar-2014 15:55:00.
 * 
 * @author UDA
 */

@Service(value = "aa00j15s01Service")
public class Aa00j15s01ServiceImpl implements Aa00j15s01Service {

	@Autowired
	private Aa00j15s01Dao aa00j15s01Dao;

	/**
	 * Inserts a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j15s01 add(Aa00j15s01 aa00j15s01) {
		return this.aa00j15s01Dao.add(aa00j15s01);
	}

	/**
	 * Updates a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j15s01 update(Aa00j15s01 aa00j15s01) {
		return this.aa00j15s01Dao.update(aa00j15s01);
	}

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @return Aa00j15s01
	 */
	public Aa00j15s01 find(Aa00j15s01 aa00j15s01) {
		return (Aa00j15s01) this.aa00j15s01Dao.find(aa00j15s01);
	}

	/**
	 * Deletes a single row in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j15s01 aa00j15s01) {
		this.aa00j15s01Dao.remove(aa00j15s01);
	}

	/**
	 * Finds a list of rows in the Aa00j15s01 table.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j15s01>
	 */
	public List<Aa00j15s01> findAll(Aa00j15s01 aa00j15s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j15s01>) this.aa00j15s01Dao.findAll(aa00j15s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j15s01 table using like.
	 * 
	 * @param aa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j15s01>
	 */
	public List<Aa00j15s01> findAllLike(Long edificio, int anio,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j15s01>) this.aa00j15s01Dao.findAllLike(edificio,
				anio, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa00j15s01Dao.removeMultiple(filterAa00j15s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j15s01>
	 */
	public JQGridResponseDto<Aa00j15s01> filter(Long edificio, int anio,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j15s01> listaAa00j15s01 = this.aa00j15s01Dao.findAllLike(
				edificio, anio, jqGridRequestDto, false);
		Long recordNum = this.aa00j15s01Dao.findAllLikeCount(edificio, anio,
				false);
		// if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
		// List<TableRowDto<Aa00j15s01>> reorderSelection = this.aa00j15s01Dao
		// .reorderSelection(filterAa00j15s01, jqGridRequestDto,
		// startsWith);
		// return new JQGridResponseDto<Aa00j15s01>(jqGridRequestDto,
		// recordNum, listaAa00j15s01, reorderSelection);
		// }
		return new JQGridResponseDto<Aa00j15s01>(jqGridRequestDto, recordNum,
				listaAa00j15s01);
	}

	/**
	 * Searches rows in the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param searchAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j15s01>>
	 */
	public List<TableRowDto<Aa00j15s01>> search(Aa00j15s01 filterAa00j15s01,
			Aa00j15s01 searchAa00j15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j15s01Dao.search(filterAa00j15s01, searchAa00j15s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j15s01 filterAa00j15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j15s01Dao.reorderSelection(filterAa00j15s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j15s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j15s01>> jerarquia(
			Aa00j15s01 filterAa00j15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j15s01>> listaAa00j15s01 = this.aa00j15s01Dao
				.findAllLikeJerarquia(filterAa00j15s01, jqGridRequestDto);
		Long recordNum = this.aa00j15s01Dao.findAllLikeCountJerarquia(
				filterAa00j15s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j15s01>>(
				jqGridRequestDto, recordNum, listaAa00j15s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j15s01 table.
	 * 
	 * @param filterAa00j15s01
	 *            Aa00j15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j15s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j15s01>> jerarquiaChildren(
			Aa00j15s01 filterAa00j15s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j15s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j15s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j15s01Dao.findAllChild(filterAa00j15s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Crea el calendario básico para el edificio y el año
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int crear(Long edificio, int anio) {
		return this.aa00j15s01Dao.crear(edificio, anio);
	}

	/**
	 * Borra los datos del del calendario para el edificio el año en concreto
	 * 
	 * @param edificio
	 * @param anio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int borrar(Long edificio, int anio) {
		return this.aa00j15s01Dao.borrar(edificio, anio);
	}

	/**
	 * Actualiza los datos de hora de inicio para el calendario de edificio el
	 * año anio por la horainicio los festivos siguen siendo festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horainicio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int actualizarHoraInicio(Long edificio, int anio, String horainicio) {
		return this.aa00j15s01Dao.actualizarHoraInicio(edificio, anio,
				horainicio);
	}

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin, menos los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int actualizarHoraFin(Long edificio, int anio, String horafin) {
		return this.aa00j15s01Dao.actualizarHoraFin(edificio, anio, horafin);
	}

	/**
	 * Actualiza los datos de hora final para el calendario de edificio el año
	 * anio por la horafin para los viernes. los festivos siguen siendo
	 * festivos.
	 * 
	 * @param edificio
	 * @param anio
	 * @param horafin
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int actualizarHoraFinViernes(Long edificio, int anio, String horafin) {
		return this.aa00j15s01Dao.actualizarHoraFinViernes(edificio, anio,
				horafin);
	}

	/**
	 * Crea la jornada intensiva, para ello borra las fechas existentes primero,
	 * luego hace una insert
	 * 
	 * @param edificio
	 * @param hinit
	 * @param hfin
	 * @param sfecha1
	 * @param sfecha2
	 * @param local
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public int crearIntensiva(Long edificio, String hinit, String hfin,
			String sfecha1, String sfecha2, Locale local) {
		return this.aa00j15s01Dao.crearIntensiva(edificio, hinit, hfin,
				sfecha1, sfecha2, local);
	}

	/**
	 * Finds a single row in the Aa00j15s01 table.
	 * 
	 * @param edificio
	 * @param dia
	 * @return Aa00j15s01
	 */

	public Aa00j15s01 find(int edificio, int dia) {
		return this.aa00j15s01Dao.find(edificio, dia);
	}

}
