package com.ejie.aa00j.service;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.dao.Aa00j13s01Dao;
import com.ejie.aa00j.dao.Aa00j14s01Dao;
import com.ejie.aa00j.dao.Aa00j30s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j13s01;
import com.ejie.aa00j.model.Aa00j14s01;
import com.ejie.aa00j.model.Option;

/**
 * Aa00j13s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j13s01Service")
public class Aa00j13s01ServiceImpl implements Aa00j13s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j13s01Dao aa00j13s01Dao;

	@Autowired
	private Aa00j14s01Dao aa00j14s01Dao;

	@Autowired
	private Aa00j30s01Dao aa00j30s01Dao;

	/**
	 * Inserts a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j13s01 add(Aa00j13s01 aa00j13s01) throws Exception {
		String mensaje = "etErrorCrearRecurso";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// recurso
			if (aa00j13s01.getNomc13().trim().length() <= 0) {
				mensaje = "etNombreRecursoObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j13s01Dao.existe(aa00j13s01.getNomc13().trim(),
						null)) {
					mensaje = "etYaExisteRecurso";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					Aa00j13s01 ret = null;
					ret = this.aa00j13s01Dao.add(aa00j13s01);
					if (aa00j13s01.getAa00j14s01s() != null
							&& aa00j13s01.getAa00j14s01s().size() > 0) {
						for (Aa00j14s01 aux : aa00j13s01.getAa00j14s01s()) {
							aux.setAa00j13s01(ret);
							aux.setSit14(aa00jConstantes.SITUACION_ALTA);
						}
						this.aa00j14s01Dao.addMultiple(aa00j13s01
								.getAa00j14s01s());
					}
					return ret;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j13s01 update(Aa00j13s01 aa00j13s01) throws Exception {
		String mensaje = "etErrorActualizarRecurso";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para el nuevo
			// recurso
			if (aa00j13s01.getNomc13().trim().length() <= 0) {
				mensaje = "etNombreRecursoObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j13s01Dao.existe(aa00j13s01.getNomc13().trim(),
						aa00j13s01.getCrec13())) {
					mensaje = "etYaExisteRecurso";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					aa00j13s01 = this.aa00j13s01Dao.update(aa00j13s01);
					this.aa00j14s01Dao.removeRecurso(aa00j13s01.getCrec13());
					if (aa00j13s01.getAa00j14s01s() != null
							&& aa00j13s01.getAa00j14s01s().size() > 0) {
						for (Aa00j14s01 aux : aa00j13s01.getAa00j14s01s()) {
							aux.setAa00j13s01(aa00j13s01);
							aux.setSit14(aa00jConstantes.SITUACION_ALTA);
						}
						this.aa00j14s01Dao.addMultiple(aa00j13s01
								.getAa00j14s01s());
					}
					return aa00j13s01;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @return Aa00j13s01
	 */
	public Aa00j13s01 find(Aa00j13s01 aa00j13s01) {
		return (Aa00j13s01) this.aa00j13s01Dao.find(aa00j13s01);
	}

	/**
	 * Deletes a single row in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j13s01 aa00j13s01) throws Exception {
		String mensaje = "etErrorBorrarRecurso";
		try {
			// 1º Comprobamos que no exista ninguna reserva para este recurso
			if (this.aa00j30s01Dao.existeRecurso(aa00j13s01.getCrec13())) {
				mensaje = "etExisteReservaRecursoRecurso";
				throw new Exception();
			} else {
				// 2º La borramos
				this.aa00j14s01Dao.removeRecurso(aa00j13s01.getCrec13());
				this.aa00j13s01Dao.remove(aa00j13s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j13s01 table.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j13s01>
	 */
	public List<Aa00j13s01> findAll(Aa00j13s01 aa00j13s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao.findAll(aa00j13s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j13s01 table using like.
	 * 
	 * @param aa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j13s01>
	 */
	public List<Aa00j13s01> findAllLike(Aa00j13s01 aa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao.findAllLike(aa00j13s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j13s01 filterAa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarRecurso";
		String mensajeExisteReserva = "etExisteReservaRecursoRecurso";
		String strError = "";
		String strExisteReserva = "";
		String aux = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j13s01.class) != null) {
			for (Aa00j13s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j13s01.class)) {
				try {
					// 1º Comprobamos que no exista ninguna Reserva de recurso
					// para este recurso
					if (this.aa00j30s01Dao.existeRecurso(selected.getCrec13())) {
						if (LocaleContextHolder.getLocale().equals(
								aa00jConstantes.IDIOMA_EUSKERA)) {
							aux = this.aa00j13s01Dao.find(selected).getNome13();
						} else {
							aux = this.aa00j13s01Dao.find(selected).getNomc13();
						}
						strExisteReserva = strExisteReserva.concat("<br/>")
								.concat("-").concat(aux);
					} else {
						// 2º La borramos
						this.aa00j14s01Dao.removeRecurso(selected.getCrec13());
						this.aa00j13s01Dao.remove(selected);
					}
				} catch (Exception e) {
					if (LocaleContextHolder.getLocale().equals(
							aa00jConstantes.IDIOMA_EUSKERA)) {
						aux = this.aa00j13s01Dao.find(selected).getNome13();
					} else {
						aux = this.aa00j13s01Dao.find(selected).getNomc13();
					}
					strExisteReserva = strExisteReserva.concat("<br/>")
							.concat("-").concat(aux);
				}
			}
		}

		if (strExisteReserva.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExisteReserva.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteReserva, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteReserva);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j13s01>
	 */
	public JQGridResponseDto<Aa00j13s01> filter(Aa00j13s01 filterAa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j13s01> listaAa00j13s01 = this.aa00j13s01Dao.findAllLike(
				filterAa00j13s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j13s01Dao.findAllLikeCount(
				filterAa00j13s01 != null ? filterAa00j13s01 : new Aa00j13s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j13s01>> reorderSelection = this.aa00j13s01Dao
					.reorderSelection(filterAa00j13s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j13s01>(jqGridRequestDto,
					recordNum, listaAa00j13s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j13s01>(jqGridRequestDto, recordNum,
				listaAa00j13s01);
	}

	/**
	 * Searches rows in the Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param searchAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j13s01>>
	 */
	public List<TableRowDto<Aa00j13s01>> search(Aa00j13s01 filterAa00j13s01,
			Aa00j13s01 searchAa00j13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j13s01Dao.search(filterAa00j13s01, searchAa00j13s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j13s01 filterAa00j13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j13s01Dao.reorderSelection(filterAa00j13s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j13s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j13s01>> jerarquia(
			Aa00j13s01 filterAa00j13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j13s01>> listaAa00j13s01 = this.aa00j13s01Dao
				.findAllLikeJerarquia(filterAa00j13s01, jqGridRequestDto);
		Long recordNum = this.aa00j13s01Dao.findAllLikeCountJerarquia(
				filterAa00j13s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j13s01>>(
				jqGridRequestDto, recordNum, listaAa00j13s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j13s01 table.
	 * 
	 * @param filterAa00j13s01
	 *            Aa00j13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j13s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j13s01>> jerarquiaChildren(
			Aa00j13s01 filterAa00j13s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j13s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j13s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j13s01Dao.findAllChild(filterAa00j13s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public List<Aa00j13s01> obtenerCombo(Long codEdificio) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao.obtenerCombo(codEdificio);
	}

	public List<Aa00j13s01> obtenerRecursosEdificio(Long cedif03) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao
				.obtenerRecursosEdificio(cedif03);
	}

	public boolean bloquear(Long crec13) {

		return this.comunDao.bloquear("crec13", crec13.toString());
	}

	public boolean desbloquear(Long crec13) {

		return this.comunDao.desbloquear("crec13", crec13.toString());
	}

	public List<Aa00j13s01> obtenerRecursosEdificioReserva(Long codReserva) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao
				.obtenerRecursosEdificioReserva(codReserva);
	}

	public List<Aa00j13s01> obtenerRecursosEdificioReservaSala(
			Long codReservaSala) {
		return (List<Aa00j13s01>) this.aa00j13s01Dao
				.obtenerRecursosEdificioReservaSala(codReservaSala);
	}

	public List<Option> recursosPorSitio(int sitio) {
		return this.aa00j13s01Dao.recursosPorSitio(sitio);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("13", "CREC13", ids);
	}
}