package com.ejie.aa00j.service;

import com.ejie.aa00j.dao.Aa00j12s01Dao;
import com.ejie.aa00j.model.Aa00j20s01;
import com.ejie.aa00j.model.Option;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.dto.TableRowDto;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.model.Aa00j12s01;

/**
 * Aa00j12s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j12s01Service")
public class Aa00j12s01ServiceImpl implements Aa00j12s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private Aa00j12s01Dao aa00j12s01Dao;

	/**
	 * Inserts a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j12s01 add(Aa00j12s01 aa00j12s01) {
		return this.aa00j12s01Dao.add(aa00j12s01);
	}

	/**
	 * Updates a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j12s01 update(Aa00j12s01 aa00j12s01) {
		return this.aa00j12s01Dao.update(aa00j12s01);
	}

	/**
	 * Finds a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	public Aa00j12s01 find(Aa00j12s01 aa00j12s01) {
		return (Aa00j12s01) this.aa00j12s01Dao.find(aa00j12s01);
	}

	/**
	 * Deletes a single row in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j12s01 aa00j12s01) {
		this.aa00j12s01Dao.remove(aa00j12s01);
	}

	/**
	 * Finds a list of rows in the Aa00j12s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j12s01>
	 */
	public List<Aa00j12s01> findAll(Aa00j12s01 aa00j12s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j12s01>) this.aa00j12s01Dao.findAll(aa00j12s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j12s01 table using like.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j12s01>
	 */
	public List<Aa00j12s01> findAllLike(Aa00j12s01 aa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j12s01>) this.aa00j12s01Dao.findAllLike(aa00j12s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j12s01 filterAa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.aa00j12s01Dao.removeMultiple(filterAa00j12s01, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j12s01>
	 */
	public JQGridResponseDto<Aa00j12s01> filter(Aa00j12s01 filterAa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j12s01> listaAa00j12s01 = this.aa00j12s01Dao.findAllLike(
				filterAa00j12s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j12s01Dao.findAllLikeCount(
				filterAa00j12s01 != null ? filterAa00j12s01 : new Aa00j12s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j12s01>> reorderSelection = this.aa00j12s01Dao
					.reorderSelection(filterAa00j12s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j12s01>(jqGridRequestDto,
					recordNum, listaAa00j12s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j12s01>(jqGridRequestDto, recordNum,
				listaAa00j12s01);
	}

	/**
	 * Searches rows in the Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param searchAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j12s01>>
	 */
	public List<TableRowDto<Aa00j12s01>> search(Aa00j12s01 filterAa00j12s01,
			Aa00j12s01 searchAa00j12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j12s01Dao.search(filterAa00j12s01, searchAa00j12s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j12s01 filterAa00j12s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j12s01Dao.reorderSelection(filterAa00j12s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j12s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j12s01>> jerarquia(
			Aa00j12s01 filterAa00j12s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j12s01>> listaAa00j12s01 = this.aa00j12s01Dao
				.findAllLikeJerarquia(filterAa00j12s01, jqGridRequestDto);
		Long recordNum = this.aa00j12s01Dao.findAllLikeCountJerarquia(
				filterAa00j12s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j12s01>>(
				jqGridRequestDto, recordNum, listaAa00j12s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j12s01 table.
	 * 
	 * @param filterAa00j12s01
	 *            Aa00j12s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j12s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j12s01>> jerarquiaChildren(
			Aa00j12s01 filterAa00j12s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j12s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j12s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j12s01Dao.findAllChild(filterAa00j12s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Inserts a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @return Aa00j12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j12s01 addAa00j21s01(Aa00j12s01 aa00j12s01) {
		return this.aa00j12s01Dao.addAa00j21s01(aa00j12s01);
	}

	/**
	 * Deletes a single row in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeAa00j21s01(Aa00j12s01 aa00j12s01) {
		this.aa00j12s01Dao.removeAa00j21s01(aa00j12s01);
	}

	/**
	 * Find a single row in the findAa00j21s01 Many To Many relationship.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @param pagination
	 *            Pagination
	 * @return Aa00j12s01
	 */
	public Aa00j12s01 findAa00j21s01(Aa00j12s01 aa00j12s01,
			Aa00j20s01 aa00j20s01, Pagination pagination) {
		return this.aa00j12s01Dao.findAa00j21s01(aa00j12s01, aa00j20s01,
				pagination);
	}

	/**
	 * Counts rows in the Aa00j21s01 table.
	 * 
	 * @param aa00j12s01
	 *            Aa00j12s01
	 * @param aa00j20s01
	 *            Aa00j20s01
	 * @return Long
	 */
	public Long findAa00j21s01Count(Aa00j12s01 aa00j12s01, Aa00j20s01 aa00j20s01) {
		return this.aa00j12s01Dao.findAa00j21s01Count(aa00j12s01, aa00j20s01);
	}

	public List<Aa00j12s01> obtenerMediosFijosSala(Long csala12) {
		return (List<Aa00j12s01>) this.aa00j12s01Dao
				.obtenerMediosFijosSala(csala12);
	}

	public String comprobarBorrado(List<String> nombres, Long csala12) {

		StringBuffer ret = new StringBuffer();
		String listaNombres = "";

		for (String nombre : nombres) {
			if (this.aa00j12s01Dao.existeEnReserva(nombre, csala12)) {
				listaNombres = listaNombres.concat("<br/>").concat("-")
						.concat(nombre);
			}
		}

		if (listaNombres.length() > 0) {
			ret.append(this.appMessageSource.getMessage("etMedioFijoReservado",
					null, LocaleContextHolder.getLocale()));
			ret.append(listaNombres);
		}

		return ret.toString();
	}

	public List<Aa00j12s01> obtenerMediosFijosSalaReserva(Long cres21) {
		return (List<Aa00j12s01>) this.aa00j12s01Dao
				.obtenerMediosFijosSalaReserva(cres21);
	}

	/**
	 * Devuelve una lista de medios fijos
	 * 
	 * @return
	 */

	public List<Option> getListForOption() {
		return this.aa00j12s01Dao.getListForOption();
	}
}