package com.ejie.aa00j.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa00j.classes.aa00jConstantes;
import com.ejie.aa00j.dao.Aa00j10s01Dao;
import com.ejie.aa00j.dao.Aa00j11s01Dao;
import com.ejie.aa00j.dao.Aa00j12s01Dao;
import com.ejie.aa00j.dao.Aa00j20s01Dao;
import com.ejie.aa00j.dao.ComunDao;
import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Aa00j12s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormConsultaAsistida;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa00j10s01ServiceImpl generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

@Service(value = "aa00j10s01Service")
public class Aa00j10s01ServiceImpl implements Aa00j10s01Service {

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private ComunDao comunDao;

	@Autowired
	private Aa00j10s01Dao aa00j10s01Dao;

	@Autowired
	private Aa00j11s01Dao aa00j11s01Dao;

	@Autowired
	private Aa00j12s01Dao aa00j12s01Dao;

	@Autowired
	private Aa00j20s01Dao aa00j20s01Dao;

	/**
	 * Inserts a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 * @throws Exception
	 * @throws
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j10s01 add(Aa00j10s01 aa00j10s01) throws Exception {
		String mensaje = "etErrorCrearSala";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para la nueva
			// sala
			if (aa00j10s01.getNombre10().trim().length() <= 0) {
				mensaje = "etNombreSalaObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j10s01Dao.existe(aa00j10s01.getNombre10().trim(),
						null)) {
					mensaje = "etYaExisteSala";
					throw new Exception();
				} else {
					// 3º Lo insertamos
					Aa00j10s01 ret = null;
					ret = this.aa00j10s01Dao.add(aa00j10s01);
					if (aa00j10s01.getAa00j11s01() != null) {
						aa00j10s01.getAa00j11s01().setCsala11(ret.getCsala10());
						this.aa00j11s01Dao.add(aa00j10s01.getAa00j11s01());
					}
					if (aa00j10s01.getAa00j12s01s() != null
							&& aa00j10s01.getAa00j12s01s().size() > 0) {
						for (Aa00j12s01 aux : aa00j10s01.getAa00j12s01s()) {
							aux.setAa00j10s01(ret);
							aux.setSwdisp12(1);
							aux.setSit12(aa00jConstantes.SITUACION_ALTA);
						}
						this.aa00j12s01Dao.addMultiple(aa00j10s01
								.getAa00j12s01s());
					}
					return ret;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Updates a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Aa00j10s01 update(Aa00j10s01 aa00j10s01) throws Exception {
		String mensaje = "etErrorActualizarSala";
		try {
			// 1º Comprobamos que se haya introducido algún nombre para la nueva
			// sala
			if (aa00j10s01.getNombre10().trim().length() <= 0) {
				mensaje = "etNombreSalaObligatorio";
				throw new Exception();
			} else {
				// 2º Comprobamos que no exista
				if (this.aa00j10s01Dao.existe(aa00j10s01.getNombre10().trim(),
						aa00j10s01.getCsala10())) {
					mensaje = "etYaExisteSala";
					throw new Exception();
				} else {
					// 3º Lo actualizamos
					aa00j10s01 = this.aa00j10s01Dao.update(aa00j10s01);

					// FOTO Y CROQUIS
					if (aa00j10s01.getAa00j11s01() != null) {
						aa00j10s01.getAa00j11s01().setCsala11(
								aa00j10s01.getCsala10());
						if (aa00j10s01.getAa00j11s01().getQuitaFoto() != null) {
							aa00j10s01.getAa00j11s01().setFoto11(null);
							this.aa00j11s01Dao.removeFoto(aa00j10s01
									.getCsala10());
						} else if (aa00j10s01.getAa00j11s01().getNombreFoto() != null
								&& aa00j10s01.getAa00j11s01().getNombreFoto()
										.length() > 0
								&& aa00j10s01.getAa00j11s01().getFoto11().length > 0) {
							if (aa00j11s01Dao.tieneFoto(aa00j10s01
									.getAa00j11s01()))
								this.aa00j11s01Dao.updateFoto(aa00j10s01
										.getAa00j11s01());
							else
								this.aa00j11s01Dao.add(aa00j10s01
										.getAa00j11s01());
						}
						if (aa00j10s01.getAa00j11s01().getQuitaCroquis() != null) {
							aa00j10s01.getAa00j11s01().setCroq11(null);
							this.aa00j11s01Dao.removeCroquis(aa00j10s01
									.getCsala10());
						} else if (aa00j10s01.getAa00j11s01()
								.getNombreCroquis() != null
								&& aa00j10s01.getAa00j11s01()
										.getNombreCroquis().length() > 0
								&& aa00j10s01.getAa00j11s01().getCroq11().length > 0) {
							if (aa00j11s01Dao.tieneFoto(aa00j10s01
									.getAa00j11s01()))
								this.aa00j11s01Dao.updateCroquis(aa00j10s01
										.getAa00j11s01());
							else
								this.aa00j11s01Dao.add(aa00j10s01
										.getAa00j11s01());
						}
					}
					//

					if (aa00j10s01.getAa00j12s01s() != null
							&& aa00j10s01.getAa00j12s01s().size() > 0) {
						String listaNombres = "";
						for (Aa00j12s01 medioFijo : aa00j10s01.getAa00j12s01s()) {
							listaNombres = listaNombres.concat(",'")
									.concat(medioFijo.getNom12()).concat("'");

							if (!this.aa00j12s01Dao.existe(
									medioFijo.getNom12(),
									aa00j10s01.getCsala10())) {
								medioFijo.setAa00j10s01(aa00j10s01);
								medioFijo.setSwdisp12(1);
								medioFijo
										.setSit12(aa00jConstantes.SITUACION_ALTA);
								this.aa00j12s01Dao.add(medioFijo);
							}
						}

						List<Aa00j12s01> listaMF = this.aa00j12s01Dao
								.obtenerMediosFijosSala(aa00j10s01.getCsala10());
						if (listaMF != null && listaMF.size() > 0) {
							for (Aa00j12s01 mf : listaMF) {
								boolean existe = false;
								for (Aa00j12s01 medioFijo : aa00j10s01
										.getAa00j12s01s()) {
									if (mf.getNom12()
											.toUpperCase()
											.equals(medioFijo.getNom12()
													.toUpperCase())) {
										existe = true;
									}
								}
								if (!existe) {
									this.aa00j12s01Dao.remove(mf);
								}
							}
						}
					}

					return aa00j10s01;
				}
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	public Aa00j10s01 find(Aa00j10s01 aa00j10s01) {
		return (Aa00j10s01) this.aa00j10s01Dao.find(aa00j10s01);
	}

	/**
	 * Deletes a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Aa00j10s01 aa00j10s01) throws Exception {
		String mensaje = "etErrorBorrarSala";
		try {
			// 1º Comprobamos que no exista ninguna reserva para esta sala
			if (this.aa00j20s01Dao.existeSala(aa00j10s01.getCsala10())) {
				mensaje = "etExisteReservaSalaSala";
				throw new Exception();
			} else {
				// 2º La borramos
				this.aa00j11s01Dao.removeSala(aa00j10s01.getCsala10());
				this.aa00j12s01Dao.removeSala(aa00j10s01.getCsala10());
				this.aa00j10s01Dao.remove(aa00j10s01);
			}
		} catch (Exception e) {
			throw new Exception(this.appMessageSource.getMessage(mensaje, null,
					LocaleContextHolder.getLocale()));
		}
	}

	/**
	 * Finds a list of rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j10s01>
	 */
	public List<Aa00j10s01> findAll(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto) {
		return (List<Aa00j10s01>) this.aa00j10s01Dao.findAll(aa00j10s01,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j10s01>
	 */
	public List<Aa00j10s01> findAllLike(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<Aa00j10s01>) this.aa00j10s01Dao.findAllLike(aa00j10s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	public void removeMultiple(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception {
		String mensajeError = "etErrorBorrarSala";
		String mensajeExisteReserva = "etExisteReservaSalaSala";
		String strError = "";
		String strExisteReserva = "";

		if (jqGridRequestDto != null
				&& jqGridRequestDto.getMultiselection() != null
				&& jqGridRequestDto.getMultiselection().getSelected(
						Aa00j10s01.class) != null) {
			for (Aa00j10s01 selected : jqGridRequestDto.getMultiselection()
					.getSelected(Aa00j10s01.class)) {
				try {
					// 1º Comprobamos que no exista ninguna Reserva de sala para
					// esta sala
					if (this.aa00j20s01Dao.existeSala(selected.getCsala10())) {
						strExisteReserva = strExisteReserva
								.concat("<br/>")
								.concat("-")
								.concat(this.aa00j10s01Dao.find(selected)
										.getNombre10());
					} else {
						// 2º La borramos
						this.aa00j11s01Dao.removeSala(selected.getCsala10());
						this.aa00j12s01Dao.removeSala(selected.getCsala10());
						this.aa00j10s01Dao.remove(selected);
					}
				} catch (Exception e) {
					strError = strError
							.concat("<br/>")
							.concat("-")
							.concat(this.aa00j10s01Dao.find(selected)
									.getNombre10());
				}
			}
		}

		if (strExisteReserva.length() > 0 || strError.length() > 0) {
			String mensaje = "";
			if (strExisteReserva.length() > 0) {
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(
								mensajeExisteReserva, null,
								LocaleContextHolder.getLocale())).concat(":")
						.concat(strExisteReserva);
			}
			if (strError.length() > 0) {
				if (mensaje.length() > 0) {
					mensaje = mensaje.concat("<br/><br/>");
				}
				mensaje = mensaje
						.concat(this.appMessageSource.getMessage(mensajeError,
								null, LocaleContextHolder.getLocale()))
						.concat(":").concat(strError);
			}
			throw new Exception(mensaje);
		}
	}

	/**
	 * Filter method in the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j10s01>
	 */
	public JQGridResponseDto<Aa00j10s01> filter(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Aa00j10s01> listaAa00j10s01 = this.aa00j10s01Dao.findAllLike(
				filterAa00j10s01, jqGridRequestDto, false);
		Long recordNum = this.aa00j10s01Dao.findAllLikeCount(
				filterAa00j10s01 != null ? filterAa00j10s01 : new Aa00j10s01(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<Aa00j10s01>> reorderSelection = this.aa00j10s01Dao
					.reorderSelection(filterAa00j10s01, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<Aa00j10s01>(jqGridRequestDto,
					recordNum, listaAa00j10s01, reorderSelection);
		}
		return new JQGridResponseDto<Aa00j10s01>(jqGridRequestDto, recordNum,
				listaAa00j10s01);
	}

	/**
	 * Searches rows in the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param searchAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	public List<TableRowDto<Aa00j10s01>> search(Aa00j10s01 filterAa00j10s01,
			Aa00j10s01 searchAa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.aa00j10s01Dao.search(filterAa00j10s01, searchAa00j10s01,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	public Object reorderSelection(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.aa00j10s01Dao.reorderSelection(filterAa00j10s01,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquia(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<Aa00j10s01>> listaAa00j10s01 = this.aa00j10s01Dao
				.findAllLikeJerarquia(filterAa00j10s01, jqGridRequestDto);
		Long recordNum = this.aa00j10s01Dao.findAllLikeCountJerarquia(
				filterAa00j10s01, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<Aa00j10s01>>(
				jqGridRequestDto, recordNum, listaAa00j10s01);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>>
	 */
	public JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquiaChildren(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<Aa00j10s01>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.aa00j10s01Dao.findAllChild(filterAa00j10s01,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	public List<Aa00j10s01> obtenerCombo(Long codDepartamento, Long codEdificio) {
		return (List<Aa00j10s01>) this.aa00j10s01Dao.obtenerCombo(
				codDepartamento, codEdificio);
	}

	public List<Aa00j10s01> obtenerComboTodas() {
		return (List<Aa00j10s01>) this.aa00j10s01Dao.obtenerComboTodas();
	}

	public boolean bloquear(Long csala10) {

		return this.comunDao.bloquear("csala10", csala10.toString());
	}

	public boolean desbloquear(Long csala10) {

		return this.comunDao.desbloquear("csala10", csala10.toString());
	}

	public JQGridResponseDto<Aa00j10s01> consultaAsistida(
			FormConsultaAsistida form, JQGridRequestDto jqGridRequestDto,
			Locale local) {

		// igual que en el ASP
		// Primero miramos si hay salas que tengan esos medios fijos
		// si hay se hace la búsqueda de las fechas con esos medios fijos
		// si no hay, se quitan los medios fijos de la búsqueda
		if (form.getMediosFijos() != null && form.getMediosFijos().size() > 0) {
			long numsalas = this.aa00j10s01Dao.numeroSalasConMedios(form
					.getMediosFijos());
			if (numsalas == 0)
				form.setMediosFijos(null);
		}

		List<Aa00j10s01> listaAa00j10s01 = this.aa00j10s01Dao.consultaAsistida(
				form, jqGridRequestDto, local);
		Long recordNum = this.aa00j10s01Dao.consultaAsistidaNum(form, local);

		return new JQGridResponseDto<Aa00j10s01>(jqGridRequestDto, recordNum,
				listaAa00j10s01);

	}

	public long numeroSalasConMedios(ArrayList<String> medios) {
		return this.aa00j10s01Dao.numeroSalasConMedios(medios);
	}

	public List<Option> salasPorSitio(int sitio) {
		return this.aa00j10s01Dao.salasPorSitio(sitio);
	}

	/**
	 * Devuelve una lista de salas por código de departamento
	 */
	@Override
	public List<Option> salasPorDepartamento(int departamento) {
		return this.aa00j10s01Dao.salasPorDepartamento(departamento);
	}

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public boolean cambiarSituacion(String ids) {
		return this.comunDao.cambiarSituacion("10", "CSALA10", ids);
	}

	/**
	 * Devuelve una lista de las salas del listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasListado(int listado) {
		return this.aa00j10s01Dao.obtenerSalasListado(listado);
	}

	/**
	 * Devuelve una lista que no están en un listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasNoListado(int listado) {
		return this.aa00j10s01Dao.obtenerSalasNoListado(listado);
	}
}