package com.ejie.aa00j.service;

import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.ejie.aa00j.model.Aa00j10s01;
import com.ejie.aa00j.model.Option;
import com.ejie.aa00j.model.forms.FormConsultaAsistida;

/**
 * Aa00j10s01Service generated by UDA, 16-oct-2013 13:02:12.
 * 
 * @author UDA
 */

public interface Aa00j10s01Service {

	/**
	 * Inserts a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 add(Aa00j10s01 aa00j10s01) throws Exception;

	/**
	 * Updates a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 update(Aa00j10s01 aa00j10s01) throws Exception;

	/**
	 * Finds a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @return Aa00j10s01
	 */
	Aa00j10s01 find(Aa00j10s01 aa00j10s01);

	/**
	 * Deletes a single row in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 */
	void remove(Aa00j10s01 aa00j10s01) throws Exception;

	/**
	 * Finds a list of rows in the Aa00j10s01 table.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa00j10s01>
	 */
	List<Aa00j10s01> findAll(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa00j10s01 table using like.
	 * 
	 * @param aa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa00j10s01>
	 */
	List<Aa00j10s01> findAllLike(Aa00j10s01 aa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith)
			throws Exception;

	/**
	 * Filter method in the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<Aa00j10s01>
	 */
	JQGridResponseDto<Aa00j10s01> filter(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param searchAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa00j10s01>>
	 */
	List<TableRowDto<Aa00j10s01>> search(Aa00j10s01 filterAa00j10s01,
			Aa00j10s01 searchAa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return Object
	 */
	Object reorderSelection(Aa00j10s01 filterAa00j10s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquia(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Finder method for siblings rows in the hierarchical the Aa00j10s01 table.
	 * 
	 * @param filterAa00j10s01
	 *            Aa00j10s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return JQGridResponseDto<JerarquiaDto<Aa00j10s01>>
	 */
	JQGridResponseDto<JerarquiaDto<Aa00j10s01>> jerarquiaChildren(
			Aa00j10s01 filterAa00j10s01, JQGridRequestDto jqGridRequestDto);

	List<Aa00j10s01> obtenerCombo(Long codDepartamento, Long codEdificio);

	List<Aa00j10s01> obtenerComboTodas();

	boolean bloquear(Long csala10);

	boolean desbloquear(Long csala10);

	public JQGridResponseDto<Aa00j10s01> consultaAsistida(
			FormConsultaAsistida form, JQGridRequestDto jqGridRequestDto,
			Locale local);

	public long numeroSalasConMedios(ArrayList<String> medios);

	public List<Option> salasPorSitio(int sitio);

	List<Option> salasPorDepartamento(int departamento);

	/**
	 * Modifica la situacion de los registros ids en la tabla
	 * 
	 * 
	 * @param ids
	 * @return
	 */

	public boolean cambiarSituacion(String ids);

	/**
	 * Devuelve una lista de las salas del listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasListado(int listado);

	/**
	 * Devuelve una lista que no están en un listado
	 * 
	 * @param listado
	 * @return
	 */
	public List<Aa00j10s01> obtenerSalasNoListado(int listado);
}